/* Generated By:JavaCC: Do not edit this line. EscapeParser.java */
package org.apache.kylin.query.util;

import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;

import org.apache.commons.lang.StringUtils;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class EscapeParser implements EscapeParserConstants {

    private static final String CEIL_FLOOR_EXCEPTION_MSG = "%s(exp to timeunit) encounters timeunit %s, but only supports %s";
    private static final String EXTRACT_FROM_EXCEPTION_MSG = "extract(timeunit from exp) encounters timeunit %s, but only supports %s";
    private static final String TIMESTAMP_DIFF_ADD_EXCEPTION_MSG = "%s(timeunit, exp1, exp2) encounters timeunit %s, but only supports %s";
    private static final String COMMA_STR = ",";
    private static final String SPACE_STR = " ";
    private static final char SPACE_CHAR = ' ';
    private static final String QUOTE_STR = "'";
    private static final ImmutableSet<String> OPERATORS = ImmutableSet.of("+", "-", "*", "/", "%", "=",
        ">=", "<=", "!=", "<>", "||");

    private EscapeDialect dialect = EscapeDialect.DEFAULT;

    public static void main(String[] args) throws ParseException {
        System.out.println("Input SQL:");
        Scanner reader = new Scanner(System.in, Charset.defaultCharset().name());
        String sql = reader.nextLine();
        reader.close();
        EscapeParser parser = new EscapeParser(new StringReader(sql));
        String parseResult = parser.Input();
        System.out.println("Translated SQL:");
        System.out.println(parseResult);
    }

    public EscapeParser(EscapeDialect newDialect, String sql) {
        this(new StringReader(sql));
        this.dialect = newDialect;
    }

    private static String normalize(String str) {
        if (str.equals(COMMA_STR)) {
            str = str + SPACE_STR;
        } else if (OPERATORS.contains(str)) {
            str = SPACE_STR + str + SPACE_STR;
        }
        return str;
    }

    private static boolean needDropPreSpace(String str) {
        return COMMA_STR.equals(str) || OPERATORS.contains(str)
            || (StringUtils.isBlank(str) && !SPACE_STR.equals(str));
    }

    private static void appendExpression(StringBuilder sb, String innerString) {
        if (sb.length() != 0) {
            int last = sb.length() - 1;
            if (sb.charAt(last) != SPACE_CHAR && innerString.startsWith(QUOTE_STR)) {
                sb.append(SPACE_STR);
            }
        }

        int len = sb.length();
        if (!SPACE_STR.equals(innerString) || (len != 0 && sb.charAt(len - 1) != SPACE_CHAR)) {
            sb.append(innerString);
        }
    }

/** Root production. */
  final public String Input() throws ParseException {
    String innerString;
    StringBuilder transformedStr = new StringBuilder();
    label_1:
    while (true) {
      innerString = Expression();
        if(transformedStr.length() != 0) {
            int lastIndex = transformedStr.length() - 1;
            if (transformedStr.charAt(lastIndex) == SPACE_CHAR && needDropPreSpace(innerString)) {
                transformedStr.deleteCharAt(lastIndex);
            }
            innerString = normalize(innerString);
        }
        appendExpression(transformedStr, innerString);
      if (jj_2_1(2)) {
        ;
      } else {
        break label_1;
      }
    }
    jj_consume_token(0);
        {if (true) return transformedStr.toString();}
    throw new Error("Missing return statement in function");
  }

/** Brace counting production. */
  final public String Expression() throws ParseException {
    String innerString = "";
        if (Thread.currentThread().isInterrupted()) {
            {if (true) throw new ParseException("EscapeParser is interrupted");}
        }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      innerString = EscapeExpress();
      break;
    case SUBSTRING:
    case SUBSTR:
      innerString = SubstringExpression();
      break;
    case OVERLAY:
      innerString = OverlayExpression();
      break;
    case GROUPING:
      innerString = GroupingSetsExpression();
      break;
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
      innerString = TsDiffOrAddExpression();
      break;
    case HINT:
      innerString = Hint();
      break;
    case CUBE_PRIORITY:
      innerString = CubePriority();
      break;
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
      innerString = Numeric();
      break;
    case CAST:
      innerString = CastExpression();
      break;
    case EXTRACT:
      innerString = ExtractExpression();
      break;
    case CEIL:
    case FLOOR:
      innerString = CeilFloorExpress();
      break;
    case LPAREN:
      innerString = ParenExpress();
      break;
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
      innerString = QuotedString();
      break;
    case QUOTED_IDENTIFIER:
      innerString = DoubleQuotedString();
      break;
    case BANGEQUAL:
      innerString = BangEqual();
      break;
    case COMMA:
      innerString = Comma();
      break;
    case SPACE:
      innerString = Space();
      break;
    case PI:
      innerString = PiFunction();
      break;
    case DOT:
    case EQ:
    case GT:
    case LT:
    case HOOK:
    case COLON:
    case LE:
    case GE:
    case NE:
    case NOT:
    case PLUS:
    case MINUS:
    case STAR:
    case SLASH:
    case MOD:
    case CONCAT:
    case VERTICAL_BAR:
    case CARET:
    case DOLLAR:
      innerString = Punctuation();
      break;
    case FROM:
      innerString = From();
      break;
    case FOR:
      innerString = For();
      break;
    case TO:
      innerString = To();
      break;
    case AS:
      innerString = As();
      break;
    case ANY:
      innerString = Any();
      break;
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return innerString;}
    throw new Error("Missing return statement in function");
  }

  final public String Comma() throws ParseException {
    jj_consume_token(COMMA);
        log.trace("meet token <COMMA>");
        {if (true) return getToken(0).image;}
    throw new Error("Missing return statement in function");
  }

  final public String Space() throws ParseException {
    jj_consume_token(SPACE);
        log.trace("meet token <SPACE>");
        {if (true) return getToken(0).image;}
    throw new Error("Missing return statement in function");
  }

  final public String Punctuation() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DOT:
      jj_consume_token(DOT);
      break;
    case LE:
      jj_consume_token(LE);
      break;
    case GE:
      jj_consume_token(GE);
      break;
    case NE:
      jj_consume_token(NE);
      break;
    case BANGEQUAL:
      jj_consume_token(BANGEQUAL);
      break;
    case EQ:
      jj_consume_token(EQ);
      break;
    case GT:
      jj_consume_token(GT);
      break;
    case LT:
      jj_consume_token(LT);
      break;
    case NOT:
      jj_consume_token(NOT);
      break;
    case HOOK:
      jj_consume_token(HOOK);
      break;
    case COLON:
      jj_consume_token(COLON);
      break;
    case PLUS:
      jj_consume_token(PLUS);
      break;
    case MINUS:
      jj_consume_token(MINUS);
      break;
    case STAR:
      jj_consume_token(STAR);
      break;
    case SLASH:
      jj_consume_token(SLASH);
      break;
    case MOD:
      jj_consume_token(MOD);
      break;
    case CONCAT:
      jj_consume_token(CONCAT);
      break;
    case CARET:
      jj_consume_token(CARET);
      break;
    case DOLLAR:
      jj_consume_token(DOLLAR);
      break;
    case VERTICAL_BAR:
      jj_consume_token(VERTICAL_BAR);
      break;
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        log.trace("meet token {}", getToken(0).toString());
        {if (true) return getToken(0).image;}
    throw new Error("Missing return statement in function");
  }

  final public String From() throws ParseException {
    jj_consume_token(FROM);
        log.trace("met token <FROM>");
        {if (true) return getToken(0).image;}
    throw new Error("Missing return statement in function");
  }

  final public String For() throws ParseException {
    jj_consume_token(FOR);
        log.trace("met token <FOR>");
        {if (true) return getToken(0).image;}
    throw new Error("Missing return statement in function");
  }

  final public String To() throws ParseException {
    jj_consume_token(TO);
        log.trace("met token <TO>");
        {if (true) return getToken(0).image;}
    throw new Error("Missing return statement in function");
  }

  final public String As() throws ParseException {
    jj_consume_token(AS);
        log.trace("met token <AS>");
        {if (true) return getToken(0).image;}
    throw new Error("Missing return statement in function");
  }

  final public String DoubleQuotedString() throws ParseException {
    jj_consume_token(QUOTED_IDENTIFIER);
        {if (true) return dialect.transformDoubleQuoteString(getToken(0).image);}
    throw new Error("Missing return statement in function");
  }

  final public String QuotedString() throws ParseException {
    String s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BINARY_STRING_LITERAL:
      jj_consume_token(BINARY_STRING_LITERAL);
        log.trace("meet token in <BINARY_STRING_LITERAL>: " + getToken(0).image);
        {if (true) return getToken(0).image;}
      break;
    case QUOTED_STRING:
      jj_consume_token(QUOTED_STRING);
        log.trace("meet token in <QUOTED_STRING>: " + getToken(0).image);
        {if (true) return getToken(0).image;}
      break;
    case PREFIXED_STRING_LITERAL:
      jj_consume_token(PREFIXED_STRING_LITERAL);
        log.trace("meet token in <PREFIXED_STRING_LITERAL>: " + getToken(0).image);
        {if (true) return getToken(0).image;}
      break;
    case UNICODE_STRING_LITERAL:
      jj_consume_token(UNICODE_STRING_LITERAL);
        log.trace("meet token in <UNICODE_STRING_LITERAL>: " + getToken(0).image);
        {if (true) return getToken(0).image;}
      break;
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String Any() throws ParseException {
    jj_consume_token(ANY);
        log.trace("meet token in <ANY>: " + getToken(0).image);
        {if (true) return getToken(0).image;}
    throw new Error("Missing return statement in function");
  }

  final public String ParenExpress() throws ParseException {
    String innerString;
    StringBuilder transformed = new StringBuilder();
    jj_consume_token(LPAREN);
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACE:
      case LPAREN:
      case COMMA:
      case SPACE:
      case BINARY_STRING_LITERAL:
      case QUOTED_STRING:
      case PREFIXED_STRING_LITERAL:
      case UNICODE_STRING_LITERAL:
      case QUOTED_IDENTIFIER:
      case HINT:
      case CUBE_PRIORITY:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case DOT:
      case CEIL:
      case FLOOR:
      case TO:
      case SUBSTRING:
      case SUBSTR:
      case FROM:
      case FOR:
      case CAST:
      case AS:
      case TIMESTAMPADD:
      case TIMESTAMPDIFF:
      case EXTRACT:
      case OVERLAY:
      case GROUPING:
      case PI:
      case ANY:
      case EQ:
      case GT:
      case LT:
      case HOOK:
      case COLON:
      case LE:
      case GE:
      case NE:
      case BANGEQUAL:
      case NOT:
      case PLUS:
      case MINUS:
      case STAR:
      case SLASH:
      case MOD:
      case CONCAT:
      case VERTICAL_BAR:
      case CARET:
      case DOLLAR:
        ;
        break;
      default:
        jj_la1[3] = jj_gen;
        break label_2;
      }
      innerString = Expression();
        if(transformed.length() != 0) {
            int lastIndex = transformed.length() - 1;
            if (transformed.charAt(lastIndex) == SPACE_CHAR && needDropPreSpace(innerString)) {
                transformed.deleteCharAt(lastIndex);
            }
            innerString = normalize(innerString);
        }
        appendExpression(transformed, innerString);
    }
    jj_consume_token(RPAREN);
        {if (true) return "(" + transformed.toString() + ")";}
    throw new Error("Missing return statement in function");
  }

  final public String EscapeExpress() throws ParseException {
    String innerString;
    jj_consume_token(LBRACE);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[4] = jj_gen;
        break label_3;
      }
      jj_consume_token(SPACE);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FN:
      innerString = EscapeFunction();
      break;
    case TS:
      innerString = EscapeTimestamp();
      break;
    case D:
    case DATE:
      innerString = EscapeDate();
      break;
    case T:
    case TIME:
      innerString = EscapeTime();
      break;
    default:
      jj_la1[5] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[6] = jj_gen;
        break label_4;
      }
      jj_consume_token(SPACE);
    }
    jj_consume_token(RBRACE);
        {if (true) return innerString;}
    throw new Error("Missing return statement in function");
  }

  final public String CastExpression() throws ParseException {
    String function;
    List<String> parameters = Lists.newArrayList();
    jj_consume_token(CAST);
        function = getToken(0).image;
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[7] = jj_gen;
        break label_5;
      }
      jj_consume_token(SPACE);
    }
    jj_consume_token(LPAREN);
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[8] = jj_gen;
        break label_6;
      }
      jj_consume_token(SPACE);
    }
        parameters.add(ParameterExpression().trim());
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[9] = jj_gen;
        break label_7;
      }
      jj_consume_token(SPACE);
    }
    jj_consume_token(AS);
        parameters.add(getToken(0).image);
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[10] = jj_gen;
        break label_8;
      }
      jj_consume_token(SPACE);
    }
        String type = dialect.transformDataType(ParameterExpression().trim());
        parameters.add(type);
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[11] = jj_gen;
        break label_9;
      }
      jj_consume_token(SPACE);
    }
    jj_consume_token(RPAREN);
        {if (true) return String.format(Locale.ROOT, "%s(%s)", function, String.join(SPACE_STR, parameters));}
    throw new Error("Missing return statement in function");
  }

  final public String ExtractExpression() throws ParseException {
    String functionName;
    String parameter;
    ImmutableSet<String> timeunitSet = ImmutableSet.of("YEAR", "QUARTER", "MONTH", "WEEK",
        "DAY", "HOUR", "MINUTE", "SECOND", "DOW", "DOY");
    jj_consume_token(EXTRACT);
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[12] = jj_gen;
        break label_10;
      }
      jj_consume_token(SPACE);
    }
    jj_consume_token(LPAREN);
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[13] = jj_gen;
        break label_11;
      }
      jj_consume_token(SPACE);
    }
    functionName = ParameterExpression().trim();
    if (!timeunitSet.contains(functionName.toUpperCase(Locale.ROOT))) {
        {if (true) throw new IllegalArgumentException(String.format(Locale.ROOT, EXTRACT_FROM_EXCEPTION_MSG,
            functionName, String.join(", ", timeunitSet)));}
    }
    if (functionName.equalsIgnoreCase("DAY")) {
        functionName = "DAYOFMONTH";
    } else if (functionName.equalsIgnoreCase("DOW")) {
        functionName = "DAYOFWEEK";
    } else if (functionName.equalsIgnoreCase("DOY")) {
        functionName = "DAYOFYEAR";
    }
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[14] = jj_gen;
        break label_12;
      }
      jj_consume_token(SPACE);
    }
    jj_consume_token(FROM);
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[15] = jj_gen;
        break label_13;
      }
      jj_consume_token(SPACE);
    }
        parameter = ParameterExpression().trim();
    label_14:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[16] = jj_gen;
        break label_14;
      }
      jj_consume_token(SPACE);
    }
    jj_consume_token(RPAREN);
        {if (true) return dialect.transformFN(functionName, new String[]{ parameter });}
    throw new Error("Missing return statement in function");
  }

  final public String TsDiffOrAddExpression() throws ParseException {
    String functionName;
    List<String> parameters = Lists.newArrayList();
    ImmutableSet<String> timeunitSet = ImmutableSet.of("YEAR", "QUARTER", "MONTH", "WEEK",
       "DAY", "HOUR", "MINUTE", "SECOND", "SQL_TSI_SECOND", "SQL_TSI_MINUTE", "SQL_TSI_HOUR",
       "SQL_TSI_DAY", "SQL_TSI_WEEK", "SQL_TSI_MONTH", "SQL_TSI_QUARTER","SQL_TSI_YEAR");
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TIMESTAMPDIFF:
      jj_consume_token(TIMESTAMPDIFF);
      break;
    case TIMESTAMPADD:
      jj_consume_token(TIMESTAMPADD);
      break;
    default:
      jj_la1[17] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        functionName = getToken(0).image;
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[18] = jj_gen;
        break label_15;
      }
      jj_consume_token(SPACE);
    }
    jj_consume_token(LPAREN);
    label_16:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[19] = jj_gen;
        break label_16;
      }
      jj_consume_token(SPACE);
    }
        String timeunit = ParameterExpression().trim();
        if (timeunit.startsWith(QUOTE_STR) && timeunit.endsWith(QUOTE_STR) && timeunit.length() > 2) {
            timeunit = timeunit.substring(1, timeunit.length() - 1);
        }
        if (!timeunitSet.contains(timeunit.toUpperCase(Locale.ROOT))) {
            {if (true) throw new IllegalStateException(String.format(Locale.ROOT, TIMESTAMP_DIFF_ADD_EXCEPTION_MSG,
                functionName, timeunit, String.join(", ", timeunitSet)));}
        }
        if (timeunit.toUpperCase(Locale.ROOT).startsWith("SQL_TSI_")) {
            timeunit = timeunit.toUpperCase(Locale.ROOT).replace("SQL_TSI_", "");
        }
        parameters.add(dialect.transformTimeunitOfTimestampDiffOrAdd(timeunit));
    label_17:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[20] = jj_gen;
        break label_17;
      }
      jj_consume_token(SPACE);
    }
    jj_consume_token(COMMA);
    label_18:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[21] = jj_gen;
        break label_18;
      }
      jj_consume_token(SPACE);
    }
        parameters.add(ParameterExpression().trim());
    label_19:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[22] = jj_gen;
        break label_19;
      }
      jj_consume_token(SPACE);
    }
    jj_consume_token(COMMA);
    label_20:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[23] = jj_gen;
        break label_20;
      }
      jj_consume_token(SPACE);
    }
        parameters.add(ParameterExpression().trim());
    label_21:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[24] = jj_gen;
        break label_21;
      }
      jj_consume_token(SPACE);
    }
    jj_consume_token(RPAREN);
        {if (true) return dialect.transformFN(functionName, parameters.toArray(new String [ 0 ]));}
    throw new Error("Missing return statement in function");
  }

  final public String SubstringExpression() throws ParseException {
    String functionName;
    List<String> parameters = Lists.newArrayList();
    List<String> params = Lists.newArrayList();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SUBSTR:
      jj_consume_token(SUBSTR);
      break;
    case SUBSTRING:
      jj_consume_token(SUBSTRING);
      break;
    default:
      jj_la1[25] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        functionName = getToken(0).image;
    label_22:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[26] = jj_gen;
        break label_22;
      }
      jj_consume_token(SPACE);
    }
    jj_consume_token(LPAREN);
    label_23:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[27] = jj_gen;
        break label_23;
      }
      jj_consume_token(SPACE);
    }
       parameters.add(ParameterExpression().trim());
    label_24:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[28] = jj_gen;
        break label_24;
      }
      jj_consume_token(SPACE);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FROM:
      jj_consume_token(FROM);
      break;
    case COMMA:
      jj_consume_token(COMMA);
      break;
    default:
      jj_la1[29] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_25:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[30] = jj_gen;
        break label_25;
      }
      jj_consume_token(SPACE);
    }
        parameters.add(ParameterExpression().trim());
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
    case SPACE:
    case FOR:
      label_26:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SPACE:
          ;
          break;
        default:
          jj_la1[31] = jj_gen;
          break label_26;
        }
        jj_consume_token(SPACE);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FOR:
        jj_consume_token(FOR);
        break;
      case COMMA:
        jj_consume_token(COMMA);
        break;
      default:
        jj_la1[32] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_27:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SPACE:
          ;
          break;
        default:
          jj_la1[33] = jj_gen;
          break label_27;
        }
        jj_consume_token(SPACE);
      }
           parameters.add(ParameterExpression().trim());
      break;
    default:
      jj_la1[34] = jj_gen;
      ;
    }
    label_28:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[35] = jj_gen;
        break label_28;
      }
      jj_consume_token(SPACE);
    }
    jj_consume_token(RPAREN);
        {if (true) return dialect.transformFN(functionName, parameters.toArray(new String [ 0 ]));}
    throw new Error("Missing return statement in function");
  }

  final public String OverlayExpression() throws ParseException {
    String functionName;
    List<String> parameters = Lists.newArrayList();
    List<String> params = Lists.newArrayList();
    jj_consume_token(OVERLAY);
        functionName = getToken(0).image;
    label_29:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[36] = jj_gen;
        break label_29;
      }
      jj_consume_token(SPACE);
    }
    jj_consume_token(LPAREN);
    label_30:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[37] = jj_gen;
        break label_30;
      }
      jj_consume_token(SPACE);
    }
       parameters.add(ParameterExpression().trim());
    label_31:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[38] = jj_gen;
        break label_31;
      }
      jj_consume_token(SPACE);
    }
    jj_consume_token(PLACING);
    label_32:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[39] = jj_gen;
        break label_32;
      }
      jj_consume_token(SPACE);
    }
        parameters.add(ParameterExpression().trim());
    label_33:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[40] = jj_gen;
        break label_33;
      }
      jj_consume_token(SPACE);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FROM:
      jj_consume_token(FROM);
      break;
    case COMMA:
      jj_consume_token(COMMA);
      break;
    default:
      jj_la1[41] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_34:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[42] = jj_gen;
        break label_34;
      }
      jj_consume_token(SPACE);
    }
        parameters.add(ParameterExpression().trim());
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
    case SPACE:
    case FOR:
      label_35:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SPACE:
          ;
          break;
        default:
          jj_la1[43] = jj_gen;
          break label_35;
        }
        jj_consume_token(SPACE);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FOR:
        jj_consume_token(FOR);
        break;
      case COMMA:
        jj_consume_token(COMMA);
        break;
      default:
        jj_la1[44] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_36:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SPACE:
          ;
          break;
        default:
          jj_la1[45] = jj_gen;
          break label_36;
        }
        jj_consume_token(SPACE);
      }
           parameters.add(ParameterExpression().trim());
      break;
    default:
      jj_la1[46] = jj_gen;
      ;
    }
    label_37:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[47] = jj_gen;
        break label_37;
      }
      jj_consume_token(SPACE);
    }
    jj_consume_token(RPAREN);
        {if (true) return dialect.transformFN(functionName, parameters.toArray(new String [ 0 ]));}
    throw new Error("Missing return statement in function");
  }

  final public String GroupingSetsExpression() throws ParseException {
    String function;
    List <String> parameters = Lists.newArrayList();
    jj_consume_token(GROUPING);
        function = getToken(0).image;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SPACE:
    case SETS:
      label_38:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SPACE:
          ;
          break;
        default:
          jj_la1[48] = jj_gen;
          break label_38;
        }
        jj_consume_token(SPACE);
      }
      jj_consume_token(SETS);
            log.trace("recognized grouping sets");
            function = getToken(0).image;
      break;
    default:
      jj_la1[49] = jj_gen;
      ;
    }
        log.trace("recognized grouping function");
    label_39:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[50] = jj_gen;
        break label_39;
      }
      jj_consume_token(SPACE);
    }
    jj_consume_token(LPAREN);
    label_40:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[51] = jj_gen;
        break label_40;
      }
      jj_consume_token(SPACE);
    }
        parameters.add(ParameterExpression().trim());
    label_41:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
      case SPACE:
        ;
        break;
      default:
        jj_la1[52] = jj_gen;
        break label_41;
      }
      label_42:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SPACE:
          ;
          break;
        default:
          jj_la1[53] = jj_gen;
          break label_42;
        }
        jj_consume_token(SPACE);
      }
      jj_consume_token(COMMA);
      label_43:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SPACE:
          ;
          break;
        default:
          jj_la1[54] = jj_gen;
          break label_43;
        }
        jj_consume_token(SPACE);
      }
            parameters.add(ParameterExpression().trim());
    }
    label_44:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[55] = jj_gen;
        break label_44;
      }
      jj_consume_token(SPACE);
    }
    jj_consume_token(RPAREN);
        {if (true) return dialect.transformFN(function, parameters.toArray(new String [ 0 ]));}
    throw new Error("Missing return statement in function");
  }

  final public String CeilFloorExpress() throws ParseException {
     String functionName;
     List <String> parameters = Lists.newArrayList();
     ImmutableSet<String> timeunitSet = ImmutableSet.of("YEAR", "QUARTER", "MONTH", "WEEK",
                           "DAY", "HOUR", "MINUTE", "SECOND");
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CEIL:
      jj_consume_token(CEIL);
      break;
    case FLOOR:
      jj_consume_token(FLOOR);
      break;
    default:
      jj_la1[56] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        functionName = getToken(0).image;
    label_45:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[57] = jj_gen;
        break label_45;
      }
      jj_consume_token(SPACE);
    }
    jj_consume_token(LPAREN);
    label_46:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[58] = jj_gen;
        break label_46;
      }
      jj_consume_token(SPACE);
    }
       parameters.add(ParameterExpression().trim());
    label_47:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[59] = jj_gen;
        break label_47;
      }
      jj_consume_token(SPACE);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TO:
      jj_consume_token(TO);
      label_48:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SPACE:
          ;
          break;
        default:
          jj_la1[60] = jj_gen;
          break label_48;
        }
        jj_consume_token(SPACE);
      }
            String timeUnit = ParameterExpression().trim();
            if (!timeunitSet.contains(timeUnit.toUpperCase(Locale.ROOT))) {
                {if (true) throw new IllegalStateException(String.format(Locale.ROOT, CEIL_FLOOR_EXCEPTION_MSG,
                    functionName, timeUnit, String.join(", ", timeunitSet)));}
            }
            parameters.add(timeUnit);
      label_49:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SPACE:
          ;
          break;
        default:
          jj_la1[61] = jj_gen;
          break label_49;
        }
        jj_consume_token(SPACE);
      }
      break;
    default:
      jj_la1[62] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        {if (true) return dialect.transformFN(functionName, parameters.toArray(new String [ 0 ]));}
    throw new Error("Missing return statement in function");
  }

  final public String PiFunction() throws ParseException {
    String function;
    jj_consume_token(PI);
        {if (true) return dialect.transformNiladicFunction("PI");}
    throw new Error("Missing return statement in function");
  }

  final public String Hint() throws ParseException {
    jj_consume_token(HINT);
        log.trace("meet token <HINT>");
        {if (true) return getToken(0).image;}
    throw new Error("Missing return statement in function");
  }

  final public String CubePriority() throws ParseException {
    jj_consume_token(CUBE_PRIORITY);
        log.trace("meet token <CubePriority>");
        {if (true) return getToken(0).image;}
    throw new Error("Missing return statement in function");
  }

  final public String Numeric() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNSIGNED_INTEGER_LITERAL:
      jj_consume_token(UNSIGNED_INTEGER_LITERAL);
      break;
    case DECIMAL_NUMERIC_LITERAL:
      jj_consume_token(DECIMAL_NUMERIC_LITERAL);
      break;
    case APPROX_NUMERIC_LITERAL:
      jj_consume_token(APPROX_NUMERIC_LITERAL);
      break;
    default:
      jj_la1[63] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        log.trace("meet token <APPROX_NUMERIC_LITERAL>");
        {if (true) return getToken(0).image;}
    throw new Error("Missing return statement in function");
  }

  final public String EscapeFunction() throws ParseException {
    String functionName;
    String param;
    List <String> parameters = Lists.newArrayList();
    ImmutableSet<String> tsFunctions = ImmutableSet.of("TIMESTAMPDIFF", "TIMESTAMPADD");
    jj_consume_token(FN);
    jj_consume_token(FUNCTION_NAME);
        functionName = getToken(0).image;
    jj_consume_token(LPAREN);
    label_50:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[64] = jj_gen;
        break label_50;
      }
      jj_consume_token(SPACE);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
    case LPAREN:
    case SPACE:
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
    case QUOTED_IDENTIFIER:
    case HINT:
    case CUBE_PRIORITY:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case DOT:
    case CEIL:
    case FLOOR:
    case SUBSTRING:
    case SUBSTR:
    case CAST:
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
    case EXTRACT:
    case OVERLAY:
    case GROUPING:
    case PI:
    case ANY:
    case EQ:
    case GT:
    case LT:
    case HOOK:
    case COLON:
    case LE:
    case GE:
    case NE:
    case BANGEQUAL:
    case NOT:
    case PLUS:
    case MINUS:
    case STAR:
    case SLASH:
    case MOD:
    case CONCAT:
    case VERTICAL_BAR:
    case CARET:
    case DOLLAR:
      param = ParameterExpression();
            if (tsFunctions.contains(functionName.trim().toUpperCase(Locale.ROOT))) {
                if (param.toUpperCase(Locale.ROOT).startsWith("SQL_TSI_")) {
                    param = param.toUpperCase(Locale.ROOT).replace("SQL_TSI_", "");
                }
                parameters.add(dialect.transformTimeunitOfTimestampDiffOrAdd(param));
            } else {
                parameters.add(param);
            }
      label_51:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[65] = jj_gen;
          break label_51;
        }
        jj_consume_token(COMMA);
        EscapeFunctionParameter(parameters);
      }
      break;
    default:
      jj_la1[66] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
        {if (true) return dialect.transformFN(functionName, parameters.toArray(new String [ 0 ]));}
    throw new Error("Missing return statement in function");
  }

  final public void EscapeFunctionParameter(List<String> paramCollection) throws ParseException {
    String parameter = "";
    parameter = ParameterExpression();
        paramCollection.add(parameter.trim());
  }

  final public String ParameterExpression() throws ParseException {
    String innerString = "";
    String nextString = "";
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      innerString = EscapeExpress();
      break;
    case SUBSTRING:
    case SUBSTR:
      innerString = SubstringExpression();
      break;
    case OVERLAY:
      innerString = OverlayExpression();
      break;
    case GROUPING:
      innerString = GroupingSetsExpression();
      break;
    case CAST:
      innerString = CastExpression();
      break;
    case TIMESTAMPADD:
    case TIMESTAMPDIFF:
      innerString = TsDiffOrAddExpression();
      break;
    case EXTRACT:
      innerString = ExtractExpression();
      break;
    case CEIL:
    case FLOOR:
      innerString = CeilFloorExpress();
      break;
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
      innerString = Numeric();
      break;
    case HINT:
      innerString = Hint();
      break;
    case CUBE_PRIORITY:
      innerString = CubePriority();
      break;
    case LPAREN:
      innerString = ParenExpress();
      break;
    case BINARY_STRING_LITERAL:
    case QUOTED_STRING:
    case PREFIXED_STRING_LITERAL:
    case UNICODE_STRING_LITERAL:
      innerString = QuotedString();
      break;
    case QUOTED_IDENTIFIER:
      innerString = DoubleQuotedString();
      break;
    case SPACE:
      innerString = Space();
      break;
    case PI:
      innerString = PiFunction();
      break;
    case DOT:
    case EQ:
    case GT:
    case LT:
    case HOOK:
    case COLON:
    case LE:
    case GE:
    case NE:
    case BANGEQUAL:
    case NOT:
    case PLUS:
    case MINUS:
    case STAR:
    case SLASH:
    case MOD:
    case CONCAT:
    case VERTICAL_BAR:
    case CARET:
    case DOLLAR:
      innerString = Punctuation();
      break;
    case ANY:
      innerString = Any();
      break;
    default:
      jj_la1[67] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_2(2)) {
      nextString = ParameterExpression();
    } else {
      ;
    }
        {if (true) return innerString + nextString;}
    throw new Error("Missing return statement in function");
  }

  final public String EscapeTimestamp() throws ParseException {
    String timestampExpr;
    jj_consume_token(TS);
    label_52:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[68] = jj_gen;
        break label_52;
      }
      jj_consume_token(SPACE);
    }
    timestampExpr = QuotedString();
        {if (true) return "TIMESTAMP " + timestampExpr;}
    throw new Error("Missing return statement in function");
  }

  final public String EscapeDate() throws ParseException {
    String timestampExpr;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DATE:
      jj_consume_token(DATE);
      break;
    case D:
      jj_consume_token(D);
      break;
    default:
      jj_la1[69] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_53:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[70] = jj_gen;
        break label_53;
      }
      jj_consume_token(SPACE);
    }
    timestampExpr = QuotedString();
        {if (true) return "DATE " + timestampExpr;}
    throw new Error("Missing return statement in function");
  }

  final public String EscapeTime() throws ParseException {
    String timestampExpr;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case T:
      jj_consume_token(T);
      break;
    case TIME:
      jj_consume_token(TIME);
      break;
    default:
      jj_la1[71] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_54:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SPACE:
        ;
        break;
      default:
        jj_la1[72] = jj_gen;
        break label_54;
      }
      jj_consume_token(SPACE);
    }
    timestampExpr = QuotedString();
        {if (true) return "TIME " + timestampExpr;}
    throw new Error("Missing return statement in function");
  }

  final public String BangEqual() throws ParseException {
    jj_consume_token(BANGEQUAL);
        {if (true) return "<>";}
    throw new Error("Missing return statement in function");
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_3R_101() {
    if (jj_scan_token(OVERLAY)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(8)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_122() {
    if (jj_scan_token(ANY)) return true;
    return false;
  }

  private boolean jj_3R_132() {
    if (jj_scan_token(UNICODE_STRING_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_131() {
    if (jj_scan_token(PREFIXED_STRING_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_130() {
    if (jj_scan_token(QUOTED_STRING)) return true;
    return false;
  }

  private boolean jj_3R_129() {
    if (jj_scan_token(BINARY_STRING_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_111() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_129()) {
    jj_scanpos = xsp;
    if (jj_3R_130()) {
    jj_scanpos = xsp;
    if (jj_3R_131()) {
    jj_scanpos = xsp;
    if (jj_3R_132()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_100() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_scan_token(27)) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(8)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_112() {
    if (jj_scan_token(QUOTED_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_133() {
    if (jj_scan_token(FN)) return true;
    return false;
  }

  private boolean jj_3R_121() {
    if (jj_scan_token(AS)) return true;
    return false;
  }

  private boolean jj_3R_106() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_120() {
    if (jj_scan_token(TO)) return true;
    return false;
  }

  private boolean jj_3R_105() {
    if (jj_scan_token(CUBE_PRIORITY)) return true;
    return false;
  }

  private boolean jj_3R_119() {
    if (jj_scan_token(FOR)) return true;
    return false;
  }

  private boolean jj_3R_103() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(34)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(8)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_104() {
    if (jj_scan_token(HINT)) return true;
    return false;
  }

  private boolean jj_3R_118() {
    if (jj_scan_token(FROM)) return true;
    return false;
  }

  private boolean jj_3R_116() {
    if (jj_scan_token(PI)) return true;
    return false;
  }

  private boolean jj_3R_117() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(23)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(42)) {
    jj_scanpos = xsp;
    if (jj_scan_token(43)) {
    jj_scanpos = xsp;
    if (jj_scan_token(44)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(45)) {
    jj_scanpos = xsp;
    if (jj_scan_token(46)) {
    jj_scanpos = xsp;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) {
    jj_scanpos = xsp;
    if (jj_scan_token(56)) {
    jj_scanpos = xsp;
    if (jj_scan_token(57)) {
    jj_scanpos = xsp;
    if (jj_scan_token(59)) {
    jj_scanpos = xsp;
    if (jj_scan_token(60)) {
    jj_scanpos = xsp;
    if (jj_scan_token(58)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_115() {
    if (jj_scan_token(SPACE)) return true;
    return false;
  }

  private boolean jj_3R_108() {
    if (jj_scan_token(EXTRACT)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(8)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_113() {
    if (jj_scan_token(BANGEQUAL)) return true;
    return false;
  }

  private boolean jj_3R_114() {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_109() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(24)) {
    jj_scanpos = xsp;
    if (jj_scan_token(25)) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(8)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_80() {
    if (jj_3R_122()) return true;
    return false;
  }

  private boolean jj_3R_79() {
    if (jj_3R_121()) return true;
    return false;
  }

  private boolean jj_3R_78() {
    if (jj_3R_120()) return true;
    return false;
  }

  private boolean jj_3R_136() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(65)) {
    jj_scanpos = xsp;
    if (jj_scan_token(66)) return true;
    }
    return false;
  }

  private boolean jj_3R_77() {
    if (jj_3R_119()) return true;
    return false;
  }

  private boolean jj_3R_76() {
    if (jj_3R_118()) return true;
    return false;
  }

  private boolean jj_3R_75() {
    if (jj_3R_117()) return true;
    return false;
  }

  private boolean jj_3R_74() {
    if (jj_3R_116()) return true;
    return false;
  }

  private boolean jj_3R_73() {
    if (jj_3R_115()) return true;
    return false;
  }

  private boolean jj_3R_72() {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_71() {
    if (jj_3R_113()) return true;
    return false;
  }

  private boolean jj_3R_70() {
    if (jj_3R_112()) return true;
    return false;
  }

  private boolean jj_3R_69() {
    if (jj_3R_111()) return true;
    return false;
  }

  private boolean jj_3R_68() {
    if (jj_3R_110()) return true;
    return false;
  }

  private boolean jj_3R_67() {
    if (jj_3R_109()) return true;
    return false;
  }

  private boolean jj_3R_66() {
    if (jj_3R_108()) return true;
    return false;
  }

  private boolean jj_3R_65() {
    if (jj_3R_107()) return true;
    return false;
  }

  private boolean jj_3R_64() {
    if (jj_3R_106()) return true;
    return false;
  }

  private boolean jj_3R_63() {
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3R_107() {
    if (jj_scan_token(CAST)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(8)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_135() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(64)) {
    jj_scanpos = xsp;
    if (jj_scan_token(63)) return true;
    }
    return false;
  }

  private boolean jj_3R_62() {
    if (jj_3R_104()) return true;
    return false;
  }

  private boolean jj_3R_61() {
    if (jj_3R_103()) return true;
    return false;
  }

  private boolean jj_3R_60() {
    if (jj_3R_102()) return true;
    return false;
  }

  private boolean jj_3R_59() {
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3R_57() {
    if (jj_3R_99()) return true;
    return false;
  }

  private boolean jj_3R_58() {
    if (jj_3R_100()) return true;
    return false;
  }

  private boolean jj_3R_127() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(8)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(SETS)) return true;
    return false;
  }

  private boolean jj_3R_126() {
    if (jj_3R_136()) return true;
    return false;
  }

  private boolean jj_3R_125() {
    if (jj_3R_135()) return true;
    return false;
  }

  private boolean jj_3R_124() {
    if (jj_3R_134()) return true;
    return false;
  }

  private boolean jj_3R_55() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_57()) {
    jj_scanpos = xsp;
    if (jj_3R_58()) {
    jj_scanpos = xsp;
    if (jj_3R_59()) {
    jj_scanpos = xsp;
    if (jj_3R_60()) {
    jj_scanpos = xsp;
    if (jj_3R_61()) {
    jj_scanpos = xsp;
    if (jj_3R_62()) {
    jj_scanpos = xsp;
    if (jj_3R_63()) {
    jj_scanpos = xsp;
    if (jj_3R_64()) {
    jj_scanpos = xsp;
    if (jj_3R_65()) {
    jj_scanpos = xsp;
    if (jj_3R_66()) {
    jj_scanpos = xsp;
    if (jj_3R_67()) {
    jj_scanpos = xsp;
    if (jj_3R_68()) {
    jj_scanpos = xsp;
    if (jj_3R_69()) {
    jj_scanpos = xsp;
    if (jj_3R_70()) {
    jj_scanpos = xsp;
    if (jj_3R_71()) {
    jj_scanpos = xsp;
    if (jj_3R_72()) {
    jj_scanpos = xsp;
    if (jj_3R_73()) {
    jj_scanpos = xsp;
    if (jj_3R_74()) {
    jj_scanpos = xsp;
    if (jj_3R_75()) {
    jj_scanpos = xsp;
    if (jj_3R_76()) {
    jj_scanpos = xsp;
    if (jj_3R_77()) {
    jj_scanpos = xsp;
    if (jj_3R_78()) {
    jj_scanpos = xsp;
    if (jj_3R_79()) {
    jj_scanpos = xsp;
    if (jj_3R_80()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_123() {
    if (jj_3R_133()) return true;
    return false;
  }

  private boolean jj_3R_134() {
    if (jj_scan_token(TS)) return true;
    return false;
  }

  private boolean jj_3R_102() {
    if (jj_scan_token(GROUPING)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_127()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(8)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_99() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(8)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_123()) {
    jj_scanpos = xsp;
    if (jj_3R_124()) {
    jj_scanpos = xsp;
    if (jj_3R_125()) {
    jj_scanpos = xsp;
    if (jj_3R_126()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3_2() {
    if (jj_3R_56()) return true;
    return false;
  }

  private boolean jj_3R_98() {
    if (jj_3R_122()) return true;
    return false;
  }

  private boolean jj_3R_97() {
    if (jj_3R_117()) return true;
    return false;
  }

  private boolean jj_3R_96() {
    if (jj_3R_116()) return true;
    return false;
  }

  private boolean jj_3R_95() {
    if (jj_3R_115()) return true;
    return false;
  }

  private boolean jj_3R_94() {
    if (jj_3R_112()) return true;
    return false;
  }

  private boolean jj_3R_93() {
    if (jj_3R_111()) return true;
    return false;
  }

  private boolean jj_3R_92() {
    if (jj_3R_110()) return true;
    return false;
  }

  private boolean jj_3R_91() {
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3R_90() {
    if (jj_3R_104()) return true;
    return false;
  }

  private boolean jj_3_1() {
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_89() {
    if (jj_3R_106()) return true;
    return false;
  }

  private boolean jj_3R_128() {
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_88() {
    if (jj_3R_109()) return true;
    return false;
  }

  private boolean jj_3R_87() {
    if (jj_3R_108()) return true;
    return false;
  }

  private boolean jj_3R_86() {
    if (jj_3R_103()) return true;
    return false;
  }

  private boolean jj_3R_85() {
    if (jj_3R_107()) return true;
    return false;
  }

  private boolean jj_3R_84() {
    if (jj_3R_102()) return true;
    return false;
  }

  private boolean jj_3R_83() {
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3R_81() {
    if (jj_3R_99()) return true;
    return false;
  }

  private boolean jj_3R_110() {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_128()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_82() {
    if (jj_3R_100()) return true;
    return false;
  }

  private boolean jj_3R_56() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_81()) {
    jj_scanpos = xsp;
    if (jj_3R_82()) {
    jj_scanpos = xsp;
    if (jj_3R_83()) {
    jj_scanpos = xsp;
    if (jj_3R_84()) {
    jj_scanpos = xsp;
    if (jj_3R_85()) {
    jj_scanpos = xsp;
    if (jj_3R_86()) {
    jj_scanpos = xsp;
    if (jj_3R_87()) {
    jj_scanpos = xsp;
    if (jj_3R_88()) {
    jj_scanpos = xsp;
    if (jj_3R_89()) {
    jj_scanpos = xsp;
    if (jj_3R_90()) {
    jj_scanpos = xsp;
    if (jj_3R_91()) {
    jj_scanpos = xsp;
    if (jj_3R_92()) {
    jj_scanpos = xsp;
    if (jj_3R_93()) {
    jj_scanpos = xsp;
    if (jj_3R_94()) {
    jj_scanpos = xsp;
    if (jj_3R_95()) {
    jj_scanpos = xsp;
    if (jj_3R_96()) {
    jj_scanpos = xsp;
    if (jj_3R_97()) {
    jj_scanpos = xsp;
    if (jj_3R_98()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_2()) jj_scanpos = xsp;
    return false;
  }

  /** Generated Token Manager. */
  public EscapeParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[73];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0xffbf3dc8,0x800000,0x3c00,0xffbf3dc8,0x100,0x0,0x100,0x100,0x100,0x100,0x100,0x100,0x100,0x100,0x100,0x100,0x100,0x0,0x100,0x100,0x100,0x100,0x100,0x100,0x100,0x18000000,0x100,0x100,0x100,0x20000080,0x100,0x100,0x40000080,0x100,0x40000180,0x100,0x100,0x100,0x100,0x100,0x100,0x20000080,0x100,0x100,0x40000080,0x100,0x40000180,0x100,0x100,0x100,0x100,0x100,0x180,0x100,0x100,0x100,0x3000000,0x100,0x100,0x100,0x100,0x100,0x4000000,0x380000,0x100,0x80,0x9bbf3d48,0x9bbf3d48,0x100,0x0,0x100,0x0,0x100,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x1fffff5f,0x1ffffc00,0x0,0x1fffff5f,0x0,0xe0000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1fffff5e,0x1fffff5e,0x0,0x80000000,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x6,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[2];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public EscapeParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public EscapeParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new EscapeParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 73; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 73; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public EscapeParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new EscapeParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 73; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 73; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public EscapeParser(EscapeParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 73; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(EscapeParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 73; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[68];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 73; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 68; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 2; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
