/* Generated By:JavaCC: Do not edit this line. RawSqlParser.java */
package org.apache.kylin.query.util;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class RawSqlParser implements RawSqlParserConstants {

    public static void main(String[] args) throws Exception {
        final String SQL = "select /*+ MODEL_PRIORITY(model1, model2) */ 'col1-;1', col2 -- comment1;\u005cn"
            + "from table -- comment2\u005cn"
            + "/* comment3\u005cn"
            + "   comment4;\u005cn"
            + "   comment5\u005cn"
            + "*/\u005cn"
            + "limit /* comment6 */ 10; -- comment7;";
        System.out.println("--------------Input Sql---------------");
        System.out.println(SQL);

        RawSqlParser parser = new RawSqlParser(new StringReader(SQL));
        List<RawSqlBlock> stmtBlockList = new ArrayList<RawSqlBlock>();
        List<RawSqlBlock> allBlockList = new ArrayList<RawSqlBlock>();
        parser.DoParse(stmtBlockList, allBlockList);

        System.out.println();
        System.out.println("--------------Statements Only---------------");
        StringBuilder stmt = new StringBuilder();
        int prevEndLine = -1;
        for (int i = 0; i < stmtBlockList.size(); i++) {
            RawSqlBlock block = stmtBlockList.get(i);
            String text = block.getText().trim();
            if (i == stmtBlockList.size() - 1) {
                if (";".equals(text.substring(text.length() - 1))) {
                    text = text.substring(0, text.length() - 1);
                }
            }
            if (block.getBeginLine() > prevEndLine) {
                if (prevEndLine != -1) {
                    stmt.append("\u005cn");
                }
                stmt.append(text);
            } else if (block.getBeginLine() == prevEndLine) {
                stmt.append(" ");
                stmt.append(text);
            }
            prevEndLine = block.getEndLine();
        }
        System.out.println(stmt);

        System.out.println();
        System.out.println("--------------Full Text---------------");
        StringBuilder fullText = new StringBuilder();
        for (RawSqlBlock block : allBlockList) {
            String text = block.getText();
            if (block.getType().equals(RawSqlBlock.Type.STATEMENT) && block.equals(stmtBlockList.get(stmtBlockList.size() - 1))) {
                for (int i = text.length() - 1; i >= 0; i--) {
                    char c = text.charAt(i);
                    if (c == '\u005c'' || c == '"') {
                        break;
                    }
                    if (c == ';') {
                        text = text.substring(0, i) + text.substring(i + 1);
                    }
                }
            }
            fullText.append(text);
        }
        System.out.println(fullText);
    }

    private String sql;

    public RawSqlParser(final String sql) {
        this(new StringReader(sql.trim()));
        this.sql = sql.trim();
    }

    public RawSql parse() throws ParseException {
        List<RawSqlBlock> stmtBlockList = new ArrayList<RawSqlBlock>();
        List<RawSqlBlock> allBlockList = new ArrayList<RawSqlBlock>();
        DoParse(stmtBlockList, allBlockList);
        return new RawSql(sql, stmtBlockList, allBlockList);
    }

  final private void DoParse(List<RawSqlBlock> stmtBlockList, List<RawSqlBlock> allBlockList) throws ParseException {
    Token t;
    RawSqlBlock block;
    label_1:
    while (true) {
      if (jj_2_1(2)) {
            if (Thread.currentThread().isInterrupted()) {
                {if (true) throw new ParseException("RawSqlParser is interrupted");}
            }
        block = Comment();
            if (block.getText().contains("CubePriority(")) {
                stmtBlockList.add(block);
            }
            allBlockList.add(block);
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case REMAIN_TOKEN:
        case ANY:
        case HINT:
        case QUOTE_STRING:
        case DOUBLE_QUOTE_STRING:
          block = Stmt();
            stmtBlockList.add(block);
            allBlockList.add(block);
          break;
        default:
          jj_la1[0] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SINGLE_LINE_COMMENT:
      case REMAIN_TOKEN:
      case ANY:
      case HINT:
      case MULTI_LINE_COMMENT:
      case QUOTE_STRING:
      case DOUBLE_QUOTE_STRING:
        ;
        break;
      default:
        jj_la1[1] = jj_gen;
        break label_1;
      }
    }
    jj_consume_token(0);
  }

  final private RawSqlBlock Comment() throws ParseException {
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SINGLE_LINE_COMMENT:
      t = jj_consume_token(SINGLE_LINE_COMMENT);
      break;
    case MULTI_LINE_COMMENT:
      t = jj_consume_token(MULTI_LINE_COMMENT);
      break;
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return new RawSqlBlock(t.image, RawSqlBlock.Type.COMMENT, t.beginLine, t.beginColumn, t.endLine, t.endColumn);}
    throw new Error("Missing return statement in function");
  }

  final private RawSqlBlock Stmt() throws ParseException {
    Token t;
    StringBuilder stmtBuilder = new StringBuilder();
    int beginLine = -1;
    int beginColumn = -1;
    int endLine = -1;
    int endColumn = -1;
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case QUOTE_STRING:
        t = jj_consume_token(QUOTE_STRING);
        break;
      case DOUBLE_QUOTE_STRING:
        t = jj_consume_token(DOUBLE_QUOTE_STRING);
        break;
      case REMAIN_TOKEN:
        t = jj_consume_token(REMAIN_TOKEN);
        break;
      case ANY:
        t = jj_consume_token(ANY);
        break;
      case HINT:
        t = jj_consume_token(HINT);
        break;
      default:
        jj_la1[3] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            stmtBuilder.append(t.image);
            beginLine = beginLine == -1 ? t.beginLine : Math.min(beginLine, t.beginLine);
            beginColumn = beginColumn == -1 ? t.beginColumn : Math.min(beginColumn, t.beginColumn);
            endLine = Math.max(endLine, t.endLine);
            endColumn = Math.max(endColumn, t.endColumn);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case REMAIN_TOKEN:
      case ANY:
      case HINT:
      case QUOTE_STRING:
      case DOUBLE_QUOTE_STRING:
        ;
        break;
      default:
        jj_la1[4] = jj_gen;
        break label_2;
      }
    }
      {if (true) return new RawSqlBlock(stmtBuilder.toString(), RawSqlBlock.Type.STATEMENT, beginLine, beginColumn, endLine, endColumn);}
    throw new Error("Missing return statement in function");
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_3R_3() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(1)) {
    jj_scanpos = xsp;
    if (jj_scan_token(11)) return true;
    }
    return false;
  }

  private boolean jj_3_1() {
    if (jj_3R_3()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public RawSqlParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[5];
  static private int[] jj_la1_0;
  static {
      jj_la1_init_0();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0xa04c,0xa84e,0x802,0xa04c,0xa04c,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[1];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public RawSqlParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public RawSqlParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new RawSqlParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 5; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 5; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public RawSqlParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new RawSqlParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 5; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 5; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public RawSqlParser(RawSqlParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 5; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(RawSqlParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 5; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[16];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 5; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 16; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 1; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
