/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query;

import io.kyligence.kap.guava20.shaded.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.extension.ExtensionFactoryLoader;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.query.engine.SchemaMapExtension;
import org.apache.kylin.query.engine.TableColumnAuthExtension;

public class QueryExtension {
    private static final ExtensionFactoryLoader<Factory> loader = new ExtensionFactoryLoader();
    private static Factory extensionFactory = null;

    private QueryExtension() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Factory getFactory() {
        if (extensionFactory != null) return extensionFactory;
        Class<QueryExtension> clazz = QueryExtension.class;
        synchronized (QueryExtension.class) {
            extensionFactory = (Factory)loader.loadFactory(Factory.class, KylinConfig.getInstanceFromEnv().getQueryExtensionFactory());
            // ** MonitorExit[var0] (shouldn't be in output)
            return extensionFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void setFactory(Factory newFactory) {
        Class<QueryExtension> clazz = QueryExtension.class;
        synchronized (QueryExtension.class) {
            extensionFactory = newFactory;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static class TableColumnAuthExtensionDefault
    implements TableColumnAuthExtension {
        private TableColumnAuthExtensionDefault() {
        }

        @Override
        public boolean isColumnsAuthorized(KylinConfig kylinConfig, String projectName, String user, Set<String> groups, Set<String> columns) {
            return true;
        }
    }

    private static class SchemaMapExtensionDefault
    implements SchemaMapExtension {
        private SchemaMapExtensionDefault() {
        }

        @Override
        public Map<String, List<TableDesc>> getAuthorizedTablesAndColumns(KylinConfig kylinConfig, String projectName, boolean fullyAuthorized, String userName, Set<String> groups) {
            return NTableMetadataManager.getInstance((KylinConfig)kylinConfig, (String)projectName).listTablesGroupBySchema();
        }
    }

    public static class Factory {
        private SchemaMapExtension schemaMapExtension;
        private TableColumnAuthExtension tableColumnAuthExtension;

        public SchemaMapExtension getSchemaMapExtension() {
            if (this.schemaMapExtension == null) {
                this.schemaMapExtension = this.createSchemaMapExtension();
            }
            return this.schemaMapExtension;
        }

        public TableColumnAuthExtension getTableColumnAuthExtension() {
            if (this.tableColumnAuthExtension == null) {
                this.tableColumnAuthExtension = this.createTableColumnAuthExtension();
            }
            return this.tableColumnAuthExtension;
        }

        protected SchemaMapExtension createSchemaMapExtension() {
            return new SchemaMapExtensionDefault();
        }

        protected TableColumnAuthExtension createTableColumnAuthExtension() {
            return new TableColumnAuthExtensionDefault();
        }
    }
}

