/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlowQueryDetector
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger((String)"query");
    private static final ConcurrentHashMap<Thread, QueryEntry> runningQueries = new ConcurrentHashMap();
    private static final ConcurrentMap<String, CanceledSlowQueryStatus> canceledSlowQueriesStatus = Maps.newConcurrentMap();
    private final int detectionIntervalMs;
    private final int queryTimeoutMs;

    public SlowQueryDetector() {
        super("SlowQueryDetector");
        this.setDaemon(true);
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        this.detectionIntervalMs = kylinConfig.getSlowQueryDefaultDetectIntervalSeconds() * 1000;
        this.queryTimeoutMs = kylinConfig.getQueryTimeoutSeconds() * 1000;
    }

    public SlowQueryDetector(int detectionIntervalMs, int queryTimeoutMs) {
        super("SlowQueryDetector");
        this.setDaemon(true);
        this.detectionIntervalMs = detectionIntervalMs;
        this.queryTimeoutMs = queryTimeoutMs;
    }

    public static ConcurrentMap<String, CanceledSlowQueryStatus> getCanceledSlowQueriesStatus() {
        return canceledSlowQueriesStatus;
    }

    @VisibleForTesting
    public static void addCanceledSlowQueriesStatus(ConcurrentMap<String, CanceledSlowQueryStatus> slowQueriesStatus) {
        canceledSlowQueriesStatus.putAll(slowQueriesStatus);
    }

    @VisibleForTesting
    public static void clearCanceledSlowQueriesStatus() {
        canceledSlowQueriesStatus.clear();
    }

    public void queryStart(String stopId) {
        if (QueryContext.current().getQueryTagInfo().isAsyncQuery()) {
            return;
        }
        runningQueries.put(SlowQueryDetector.currentThread(), new QueryEntry(System.currentTimeMillis(), SlowQueryDetector.currentThread(), QueryContext.current().getQueryId(), QueryContext.current().getUserSQL(), stopId, false));
    }

    public void queryEnd() {
        if (QueryContext.current().getQueryTagInfo().isAsyncQuery()) {
            return;
        }
        QueryEntry entry = runningQueries.remove(SlowQueryDetector.currentThread());
        if (null != entry && null != canceledSlowQueriesStatus.get(entry.queryId)) {
            canceledSlowQueriesStatus.remove(entry.queryId);
            logger.debug("Remove query [{}] from canceledSlowQueriesStatus", (Object)entry.queryId);
        }
    }

    @Override
    public void run() {
        while (true) {
            this.checkStopByUser();
            this.checkTimeout();
            try {
                Thread.sleep(this.detectionIntervalMs);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    private void checkStopByUser() {
        for (QueryEntry e : runningQueries.values()) {
            if (!e.isStopByUser) continue;
            e.getThread().interrupt();
            logger.error("Trying to cancel query: {}", (Object)e.getThread().getName());
        }
    }

    private void checkTimeout() {
        for (QueryEntry e : runningQueries.values()) {
            if (!e.setInterruptIfTimeout()) continue;
            try {
                CanceledSlowQueryStatus canceledSlowQueryStatus = (CanceledSlowQueryStatus)canceledSlowQueriesStatus.get(e.getQueryId());
                if (null == canceledSlowQueryStatus) {
                    canceledSlowQueriesStatus.putIfAbsent(e.getQueryId(), new CanceledSlowQueryStatus(e.getQueryId(), 1, System.currentTimeMillis(), e.getRunningTime()));
                    logger.debug("Query [{}] has been canceled 1 times, put to canceledSlowQueriesStatus", (Object)e.queryId);
                    continue;
                }
                int canceledTimes = canceledSlowQueryStatus.getCanceledTimes() + 1;
                canceledSlowQueriesStatus.put(e.getQueryId(), new CanceledSlowQueryStatus(e.getQueryId(), canceledTimes, System.currentTimeMillis(), e.getRunningTime()));
                logger.debug("Query [{}] has been canceled {} times", (Object)e.getQueryId(), (Object)canceledTimes);
            }
            catch (Exception ex) {
                logger.error("Record slow query status failed!", (Throwable)ex);
            }
        }
    }

    @Generated
    public static ConcurrentHashMap<Thread, QueryEntry> getRunningQueries() {
        return runningQueries;
    }

    public class QueryEntry {
        final long startTime;
        final Thread thread;
        final String queryId;
        final String sql;
        final String stopId;
        boolean isStopByUser;

        public long getRunningTime() {
            return (System.currentTimeMillis() - this.startTime) / 1000L;
        }

        private boolean setInterruptIfTimeout() {
            long runningMs = System.currentTimeMillis() - this.startTime;
            if (runningMs >= (long)SlowQueryDetector.this.queryTimeoutMs) {
                this.thread.interrupt();
                logger.error("Trying to cancel query: {}", (Object)this.thread.getName());
                return true;
            }
            return false;
        }

        @Generated
        public long getStartTime() {
            return this.startTime;
        }

        @Generated
        public Thread getThread() {
            return this.thread;
        }

        @Generated
        public String getQueryId() {
            return this.queryId;
        }

        @Generated
        public String getSql() {
            return this.sql;
        }

        @Generated
        public String getStopId() {
            return this.stopId;
        }

        @Generated
        public boolean isStopByUser() {
            return this.isStopByUser;
        }

        @Generated
        public void setStopByUser(boolean isStopByUser) {
            this.isStopByUser = isStopByUser;
        }

        @Generated
        public QueryEntry(long startTime, Thread thread, String queryId, String sql, String stopId, boolean isStopByUser) {
            this.startTime = startTime;
            this.thread = thread;
            this.queryId = queryId;
            this.sql = sql;
            this.stopId = stopId;
            this.isStopByUser = isStopByUser;
        }
    }

    public static class CanceledSlowQueryStatus {
        public final String queryId;
        public final int canceledTimes;
        public final long lastCanceledTime;
        public final float queryDurationTime;

        @Generated
        public String getQueryId() {
            return this.queryId;
        }

        @Generated
        public int getCanceledTimes() {
            return this.canceledTimes;
        }

        @Generated
        public long getLastCanceledTime() {
            return this.lastCanceledTime;
        }

        @Generated
        public float getQueryDurationTime() {
            return this.queryDurationTime;
        }

        @Generated
        public CanceledSlowQueryStatus(String queryId, int canceledTimes, long lastCanceledTime, float queryDurationTime) {
            this.queryId = queryId;
            this.canceledTimes = canceledTimes;
            this.lastCanceledTime = lastCanceledTime;
            this.queryDurationTime = queryDurationTime;
        }
    }
}

