/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.calcite;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.kylin.common.KapConfig;

public class KylinRelDataTypeSystem
extends RelDataTypeSystemImpl {
    public RelDataType deriveAvgAggType(RelDataTypeFactory typeFactory, RelDataType argumentType) {
        if (argumentType instanceof BasicSqlType) {
            switch (argumentType.getSqlTypeName()) {
                case DECIMAL: {
                    return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DECIMAL, argumentType.getPrecision() + 4, argumentType.getScale() + 4), argumentType.isNullable());
                }
            }
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), argumentType.isNullable());
        }
        return super.deriveAvgAggType(typeFactory, argumentType);
    }

    public RelDataType deriveSumType(RelDataTypeFactory typeFactory, RelDataType argumentType) {
        if (argumentType instanceof BasicSqlType) {
            switch (argumentType.getSqlTypeName()) {
                case INTEGER: 
                case SMALLINT: 
                case TINYINT: {
                    return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BIGINT), argumentType.isNullable());
                }
                case DECIMAL: {
                    return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DECIMAL, Math.max(19, argumentType.getPrecision()), argumentType.getScale()), argumentType.isNullable());
                }
            }
        }
        return argumentType;
    }

    public int getMaxNumericPrecision() {
        return 38;
    }

    public boolean shouldConvertRaggedUnionTypesToVarying() {
        return true;
    }

    public int getDefaultScale(SqlTypeName typeName) {
        switch (typeName) {
            case DECIMAL: {
                return KapConfig.getInstanceFromEnv().defaultDecimalScale();
            }
        }
        return super.getDefaultScale(typeName);
    }
}

