/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.enumerator;

import org.apache.calcite.DataContext;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.kylin.common.debug.BackdoorToggles;
import org.apache.kylin.query.enumerator.HiveEnumerator;
import org.apache.kylin.query.enumerator.OLAPEnumerator;
import org.apache.kylin.query.relnode.OLAPContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OLAPQuery
extends AbstractEnumerable<Object[]>
implements Enumerable<Object[]> {
    private static final Logger logger = LoggerFactory.getLogger(OLAPQuery.class);
    private final DataContext optiqContext;
    private final EnumeratorTypeEnum type;
    private final int contextId;

    public OLAPQuery(DataContext optiqContext, EnumeratorTypeEnum type, int ctxId) {
        this.optiqContext = optiqContext;
        this.type = type;
        this.contextId = ctxId;
    }

    public OLAPQuery(EnumeratorTypeEnum type, int ctxSeq) {
        this(null, type, ctxSeq);
    }

    public Enumerator<Object[]> enumerator() {
        if (BackdoorToggles.getPrepareOnly()) {
            return new EmptyEnumerator();
        }
        OLAPContext olapContext = OLAPContext.getThreadLocalContextById(this.contextId);
        switch (this.type) {
            case SIMPLE_AGGREGATION: {
                return new SingleRowEnumerator();
            }
            case OLAP: {
                return new OLAPEnumerator(olapContext, this.optiqContext);
            }
            case HIVE: {
                return new HiveEnumerator(olapContext);
            }
        }
        throw new IllegalArgumentException("Wrong type " + (Object)((Object)this.type) + "!");
    }

    private static class SingleRowEnumerator
    extends RowCountEnumerator {
        public SingleRowEnumerator() {
            logger.debug("Using SingleRow enumerator");
            this.totalRowCount = 1;
        }
    }

    private static abstract class RowCountEnumerator
    implements Enumerator<Object[]> {
        protected int totalRowCount = 1;
        private int currentRowCount = 0;

        public RowCountEnumerator() {
            logger.debug("Using ColumnCount enumerator");
        }

        public void close() {
        }

        public Object[] current() {
            return this.currentRowCount == this.totalRowCount ? null : new Object[]{};
        }

        public boolean moveNext() {
            if (this.currentRowCount == this.totalRowCount) {
                return false;
            }
            ++this.currentRowCount;
            return true;
        }

        public void reset() {
            this.currentRowCount = 0;
        }
    }

    public static class EmptyEnumerator
    implements Enumerator<Object[]> {
        public EmptyEnumerator() {
            logger.debug("Using empty enumerator");
        }

        public void close() {
        }

        public Object[] current() {
            return null;
        }

        public boolean moveNext() {
            return false;
        }

        public void reset() {
        }
    }

    public static enum EnumeratorTypeEnum {
        SIMPLE_AGGREGATION,
        OLAP,
        HIVE;

    }
}

