/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.relnode.OLAPContext;

public class ColumnRowType {
    private List<TblColRef> columns;
    private List<Set<TblColRef>> sourceColumns;

    public ColumnRowType(List<TblColRef> columns) {
        this(columns, null);
    }

    public ColumnRowType(List<TblColRef> columns, List<Set<TblColRef>> sourceColumns) {
        this.columns = columns;
        this.sourceColumns = sourceColumns;
    }

    public TblColRef getColumnByIndex(int index) {
        return this.columns.get(index);
    }

    public TblColRef getColumnByIndexNullable(int index) {
        if (index < 0 || index >= this.columns.size()) {
            return null;
        }
        return this.columns.get(index);
    }

    public TblColRef getColumnByName(String columnName) {
        return this.getColumnByIndexNullable(this.getIndexByName(columnName));
    }

    public int getIndexByName(String columnName) {
        for (int i = 0; i < this.columns.size(); ++i) {
            if (!this.columns.get(i).getName().equalsIgnoreCase(columnName)) continue;
            return i;
        }
        return -1;
    }

    public int getIndexByCanonicalName(String columnName) {
        for (int i = 0; i < this.columns.size(); ++i) {
            if (!this.columns.get(i).getCanonicalName().equalsIgnoreCase(columnName)) continue;
            return i;
        }
        return -1;
    }

    public int getIndexByNameAndByContext(OLAPContext ctx, String columnName) {
        for (int i = 0; i < this.columns.size(); ++i) {
            TblColRef colRef = this.columns.get(i);
            if (!colRef.getName().equals(columnName) || !ctx.belongToContextTables(colRef) || !ctx.realization.getModel().getRootFactTable().equals((Object)colRef.getTableRef())) continue;
            return i;
        }
        return -1;
    }

    public Set<TblColRef> getSourceColumnsByIndex(int i) {
        if (this.sourceColumns != null) {
            return this.sourceColumns.get(i);
        }
        HashSet<TblColRef> result = new HashSet<TblColRef>();
        TblColRef.collectSourceColumns((TblColRef)this.getColumnByIndex(i), result);
        return result;
    }

    public List<TblColRef> getAllColumns() {
        return this.columns;
    }

    public List<Set<TblColRef>> getSourceColumns() {
        return this.sourceColumns;
    }

    public int size() {
        return this.columns.size();
    }

    public String toString() {
        return "ColumnRowType [" + this.columns + "]";
    }
}

