/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSlot;
import org.apache.calcite.sql.fun.SqlCountAggFunction;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.relnode.KapAggregateRel;
import org.apache.kylin.query.relnode.KapFilterRel;
import org.apache.kylin.query.relnode.KapJoinRel;
import org.apache.kylin.query.relnode.KapNonEquiJoinRel;
import org.apache.kylin.query.relnode.KapProjectRel;
import org.apache.kylin.query.relnode.KapRel;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.util.RexUtils;
import org.apache.kylin.util.CalciteSystemProperty;
import org.slf4j.Logger;

public class ContextUtil {
    private ContextUtil() {
    }

    public static Set<OLAPContext> collectSubContext(RelNode subRel) {
        HashSet subContexts = Sets.newHashSet();
        if (subRel == null) {
            return subContexts;
        }
        subContexts.addAll(((KapRel)subRel).getSubContext());
        if (((KapRel)subRel).getContext() != null) {
            subContexts.add(((KapRel)subRel).getContext());
        }
        return subContexts;
    }

    public static Set<OLAPContext> setSubContexts(RelNode relNode) {
        HashSet subContexts = Sets.newHashSet();
        if (relNode == null) {
            return subContexts;
        }
        for (RelNode inputNode : relNode.getInputs()) {
            ContextUtil.setSubContexts(inputNode);
            subContexts.addAll(ContextUtil.collectSubContext(inputNode));
        }
        ((KapRel)relNode).setSubContexts(subContexts);
        return subContexts;
    }

    public static List<OLAPContext> listContextsHavingScan() {
        int size = OLAPContext.getThreadLocalContexts().size();
        ArrayList result = Lists.newArrayListWithCapacity((int)size);
        for (OLAPContext ctx : OLAPContext.getThreadLocalContexts()) {
            if (ctx.firstTableScan == null) continue;
            result.add(ctx);
        }
        return result;
    }

    public static List<OLAPContext> listContexts() {
        if (CollectionUtils.isEmpty(OLAPContext.getThreadLocalContexts())) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList(OLAPContext.getThreadLocalContexts());
    }

    public static boolean qualifiedForAggInfoPushDown(RelNode currentRel, OLAPContext subContext) {
        return (subContext.getParentOfTopNode() instanceof KapJoinRel || subContext.getParentOfTopNode() instanceof KapNonEquiJoinRel) && !(subContext.getTopNode() instanceof KapAggregateRel) && ContextUtil.areSubJoinRelsSameType(currentRel, subContext, null, null) && ContextUtil.derivedFromSameContext(new HashSet<Integer>(), currentRel, subContext, false);
    }

    public static void dumpCalcitePlan(String msg, RelNode relNode, Logger logger) {
        if (Boolean.TRUE.equals(CalciteSystemProperty.DEBUG.value()) && logger.isDebugEnabled()) {
            logger.debug("{} :{}{}", new Object[]{msg, System.getProperty("line.separator"), RelOptUtil.toString((RelNode)relNode)});
        }
    }

    private static boolean derivedFromSameContext(Collection<Integer> indexOfInputCols, RelNode currentNode, OLAPContext subContext, boolean hasCountConstant) {
        if (currentNode instanceof KapAggregateRel) {
            hasCountConstant = ContextUtil.hasCountConstant((KapAggregateRel)currentNode);
            Set<Integer> inputColsIndex = ContextUtil.collectAggInputIndex((KapAggregateRel)currentNode);
            return ContextUtil.derivedFromSameContext(inputColsIndex, ((KapAggregateRel)currentNode).getInput(), subContext, hasCountConstant);
        }
        if (currentNode instanceof KapProjectRel) {
            Set rexLiterals = indexOfInputCols.stream().map(index -> (RexNode)((KapProjectRel)currentNode).rewriteProjects.get((int)index)).filter(RexLiteral.class::isInstance).collect(Collectors.toSet());
            Set<Integer> indexOfInputRel = indexOfInputCols.stream().map(index -> (RexNode)((KapProjectRel)currentNode).rewriteProjects.get((int)index)).flatMap(rex -> RexUtils.getAllInputRefs(rex).stream()).map(RexSlot::getIndex).collect(Collectors.toSet());
            if (!indexOfInputCols.isEmpty() && indexOfInputRel.isEmpty() && rexLiterals.isEmpty()) {
                throw new IllegalStateException("Error on collection index, index " + indexOfInputCols + " child index " + indexOfInputRel);
            }
            return ContextUtil.derivedFromSameContext(indexOfInputRel, ((KapProjectRel)currentNode).getInput(), subContext, hasCountConstant);
        }
        if (currentNode instanceof KapJoinRel || currentNode instanceof KapNonEquiJoinRel) {
            return ContextUtil.isJoinFromSameContext(indexOfInputCols, (Join)currentNode, subContext, hasCountConstant);
        }
        if (currentNode instanceof KapFilterRel) {
            RexNode condition = ((KapFilterRel)currentNode).getCondition();
            if (condition instanceof RexCall) {
                indexOfInputCols.addAll(ContextUtil.collectColsFromFilterRel((RexCall)condition));
            }
            return ContextUtil.derivedFromSameContext(indexOfInputCols, ((KapFilterRel)currentNode).getInput(), subContext, hasCountConstant);
        }
        return false;
    }

    private static boolean hasCountConstant(KapAggregateRel aggRel) {
        return aggRel.aggregateCalls.stream().anyMatch(func -> !func.isDistinct() && func.getArgList().isEmpty() && func.getAggregation() instanceof SqlCountAggFunction);
    }

    private static Set<Integer> collectAggInputIndex(KapAggregateRel aggRel) {
        HashSet inputColsIndex = Sets.newHashSet();
        for (AggregateCall aggregateCall : aggRel.aggregateCalls) {
            if (aggregateCall.getArgList() == null) continue;
            inputColsIndex.addAll(aggregateCall.getArgList());
        }
        inputColsIndex.addAll(aggRel.getRewriteGroupKeys());
        return inputColsIndex;
    }

    private static boolean isJoinFromSameContext(Collection<Integer> indexOfInputCols, Join joinRel, OLAPContext subContext, boolean hasCountConstant) {
        int leftLength;
        if (joinRel.getJoinType() == JoinRelType.LEFT && hasCountConstant) {
            return false;
        }
        if (indexOfInputCols.isEmpty()) {
            return true;
        }
        int maxIndex = Collections.max(indexOfInputCols);
        if (maxIndex < (leftLength = joinRel.getLeft().getRowType().getFieldList().size())) {
            return ContextUtil.isLeftJoinFromSameContext(indexOfInputCols, joinRel, subContext, hasCountConstant);
        }
        int minIndex = Collections.min(indexOfInputCols);
        if (minIndex >= leftLength) {
            return ContextUtil.isRightJoinFromSameContext(indexOfInputCols, joinRel, subContext, hasCountConstant, leftLength);
        }
        return false;
    }

    private static boolean isLeftJoinFromSameContext(Collection<Integer> indexOfInputCols, Join joinRel, OLAPContext subContext, boolean hasCountConstant) {
        KapRel potentialSubRel = (KapRel)joinRel.getLeft();
        if (subContext == potentialSubRel.getContext()) {
            return true;
        }
        if (potentialSubRel.getContext() != null) {
            return false;
        }
        if (potentialSubRel instanceof KapProjectRel) {
            ((KapJoinRel)joinRel).leftKeys.forEach(leftKey -> {
                RexNode leftCol = ((KapProjectRel)potentialSubRel).getProjects().get((int)leftKey);
                if (leftCol instanceof RexCall) {
                    indexOfInputCols.add((Integer)leftKey);
                }
            });
        }
        return ContextUtil.derivedFromSameContext(indexOfInputCols, potentialSubRel, subContext, hasCountConstant);
    }

    private static boolean isRightJoinFromSameContext(Collection<Integer> indexOfInputCols, Join joinRel, OLAPContext subContext, boolean hasCountConstant, int leftLength) {
        KapRel potentialSubRel = (KapRel)joinRel.getRight();
        if (subContext == potentialSubRel.getContext()) {
            return true;
        }
        if (potentialSubRel.getContext() != null) {
            return false;
        }
        HashSet indexOfInputRel = Sets.newHashSet();
        for (Integer indexOfInputCol : indexOfInputCols) {
            indexOfInputRel.add(indexOfInputCol - leftLength);
        }
        return ContextUtil.derivedFromSameContext(indexOfInputRel, potentialSubRel, subContext, hasCountConstant);
    }

    private static boolean areSubJoinRelsSameType(RelNode kapRel, OLAPContext subContext, JoinRelType expectedJoinType, Class<?> joinCondClz) {
        OLAPContext ctx = ((KapRel)kapRel).getContext();
        if (ctx != null && ctx != subContext) {
            return false;
        }
        if (kapRel instanceof Join) {
            Join joinRel = (Join)kapRel;
            if (joinCondClz == null) {
                joinCondClz = joinRel.getCondition().getClass();
            }
            if (expectedJoinType == null) {
                expectedJoinType = joinRel.getJoinType();
            }
            if (joinRel.getJoinType() == expectedJoinType && joinRel.getCondition().getClass().equals(joinCondClz)) {
                return kapRel == subContext.getParentOfTopNode() || ContextUtil.areSubJoinRelsSameType(joinRel.getLeft(), subContext, expectedJoinType, joinCondClz) || ContextUtil.areSubJoinRelsSameType(joinRel.getRight(), subContext, expectedJoinType, joinCondClz);
            }
            return false;
        }
        return kapRel.getInputs().isEmpty() || ContextUtil.areSubJoinRelsSameType(kapRel.getInput(0), subContext, expectedJoinType, joinCondClz);
    }

    private static Set<Integer> collectColsFromFilterRel(RexCall filterCondition) {
        return RexUtils.getAllInputRefs((RexNode)filterCondition).stream().map(RexSlot::getIndex).collect(Collectors.toSet());
    }

    public static void updateSubContexts(Collection<TblColRef> colRefs, Set<OLAPContext> subContexts) {
        for (TblColRef colRef : colRefs) {
            for (OLAPContext context : subContexts) {
                if (colRef == null || !context.belongToContextTables(colRef)) continue;
                context.allColumns.add(colRef);
            }
        }
    }
}

