/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.metadata.cube.cuboid.NLayoutCandidate;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MultiPartitionDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.KapProjectRel;
import org.apache.kylin.query.relnode.KapRel;
import org.apache.kylin.query.relnode.KylinAggregateCall;
import org.apache.kylin.query.relnode.OLAPAggregateRel;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPRel;
import org.apache.kylin.query.util.ICutContextStrategy;

public class KapAggregateRel
extends OLAPAggregateRel
implements KapRel {
    protected static final List<String> supportedFunction = Lists.newArrayList((Object[])new String[]{"SUM", "MIN", "MAX", "COUNT_DISTINCT", "BITMAP_UUID", "PERCENTILE_APPROX", "BITMAP_BUILD", "SUM_LC"});
    private ImmutableList<Integer> rewriteGroupKeys;
    private List<ImmutableBitSet> rewriteGroupSets;
    List<AggregateCall> aggregateCalls;
    private Set<TblColRef> groupByInnerColumns = new HashSet<TblColRef>();
    private Set<OLAPContext> subContexts = Sets.newHashSet();

    public KapAggregateRel(RelOptCluster cluster, RelTraitSet traits, RelNode child, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggregateCalls) throws InvalidRelException {
        super(cluster, traits, child, indicator, groupSet, groupSets, aggregateCalls);
        this.rewriteGroupKeys = ImmutableList.copyOf((Collection)groupSet.toList());
        this.aggregateCalls = aggregateCalls;
        this.rewriteGroupSets = groupSets;
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        for (AggregateCall call : this.aggregateCalls) {
            if (KylinConfig.getInstanceFromEnv().getSkipCorrReduceRule() || !"CORR".equalsIgnoreCase(call.getAggregation().getName())) continue;
            return planner.getCostFactory().makeInfiniteCost();
        }
        return super.computeSelfCost(planner, mq);
    }

    @Override
    public Aggregate copy(RelTraitSet traitSet, RelNode input, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        try {
            return new KapAggregateRel(this.getCluster(), traitSet, input, indicator, groupSet, groupSets, aggCalls);
        }
        catch (InvalidRelException e) {
            throw new IllegalStateException("Can't create OLAPAggregateRel!", e);
        }
    }

    @Override
    public void implementContext(KapRel.OLAPContextImplementor olapContextImplementor, KapRel.ContextVisitorState state) {
        olapContextImplementor.fixSharedOlapTableScan((SingleRel)this);
        KapRel.ContextVisitorState tempState = KapRel.ContextVisitorState.init();
        olapContextImplementor.visitChild(this.getInput(), this, tempState);
        if (tempState.hasFreeTable()) {
            if (CollectionUtils.exists(this.aggregateCalls, aggCall -> ((AggregateCall)aggCall).getAggregation().getKind() == SqlKind.SINGLE_VALUE)) {
                olapContextImplementor.allocateContext((KapRel)this.getInput(), this);
            } else {
                olapContextImplementor.allocateContext(this, null);
            }
            tempState.setHasFreeTable(false);
        }
        state.merge(tempState);
        this.subContexts.addAll(ContextUtil.collectSubContext(this.getInput()));
    }

    @Override
    public void implementCutContext(ICutContextStrategy.CutContextImplementor implementor) {
        this.context = null;
        this.columnRowType = null;
        implementor.visitChild(this.getInput());
    }

    @Override
    public void implementOLAP(OLAPRel.OLAPImplementor olapContextImplementor) {
        olapContextImplementor.visitChild(this.getInput(), this);
        for (AggregateCall aggCall : this.aggregateCalls) {
            if (!FunctionDesc.NOT_SUPPORTED_FUNCTION.contains((Object)aggCall.getAggregation().getName())) continue;
            this.context.getContainedNotSupportedFunc().add(aggCall.getAggregation().getName());
        }
        this.columnRowType = this.buildColumnRowType();
        if (this.context != null) {
            this.context.setHasAgg(true);
            this.afterAggregate = this.context.afterAggregate;
            if (!this.afterAggregate) {
                this.updateContextGroupByColumns();
                this.addAggFunctions();
                this.context.afterAggregate = true;
                if (this.context.afterLimit) {
                    this.context.limitPrecedesAggr = true;
                }
                this.addSourceColsToContext();
                return;
            }
            this.checkAggCallAfterAggRel();
        }
    }

    private void addAggFunctions() {
        for (FunctionDesc agg : this.aggregations) {
            if (agg.isAggregateOnConstant()) {
                this.context.getConstantAggregations().add(agg);
                continue;
            }
            this.context.aggregations.add(agg);
        }
    }

    @Override
    protected void buildGroups() {
        this.buildGroupSet();
        this.buildGroupSets();
    }

    private void buildGroupSet() {
        ArrayList<TblColRef> groups = new ArrayList<TblColRef>();
        LinkedList<Integer> groupKeys = new LinkedList<Integer>();
        this.doBuildGroupSet(this.getGroupSet(), groups, groupKeys);
        this.groups = groups;
        this.rewriteGroupKeys = ImmutableList.copyOf(groupKeys);
    }

    private void buildGroupSets() {
        LinkedList<ImmutableBitSet> newRewriteGroupSets = new LinkedList<ImmutableBitSet>();
        for (ImmutableBitSet subGroup : this.groupSets) {
            ArrayList<TblColRef> groups = new ArrayList<TblColRef>();
            LinkedList<Integer> groupKeys = new LinkedList<Integer>();
            this.doBuildGroupSet(subGroup, groups, groupKeys);
            ImmutableBitSet rewriteGroupSet = ImmutableBitSet.of(groupKeys);
            newRewriteGroupSets.add(rewriteGroupSet);
        }
        this.rewriteGroupSets = newRewriteGroupSets;
    }

    private void doBuildGroupSet(ImmutableBitSet groupSet, List<TblColRef> groups, List<Integer> groupKeys) {
        ColumnRowType inputColumnRowType = ((OLAPRel)this.getInput()).getColumnRowType();
        int i = groupSet.nextSetBit(0);
        while (i >= 0) {
            TblColRef originalColumn = inputColumnRowType.getColumnByIndex(i);
            if (null != this.context && this.context.getGroupCCColRewriteMapping().containsKey(originalColumn)) {
                groups.add(this.context.getGroupCCColRewriteMapping().get(originalColumn));
                groupKeys.add(inputColumnRowType.getIndexByName(this.context.getGroupCCColRewriteMapping().get(originalColumn).getName()));
            } else {
                Set<TblColRef> sourceColumns = inputColumnRowType.getSourceColumnsByIndex(i);
                groups.addAll(sourceColumns);
                groupKeys.add(i);
            }
            if (originalColumn.isInnerColumn()) {
                this.groupByInnerColumns.add(originalColumn);
            }
            i = groupSet.nextSetBit(i + 1);
        }
    }

    public void reBuildGroups(Map<TblColRef, TblColRef> colReplacementMapping) {
        this.context.setGroupCCColRewriteMapping(colReplacementMapping);
        ColumnRowType inputColumnRowType = ((OLAPRel)this.getInput()).getColumnRowType();
        HashSet<TblColRef> groups = new HashSet<TblColRef>();
        int i = this.getGroupSet().nextSetBit(0);
        while (i >= 0) {
            TblColRef originalColumn = inputColumnRowType.getColumnByIndex(i);
            Set<TblColRef> sourceColumns = inputColumnRowType.getSourceColumnsByIndex(i);
            if (colReplacementMapping.containsKey(originalColumn)) {
                groups.add(colReplacementMapping.get(originalColumn));
            } else {
                groups.addAll(sourceColumns);
            }
            i = this.getGroupSet().nextSetBit(i + 1);
        }
        this.setGroups(new ArrayList<TblColRef>(groups));
        this.updateContextGroupByColumns();
    }

    private void updateContextGroupByColumns() {
        this.context.getGroupByColumns().clear();
        for (TblColRef col : this.groups) {
            if (col.isInnerColumn() || !this.context.belongToContextTables(col)) continue;
            this.context.getGroupByColumns().add(col);
        }
        this.context.addInnerGroupColumns(this, this.groupByInnerColumns);
    }

    @Override
    public void setContext(OLAPContext context) {
        this.context = context;
        ((KapRel)this.getInput()).setContext(context);
        this.subContexts.addAll(ContextUtil.collectSubContext(this.getInput()));
    }

    @Override
    public boolean pushRelInfoToContext(OLAPContext context) {
        if (this.context != null) {
            return false;
        }
        if (((KapRel)this.getInput()).pushRelInfoToContext(context)) {
            this.context = context;
            return true;
        }
        return false;
    }

    @Override
    public void implementRewrite(OLAPRel.RewriteImplementor implementor) {
        if (this.context == null) {
            QueryContext.current().getQueryTagInfo().setHasRuntimeAgg(true);
        } else if (this.needRewrite()) {
            this.translateAggregation();
            this.buildRewriteFieldsAndMetricsColumns();
        }
        implementor.visitChild(this, this.getInput());
        if (this.context == null) {
            return;
        }
        if (this.needRewrite()) {
            this.rewriteAggCalls = new ArrayList(this.aggregateCalls.size());
            for (int i = 0; i < this.aggregateCalls.size(); ++i) {
                AggregateCall aggCall = this.aggregateCalls.get(i);
                if (SqlStdOperatorTable.GROUPING == aggCall.getAggregation()) {
                    this.rewriteAggCalls.add(aggCall);
                    continue;
                }
                FunctionDesc cubeFunc = (FunctionDesc)this.aggregations.get(i);
                if (cubeFunc.isAggregateOnConstant()) {
                    this.rewriteAggCalls.add(aggCall);
                    continue;
                }
                aggCall = this.rewriteAggCall(aggCall, cubeFunc);
                this.rewriteAggCalls.add(aggCall);
            }
            this.getContext().setExactlyAggregate(this.isExactlyMatched());
            if (this.getContext().isExactlyAggregate()) {
                boolean fastBitmapEnabled = this.getContext().storageContext.getCandidate().getLayoutEntity().getIndex().getIndexPlan().isFastBitmapEnabled();
                this.getContext().setExactlyFastBitmap(fastBitmapEnabled && this.getContext().isHasBitmapMeasure());
            }
        }
        this.rowType = this.deriveRowType();
        this.columnRowType = this.buildColumnRowType();
    }

    private Boolean isExactlyMatched() {
        if (!KapConfig.getInstanceFromEnv().needReplaceAggWhenExactlyMatched()) {
            return false;
        }
        if (this.getSubContext().size() > 1) {
            return false;
        }
        NLayoutCandidate candidate = this.getContext().storageContext.getCandidate();
        if (candidate.isEmptyCandidate()) {
            return false;
        }
        NDataModel model = candidate.getLayoutEntity().getModel();
        if (model.getStorageType() != 0) {
            return false;
        }
        if (model.getModelType() != NDataModel.ModelType.BATCH) {
            return false;
        }
        if (!this.checkAggCall().booleanValue()) {
            return false;
        }
        HashSet<String> cuboidDimSet = new HashSet();
        if (this.getContext() != null && this.getContext().storageContext.getCandidate() != null) {
            cuboidDimSet = this.getContext().storageContext.getCandidate().getLayoutEntity().getOrderedDimensions().values().stream().map(TblColRef::getIdentity).collect(Collectors.toSet());
        }
        Set<String> groupByCols = this.getGroups().stream().map(TblColRef::getIdentity).collect(Collectors.toSet());
        OLAPRel.logger.info("group by cols:{}", groupByCols);
        OLAPRel.logger.info("cuboid dimensions: {}", cuboidDimSet);
        boolean isDimensionMatch = this.isDimExactlyMatch(groupByCols, cuboidDimSet);
        if (!isDimensionMatch) {
            return false;
        }
        NDataflow dataflow = (NDataflow)this.getContext().realization;
        PartitionDesc partitionDesc = dataflow.getModel().getPartitionDesc();
        MultiPartitionDesc multiPartitionDesc = dataflow.getModel().getMultiPartitionDesc();
        if (this.groupbyContainMultiPartitions(multiPartitionDesc) && this.groupbyContainSegmentPartition(partitionDesc)) {
            OLAPRel.logger.info("Find partition column. skip agg");
            return true;
        }
        return dataflow.getQueryableSegments().size() == 1 && ((NDataSegment)dataflow.getQueryableSegments().get(0)).getMultiPartitions().size() <= 1;
    }

    private Boolean checkAggCall() {
        for (AggregateCall call : this.getRewriteAggCalls()) {
            if (!supportedFunction.contains(OLAPAggregateRel.getAggrFuncName(call))) {
                return false;
            }
            if (OLAPAggregateRel.getAggrFuncName(call).equals("BITMAP_UUID") || OLAPAggregateRel.getAggrFuncName(call).equals("BITMAP_BUILD")) continue;
            if (call instanceof KylinAggregateCall) {
                FunctionDesc func = ((KylinAggregateCall)call).getFunc();
                boolean hasBitmap = func.getReturnDataType() != null && func.getReturnDataType().getName().equals("bitmap");
                if (!hasBitmap) continue;
                this.getContext().setHasBitmapMeasure(true);
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean groupbyContainSegmentPartition(PartitionDesc partitionDesc) {
        return partitionDesc != null && partitionDesc.getPartitionDateColumnRef() != null && this.getGroups().stream().map(TblColRef::getIdentity).collect(Collectors.toSet()).contains(partitionDesc.getPartitionDateColumnRef().getIdentity());
    }

    private boolean groupbyContainMultiPartitions(MultiPartitionDesc multiPartitionDesc) {
        if (multiPartitionDesc == null || CollectionUtils.isEmpty((Collection)multiPartitionDesc.getPartitions())) {
            return true;
        }
        return this.getGroups().stream().map(TblColRef::getIdentity).collect(Collectors.toSet()).containsAll(multiPartitionDesc.getColumnRefs().stream().map(TblColRef::getIdentity).collect(Collectors.toSet()));
    }

    private boolean isDimExactlyMatch(Set<String> groupByCols, Set<String> cuboidDimSet) {
        return groupByCols.equals(cuboidDimSet) && this.isSimpleGroupType() && (this.context.getInnerGroupByColumns().isEmpty() || !this.context.getGroupCCColRewriteMapping().isEmpty());
    }

    @Override
    public Set<OLAPContext> getSubContext() {
        return this.subContexts;
    }

    @Override
    public void setSubContexts(Set<OLAPContext> contexts) {
        this.subContexts = contexts;
    }

    @Override
    protected void buildRewriteFieldsAndMetricsColumns() {
        super.buildRewriteFieldsAndMetricsColumns();
    }

    public void optimizeContextCut() {
        if (this.context == null) {
            for (OLAPContext subContext : this.subContexts) {
                if (subContext.aggregations.size() > 0 || !ContextUtil.qualifiedForAggInfoPushDown(this, subContext)) continue;
                subContext.setTopNode(this);
                this.pushRelInfoToContext(subContext);
            }
        }
    }

    private void addSourceColsToContext() {
        if (this.context == null) {
            return;
        }
        for (TblColRef tblColRef : this.context.getGroupByColumns()) {
            if (tblColRef.getName().startsWith("_KY_") || !this.context.belongToContextTables(tblColRef)) continue;
            this.context.allColumns.add(tblColRef);
        }
        if (!(this.getInput() instanceof KapProjectRel)) {
            for (TblColRef tblColRef : ((KapRel)this.getInput()).getColumnRowType().getAllColumns()) {
                if (!this.context.belongToContextTables(tblColRef) || tblColRef.getName().startsWith("_KY_")) continue;
                this.context.allColumns.add(tblColRef);
            }
            return;
        }
        for (Set set : ((KapProjectRel)this.getInput()).getColumnRowType().getSourceColumns()) {
            for (TblColRef colRef : set) {
                if (!this.context.belongToContextTables(colRef) || colRef.getName().startsWith("_KY_")) continue;
                this.context.allColumns.add(colRef);
            }
        }
    }

    private void checkAggCallAfterAggRel() {
        for (AggregateCall aggCall : this.aggregateCalls) {
            if (!aggCall.isDistinct()) continue;
            throw new IllegalStateException("Distinct count is only allowed in innermost sub-query.");
        }
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        pw.input("input", this.getInput());
        pw.item("group-set", this.rewriteGroupKeys).itemIf("group-sets", this.rewriteGroupSets, this.getGroupType() != Aggregate.Group.SIMPLE).item("groups", (Object)this.groups).itemIf("indicator", (Object)this.indicator, this.indicator).itemIf("aggs", (Object)this.rewriteAggCalls, pw.nest());
        if (!pw.nest()) {
            for (Ord ord : Ord.zip((List)this.rewriteAggCalls)) {
                pw.item((String)Util.first((Object)((AggregateCall)ord.e).name, (Object)("agg#" + ord.i)), ord.e);
            }
        }
        pw.item("ctx", (Object)(this.context == null ? "" : String.valueOf(this.context.id) + "@" + this.context.realization));
        return pw;
    }

    public List<ImmutableBitSet> getRewriteGroupSets() {
        return this.rewriteGroupSets;
    }

    public ImmutableList<Integer> getRewriteGroupKeys() {
        return this.rewriteGroupKeys;
    }

    public boolean isSimpleGroupType() {
        return this.getGroupType() == Aggregate.Group.SIMPLE;
    }

    public boolean isContainCountDistinct() {
        return this.aggregateCalls.stream().anyMatch(agg -> agg.getAggregation().getKind() == SqlKind.COUNT && agg.isDistinct());
    }
}

