/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import java.util.Collection;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.kylin.query.relnode.KapJoinRel;
import org.apache.kylin.query.relnode.KapProjectRel;
import org.apache.kylin.query.relnode.KapRel;
import org.apache.kylin.query.relnode.KapTableScan;
import org.apache.kylin.query.relnode.KapValuesRel;
import org.apache.kylin.query.relnode.KapWindowRel;
import org.apache.kylin.query.relnode.OLAPContext;

public class KapContext {
    static final ThreadLocal<KapRel> _inputRel = new ThreadLocal();
    static final ThreadLocal<RelDataType> _resultType = new ThreadLocal();

    private KapContext() {
    }

    public static KapRel getKapRel() {
        return _inputRel.get();
    }

    public static void setKapRel(KapRel kapRel) {
        _inputRel.set(kapRel);
    }

    public static RelDataType getRowType() {
        return _resultType.get();
    }

    public static void setRowType(RelDataType relDataType) {
        _resultType.set(relDataType);
    }

    public static void clean() {
        _inputRel.set(null);
        _resultType.remove();
    }

    public static void amendAllColsIfNoAgg(RelNode kapRel) {
        if (kapRel == null || ((KapRel)kapRel).getContext() == null || kapRel instanceof KapTableScan) {
            return;
        }
        OLAPContext context = ((KapRel)kapRel).getContext();
        if (kapRel instanceof KapProjectRel && !((KapProjectRel)kapRel).isMerelyPermutation()) {
            ((KapRel)kapRel).getColumnRowType().getSourceColumns().stream().flatMap(Collection::stream).filter(context::isOriginAndBelongToCtxTables).forEach(context.allColumns::add);
        } else if (kapRel instanceof KapValuesRel) {
            ((KapRel)kapRel).getColumnRowType().getAllColumns().stream().filter(context::isOriginAndBelongToCtxTables).forEach(context.allColumns::add);
        } else if (kapRel instanceof KapWindowRel) {
            ((KapWindowRel)kapRel).getGroupingColumns().stream().filter(context::isOriginAndBelongToCtxTables).forEach(context.allColumns::add);
        } else if (kapRel instanceof KapJoinRel) {
            KapContext.amendAllColsIfNoAgg(kapRel.getInput(0));
            KapContext.amendAllColsIfNoAgg(kapRel.getInput(1));
        } else {
            KapContext.amendAllColsIfNoAgg(kapRel.getInput(0));
        }
    }
}

