/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.fun.SqlLikeOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.query.calcite.KylinRelDataTypeSystem;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.KapContext;
import org.apache.kylin.query.relnode.KapRel;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPFilterRel;
import org.apache.kylin.query.relnode.OLAPRel;
import org.apache.kylin.query.relnode.OLAPTableScan;
import org.apache.kylin.query.util.ICutContextStrategy;
import org.apache.kylin.query.util.RexToTblColRefTranslator;
import org.apache.kylin.query.util.RexUtils;
import org.apache.kylin.util.FilterConditionExpander;

public class KapFilterRel
extends OLAPFilterRel
implements KapRel {
    private Set<OLAPContext> subContexts = Sets.newHashSet();
    private boolean belongToPreAggContext = false;

    public KapFilterRel(RelOptCluster cluster, RelTraitSet traits, RelNode child, RexNode condition) {
        super(cluster, traits, child, condition);
    }

    @Override
    public Filter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
        return new KapFilterRel(this.getCluster(), traitSet, input, condition);
    }

    @Override
    public void implementCutContext(ICutContextStrategy.CutContextImplementor implementor) {
        this.context = null;
        this.columnRowType = null;
        this.belongToPreAggContext = false;
        implementor.visitChild(this.getInput());
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        RelOptCost c = super.computeSelfCost(planner, mq);
        return c;
    }

    @Override
    public void setContext(OLAPContext context) {
        this.context = context;
        ((KapRel)this.getInput()).setContext(context);
        this.subContexts.addAll(ContextUtil.collectSubContext((KapRel)this.getInput()));
    }

    @Override
    public boolean pushRelInfoToContext(OLAPContext context) {
        if (this.context == null && ((KapRel)this.getInput()).pushRelInfoToContext(context)) {
            this.context = context;
            this.belongToPreAggContext = true;
            return true;
        }
        return false;
    }

    @Override
    public void implementContext(KapRel.OLAPContextImplementor olapContextImplementor, KapRel.ContextVisitorState state) {
        olapContextImplementor.fixSharedOlapTableScan((SingleRel)this);
        KapRel.ContextVisitorState tempState = KapRel.ContextVisitorState.init();
        olapContextImplementor.visitChild(this.getInput(), this, tempState);
        state.merge(KapRel.ContextVisitorState.of(true, false)).merge(tempState);
        this.subContexts.addAll(ContextUtil.collectSubContext((KapRel)this.getInput()));
    }

    @Override
    public void implementOLAP(OLAPRel.OLAPImplementor olapContextImplementor) {
        olapContextImplementor.visitChild(this.getInput(), this);
        if (RexUtils.countOperatorCall(this.condition, SqlLikeOperator.class) > 0) {
            QueryContext.current().getQueryTagInfo().setHasLike(true);
        }
        this.columnRowType = this.buildColumnRowType();
        if (this.context != null) {
            if (!this.context.afterAggregate) {
                this.updateContextFilter();
            } else {
                this.context.afterHavingClauseFilter = true;
            }
            if (this == this.context.getTopNode() && !this.context.isHasAgg()) {
                KapContext.amendAllColsIfNoAgg(this);
            }
        } else {
            this.pushDownColsInfo(this.subContexts);
        }
    }

    private boolean isHeterogeneousSegmentOrMultiPartEnabled(OLAPContext context) {
        if (context.olapSchema == null) {
            return false;
        }
        String projectName = context.olapSchema.getProjectName();
        KylinConfigExt kylinConfig = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(projectName).getConfig();
        return kylinConfig.isHeterogeneousSegmentEnabled() || kylinConfig.isMultiPartitionEnabled();
    }

    private boolean isJoinMatchOptimizationEnabled() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        return kylinConfig.isJoinMatchOptimizationEnabled();
    }

    private void collectNotNullTableWithFilterCondition(OLAPContext context) {
        if (context == null || CollectionUtils.isEmpty(context.allTableScans)) {
            return;
        }
        RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)new JavaTypeFactoryImpl((RelDataTypeSystem)new KylinRelDataTypeSystem()));
        RexNode newDnf = RexUtil.toDnf((RexBuilder)rexBuilder, (RexNode)this.condition);
        Set leftOrInnerTables = context.allTableScans.stream().map(OLAPTableScan::getTableRef).collect(Collectors.toSet());
        HashSet orNotNullTables = Sets.newHashSet();
        MatchWithFilterVisitor visitor = new MatchWithFilterVisitor(this.columnRowType, orNotNullTables);
        if (SqlStdOperatorTable.OR.equals((Object)((RexCall)newDnf).getOperator())) {
            for (RexNode rexNode : ((RexCall)newDnf).getOperands()) {
                rexNode.accept((RexVisitor)visitor);
                leftOrInnerTables.retainAll(orNotNullTables);
                orNotNullTables.clear();
            }
        } else {
            newDnf.accept((RexVisitor)visitor);
            leftOrInnerTables.retainAll(orNotNullTables);
        }
        context.getNotNullTables().addAll(leftOrInnerTables);
    }

    private void updateContextFilter() {
        HashSet filterColumns = Sets.newHashSet();
        OLAPFilterRel.FilterVisitor visitor = new OLAPFilterRel.FilterVisitor(this.columnRowType, filterColumns);
        this.condition.accept((RexVisitor)visitor);
        if (this.isHeterogeneousSegmentOrMultiPartEnabled(this.context)) {
            this.context.getExpandedFilterConditions().addAll(new FilterConditionExpander(this.context, this).convert(this.condition));
        }
        if (this.isJoinMatchOptimizationEnabled()) {
            this.collectNotNullTableWithFilterCondition(this.context);
        }
        for (TblColRef tblColRef : filterColumns) {
            if (tblColRef.isInnerColumn() || !this.context.belongToContextTables(tblColRef)) continue;
            this.context.allColumns.add(tblColRef);
            this.context.filterColumns.add(tblColRef);
        }
        this.context.getInnerFilterColumns().addAll(this.collectInnerColumnInFilter());
    }

    private Collection<TblColRef> collectInnerColumnInFilter() {
        HashSet<TblColRef> resultSet = new HashSet<TblColRef>();
        if (this.condition instanceof RexCall) {
            for (RexNode childCondition : ((RexCall)this.condition).getOperands()) {
                this.doCollectInnerColumnInFilter(childCondition, resultSet);
            }
        }
        return resultSet;
    }

    private void doCollectInnerColumnInFilter(RexNode rexNode, Collection<TblColRef> resultSet) {
        if (rexNode instanceof RexCall) {
            RexCall rexCall = (RexCall)rexNode;
            SqlKind sqlKind = rexCall.getOperator().kind;
            if (sqlKind == SqlKind.AND || sqlKind == SqlKind.OR || SqlKind.COMPARISON.contains(sqlKind) || sqlKind == SqlKind.NOT_IN || sqlKind == SqlKind.LIKE || sqlKind == SqlKind.SIMILAR || sqlKind == SqlKind.BETWEEN || sqlKind.name().startsWith("IS_")) {
                rexCall.getOperands().forEach(childRexNode -> this.doCollectInnerColumnInFilter((RexNode)childRexNode, resultSet));
            } else {
                TblColRef colRef;
                try {
                    colRef = RexToTblColRefTranslator.translateRexNode((RexNode)rexCall, ((OLAPRel)this.input).getColumnRowType());
                }
                catch (IllegalStateException e) {
                    return;
                }
                if (colRef.isInnerColumn() && !colRef.getSourceColumns().isEmpty()) {
                    resultSet.add(colRef);
                }
            }
        }
    }

    @Override
    public void implementRewrite(OLAPRel.RewriteImplementor implementor) {
        implementor.visitChild(this, this.getInput());
        if (this.context != null) {
            this.rowType = this.deriveRowType();
            this.columnRowType = this.buildColumnRowType();
        }
    }

    private void pushDownColsInfo(Set<OLAPContext> subContexts) {
        for (OLAPContext context : subContexts) {
            if (this.condition == null) {
                return;
            }
            HashSet filterColumns = Sets.newHashSet();
            OLAPFilterRel.FilterVisitor visitor = new OLAPFilterRel.FilterVisitor(this.columnRowType, filterColumns);
            this.condition.accept((RexVisitor)visitor);
            if (this.isHeterogeneousSegmentOrMultiPartEnabled(context)) {
                context.getExpandedFilterConditions().addAll(new FilterConditionExpander(context, this).convert(this.condition));
            }
            if (this.isJoinMatchOptimizationEnabled()) {
                this.collectNotNullTableWithFilterCondition(context);
            }
            for (TblColRef tblColRef : filterColumns) {
                if (tblColRef.isInnerColumn() || !context.belongToContextTables(tblColRef)) continue;
                context.allColumns.add(tblColRef);
                context.filterColumns.add(tblColRef);
                if (!this.belongToPreAggContext) continue;
                context.getGroupByColumns().add(tblColRef);
            }
        }
    }

    @Override
    public Set<OLAPContext> getSubContext() {
        return this.subContexts;
    }

    @Override
    public void setSubContexts(Set<OLAPContext> contexts) {
        this.subContexts = contexts;
    }

    private class MatchWithFilterVisitor
    extends RexVisitorImpl<RexNode> {
        private ColumnRowType columnRowType;
        private Set<TableRef> notNullTables;

        protected MatchWithFilterVisitor(ColumnRowType columnRowType, Set<TableRef> notNullTables) {
            super(true);
            this.columnRowType = columnRowType;
            this.notNullTables = notNullTables;
        }

        public RexCall visitCall(RexCall call) {
            if (!this.deep) {
                return null;
            }
            RexCall r = null;
            if (SqlStdOperatorTable.CASE.equals((Object)call.getOperator())) {
                List rexNodes = call.getOperands();
                boolean isOpNull = SqlStdOperatorTable.IS_NULL.equals((Object)((RexCall)rexNodes.get(0)).getOperator());
                boolean isSecondFalse = ((RexNode)call.getOperands().get(1)).isAlwaysFalse();
                if (isOpNull && isSecondFalse) {
                    r = (RexCall)((RexNode)call.getOperands().get(2)).accept((RexVisitor)this);
                    return r;
                }
                return null;
            }
            if (SqlStdOperatorTable.IS_NULL.equals((Object)call.getOperator())) {
                return null;
            }
            for (RexNode operand : call.operands) {
                r = (RexCall)operand.accept((RexVisitor)this);
            }
            return r;
        }

        public RexCall visitInputRef(RexInputRef inputRef) {
            TableRef notNullTable = this.columnRowType.getColumnByIndex(inputRef.getIndex()).getTableRef();
            this.notNullTables.add(notNullTable);
            return null;
        }
    }
}

