/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.adapter.enumerable.EnumerableJoin;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.KapContext;
import org.apache.kylin.query.relnode.KapRel;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPJoinRel;
import org.apache.kylin.query.relnode.OLAPRel;
import org.apache.kylin.query.relnode.OLAPTableScan;
import org.apache.kylin.query.util.ICutContextStrategy;
import org.apache.kylin.query.util.RexUtils;

public class KapJoinRel
extends OLAPJoinRel
implements KapRel {
    private Set<OLAPContext> subContexts = Sets.newHashSet();
    private boolean isPreCalJoin = true;
    private boolean aboveTopPreCalcJoin = false;
    private boolean joinCondEqualNullSafe = false;

    public KapJoinRel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys, Set<CorrelationId> variablesSet, JoinRelType joinType) throws InvalidRelException {
        super(cluster, traits, left, right, condition, leftKeys, rightKeys, variablesSet, joinType);
    }

    @Override
    public EnumerableJoin copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        JoinInfo joinInfo = JoinInfo.of((RelNode)left, (RelNode)right, (RexNode)conditionExpr);
        assert (joinInfo.isEqui());
        try {
            return new KapJoinRel(this.getCluster(), traitSet, left, right, conditionExpr, joinInfo.leftKeys, joinInfo.rightKeys, (Set<CorrelationId>)this.variablesSet, joinType);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean isRuntimeJoin() {
        if (this.context != null) {
            this.context.setReturnTupleInfo(this.rowType, this.columnRowType);
        }
        return this.context == null || ((KapRel)this.left).getContext() != ((KapRel)this.right).getContext();
    }

    @Override
    public void implementContext(KapRel.OLAPContextImplementor olapContextImplementor, KapRel.ContextVisitorState state) {
        KapRel.ContextVisitorState leftState = KapRel.ContextVisitorState.init();
        olapContextImplementor.fixSharedOlapTableScanOnTheLeft((BiRel)this);
        olapContextImplementor.visitChild(this.getInput(0), this, leftState);
        KapRel.ContextVisitorState rightState = KapRel.ContextVisitorState.init();
        olapContextImplementor.fixSharedOlapTableScanOnTheRight((BiRel)this);
        olapContextImplementor.visitChild(this.getInput(1), this, rightState);
        if (leftState.hasModelView() || rightState.hasModelView()) {
            if (leftState.hasFreeTable()) {
                olapContextImplementor.allocateContext((KapRel)this.getInput(0), this);
                leftState.setHasFreeTable(false);
            }
            if (rightState.hasFreeTable()) {
                olapContextImplementor.allocateContext((KapRel)this.getInput(1), this);
                rightState.setHasFreeTable(false);
            }
        }
        if (this.getJoinType() == JoinRelType.LEFT && rightState.hasFilter() && rightState.hasFreeTable()) {
            olapContextImplementor.allocateContext((KapRel)this.getInput(1), this);
            rightState.setHasFreeTable(false);
        }
        if (this.getJoinType() == JoinRelType.INNER || this.getJoinType() == JoinRelType.LEFT) {
            if (!leftState.hasFreeTable() && rightState.hasFreeTable()) {
                olapContextImplementor.allocateContext((KapRel)this.right, this);
                rightState.setHasFreeTable(false);
            } else if (leftState.hasFreeTable() && !rightState.hasFreeTable()) {
                olapContextImplementor.allocateContext((KapRel)this.left, this);
                leftState.setHasFreeTable(false);
            } else if (leftState.hasFreeTable() && rightState.hasFreeTable() && (this.isCrossJoin() || this.hasSameFirstTable(leftState, rightState) || this.isRightSideIncrementalTable(rightState) || RexUtils.joinMoreThanOneTable((Join)this) || !RexUtils.isMerelyTableColumnReference(this, this.condition) || this.joinCondEqualNullSafe)) {
                olapContextImplementor.allocateContext((KapRel)this.left, this);
                olapContextImplementor.allocateContext((KapRel)this.right, this);
                leftState.setHasFreeTable(false);
                rightState.setHasFreeTable(false);
            }
            state.merge(leftState).merge(rightState);
            this.subContexts.addAll(ContextUtil.collectSubContext(this.left));
            this.subContexts.addAll(ContextUtil.collectSubContext(this.right));
            return;
        }
        if (leftState.hasFreeTable()) {
            olapContextImplementor.allocateContext((KapRel)this.left, this);
            leftState.setHasFreeTable(false);
        }
        if (rightState.hasFreeTable()) {
            olapContextImplementor.allocateContext((KapRel)this.right, this);
            rightState.setHasFreeTable(false);
        }
        state.merge(leftState).merge(rightState);
        this.subContexts.addAll(ContextUtil.collectSubContext(this.left));
        this.subContexts.addAll(ContextUtil.collectSubContext(this.right));
    }

    private boolean isRightSideIncrementalTable(KapRel.ContextVisitorState rightState) {
        return rightState.hasIncrementalTable();
    }

    private boolean hasSameFirstTable(KapRel.ContextVisitorState leftState, KapRel.ContextVisitorState rightState) {
        return !leftState.hasIncrementalTable() && !rightState.hasIncrementalTable() && leftState.hasFirstTable() && rightState.hasFirstTable();
    }

    private boolean isCrossJoin() {
        return this.leftKeys.isEmpty() || this.rightKeys.isEmpty();
    }

    @Override
    public void implementCutContext(ICutContextStrategy.CutContextImplementor implementor) {
        if (!this.isPreCalJoin) {
            RelNode input = this.context == ((KapRel)this.left).getContext() ? this.left : this.right;
            implementor.visitChild(input);
            this.context = null;
            this.columnRowType = null;
        } else {
            this.context = null;
            this.columnRowType = null;
            implementor.allocateContext((KapRel)this.getInput(0), this);
            implementor.allocateContext((KapRel)this.getInput(1), this);
        }
    }

    @Override
    public void setContext(OLAPContext context) {
        this.context = context;
        for (RelNode input : this.getInputs()) {
            ((KapRel)input).setContext(context);
            this.subContexts.addAll(ContextUtil.collectSubContext(input));
        }
    }

    @Override
    public boolean pushRelInfoToContext(OLAPContext context) {
        if (this.context != null) {
            return false;
        }
        if (this == context.getParentOfTopNode() || ((KapRel)this.getLeft()).pushRelInfoToContext(context) || ((KapRel)this.getRight()).pushRelInfoToContext(context)) {
            this.context = context;
            this.isPreCalJoin = false;
            return true;
        }
        return false;
    }

    @Override
    public void implementOLAP(OLAPRel.OLAPImplementor olapContextImplementor) {
        if (this.context != null) {
            this.context.allOlapJoins.add(this);
            this.aboveTopPreCalcJoin = !this.isPreCalJoin || !this.context.isHasPreCalcJoin();
            this.context.setHasJoin(true);
            this.context.setHasPreCalcJoin(this.context.isHasPreCalcJoin() || this.isPreCalJoin);
        }
        olapContextImplementor.visitChild(this.left, this);
        olapContextImplementor.visitChild(this.right, this);
        Preconditions.checkState((!this.hasSubQuery ? 1 : 0) != 0, (Object)"there should be no subquery in context");
        this.columnRowType = this.buildColumnRowType();
        if (this.context != null) {
            this.collectCtxOlapInfoIfExist();
        } else {
            Map<TblColRef, TblColRef> joinColumns = this.translateJoinColumn(this.getCondition());
            this.pushDownJoinColsToSubContexts(joinColumns.entrySet().stream().flatMap(e -> Stream.of((TblColRef)e.getKey(), (TblColRef)e.getValue())).collect(Collectors.toSet()));
        }
    }

    private void collectCtxOlapInfoIfExist() {
        if (this.isPreCalJoin || this.context.getParentOfTopNode() instanceof OLAPRel && ((OLAPRel)this.context.getParentOfTopNode()).getContext() != this.context) {
            JoinDesc join = this.buildJoin((RexCall)this.getCondition());
            String joinType = this.getJoinType() == JoinRelType.INNER || this.getJoinType() == JoinRelType.LEFT ? this.getJoinType().name() : null;
            join.setType(joinType);
            this.context.joins.add(join);
        } else {
            Map<TblColRef, TblColRef> joinColumnsMap = this.translateJoinColumn(this.getCondition());
            Collection joinCols = joinColumnsMap.entrySet().stream().flatMap(e -> Stream.of((TblColRef)e.getKey(), (TblColRef)e.getValue())).collect(Collectors.toSet());
            joinCols.stream().flatMap(e -> e.getSourceColumns().stream()).filter(this.context::belongToContextTables).forEach(colRef -> {
                this.context.getSubqueryJoinParticipants().add((TblColRef)colRef);
                this.context.allColumns.add((TblColRef)colRef);
            });
            this.pushDownJoinColsToSubContexts(joinCols);
        }
        if (this == this.context.getTopNode() && !this.context.isHasAgg()) {
            KapContext.amendAllColsIfNoAgg(this);
        }
    }

    @Override
    public void implementRewrite(OLAPRel.RewriteImplementor implementor) {
        implementor.visitChild(this, this.left);
        implementor.visitChild(this, this.right);
        if (this.context != null) {
            this.rowType = this.deriveRowType();
            if (this.context.hasPrecalculatedFields() && this.aboveTopPreCalcJoin && OLAPRel.RewriteImplementor.needRewrite(this.context)) {
                int paramIndex = this.rowType.getFieldList().size();
                LinkedList newFieldList = Lists.newLinkedList();
                for (Map.Entry<String, RelDataType> rewriteField : this.context.rewriteFields.entrySet()) {
                    String fieldName = rewriteField.getKey();
                    if (this.rowType.getField(fieldName, true, false) != null) continue;
                    RelDataType fieldType = rewriteField.getValue();
                    RelDataTypeFieldImpl newField = new RelDataTypeFieldImpl(fieldName, paramIndex++, fieldType);
                    newFieldList.add(newField);
                }
                RelDataTypeFactory.FieldInfoBuilder fieldInfo = this.getCluster().getTypeFactory().builder();
                fieldInfo.addAll((Iterable)this.rowType.getFieldList());
                fieldInfo.addAll((Iterable)newFieldList);
                this.rowType = this.getCluster().getTypeFactory().createStructType((RelDataTypeFactory.FieldInfo)fieldInfo);
                this.columnRowType = this.rebuildColumnRowType(newFieldList, this.context);
            }
        }
    }

    @Override
    public EnumerableRel implementEnumerable(List<EnumerableRel> inputs) {
        if (this.isRuntimeJoin()) {
            try {
                return EnumerableJoin.create((RelNode)((RelNode)inputs.get(0)), (RelNode)((RelNode)inputs.get(1)), (RexNode)this.condition, (ImmutableIntList)this.leftKeys, (ImmutableIntList)this.rightKeys, (Set)this.variablesSet, (JoinRelType)this.joinType);
            }
            catch (Exception e) {
                throw new IllegalStateException("Can't create EnumerableJoin!", e);
            }
        }
        return this;
    }

    private void pushDownJoinColsToSubContexts(Collection<TblColRef> joinColumns) {
        for (OLAPContext context : this.subContexts) {
            this.collectJoinColsToContext(joinColumns, context);
        }
    }

    private void collectJoinColsToContext(Collection<TblColRef> joinColumns, OLAPContext context) {
        Set sourceJoinKeyCols = joinColumns.stream().flatMap(col -> col.getSourceColumns().stream()).filter(context::belongToContextTables).collect(Collectors.toSet());
        context.allColumns.addAll(sourceJoinKeyCols);
        if (context.getOuterJoinParticipants().isEmpty() && this.isDirectOuterJoin(this, context)) {
            context.getOuterJoinParticipants().addAll(sourceJoinKeyCols);
        }
    }

    private boolean isDirectOuterJoin(RelNode currentNode, OLAPContext context) {
        if (currentNode == this && currentNode instanceof Join) {
            for (RelNode input : currentNode.getInputs()) {
                if (!this.isDirectOuterJoin(input, context)) continue;
                return true;
            }
            return false;
        }
        if (((KapRel)currentNode).getContext() == context) {
            return true;
        }
        if (currentNode instanceof Project || currentNode instanceof Filter) {
            return this.isDirectOuterJoin(currentNode.getInput(0), context);
        }
        return false;
    }

    @Override
    public Set<OLAPContext> getSubContext() {
        return this.subContexts;
    }

    @Override
    public void setSubContexts(Set<OLAPContext> contexts) {
        this.subContexts = contexts;
    }

    private ColumnRowType rebuildColumnRowType(List<RelDataTypeField> missingFields, OLAPContext context) {
        ArrayList columns = Lists.newArrayList();
        OLAPRel olapLeft = (OLAPRel)this.left;
        OLAPRel olapRight = (OLAPRel)this.right;
        columns.addAll(olapLeft.getColumnRowType().getAllColumns());
        columns.addAll(olapRight.getColumnRowType().getAllColumns());
        for (RelDataTypeField dataTypeField : missingFields) {
            OLAPTableScan tableScan;
            String fieldName = dataTypeField.getName();
            TblColRef aggOutCol = null;
            Iterator<OLAPTableScan> iterator = context.allTableScans.iterator();
            while (iterator.hasNext() && (aggOutCol = (tableScan = iterator.next()).getColumnRowType().getColumnByName(fieldName)) == null) {
            }
            if (aggOutCol == null) {
                aggOutCol = TblColRef.newInnerColumn((String)fieldName, (TblColRef.InnerDataTypeEnum)TblColRef.InnerDataTypeEnum.LITERAL);
            }
            aggOutCol.getColumnDesc().setId("" + dataTypeField.getIndex());
            columns.add(aggOutCol);
        }
        if (columns.size() != this.rowType.getFieldCount()) {
            throw new IllegalStateException("RowType=" + this.rowType.getFieldCount() + ", ColumnRowType=" + columns.size());
        }
        return new ColumnRowType(columns);
    }

    public boolean isJoinCondEqualNullSafe() {
        return this.joinCondEqualNullSafe;
    }

    public void setJoinCondEqualNullSafe(boolean joinCondEqualNullSafe) {
        this.joinCondEqualNullSafe = joinCondEqualNullSafe;
    }
}

