/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableLimit;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.KapContext;
import org.apache.kylin.query.relnode.KapRel;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPLimitRel;
import org.apache.kylin.query.relnode.OLAPRel;
import org.apache.kylin.query.util.ICutContextStrategy;

public class KapLimitRel
extends OLAPLimitRel
implements KapRel {
    private Set<OLAPContext> subContexts = Sets.newHashSet();

    public KapLimitRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode offset, RexNode fetch) {
        super(cluster, traitSet, child, offset, fetch);
    }

    @Override
    public KapLimitRel copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new KapLimitRel(this.getCluster(), traitSet, (RelNode)AbstractRelNode.sole(inputs), this.localOffset, this.localFetch);
    }

    @Override
    public void implementCutContext(ICutContextStrategy.CutContextImplementor implementor) {
        this.context = null;
        this.columnRowType = null;
        implementor.visitChild(this.getInput());
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq);
    }

    @Override
    public EnumerableRel implementEnumerable(List<EnumerableRel> inputs) {
        EnumerableRel input = (EnumerableRel)AbstractRelNode.sole(inputs);
        if (input instanceof OLAPRel) {
            ((OLAPRel)input).replaceTraitSet((RelTrait)EnumerableConvention.INSTANCE);
        }
        return EnumerableLimit.create((RelNode)input, (RexNode)this.localOffset, (RexNode)this.localFetch);
    }

    @Override
    public void setContext(OLAPContext context) {
        this.context = context;
        ((KapRel)this.getInput()).setContext(context);
        this.subContexts.addAll(ContextUtil.collectSubContext((KapRel)this.getInput()));
    }

    @Override
    public boolean pushRelInfoToContext(OLAPContext context) {
        if (this.context == null && ((KapRel)this.getInput()).pushRelInfoToContext(context)) {
            this.context = context;
            return true;
        }
        return false;
    }

    @Override
    public void implementContext(KapRel.OLAPContextImplementor olapContextImplementor, KapRel.ContextVisitorState state) {
        olapContextImplementor.fixSharedOlapTableScan(this);
        KapRel.ContextVisitorState tempState = KapRel.ContextVisitorState.init();
        olapContextImplementor.visitChild(this.getInput(), this, tempState);
        if (tempState.hasFreeTable()) {
            olapContextImplementor.allocateContext(this, null);
            tempState.setHasFreeTable(false);
        }
        this.subContexts.addAll(ContextUtil.collectSubContext(this.getInput()));
        if (this.context == null && this.subContexts.size() == 1 && this.getInput() == ((OLAPContext)Lists.newArrayList(this.subContexts).get(0)).getTopNode()) {
            this.context = (OLAPContext)Lists.newArrayList(this.subContexts).get(0);
            this.context.setTopNode(this);
        }
        state.merge(tempState);
    }

    @Override
    public void implementOLAP(OLAPRel.OLAPImplementor olapContextImplementor) {
        olapContextImplementor.visitChild(this.getInput(), this);
        this.columnRowType = this.buildColumnRowType();
        if (this.context != null) {
            if (!this.context.afterHavingClauseFilter && !this.context.afterLimit) {
                int limit = this.translateRexToValue(this.localFetch, Integer.MAX_VALUE);
                this.context.setLimit(limit);
                this.context.afterLimit = true;
            }
            if (this == this.context.getTopNode() && !this.context.isHasAgg()) {
                KapContext.amendAllColsIfNoAgg(this);
            }
        }
    }

    @Override
    public void implementRewrite(OLAPRel.RewriteImplementor implementor) {
        implementor.visitChild(this, this.getInput());
        if (this.context != null) {
            this.rowType = this.deriveRowType();
            this.columnRowType = this.buildColumnRowType();
        }
    }

    @Override
    public Set<OLAPContext> getSubContext() {
        return this.subContexts;
    }

    @Override
    public void setSubContexts(Set<OLAPContext> contexts) {
        this.subContexts = contexts;
    }
}

