/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.core.SetOp;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.KapContext;
import org.apache.kylin.query.relnode.KapRel;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPRel;
import org.apache.kylin.query.util.ICutContextStrategy;

public class KapMinusRel
extends Minus
implements KapRel {
    protected ColumnRowType columnRowType;
    protected OLAPContext context;
    private Set<OLAPContext> subContexts = Sets.newHashSet();

    public KapMinusRel(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
        super(cluster, traitSet, inputs, all);
        this.rowType = this.getRowType();
    }

    @Override
    public EnumerableRel implementEnumerable(List<EnumerableRel> inputs) {
        throw new RuntimeException("Not Implemented");
    }

    @Override
    public void implementCutContext(ICutContextStrategy.CutContextImplementor implementor) {
        throw new RuntimeException("Minus rel should not be re-cut from outside");
    }

    public SetOp copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
        return new KapMinusRel(this.getCluster(), traitSet, inputs, all);
    }

    @Override
    public boolean pushRelInfoToContext(OLAPContext context) {
        return context == this.context;
    }

    @Override
    public void implementContext(KapRel.OLAPContextImplementor olapContextImplementor, KapRel.ContextVisitorState state) {
        KapRel.ContextVisitorState accumulateState = KapRel.ContextVisitorState.init();
        for (int i = 0; i < this.getInputs().size(); ++i) {
            olapContextImplementor.fixSharedOlapTableScanAt(this, i);
            KapRel.ContextVisitorState tempState = KapRel.ContextVisitorState.init();
            RelNode input = this.getInput(i);
            olapContextImplementor.visitChild(input, this, tempState);
            if (tempState.hasFreeTable()) {
                olapContextImplementor.allocateContext((KapRel)input, this);
            }
            tempState.setHasFreeTable(false);
            accumulateState.merge(tempState);
        }
        state.merge(accumulateState);
        for (RelNode subRel : this.getInputs()) {
            this.subContexts.addAll(ContextUtil.collectSubContext((KapRel)subRel));
        }
    }

    protected ColumnRowType buildColumnRowType() {
        ColumnRowType inputColumnRowType = ((OLAPRel)this.getInput(0)).getColumnRowType();
        ArrayList<TblColRef> columns = new ArrayList<TblColRef>();
        for (TblColRef tblColRef : inputColumnRowType.getAllColumns()) {
            columns.add(TblColRef.newInnerColumn((String)tblColRef.getName(), (TblColRef.InnerDataTypeEnum)TblColRef.InnerDataTypeEnum.LITERAL));
        }
        return new ColumnRowType(columns, inputColumnRowType.getSourceColumns());
    }

    @Override
    public void implementOLAP(OLAPRel.OLAPImplementor olapContextImplementor) {
        int n = this.getInputs().size();
        for (int i = 0; i < n; ++i) {
            olapContextImplementor.visitChild((RelNode)this.getInputs().get(i), this);
        }
        this.columnRowType = this.buildColumnRowType();
        if (this.context != null && this == this.context.getTopNode() && !this.context.isHasAgg()) {
            KapContext.amendAllColsIfNoAgg(this);
        }
    }

    @Override
    public void implementRewrite(OLAPRel.RewriteImplementor implementor) {
        for (RelNode child : this.getInputs()) {
            implementor.visitChild(this, child);
        }
        if (this.context != null) {
            this.rowType = this.deriveRowType();
        }
    }

    @Override
    public Set<OLAPContext> getSubContext() {
        return this.subContexts;
    }

    @Override
    public void setSubContexts(Set<OLAPContext> contexts) {
        this.subContexts = contexts;
    }

    @Override
    public OLAPContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(OLAPContext context) {
        throw new RuntimeException("Minus rel should not be set context from outside");
    }

    @Override
    public ColumnRowType getColumnRowType() {
        return this.columnRowType;
    }

    @Override
    public boolean hasSubQuery() {
        for (RelNode child : this.getInputs()) {
            if (!((OLAPRel)child).hasSubQuery()) continue;
            return true;
        }
        return false;
    }

    @Override
    public RelTraitSet replaceTraitSet(RelTrait trait) {
        RelTraitSet oldTraitSet = this.traitSet;
        this.traitSet = this.traitSet.replace(trait);
        return oldTraitSet;
    }
}

