/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableThetaJoin;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.NonEquiJoinCondition;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.KapRel;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPRel;
import org.apache.kylin.query.util.ICutContextStrategy;
import org.apache.kylin.query.util.RexToTblColRefTranslator;
import org.apache.kylin.query.util.RexUtils;

public class KapNonEquiJoinRel
extends EnumerableThetaJoin
implements KapRel {
    private OLAPContext context;
    private Set<OLAPContext> subContexts = Sets.newHashSet();
    private ColumnRowType columnRowType;
    private boolean isPreCalJoin = true;
    private boolean aboveContextPreCalcJoin = false;
    private int leftInputSizeBeforeRewrite = -1;
    private boolean isQueryNonEquiJoinModelEnabled;

    public KapNonEquiJoinRel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType, boolean isQueryNonEquiJoinModelEnabled) throws InvalidRelException {
        super(cluster, traits, left, right, condition, variablesSet, joinType);
        this.leftInputSizeBeforeRewrite = left.getRowType().getFieldList().size();
        this.rowType = this.getRowType();
        this.isQueryNonEquiJoinModelEnabled = isQueryNonEquiJoinModelEnabled;
    }

    @Override
    public void implementContext(KapRel.OLAPContextImplementor olapContextImplementor, KapRel.ContextVisitorState state) {
        KapRel.ContextVisitorState leftState = KapRel.ContextVisitorState.init();
        olapContextImplementor.fixSharedOlapTableScanOnTheLeft((BiRel)this);
        olapContextImplementor.visitChild(this.getInput(0), this, leftState);
        KapRel.ContextVisitorState rightState = KapRel.ContextVisitorState.init();
        olapContextImplementor.fixSharedOlapTableScanOnTheRight((BiRel)this);
        olapContextImplementor.visitChild(this.getInput(1), this, rightState);
        this.allocateContext(leftState, rightState, olapContextImplementor);
        state.merge(leftState).merge(rightState);
        this.subContexts.addAll(ContextUtil.collectSubContext(this.left));
        this.subContexts.addAll(ContextUtil.collectSubContext(this.right));
    }

    private void allocateContext(KapRel.ContextVisitorState leftState, KapRel.ContextVisitorState rightState, KapRel.OLAPContextImplementor olapContextImplementor) {
        if (this.getJoinType() == JoinRelType.LEFT && !this.isQueryNonEquiJoinModelEnabled) {
            if (leftState.hasFreeTable()) {
                olapContextImplementor.allocateContext((KapRel)this.left, this);
                leftState.setHasFreeTable(false);
            }
            if (rightState.hasFreeTable()) {
                olapContextImplementor.allocateContext((KapRel)this.right, this);
                rightState.setHasFreeTable(false);
            }
            return;
        }
        if (this.getJoinType() == JoinRelType.LEFT && rightState.hasFreeTable() && rightState.hasFilter()) {
            olapContextImplementor.allocateContext((KapRel)this.right, this);
            rightState.setHasFreeTable(false);
        }
        if (!leftState.hasFreeTable() && !rightState.hasFreeTable()) {
            return;
        }
        if (leftState.hasFreeTable() && !rightState.hasFreeTable()) {
            olapContextImplementor.allocateContext((KapRel)this.left, this);
            leftState.setHasFreeTable(false);
        } else if (rightState.hasFreeTable() && !leftState.hasFreeTable()) {
            olapContextImplementor.allocateContext((KapRel)this.right, this);
            rightState.setHasFreeTable(false);
        } else if (rightState.hasIncrementalTable() || this.hasSameFirstTable(leftState, rightState) || RexUtils.joinMoreThanOneTable((Join)this)) {
            olapContextImplementor.allocateContext((KapRel)this.left, this);
            olapContextImplementor.allocateContext((KapRel)this.right, this);
            leftState.setHasFreeTable(false);
            rightState.setHasFreeTable(false);
        }
    }

    @Override
    public void implementCutContext(ICutContextStrategy.CutContextImplementor implementor) {
        if (this.isPreCalJoin) {
            this.context = null;
            this.columnRowType = null;
            implementor.allocateContext((KapRel)this.getInput(0), this);
            implementor.allocateContext((KapRel)this.getInput(1), this);
        } else {
            RelNode input = ((KapRel)this.left).getContext() == null ? this.left : this.right;
            implementor.visitChild(input);
            this.context = null;
            this.columnRowType = null;
        }
    }

    @Override
    public void implementOLAP(OLAPRel.OLAPImplementor implementor) {
        if (this.context != null) {
            this.aboveContextPreCalcJoin = !this.isPreCalJoin || !this.context.isHasPreCalcJoin();
            this.context.setHasJoin(true);
            this.context.setHasPreCalcJoin(this.context.isHasPreCalcJoin() || this.isPreCalJoin);
        }
        implementor.visitChild(this.left, this);
        implementor.visitChild(this.right, this);
        this.columnRowType = this.buildColumnRowType();
        Set<TblColRef> joinCols = this.collectColumnsInJoinCondition(this.getCondition());
        if (this.context != null) {
            if (this.isPreCalJoin) {
                this.buildAndUpdateContextJoin(this.condition);
            } else {
                for (TblColRef joinCol : joinCols) {
                    if (!this.context.belongToContextTables(joinCol)) continue;
                    this.context.getSubqueryJoinParticipants().add(joinCol);
                    this.context.allColumns.add(joinCol);
                }
                this.pushDownJoinColsToSubContexts(joinCols);
            }
        } else {
            this.pushDownJoinColsToSubContexts(joinCols);
        }
    }

    private void buildAndUpdateContextJoin(RexNode condition) {
        condition = this.preTransferCastColumn(condition);
        JoinDesc.JoinDescBuilder joinDescBuilder = new JoinDesc.JoinDescBuilder();
        JoinInfo joinInfo = JoinInfo.of((RelNode)this.left, (RelNode)this.right, (RexNode)condition);
        HashSet leftCols = new HashSet();
        joinInfo.leftKeys.forEach(key -> leftCols.addAll(this.getColFromLeft((int)key).getSourceColumns()));
        joinDescBuilder.addForeignKeys(leftCols);
        HashSet rightCols = new HashSet();
        joinInfo.rightKeys.forEach(key -> rightCols.addAll(this.getColFromRight((int)key).getSourceColumns()));
        joinDescBuilder.addPrimaryKeys(rightCols);
        String joinType = this.getJoinType() == JoinRelType.INNER || this.getJoinType() == JoinRelType.LEFT ? this.getJoinType().name() : null;
        joinDescBuilder.setType(joinType);
        RexNode nonEquvCond = joinInfo.getRemaining(new RexBuilder((RelDataTypeFactory)new JavaTypeFactoryImpl(RelDataTypeSystem.DEFAULT)));
        if (CollectionUtils.isNotEmpty(leftCols) && CollectionUtils.isNotEmpty(rightCols)) {
            joinDescBuilder.setForeignTableRef(((TblColRef)leftCols.iterator().next()).getTableRef());
            joinDescBuilder.setPrimaryTableRef(((TblColRef)rightCols.iterator().next()).getTableRef());
        } else {
            joinDescBuilder.setForeignTableRef(((KapRel)this.left).getColumnRowType().getColumnByIndex(0).getTableRef());
            joinDescBuilder.setPrimaryTableRef(((KapRel)this.right).getColumnRowType().getColumnByIndex(0).getTableRef());
        }
        NonEquiJoinCondition nonEquiJoinCondition = this.doBuildJoin(nonEquvCond);
        nonEquiJoinCondition.setExpr(RexToTblColRefTranslator.translateRexNode(condition, this.columnRowType).getParserDescription());
        joinDescBuilder.setNonEquiJoinCondition(nonEquiJoinCondition);
        JoinDesc joinDesc = joinDescBuilder.build();
        this.context.joins.add(joinDesc);
    }

    private RexNode preTransferCastColumn(RexNode condition) {
        if (condition instanceof RexCall) {
            RexCall conditionCall = (RexCall)condition;
            List rexNodes = conditionCall.getOperands().stream().map(RexUtils::stripOffCastInColumnEqualPredicate).collect(Collectors.toList());
            return conditionCall.clone(conditionCall.getType(), rexNodes);
        }
        return condition;
    }

    private NonEquiJoinCondition doBuildJoin(RexNode condition) {
        if (condition instanceof RexCall) {
            LinkedList<NonEquiJoinCondition> nonEquiJoinConditions = new LinkedList<NonEquiJoinCondition>();
            for (RexNode operand : ((RexCall)condition).getOperands()) {
                nonEquiJoinConditions.add(this.doBuildJoin(operand));
            }
            return new NonEquiJoinCondition(((RexCall)condition).getOperator(), nonEquiJoinConditions.toArray(new NonEquiJoinCondition[0]), condition.getType());
        }
        if (condition instanceof RexInputRef) {
            int colIdx = ((RexInputRef)condition).getIndex();
            Set sourceCols = this.getColByIndex(colIdx).getSourceColumns();
            Preconditions.checkArgument((sourceCols.size() == 1 ? 1 : 0) != 0);
            TblColRef sourceCol = (TblColRef)sourceCols.iterator().next();
            return new NonEquiJoinCondition(sourceCol, condition.getType());
        }
        if (condition instanceof RexLiteral) {
            return new NonEquiJoinCondition((RexLiteral)condition, condition.getType());
        }
        throw new IllegalStateException("Invalid join condition " + condition);
    }

    private TblColRef getColByIndex(int idx) {
        int leftColumnsSize = ((OLAPRel)this.left).getColumnRowType().getAllColumns().size();
        if (idx < leftColumnsSize) {
            return this.getColFromLeft(idx);
        }
        return this.getColFromRight(idx - leftColumnsSize);
    }

    private TblColRef getColFromLeft(int idx) {
        return ((OLAPRel)this.left).getColumnRowType().getAllColumns().get(idx);
    }

    private TblColRef getColFromRight(int idx) {
        return ((OLAPRel)this.right).getColumnRowType().getAllColumns().get(idx);
    }

    private void pushDownJoinColsToSubContexts(Set<TblColRef> joinColumns) {
        for (OLAPContext subContext : this.subContexts) {
            for (TblColRef joinCol : joinColumns) {
                if (!subContext.belongToContextTables(joinCol)) continue;
                subContext.allColumns.add(joinCol);
            }
        }
    }

    private Set<TblColRef> collectColumnsInJoinCondition(RexNode condition) {
        return RexUtils.getAllInputRefs(condition).stream().map(inRef -> this.columnRowType.getColumnByIndex(inRef.getIndex())).flatMap(col -> col.getSourceColumns().stream()).collect(Collectors.toSet());
    }

    private ColumnRowType buildColumnRowType() {
        ArrayList<TblColRef> columns = new ArrayList<TblColRef>();
        OLAPRel olapLeft = (OLAPRel)this.left;
        ColumnRowType leftColumnRowType = olapLeft.getColumnRowType();
        columns.addAll(leftColumnRowType.getAllColumns());
        OLAPRel olapRight = (OLAPRel)this.right;
        ColumnRowType rightColumnRowType = olapRight.getColumnRowType();
        columns.addAll(rightColumnRowType.getAllColumns());
        if (columns.size() != this.rowType.getFieldCount()) {
            throw new IllegalStateException("RowType=" + this.rowType.getFieldCount() + ", ColumnRowType=" + columns.size());
        }
        return new ColumnRowType(columns);
    }

    @Override
    public void implementRewrite(OLAPRel.RewriteImplementor rewriter) {
        rewriter.visitChild(this, this.left);
        rewriter.visitChild(this, this.right);
        if (this.context != null) {
            this.rowType = this.deriveRowType();
            if (this.context.hasPrecalculatedFields() && OLAPRel.RewriteImplementor.needRewrite(this.context) && this.aboveContextPreCalcJoin) {
                int paramIndex = this.rowType.getFieldList().size();
                LinkedList newFieldList = Lists.newLinkedList();
                for (Map.Entry<String, RelDataType> rewriteField : this.context.rewriteFields.entrySet()) {
                    String fieldName = rewriteField.getKey();
                    if (this.rowType.getField(fieldName, true, false) != null) continue;
                    RelDataType fieldType = rewriteField.getValue();
                    RelDataTypeFieldImpl newField = new RelDataTypeFieldImpl(fieldName, paramIndex++, fieldType);
                    newFieldList.add(newField);
                }
                RelDataTypeFactory.FieldInfoBuilder fieldInfo = this.getCluster().getTypeFactory().builder();
                fieldInfo.addAll((Iterable)this.rowType.getFieldList());
                fieldInfo.addAll((Iterable)newFieldList);
                this.rowType = this.getCluster().getTypeFactory().createStructType((RelDataTypeFactory.FieldInfo)fieldInfo);
                this.columnRowType = this.rebuildColumnRowType(newFieldList);
            }
        }
    }

    private ColumnRowType rebuildColumnRowType(List<RelDataTypeField> missingFields) {
        ArrayList columns = Lists.newArrayList();
        OLAPRel olapLeft = (OLAPRel)this.left;
        OLAPRel olapRight = (OLAPRel)this.right;
        columns.addAll(olapLeft.getColumnRowType().getAllColumns());
        columns.addAll(olapRight.getColumnRowType().getAllColumns());
        for (RelDataTypeField dataTypeField : missingFields) {
            String fieldName = dataTypeField.getName();
            TblColRef aggOutCol = TblColRef.newInnerColumn((String)fieldName, (TblColRef.InnerDataTypeEnum)TblColRef.InnerDataTypeEnum.LITERAL);
            aggOutCol.getColumnDesc().setId("" + dataTypeField.getIndex());
            columns.add(aggOutCol);
        }
        if (columns.size() != this.rowType.getFieldCount()) {
            throw new IllegalStateException("RowType=" + this.rowType.getFieldCount() + ", ColumnRowType=" + columns.size());
        }
        return new ColumnRowType(columns);
    }

    @Override
    public EnumerableRel implementEnumerable(List<EnumerableRel> inputs) {
        return super.copy(this.traitSet, this.condition, (RelNode)inputs.get(0), (RelNode)inputs.get(1), this.joinType, this.isSemiJoinDone());
    }

    @Override
    public boolean pushRelInfoToContext(OLAPContext context) {
        if (this.context != null) {
            return false;
        }
        if (this == context.getParentOfTopNode() || ((KapRel)this.getLeft()).pushRelInfoToContext(context) || ((KapRel)this.getRight()).pushRelInfoToContext(context)) {
            this.context = context;
            this.isPreCalJoin = false;
            return true;
        }
        return false;
    }

    @Override
    public Set<OLAPContext> getSubContext() {
        return ImmutableSet.copyOf(this.subContexts);
    }

    @Override
    public void setSubContexts(Set<OLAPContext> contexts) {
        this.subContexts = contexts;
    }

    @Override
    public OLAPContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(OLAPContext context) {
        this.context = context;
        for (RelNode input : this.getInputs()) {
            ((KapRel)input).setContext(context);
            this.subContexts.addAll(ContextUtil.collectSubContext(input));
        }
    }

    @Override
    public ColumnRowType getColumnRowType() {
        return this.columnRowType;
    }

    @Override
    public boolean hasSubQuery() {
        throw new UnsupportedOperationException("hasSubQuery is not implemented yet");
    }

    @Override
    public RelTraitSet replaceTraitSet(RelTrait trait) {
        RelTraitSet oldTraitSet = this.traitSet;
        this.traitSet = this.traitSet.replace(trait);
        return oldTraitSet;
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return this.joinType == JoinRelType.RIGHT ? super.computeSelfCost(planner, mq).multiplyBy(100.0) : super.computeSelfCost(planner, mq).multiplyBy(0.05);
    }

    public EnumerableThetaJoin copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        try {
            return new KapNonEquiJoinRel(this.getCluster(), traitSet, left, right, condition, (Set<CorrelationId>)this.variablesSet, joinType, this.isQueryNonEquiJoinModelEnabled);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        return super.estimateRowCount(mq) * 0.1;
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("ctx", (Object)(this.context == null ? "" : String.valueOf(this.context.id) + "@" + this.context.realization));
    }

    public boolean isRuntimeJoin() {
        if (this.context != null) {
            this.context.setReturnTupleInfo(this.rowType, this.columnRowType);
        }
        return this.context == null || ((KapRel)this.left).getContext() != ((KapRel)this.right).getContext();
    }

    private boolean hasSameFirstTable(KapRel.ContextVisitorState leftState, KapRel.ContextVisitorState rightState) {
        return !leftState.hasIncrementalTable() && !rightState.hasIncrementalTable() && leftState.hasFirstTable() && rightState.hasFirstTable();
    }

    public int getLeftInputSizeBeforeRewrite() {
        return this.leftInputSizeBeforeRewrite;
    }
}

