/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.KapContext;
import org.apache.kylin.query.relnode.KapRel;
import org.apache.kylin.query.relnode.KapWindowRel;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPProjectRel;
import org.apache.kylin.query.relnode.OLAPRel;
import org.apache.kylin.query.relnode.OLAPToEnumerableConverter;
import org.apache.kylin.query.schema.OLAPTable;
import org.apache.kylin.query.util.ICutContextStrategy;

public class KapProjectRel
extends OLAPProjectRel
implements KapRel {
    List<RexNode> exps;
    private boolean beforeTopPreCalcJoin = false;
    private Set<OLAPContext> subContexts = Sets.newHashSet();
    private boolean needPushInfoToSubCtx = false;

    public KapProjectRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, List<RexNode> exps, RelDataType rowType) {
        super(cluster, traitSet, child, exps, rowType);
        this.exps = exps;
    }

    @Override
    public void implementCutContext(ICutContextStrategy.CutContextImplementor implementor) {
        this.context = null;
        this.columnRowType = null;
        implementor.visitChild(this.getInput());
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq);
    }

    @Override
    public Project copy(RelTraitSet traitSet, RelNode child, List<RexNode> exps, RelDataType rowType) {
        return new KapProjectRel(this.getCluster(), traitSet, child, exps, rowType);
    }

    @Override
    public void setContext(OLAPContext context) {
        this.context = context;
        ((KapRel)this.getInput()).setContext(context);
        this.subContexts.addAll(ContextUtil.collectSubContext((KapRel)this.getInput()));
    }

    @Override
    public boolean pushRelInfoToContext(OLAPContext context) {
        if (this.context == null && ((KapRel)this.getInput()).pushRelInfoToContext(context)) {
            this.context = context;
            return true;
        }
        return false;
    }

    @Override
    public void implementContext(KapRel.OLAPContextImplementor olapContextImplementor, KapRel.ContextVisitorState state) {
        olapContextImplementor.fixSharedOlapTableScan((SingleRel)this);
        KapRel.ContextVisitorState tempState = KapRel.ContextVisitorState.init();
        olapContextImplementor.visitChild(this.getInput(), this, tempState);
        this.subContexts.addAll(ContextUtil.collectSubContext((KapRel)this.getInput()));
        if (this.context == null && this.subContexts.size() == 1 && this.getInput() == ((OLAPContext)Lists.newArrayList(this.subContexts).get(0)).getTopNode() && !(this.getInput() instanceof KapWindowRel)) {
            this.context = (OLAPContext)Lists.newArrayList(this.subContexts).get(0);
            this.context.setTopNode(this);
        }
        state.merge(tempState);
    }

    @Override
    public void implementOLAP(OLAPRel.OLAPImplementor implementor) {
        if (this.getPermutation() != null && !this.isTopProject(implementor.getParentNodeStack())) {
            this.isMerelyPermutation = true;
        }
        this.beforeTopPreCalcJoin = this.context != null && this.context.isHasPreCalcJoin();
        implementor.visitChild(this.getInput(), this);
        this.columnRowType = this.buildColumnRowType();
        if (this.context != null) {
            this.hasJoin = this.context.isHasJoin();
            this.afterAggregate = this.context.afterAggregate;
            if (this == this.context.getTopNode() && !this.context.isHasAgg()) {
                KapContext.amendAllColsIfNoAgg(this);
            }
        } else if (this.needPushInfoToSubCtx) {
            this.updateSubContexts(this.subContexts);
        }
    }

    private boolean isTopProject(Stack<RelNode> parentNodeStack) {
        Stack tmpStack = (Stack)parentNodeStack.clone();
        while (!tmpStack.empty()) {
            RelNode parentNode = (RelNode)tmpStack.pop();
            if (parentNode instanceof OLAPToEnumerableConverter) {
                return true;
            }
            if (!(parentNode instanceof OLAPProjectRel)) continue;
            return false;
        }
        return false;
    }

    @Override
    public void implementRewrite(OLAPRel.RewriteImplementor implementor) {
        implementor.visitChild(this, this.getInput());
        if (this.context == null) {
            return;
        }
        this.rewriting = true;
        if (!OLAPRel.RewriteImplementor.needRewrite(this.context) || this.afterAggregate || !this.context.hasPrecalculatedFields() || this.getContext().isHasJoin() && this.beforeTopPreCalcJoin) {
            this.columnRowType = this.buildColumnRowType();
            return;
        }
        LinkedList newFieldList = Lists.newLinkedList();
        Map<Integer, RelDataTypeField> needReplaceCCFieldList = this.replaceCcFiledWithOriginInnerCol(newFieldList);
        newFieldList.addAll(this.rebuildMissPreCalcField());
        if (!newFieldList.isEmpty() && needReplaceCCFieldList.isEmpty()) {
            RelDataTypeFactory.FieldInfoBuilder fieldInfo = this.getCluster().getTypeFactory().builder();
            fieldInfo.addAll((Iterable)this.rowType.getFieldList());
            fieldInfo.addAll((Iterable)newFieldList);
            this.rowType = this.getCluster().getTypeFactory().createStructType((RelDataTypeFactory.FieldInfo)fieldInfo);
        } else if (!newFieldList.isEmpty()) {
            RelDataTypeFactory.FieldInfoBuilder fieldInfo = this.getCluster().getTypeFactory().builder();
            ArrayList originfields = Lists.newArrayList((Iterable)this.rowType.getFieldList());
            for (Map.Entry<Integer, RelDataTypeField> integerRelDataTypeFieldEntry : needReplaceCCFieldList.entrySet()) {
                originfields.set(integerRelDataTypeFieldEntry.getKey(), integerRelDataTypeFieldEntry.getValue());
            }
            fieldInfo.addAll((Iterable)originfields);
            fieldInfo.addAll((Iterable)newFieldList);
            this.rowType = this.getCluster().getTypeFactory().createStructType((RelDataTypeFactory.FieldInfo)fieldInfo);
        }
        this.columnRowType = this.buildColumnRowType();
        this.rewriting = false;
    }

    private void updateSubContexts(Set<OLAPContext> subContexts) {
        if (this.isMerelyPermutation || this.rewriting || this.afterAggregate) {
            return;
        }
        ContextUtil.updateSubContexts(this.columnRowType.getSourceColumns().stream().flatMap(Collection::stream).collect(Collectors.toSet()), subContexts);
    }

    @Override
    public Set<OLAPContext> getSubContext() {
        return this.subContexts;
    }

    @Override
    public void setSubContexts(Set<OLAPContext> contexts) {
        this.subContexts = contexts;
    }

    private Map<Integer, RelDataTypeField> replaceCcFiledWithOriginInnerCol(List<RelDataTypeField> newFieldList) {
        HashMap needReplaceCCFieldList = Maps.newHashMap();
        HashMap posInTupleToCcCol = Maps.newHashMap();
        ColumnRowType inputColumnRowType = ((OLAPRel)this.getInput()).getColumnRowType();
        int paramIndex = this.rowType.getFieldList().size();
        for (Map.Entry<TblColRef, TblColRef> originExprToCcCol : this.context.getGroupCCColRewriteMapping().entrySet()) {
            String replaceCCField = originExprToCcCol.getValue().getName();
            int rowIndex = this.columnRowType.getIndexByNameAndByContext(this.context, replaceCCField);
            if (rowIndex >= 0) continue;
            RelDataType ccFieldType = OLAPTable.createSqlType(this.getCluster().getTypeFactory(), originExprToCcCol.getValue().getType(), true);
            int originExprIndex = this.findInnerColPosInPrjRelRowType(originExprToCcCol.getKey(), this);
            if (originExprIndex < 0) {
                newFieldList.add((RelDataTypeField)new RelDataTypeFieldImpl(replaceCCField, paramIndex++, ccFieldType));
                int idx = inputColumnRowType.getIndexByNameAndByContext(this.context, replaceCCField);
                RelDataTypeField inputField = (RelDataTypeField)this.getInput().getRowType().getFieldList().get(idx);
                ArrayList newRewriteProjects = Lists.newArrayList((Iterable)this.rewriteProjects);
                newRewriteProjects.add(new RexInputRef(inputField.getIndex(), inputField.getType()));
                this.rewriteProjects = newRewriteProjects;
                continue;
            }
            int ccColInInputIndex = inputColumnRowType.getIndexByNameAndByContext(this.context, replaceCCField);
            if (ccColInInputIndex < 0) continue;
            RelDataTypeFieldImpl newCcFiled = new RelDataTypeFieldImpl(replaceCCField, originExprIndex, ccFieldType);
            needReplaceCCFieldList.put(originExprIndex, newCcFiled);
            RelDataTypeField inputField = (RelDataTypeField)this.getInput().getRowType().getFieldList().get(ccColInInputIndex);
            RexInputRef ccFiledRef = new RexInputRef(inputField.getIndex(), inputField.getType());
            posInTupleToCcCol.put(originExprIndex, ccFiledRef);
        }
        if (!posInTupleToCcCol.isEmpty()) {
            ArrayList newProjects = new ArrayList(this.rewriteProjects);
            posInTupleToCcCol.forEach(newProjects::set);
            this.rewriteProjects = newProjects;
        }
        return needReplaceCCFieldList;
    }

    private List<RelDataTypeField> rebuildMissPreCalcField() {
        LinkedList newFieldList = Lists.newLinkedList();
        ArrayList newExpList = Lists.newArrayList();
        List inputFieldList = this.getInput().getRowType().getFieldList();
        ColumnRowType inputColumnRowType = ((OLAPRel)this.getInput()).getColumnRowType();
        List<TblColRef> allColumns = this.columnRowType.getAllColumns();
        for (int i = 0; i < this.rewriteProjects.size(); ++i) {
            RexNode rexNode = (RexNode)this.rewriteProjects.get(i);
            if (i >= allColumns.size() || !(rexNode instanceof RexInputRef)) {
                newExpList.add(rexNode);
                continue;
            }
            String inputColumnName = inputColumnRowType.getAllColumns().get(((RexInputRef)rexNode).getIndex()).getCanonicalName();
            String currentColumnName = allColumns.get(i).getCanonicalName();
            int actualIndex = inputColumnRowType.getIndexByCanonicalName(currentColumnName);
            if (!inputColumnName.equals(currentColumnName) && actualIndex >= 0) {
                RelDataTypeField inputField = (RelDataTypeField)inputFieldList.get(actualIndex);
                RexInputRef newFieldRef = new RexInputRef(actualIndex, inputField.getType());
                newExpList.add(newFieldRef);
                continue;
            }
            newExpList.add(rexNode);
        }
        int paramIndex = this.rowType.getFieldList().size();
        for (Map.Entry<String, RelDataType> rewriteField : this.context.rewriteFields.entrySet()) {
            int inputIndex;
            String rewriteFieldName = rewriteField.getKey();
            int rowIndex = this.columnRowType.getIndexByNameAndByContext(this.context, rewriteFieldName);
            if (rowIndex >= 0 || (inputIndex = inputColumnRowType.getIndexByNameAndByContext(this.context, rewriteFieldName)) < 0) continue;
            RelDataType fieldType = rewriteField.getValue();
            RelDataTypeFieldImpl newField = new RelDataTypeFieldImpl(rewriteFieldName, paramIndex++, fieldType);
            newFieldList.add(newField);
            RelDataTypeField inputField = (RelDataTypeField)inputFieldList.get(inputIndex);
            RexInputRef newFieldRef = new RexInputRef(inputField.getIndex(), inputField.getType());
            newExpList.add(newFieldRef);
        }
        this.rewriteProjects = newExpList;
        return newFieldList;
    }

    private int findInnerColPosInPrjRelRowType(TblColRef colRef, KapProjectRel rel) {
        for (int i = 0; i < rel.getColumnRowType().getAllColumns().size(); ++i) {
            if (!colRef.equals((Object)rel.getColumnRowType().getColumnByIndex(i))) continue;
            return i;
        }
        return -1;
    }

    @Generated
    public void setNeedPushInfoToSubCtx(boolean needPushInfoToSubCtx) {
        this.needPushInfoToSubCtx = needPushInfoToSubCtx;
    }
}

