/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import lombok.Generated;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.query.relnode.KapAggregateRel;
import org.apache.kylin.query.relnode.KapTableScan;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPRel;
import org.apache.kylin.query.relnode.OLAPTableScan;
import org.apache.kylin.query.util.ICutContextStrategy;

public interface KapRel
extends OLAPRel {
    public void implementContext(OLAPContextImplementor var1, ContextVisitorState var2);

    public void implementCutContext(ICutContextStrategy.CutContextImplementor var1);

    public void setContext(OLAPContext var1);

    public boolean pushRelInfoToContext(OLAPContext var1);

    public Set<OLAPContext> getSubContext();

    public void setSubContexts(Set<OLAPContext> var1);

    public static class ContextVisitorState {
        private boolean hasFilter;
        private boolean hasFreeTable;
        private boolean hasIncrementalTable;
        private boolean hasFirstTable;
        private boolean hasModelView;

        public ContextVisitorState(boolean hasFilter, boolean hasFreeTable, boolean hasIncrementalTable) {
            this.hasFilter = hasFilter;
            this.hasFreeTable = hasFreeTable;
            this.hasIncrementalTable = hasIncrementalTable;
        }

        public static ContextVisitorState of(boolean hasFilter, boolean hasFreeTable) {
            return ContextVisitorState.of(hasFilter, hasFreeTable, false);
        }

        public static ContextVisitorState of(boolean hasFilter, boolean hasFreeTable, boolean hasIncrementalTable) {
            return new ContextVisitorState(hasFilter, hasFreeTable, hasIncrementalTable);
        }

        public static ContextVisitorState init() {
            return ContextVisitorState.of(false, false, false);
        }

        public boolean hasFirstTable() {
            return this.hasFirstTable;
        }

        public boolean hasIncrementalTable() {
            return this.hasIncrementalTable;
        }

        public boolean hasFilter() {
            return this.hasFilter;
        }

        public boolean hasFreeTable() {
            return this.hasFreeTable;
        }

        public boolean hasModelView() {
            return this.hasModelView;
        }

        public ContextVisitorState merge(ContextVisitorState that) {
            this.hasFilter = that.hasFilter || this.hasFilter;
            this.hasFreeTable = that.hasFreeTable || this.hasFreeTable;
            this.hasIncrementalTable = that.hasIncrementalTable || this.hasIncrementalTable;
            this.hasFirstTable = that.hasFirstTable || this.hasFirstTable;
            this.hasModelView = that.hasModelView || this.hasModelView;
            return this;
        }

        @Generated
        public void setHasFilter(boolean hasFilter) {
            this.hasFilter = hasFilter;
        }

        @Generated
        public void setHasFreeTable(boolean hasFreeTable) {
            this.hasFreeTable = hasFreeTable;
        }

        @Generated
        public void setHasIncrementalTable(boolean hasIncrementalTable) {
            this.hasIncrementalTable = hasIncrementalTable;
        }

        @Generated
        public void setHasFirstTable(boolean hasFirstTable) {
            this.hasFirstTable = hasFirstTable;
        }

        @Generated
        public void setHasModelView(boolean hasModelView) {
            this.hasModelView = hasModelView;
        }
    }

    public static class OLAPContextImplementor {
        private TableDesc firstTableDesc;
        private Stack<RelNode> parentNodeStack = new Stack();
        private int ctxSeq = 0;
        private Queue<RelNode> aggRelQueue = new LinkedList<RelNode>();

        public void visitChild(RelNode input, RelNode parentNode, ContextVisitorState state) {
            this.parentNodeStack.push(parentNode);
            ((KapRel)input).implementContext(this, state);
            if (input instanceof KapAggregateRel) {
                this.addAgg(input);
            }
            this.parentNodeStack.pop();
        }

        public RelNode getParentNode() {
            return this.parentNodeStack.peek();
        }

        public OLAPContext allocateContext(KapRel topNode, RelNode parentOfTopNode) {
            OLAPContext context = new OLAPContext(this.ctxSeq++);
            OLAPContext.registerContext(context);
            context.setTopNode(topNode);
            context.setParentOfTopNode(parentOfTopNode);
            topNode.setContext(context);
            return context;
        }

        public void fixSharedOlapTableScan(SingleRel parent) {
            OLAPTableScan copy = this.copyTableScanIfNeeded(parent.getInput());
            if (copy != null) {
                parent.replaceInput(0, (RelNode)copy);
            }
        }

        public void fixSharedOlapTableScanOnTheLeft(BiRel parent) {
            OLAPTableScan copy = this.copyTableScanIfNeeded(parent.getLeft());
            if (copy != null) {
                parent.replaceInput(0, (RelNode)copy);
            }
        }

        public void fixSharedOlapTableScanOnTheRight(BiRel parent) {
            OLAPTableScan copy = this.copyTableScanIfNeeded(parent.getRight());
            if (copy != null) {
                parent.replaceInput(1, (RelNode)copy);
            }
        }

        public void fixSharedOlapTableScanAt(RelNode parent, int ordinalInParent) {
            OLAPTableScan copy = this.copyTableScanIfNeeded((RelNode)parent.getInputs().get(ordinalInParent));
            if (copy != null) {
                parent.replaceInput(ordinalInParent, (RelNode)copy);
            }
        }

        public Stack<RelNode> getParentNodeStack() {
            return this.parentNodeStack;
        }

        private OLAPTableScan copyTableScanIfNeeded(RelNode input) {
            if (input instanceof KapTableScan) {
                KapTableScan tableScan = (KapTableScan)input;
                if (tableScan.contextVisited) {
                    return (OLAPTableScan)tableScan.copy(tableScan.getTraitSet(), tableScan.getInputs());
                }
            }
            return null;
        }

        public void addAgg(RelNode relNode) {
            this.aggRelQueue.add(relNode);
        }

        public void optimizeContextCut() {
            RelNode rel = this.aggRelQueue.poll();
            while (rel != null) {
                ((KapAggregateRel)rel).optimizeContextCut();
                rel = this.aggRelQueue.poll();
            }
        }

        @Generated
        public void setFirstTableDesc(TableDesc firstTableDesc) {
            this.firstTableDesc = firstTableDesc;
        }

        @Generated
        public TableDesc getFirstTableDesc() {
            return this.firstTableDesc;
        }
    }
}

