/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rex.RexNode;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.KapContext;
import org.apache.kylin.query.relnode.KapRel;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPRel;
import org.apache.kylin.query.relnode.OLAPSortRel;
import org.apache.kylin.query.util.ICutContextStrategy;

public class KapSortRel
extends OLAPSortRel
implements KapRel {
    private Set<OLAPContext> subContexts = Sets.newHashSet();

    public KapSortRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RelCollation collation, RexNode offset, RexNode fetch) {
        super(cluster, traitSet, child, collation, offset, fetch);
    }

    @Override
    public void implementCutContext(ICutContextStrategy.CutContextImplementor implementor) {
        this.context = null;
        this.columnRowType = null;
        implementor.visitChild(this.getInput());
    }

    @Override
    public KapSortRel copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, RexNode offset, RexNode fetch) {
        return new KapSortRel(this.getCluster(), traitSet, newInput, newCollation, offset, fetch);
    }

    @Override
    public void setContext(OLAPContext context) {
        this.context = context;
        ((KapRel)this.getInput()).setContext(context);
        this.subContexts.addAll(ContextUtil.collectSubContext((KapRel)this.getInput()));
    }

    @Override
    public boolean pushRelInfoToContext(OLAPContext context) {
        if (this.context == null && ((KapRel)this.getInput()).pushRelInfoToContext(context)) {
            this.context = context;
            return true;
        }
        return false;
    }

    @Override
    public void implementContext(KapRel.OLAPContextImplementor olapContextImplementor, KapRel.ContextVisitorState state) {
        olapContextImplementor.fixSharedOlapTableScan((SingleRel)this);
        KapRel.ContextVisitorState tempState = KapRel.ContextVisitorState.init();
        olapContextImplementor.visitChild(this.getInput(), this, tempState);
        this.subContexts.addAll(ContextUtil.collectSubContext((KapRel)this.getInput()));
        if (this.context == null && this.subContexts.size() == 1 && this.getInput() == ((OLAPContext)Lists.newArrayList(this.subContexts).get(0)).getTopNode()) {
            this.context = (OLAPContext)Lists.newArrayList(this.subContexts).get(0);
            this.context.setTopNode(this);
        }
        state.merge(tempState);
    }

    @Override
    public void implementOLAP(OLAPRel.OLAPImplementor olapContextImplementor) {
        olapContextImplementor.visitChild(this.getInput(), this);
        this.columnRowType = this.buildColumnRowType();
        if (this.context != null && this == this.context.getTopNode() && !this.context.isHasAgg()) {
            KapContext.amendAllColsIfNoAgg(this);
        }
        if (this.context != null) {
            for (RelFieldCollation fieldCollation : this.collation.getFieldCollations()) {
                int index = fieldCollation.getFieldIndex();
                SQLDigest.OrderEnum order = this.getOrderEnum(fieldCollation.getDirection());
                OLAPRel olapChild = (OLAPRel)this.getInput();
                TblColRef orderCol = olapChild.getColumnRowType().getAllColumns().get(index);
                this.context.addSort(orderCol, order);
                this.context.allColumns.addAll(orderCol.getSourceColumns());
            }
        }
    }

    @Override
    public void implementRewrite(OLAPRel.RewriteImplementor implementor) {
        implementor.visitChild(this, this.getInput());
        if (this.context != null) {
            if (this.context.realization == null) {
                return;
            }
            this.rowType = this.deriveRowType();
            this.columnRowType = this.buildColumnRowType();
        }
    }

    @Override
    public Set<OLAPContext> getSubContext() {
        return this.subContexts;
    }

    @Override
    public void setSubContexts(Set<OLAPContext> contexts) {
        this.subContexts = contexts;
    }
}

