/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.engine.KECalciteConfig;
import org.apache.kylin.query.relnode.KapAggregateRel;
import org.apache.kylin.query.relnode.KapMinusRel;
import org.apache.kylin.query.relnode.KapOLAPToEnumerableConverter;
import org.apache.kylin.query.relnode.KapProjectRel;
import org.apache.kylin.query.relnode.KapRel;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPProjectRel;
import org.apache.kylin.query.relnode.OLAPRel;
import org.apache.kylin.query.relnode.OLAPTableScan;
import org.apache.kylin.query.relnode.OLAPToEnumerableConverter;
import org.apache.kylin.query.relnode.OLAPUnionRel;
import org.apache.kylin.query.schema.OLAPSchema;
import org.apache.kylin.query.schema.OLAPTable;
import org.apache.kylin.query.util.ICutContextStrategy;

public class KapTableScan
extends OLAPTableScan
implements EnumerableRel,
KapRel {
    boolean contextVisited = false;
    private Set<OLAPContext> subContexts = Sets.newHashSet();

    public KapTableScan(RelOptCluster cluster, RelOptTable table, OLAPTable olapTable, int[] fields) {
        super(cluster, table, olapTable, fields);
    }

    @Override
    public void implementCutContext(ICutContextStrategy.CutContextImplementor implementor) {
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        Preconditions.checkArgument((boolean)inputs.isEmpty());
        return new KapTableScan(this.getCluster(), this.table, this.olapTable, this.fields);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq);
    }

    @Override
    public void setContext(OLAPContext context) {
        this.context = context;
    }

    @Override
    public boolean pushRelInfoToContext(OLAPContext context) {
        return context == this.context;
    }

    @Override
    public void implementContext(KapRel.OLAPContextImplementor olapContextImplementor, KapRel.ContextVisitorState state) {
        this.contextVisited = true;
        TableDesc sourceTable = this.getOlapTable().getSourceTable();
        state.merge(KapRel.ContextVisitorState.of(false, true, sourceTable.isIncrementLoading()));
        if (olapContextImplementor.getFirstTableDesc() == null) {
            olapContextImplementor.setFirstTableDesc(sourceTable);
        }
        state.setHasFirstTable(olapContextImplementor.getFirstTableDesc().equals((Object)sourceTable));
    }

    @Override
    public void implementOLAP(OLAPRel.OLAPImplementor olapContextImplementor) {
        this.context.allTableScans.add(this);
        this.columnRowType = this.buildColumnRowType();
        if (this.context.olapSchema == null) {
            OLAPSchema schema;
            this.context.olapSchema = schema = this.olapTable.getSchema();
        }
        if (this.context.firstTableScan == null) {
            this.context.firstTableScan = this;
        }
        if (this.needCollectionColumns(olapContextImplementor.getParentNodeStack())) {
            for (TblColRef tblColRef : this.columnRowType.getAllColumns()) {
                if (tblColRef.getName().startsWith("_KY_") || tblColRef.getColumnDesc().isComputedColumn() && !KECalciteConfig.current().exposeComputedColumn()) continue;
                this.context.allColumns.add(tblColRef);
            }
        }
    }

    @Override
    public void implementRewrite(OLAPRel.RewriteImplementor implementor) {
        if (this.context != null) {
            Map<String, RelDataType> rewriteFields = this.context.rewriteFields;
            for (Map.Entry<String, RelDataType> rewriteField : rewriteFields.entrySet()) {
                String fieldName = rewriteField.getKey();
                RelDataTypeField field = this.rowType.getField(fieldName, true, false);
                if (field == null) continue;
                RelDataType fieldType = field.getType();
                rewriteField.setValue(fieldType);
            }
        }
    }

    @Override
    protected boolean needCollectionColumns(Stack<RelNode> allParents) {
        KapRel topProjParent = null;
        for (RelNode tempParent : allParents) {
            if (tempParent instanceof KapOLAPToEnumerableConverter) continue;
            if (!(tempParent instanceof KapRel)) break;
            KapRel parent = (KapRel)tempParent;
            if (topProjParent == null && parent instanceof OLAPProjectRel && !((OLAPProjectRel)((Object)parent)).isMerelyPermutation()) {
                topProjParent = parent;
            }
            if (!(parent instanceof OLAPToEnumerableConverter) && !(parent instanceof OLAPUnionRel) && !(parent instanceof KapMinusRel) && !(parent instanceof KapAggregateRel)) continue;
            topProjParent = null;
        }
        if (topProjParent != null) {
            ((KapProjectRel)topProjParent).setNeedPushInfoToSubCtx(true);
        }
        return topProjParent == null;
    }

    @Override
    public Set<OLAPContext> getSubContext() {
        return this.subContexts;
    }

    @Override
    public void setSubContexts(Set<OLAPContext> contexts) {
        this.subContexts = contexts;
    }
}

