/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.KapContext;
import org.apache.kylin.query.relnode.KapRel;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPRel;
import org.apache.kylin.query.relnode.OLAPUnionRel;
import org.apache.kylin.query.util.ICutContextStrategy;

public class KapUnionRel
extends OLAPUnionRel
implements KapRel {
    private Set<OLAPContext> subContexts = Sets.newHashSet();

    public KapUnionRel(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
        super(cluster, traitSet, inputs, all);
    }

    @Override
    public void implementCutContext(ICutContextStrategy.CutContextImplementor implementor) {
        throw new RuntimeException("Union rel should not be re-cut from outside");
    }

    @Override
    public SetOp copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
        return new KapUnionRel(this.getCluster(), traitSet, inputs, all);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq);
    }

    @Override
    public void setContext(OLAPContext context) {
        if (QueryContext.current().getQueryTagInfo().isConstantQuery()) {
            return;
        }
        throw new RuntimeException("Union should not be set context from outside");
    }

    @Override
    public boolean pushRelInfoToContext(OLAPContext context) {
        return context == this.context;
    }

    @Override
    public void implementContext(KapRel.OLAPContextImplementor olapContextImplementor, KapRel.ContextVisitorState state) {
        KapRel.ContextVisitorState accumulateState = KapRel.ContextVisitorState.init();
        for (int i = 0; i < this.getInputs().size(); ++i) {
            olapContextImplementor.fixSharedOlapTableScanAt(this, i);
            KapRel.ContextVisitorState tempState = KapRel.ContextVisitorState.init();
            RelNode input = this.getInput(i);
            olapContextImplementor.visitChild(input, this, tempState);
            if (tempState.hasFreeTable()) {
                olapContextImplementor.allocateContext((KapRel)input, this);
            }
            tempState.setHasFreeTable(false);
            accumulateState.merge(tempState);
        }
        state.merge(accumulateState);
        for (RelNode subRel : this.getInputs()) {
            this.subContexts.addAll(ContextUtil.collectSubContext((KapRel)subRel));
        }
    }

    @Override
    public void implementOLAP(OLAPRel.OLAPImplementor olapContextImplementor) {
        int n = this.getInputs().size();
        for (int i = 0; i < n; ++i) {
            olapContextImplementor.visitChild((RelNode)this.getInputs().get(i), this);
        }
        this.columnRowType = this.buildColumnRowType();
        if (this.context != null && this == this.context.getTopNode() && !this.context.isHasAgg()) {
            KapContext.amendAllColsIfNoAgg(this);
        }
    }

    @Override
    public void implementRewrite(OLAPRel.RewriteImplementor implementor) {
        for (RelNode child : this.getInputs()) {
            implementor.visitChild(this, child);
        }
        if (this.context != null) {
            this.rowType = this.deriveRowType();
        }
    }

    @Override
    public Set<OLAPContext> getSubContext() {
        return this.subContexts;
    }

    @Override
    public void setSubContexts(Set<OLAPContext> contexts) {
        this.subContexts = contexts;
    }
}

