/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.KapContext;
import org.apache.kylin.query.relnode.KapRel;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPRel;
import org.apache.kylin.query.relnode.OLAPWindowRel;
import org.apache.kylin.query.util.ICutContextStrategy;
import org.apache.kylin.query.util.RexUtils;

public class KapWindowRel
extends OLAPWindowRel
implements KapRel {
    private Set<OLAPContext> subContexts = Sets.newHashSet();

    public KapWindowRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<RexLiteral> constants, RelDataType rowType, List<Window.Group> groups) {
        super(cluster, traitSet, input, constants, rowType, groups);
    }

    @Override
    public Window copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new KapWindowRel(this.getCluster(), traitSet, inputs.get(0), (List<RexLiteral>)this.constants, this.rowType, (List<Window.Group>)this.groups);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq);
    }

    @Override
    public void implementContext(KapRel.OLAPContextImplementor olapContextImplementor, KapRel.ContextVisitorState state) {
        olapContextImplementor.fixSharedOlapTableScan((SingleRel)this);
        KapRel.ContextVisitorState tempState = KapRel.ContextVisitorState.init();
        olapContextImplementor.visitChild(this.getInput(), this, tempState);
        if (tempState.hasFreeTable()) {
            olapContextImplementor.allocateContext(this, this);
            tempState.setHasFreeTable(false);
        }
        state.merge(tempState);
        this.subContexts.addAll(ContextUtil.collectSubContext((KapRel)this.getInput()));
    }

    @Override
    public void implementCutContext(ICutContextStrategy.CutContextImplementor implementor) {
        this.context = null;
        implementor.visitChild(this.getInput());
    }

    @Override
    public void setContext(OLAPContext context) {
        this.context = context;
        ((KapRel)this.getInput()).setContext(context);
        this.subContexts.addAll(ContextUtil.collectSubContext((KapRel)this.getInput()));
    }

    @Override
    public boolean pushRelInfoToContext(OLAPContext context) {
        return true;
    }

    @Override
    public void implementOLAP(OLAPRel.OLAPImplementor olapContextImplementor) {
        olapContextImplementor.visitChild(this.getInput(), this);
        this.columnRowType = this.buildColumnRowType();
        if (this.context != null) {
            this.context.hasWindow = true;
            if (this == this.context.getTopNode() && !this.context.isHasAgg()) {
                KapContext.amendAllColsIfNoAgg(this);
            }
        } else {
            ContextUtil.updateSubContexts(this.getGroupingColumns(), this.subContexts);
        }
    }

    public Collection<TblColRef> getGroupingColumns() {
        ColumnRowType inputColumnRowType = ((KapRel)this.getInput()).getColumnRowType();
        HashSet<TblColRef> tblColRefs = new HashSet<TblColRef>();
        for (Window.Group group : this.groups) {
            group.keys.forEach(grpKey -> tblColRefs.addAll(inputColumnRowType.getSourceColumnsByIndex((int)grpKey)));
            group.orderKeys.getFieldCollations().forEach(f -> tblColRefs.addAll(inputColumnRowType.getSourceColumnsByIndex(f.getFieldIndex())));
            group.aggCalls.stream().flatMap(call -> RexUtils.getAllInputRefs((RexNode)call).stream()).filter(inRef -> inRef.getIndex() < inputColumnRowType.size()).flatMap(inRef -> inputColumnRowType.getSourceColumnsByIndex(inRef.getIndex()).stream()).forEach(tblColRefs::add);
        }
        return tblColRefs;
    }

    @Override
    public void implementRewrite(OLAPRel.RewriteImplementor implementor) {
        for (RelNode child : this.getInputs()) {
            implementor.visitChild(this, child);
        }
    }

    @Override
    public Set<OLAPContext> getSubContext() {
        return this.subContexts;
    }

    @Override
    public void setSubContexts(Set<OLAPContext> contexts) {
        this.subContexts = contexts;
    }
}

