/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.kyligence.kap.secondstorage.SecondStorageUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.metadata.cube.cuboid.NLayoutCandidate;
import org.apache.kylin.metadata.cube.realization.HybridRealization;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.JoinsGraph;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.query.NativeQueryRealization;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.metadata.tuple.TupleInfo;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.KapRel;
import org.apache.kylin.query.relnode.OLAPJoinRel;
import org.apache.kylin.query.relnode.OLAPRel;
import org.apache.kylin.query.relnode.OLAPTableScan;
import org.apache.kylin.query.relnode.TableColRefWithRel;
import org.apache.kylin.query.routing.RealizationCheck;
import org.apache.kylin.query.schema.OLAPSchema;
import org.apache.kylin.storage.StorageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OLAPContext {
    public static final String PRM_ACCEPT_PARTIAL_RESULT = "AcceptPartialResult";
    static final ThreadLocal<Map<String, String>> _localPrarameters = new ThreadLocal();
    static final ThreadLocal<Map<Integer, OLAPContext>> _localContexts = new ThreadLocal();
    private static final Logger logger = LoggerFactory.getLogger(OLAPContext.class);
    public final int id;
    public final StorageContext storageContext;
    public OLAPSchema olapSchema = null;
    public OLAPTableScan firstTableScan = null;
    public Set<OLAPTableScan> allTableScans = new HashSet<OLAPTableScan>();
    public Set<OLAPJoinRel> allOlapJoins = new HashSet<OLAPJoinRel>();
    public Set<MeasureDesc> involvedMeasure = new HashSet<MeasureDesc>();
    public TupleInfo returnTupleInfo = null;
    public boolean afterAggregate = false;
    public boolean afterHavingClauseFilter = false;
    public boolean afterLimit = false;
    public boolean limitPrecedesAggr = false;
    public boolean hasWindow = false;
    public IRealization realization;
    public RealizationCheck realizationCheck = new RealizationCheck();
    public Set<TblColRef> allColumns = new HashSet<TblColRef>();
    public Set<TblColRef> metricsColumns = new HashSet<TblColRef>();
    public List<FunctionDesc> aggregations = new ArrayList<FunctionDesc>();
    public Set<TblColRef> filterColumns = new LinkedHashSet<TblColRef>();
    public List<JoinDesc> joins = new LinkedList<JoinDesc>();
    public Map<String, RelDataType> rewriteFields = new HashMap<String, RelDataType>();
    public String sql = "";
    protected boolean isExactlyAggregate = false;
    protected boolean hasBitmapMeasure = false;
    protected boolean isExactlyFastBitmap = false;
    boolean afterTopJoin = false;
    boolean fixedModel;
    List<SQLDigest.OrderEnum> sortOrders;
    SQLDigest sqlDigest;
    private OLAPRel topNode = null;
    private RelNode parentOfTopNode = null;
    private int limit = Integer.MAX_VALUE;
    private boolean hasJoin = false;
    private boolean hasPreCalcJoin = false;
    private boolean hasAgg = false;
    private boolean hasSelected = false;
    private Set<TblColRef> groupByColumns = Sets.newLinkedHashSet();
    private Set<TableColRefWithRel> innerGroupByColumns = Sets.newLinkedHashSet();
    private Set<TblColRef> innerFilterColumns = Sets.newLinkedHashSet();
    private Set<TblColRef> subqueryJoinParticipants = new HashSet<TblColRef>();
    private Set<TblColRef> outerJoinParticipants = new HashSet<TblColRef>();
    private List<FunctionDesc> constantAggregations = new ArrayList<FunctionDesc>();
    private List<RexNode> expandedFilterConditions = new LinkedList<RexNode>();
    private Set<TableRef> notNullTables = new HashSet<TableRef>();
    private JoinsGraph joinsGraph;
    private List<TblColRef> sortColumns;
    private Set<String> containedNotSupportedFunc = Sets.newHashSet();
    private Map<TblColRef, TblColRef> groupCCColRewriteMapping = new HashMap<TblColRef, TblColRef>();
    private boolean hasAdminPermission = false;
    private boolean needToManyDerived;
    private String modelAlias;

    public OLAPContext(int seq) {
        this.id = seq;
        this.storageContext = new StorageContext(seq);
        this.sortColumns = Lists.newArrayList();
        this.sortOrders = Lists.newArrayList();
    }

    public static void setParameters(Map<String, String> parameters) {
        _localPrarameters.set(parameters);
    }

    public static void clearParameter() {
        _localPrarameters.remove();
    }

    public static void registerContext(OLAPContext ctx) {
        if (_localContexts.get() == null) {
            HashMap contextMap = new HashMap();
            _localContexts.set(contextMap);
        }
        _localContexts.get().put(ctx.id, ctx);
    }

    public static Collection<OLAPContext> getThreadLocalContexts() {
        Map<Integer, OLAPContext> map = _localContexts.get();
        return map == null ? null : map.values();
    }

    public static OLAPContext getThreadLocalContextById(int id) {
        Map<Integer, OLAPContext> map = _localContexts.get();
        return map.get(id);
    }

    public static void clearThreadLocalContexts() {
        _localContexts.remove();
    }

    public static void clearThreadLocalContextById(int id) {
        Map<Integer, OLAPContext> map = _localContexts.get();
        map.remove(id);
        _localContexts.set(map);
    }

    public static List<NativeQueryRealization> getNativeRealizations() {
        ArrayList realizations = Lists.newArrayList();
        if (OLAPContext.getThreadLocalContexts() == null) {
            return realizations;
        }
        for (OLAPContext ctx : OLAPContext.getThreadLocalContexts()) {
            String realizationType;
            if (ctx.realization == null) continue;
            HashSet tableSets = Sets.newHashSet();
            if (ctx.storageContext.isEmptyLayout() && ctx.storageContext.isFilterCondAlwaysFalse()) {
                realizationType = "Filter Conflict";
            } else if (ctx.storageContext.isEmptyLayout()) {
                realizationType = null;
            } else if (ctx.storageContext.isUseSnapshot()) {
                realizationType = "Table Snapshot";
                tableSets.add(ctx.getFirstTableIdentity());
            } else if (!ctx.storageContext.getCandidate().isEmptyCandidate() && ctx.storageContext.getCandidate().getLayoutEntity().getIndex().isTableIndex()) {
                realizationType = "Table Index";
                OLAPContext.addTableSnapshots(tableSets, ctx);
            } else {
                realizationType = "Agg Index";
                OLAPContext.addTableSnapshots(tableSets, ctx);
            }
            NDataModel ctxRealizationModel = ctx.realization.getModel();
            String modelId = ctxRealizationModel.getUuid();
            String modelAlias = ctxRealizationModel.getFusionModelAlias();
            ArrayList snapshots = Lists.newArrayList((Iterable)tableSets);
            if (ctx.storageContext.getStreamingLayoutId() != -1L) {
                realizations.add(OLAPContext.getStreamingNativeRealization(ctx, realizationType, modelId, modelAlias, snapshots));
                if (!(ctx.realization instanceof HybridRealization)) continue;
                String batchModelId = ((HybridRealization)ctx.realization).getBatchRealization().getUuid();
                realizations.add(OLAPContext.getBatchNativeRealization(ctx, realizationType, batchModelId, modelAlias, snapshots));
                continue;
            }
            realizations.add(OLAPContext.getBatchNativeRealization(ctx, realizationType, modelId, modelAlias, snapshots));
        }
        return realizations;
    }

    private static NativeQueryRealization getStreamingNativeRealization(OLAPContext ctx, String realizationType, String modelId, String modelAlias, List<String> snapshots) {
        NativeQueryRealization streamingRealization = new NativeQueryRealization(modelId, modelAlias, ctx.storageContext.getStreamingLayoutId(), realizationType, ctx.storageContext.isPartialMatchModel(), snapshots);
        streamingRealization.setSecondStorage(QueryContext.current().getSecondStorageUsageMap().getOrDefault(streamingRealization.getLayoutId(), false).booleanValue());
        streamingRealization.setStreamingLayout(true);
        return streamingRealization;
    }

    private static NativeQueryRealization getBatchNativeRealization(OLAPContext ctx, String realizationType, String modelId, String modelAlias, List<String> snapshots) {
        NativeQueryRealization realization = new NativeQueryRealization(modelId, modelAlias, ctx.storageContext.getLayoutId(), realizationType, ctx.storageContext.isPartialMatchModel(), snapshots);
        realization.setSecondStorage(QueryContext.current().getSecondStorageUsageMap().getOrDefault(realization.getLayoutId(), false).booleanValue());
        realization.setRecommendSecondStorage(OLAPContext.recommendSecondStorage(ctx.realization.getProject(), modelId, realizationType));
        return realization;
    }

    private static void addTableSnapshots(Set<String> tableSets, OLAPContext ctx) {
        tableSets.addAll(ctx.storageContext.getCandidate().getDerivedTableSnapshots());
    }

    private static boolean recommendSecondStorage(String project, String modelId, String realizationType) {
        return "Table Index".equals(realizationType) && SecondStorageUtil.isProjectEnable((String)project) && !SecondStorageUtil.isModelEnable((String)project, (String)modelId);
    }

    public static RexInputRef createUniqueInputRefAmongTables(OLAPTableScan table, int columnIdx, Collection<OLAPTableScan> tables) {
        ArrayList<OLAPTableScan> sorted = new ArrayList<OLAPTableScan>(tables);
        sorted.sort(Comparator.comparingInt(AbstractRelNode::getId));
        int offset = 0;
        for (TableScan tableScan : sorted) {
            if (tableScan == table) {
                return new RexInputRef(table.getTableName() + "." + ((RelDataTypeField)table.getRowType().getFieldList().get(columnIdx)).getName(), offset + columnIdx, ((RelDataTypeField)table.getRowType().getFieldList().get(columnIdx)).getType());
            }
            offset += tableScan.getRowType().getFieldCount();
        }
        return null;
    }

    public boolean isExactlyAggregate() {
        return this.isExactlyAggregate;
    }

    public void setExactlyAggregate(boolean exactlyAggregate) {
        this.isExactlyAggregate = exactlyAggregate;
    }

    public boolean isExactlyFastBitmap() {
        return this.isExactlyFastBitmap;
    }

    public void setExactlyFastBitmap(boolean isExactlyFastBitmap) {
        this.isExactlyFastBitmap = isExactlyFastBitmap;
    }

    public void setHasBitmapMeasure(boolean bitmapMeasure) {
        this.hasBitmapMeasure = bitmapMeasure;
    }

    public boolean isConstantQuery() {
        return this.allColumns.isEmpty() && this.aggregations.isEmpty();
    }

    public boolean isConstantQueryWithAggregations() {
        return this.allColumns.isEmpty() && this.aggregations.isEmpty() && !this.constantAggregations.isEmpty();
    }

    public SQLDigest getSQLDigest() {
        if (this.sqlDigest == null) {
            this.sqlDigest = new SQLDigest(this.firstTableScan.getTableName(), (Set)Sets.newHashSet(this.allColumns), (List)Lists.newLinkedList(this.joins), (List)Lists.newArrayList(this.groupByColumns), (Set)Sets.newHashSet(this.subqueryJoinParticipants), (Set)Sets.newHashSet(this.metricsColumns), (List)Lists.newArrayList(this.aggregations), (Set)Sets.newLinkedHashSet(this.filterColumns), (List)Lists.newArrayList(this.sortColumns), (List)Lists.newArrayList(this.sortOrders), this.limit, this.limitPrecedesAggr, (Set)Sets.newHashSet(this.involvedMeasure));
        }
        return this.sqlDigest;
    }

    public String getFirstTableIdentity() {
        return this.firstTableScan.getTableRef().getTableIdentity();
    }

    public boolean isFirstTableLookupTableInModel(NDataModel model) {
        return this.joins.isEmpty() && model.isLookupTable(this.getFirstTableIdentity());
    }

    public boolean hasPrecalculatedFields() {
        NLayoutCandidate candidate = this.storageContext.getCandidate();
        if (candidate.isEmptyCandidate()) {
            return false;
        }
        boolean isTableIndex = candidate.getLayoutEntity().getIndex().isTableIndex();
        boolean isLookupTable = this.isFirstTableLookupTableInModel(this.realization.getModel());
        return !isTableIndex && !isLookupTable;
    }

    public void resetSQLDigest() {
        this.sqlDigest = null;
    }

    public boolean belongToContextTables(TblColRef tblColRef) {
        for (OLAPTableScan olapTableScan : this.allTableScans) {
            if (!olapTableScan.getColumnRowType().getAllColumns().contains(tblColRef)) continue;
            return true;
        }
        return false;
    }

    public boolean isOriginAndBelongToCtxTables(TblColRef tblColRef) {
        return this.belongToContextTables(tblColRef) && !tblColRef.getName().startsWith("_KY_");
    }

    public void setReturnTupleInfo(RelDataType rowType, ColumnRowType columnRowType) {
        TupleInfo info = new TupleInfo();
        List fieldList = rowType.getFieldList();
        for (int i = 0; i < fieldList.size(); ++i) {
            RelDataTypeField field = (RelDataTypeField)fieldList.get(i);
            TblColRef col = columnRowType == null ? null : columnRowType.getColumnByIndex(i);
            info.setField(field.getName(), col, i);
        }
        this.returnTupleInfo = info;
    }

    public void addSort(TblColRef col, SQLDigest.OrderEnum order) {
        if (col != null) {
            this.sortColumns.add(col);
            this.sortOrders.add(order);
        }
    }

    public void fixModel(NDataModel model, Map<String, String> aliasMap) {
        if (this.fixedModel) {
            return;
        }
        for (OLAPTableScan tableScan : this.allTableScans) {
            tableScan.fixColumnRowTypeWithModel(model, aliasMap);
        }
        this.fixedModel = true;
    }

    public void unfixModel() {
        if (!this.fixedModel) {
            return;
        }
        for (OLAPTableScan tableScan : this.allTableScans) {
            tableScan.unfixColumnRowTypeWithModel();
        }
        this.fixedModel = false;
    }

    public void clearCtxInfo() {
        this.afterAggregate = false;
        this.afterHavingClauseFilter = false;
        this.afterLimit = false;
        this.limitPrecedesAggr = false;
        this.afterTopJoin = false;
        this.hasJoin = false;
        this.hasPreCalcJoin = false;
        this.hasAgg = false;
        this.hasWindow = false;
        this.allColumns.clear();
        this.groupByColumns.clear();
        this.subqueryJoinParticipants.clear();
        this.metricsColumns.clear();
        this.involvedMeasure.clear();
        this.allOlapJoins.clear();
        this.joins.clear();
        this.allTableScans.clear();
        this.filterColumns.clear();
        this.aggregations.clear();
        this.sortColumns.clear();
        this.sortOrders.clear();
        this.joinsGraph = null;
        this.sqlDigest = null;
        this.getConstantAggregations().clear();
    }

    public void addInnerGroupColumns(KapRel rel, Collection<TblColRef> innerGroupColumns) {
        HashSet<TblColRef> innerGroupColumnsSet = new HashSet<TblColRef>(innerGroupColumns);
        for (TblColRef tblColRef : innerGroupColumnsSet) {
            this.innerGroupByColumns.add(new TableColRefWithRel(rel, tblColRef));
        }
    }

    public boolean isAnsweredByTableIndex() {
        NLayoutCandidate candidate = this.realization.isStreaming() ? this.storageContext.getStreamingCandidate() : this.storageContext.getCandidate();
        return candidate != null && !candidate.isEmptyCandidate() && candidate.getLayoutEntity().getIndex().isTableIndex();
    }

    public void simplify() {
        if (this.firstTableScan != null) {
            this.firstTableScan = this.firstTableScan.cleanRelOptCluster();
        }
        HashSet simplifiedTableScans = Sets.newHashSet();
        this.allTableScans.forEach(olapTableScan -> olapTableScan.getCluster().getPlanner().clear());
        this.allTableScans.forEach(olapTableScan -> simplifiedTableScans.add(olapTableScan.cleanRelOptCluster()));
        this.allTableScans = simplifiedTableScans;
    }

    public void clean() {
        this.topNode = null;
        this.parentOfTopNode = null;
        this.allOlapJoins.clear();
    }

    public String toString() {
        return "OLAPContext{firstTableScan=" + this.firstTableScan + ", allTableScans=" + this.allTableScans + ", allOlapJoins=" + this.allOlapJoins + ", groupByColumns=" + this.groupByColumns + ", innerGroupByColumns=" + this.innerGroupByColumns + ", innerFilterColumns=" + this.innerFilterColumns + ", aggregations=" + this.aggregations + ", filterColumns=" + this.filterColumns + '}';
    }

    public void matchJoinWithFilterTransformation() {
        Set<TableRef> leftOrInnerTables = this.getNotNullTables();
        if (CollectionUtils.isEmpty(leftOrInnerTables)) {
            return;
        }
        for (JoinDesc join : this.joins) {
            if (!leftOrInnerTables.contains(join.getPKSide())) continue;
            this.joinsGraph.setJoinToLeftOrInner(join);
            logger.info("Current join: {} is set to LEFT_OR_INNER", (Object)join);
        }
    }

    public void matchJoinWithEnhancementTransformation() {
        this.setJoinsGraph(JoinsGraph.normalizeJoinGraph((JoinsGraph)this.joinsGraph));
    }

    public RexInputRef createUniqueInputRefContextTables(OLAPTableScan table, int columnIdx) {
        return OLAPContext.createUniqueInputRefAmongTables(table, columnIdx, this.allTableScans);
    }

    @Generated
    public boolean isHasBitmapMeasure() {
        return this.hasBitmapMeasure;
    }

    @Generated
    public void setTopNode(OLAPRel topNode) {
        this.topNode = topNode;
    }

    @Generated
    public OLAPRel getTopNode() {
        return this.topNode;
    }

    @Generated
    public void setParentOfTopNode(RelNode parentOfTopNode) {
        this.parentOfTopNode = parentOfTopNode;
    }

    @Generated
    public RelNode getParentOfTopNode() {
        return this.parentOfTopNode;
    }

    @Generated
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Generated
    public int getLimit() {
        return this.limit;
    }

    @Generated
    public void setHasJoin(boolean hasJoin) {
        this.hasJoin = hasJoin;
    }

    @Generated
    public boolean isHasJoin() {
        return this.hasJoin;
    }

    @Generated
    public void setHasPreCalcJoin(boolean hasPreCalcJoin) {
        this.hasPreCalcJoin = hasPreCalcJoin;
    }

    @Generated
    public boolean isHasPreCalcJoin() {
        return this.hasPreCalcJoin;
    }

    @Generated
    public void setHasAgg(boolean hasAgg) {
        this.hasAgg = hasAgg;
    }

    @Generated
    public boolean isHasAgg() {
        return this.hasAgg;
    }

    @Generated
    public boolean isHasSelected() {
        return this.hasSelected;
    }

    @Generated
    public void setHasSelected(boolean hasSelected) {
        this.hasSelected = hasSelected;
    }

    @Generated
    public void setGroupByColumns(Set<TblColRef> groupByColumns) {
        this.groupByColumns = groupByColumns;
    }

    @Generated
    public Set<TblColRef> getGroupByColumns() {
        return this.groupByColumns;
    }

    @Generated
    public void setInnerGroupByColumns(Set<TableColRefWithRel> innerGroupByColumns) {
        this.innerGroupByColumns = innerGroupByColumns;
    }

    @Generated
    public Set<TableColRefWithRel> getInnerGroupByColumns() {
        return this.innerGroupByColumns;
    }

    @Generated
    public void setInnerFilterColumns(Set<TblColRef> innerFilterColumns) {
        this.innerFilterColumns = innerFilterColumns;
    }

    @Generated
    public Set<TblColRef> getInnerFilterColumns() {
        return this.innerFilterColumns;
    }

    @Generated
    public void setSubqueryJoinParticipants(Set<TblColRef> subqueryJoinParticipants) {
        this.subqueryJoinParticipants = subqueryJoinParticipants;
    }

    @Generated
    public Set<TblColRef> getSubqueryJoinParticipants() {
        return this.subqueryJoinParticipants;
    }

    @Generated
    public void setOuterJoinParticipants(Set<TblColRef> outerJoinParticipants) {
        this.outerJoinParticipants = outerJoinParticipants;
    }

    @Generated
    public Set<TblColRef> getOuterJoinParticipants() {
        return this.outerJoinParticipants;
    }

    @Generated
    public void setConstantAggregations(List<FunctionDesc> constantAggregations) {
        this.constantAggregations = constantAggregations;
    }

    @Generated
    public List<FunctionDesc> getConstantAggregations() {
        return this.constantAggregations;
    }

    @Generated
    public List<RexNode> getExpandedFilterConditions() {
        return this.expandedFilterConditions;
    }

    @Generated
    public Set<TableRef> getNotNullTables() {
        return this.notNullTables;
    }

    @Generated
    public JoinsGraph getJoinsGraph() {
        return this.joinsGraph;
    }

    @Generated
    public void setJoinsGraph(JoinsGraph joinsGraph) {
        this.joinsGraph = joinsGraph;
    }

    @Generated
    public List<TblColRef> getSortColumns() {
        return this.sortColumns;
    }

    @Generated
    public void setSortColumns(List<TblColRef> sortColumns) {
        this.sortColumns = sortColumns;
    }

    @Generated
    public void setContainedNotSupportedFunc(Set<String> containedNotSupportedFunc) {
        this.containedNotSupportedFunc = containedNotSupportedFunc;
    }

    @Generated
    public Set<String> getContainedNotSupportedFunc() {
        return this.containedNotSupportedFunc;
    }

    @Generated
    public Map<TblColRef, TblColRef> getGroupCCColRewriteMapping() {
        return this.groupCCColRewriteMapping;
    }

    @Generated
    public void setGroupCCColRewriteMapping(Map<TblColRef, TblColRef> groupCCColRewriteMapping) {
        this.groupCCColRewriteMapping = groupCCColRewriteMapping;
    }

    @Generated
    public boolean isHasAdminPermission() {
        return this.hasAdminPermission;
    }

    @Generated
    public void setHasAdminPermission(boolean hasAdminPermission) {
        this.hasAdminPermission = hasAdminPermission;
    }

    @Generated
    public void setNeedToManyDerived(boolean needToManyDerived) {
        this.needToManyDerived = needToManyDerived;
    }

    @Generated
    public boolean isNeedToManyDerived() {
        return this.needToManyDerived;
    }

    @Generated
    public void setModelAlias(String modelAlias) {
        this.modelAlias = modelAlias;
    }

    @Generated
    public String getModelAlias() {
        return this.modelAlias;
    }

    public static interface IAccessController {
        public void check(List<OLAPContext> var1, OLAPRel var2, KylinConfig var3);
    }
}

