/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.calcite.adapter.enumerable.EnumerableCalc;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPRel;

public class OLAPFilterRel
extends Filter
implements OLAPRel {
    static final Map<SqlKind, SqlKind> REVERSE_OP_MAP = Maps.newHashMap();
    protected ColumnRowType columnRowType;
    protected OLAPContext context;

    public OLAPFilterRel(RelOptCluster cluster, RelTraitSet traits, RelNode child, RexNode condition) {
        super(cluster, traits, child, condition);
        Preconditions.checkArgument((this.getConvention() == CONVENTION ? 1 : 0) != 0);
        this.rowType = this.getRowType();
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.05);
    }

    public Filter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
        return new OLAPFilterRel(this.getCluster(), traitSet, input, condition);
    }

    @Override
    public void implementOLAP(OLAPRel.OLAPImplementor implementor) {
        implementor.fixSharedOlapTableScan((SingleRel)this);
        implementor.visitChild(this.getInput(), this);
        this.columnRowType = this.buildColumnRowType();
        this.context = implementor.getContext();
        if (!this.context.afterAggregate) {
            this.translateFilter(this.context);
        } else {
            this.context.afterHavingClauseFilter = true;
        }
    }

    protected ColumnRowType buildColumnRowType() {
        OLAPRel olapChild = (OLAPRel)this.getInput();
        ColumnRowType inputColumnRowType = olapChild.getColumnRowType();
        return inputColumnRowType;
    }

    protected void translateFilter(OLAPContext context) {
        if (this.condition == null) {
            return;
        }
        HashSet filterColumns = Sets.newHashSet();
        FilterVisitor visitor = new FilterVisitor(this.columnRowType, filterColumns);
        this.condition.accept((RexVisitor)visitor);
        for (TblColRef tblColRef : filterColumns) {
            if (tblColRef.isInnerColumn() || !context.belongToContextTables(tblColRef)) continue;
            context.allColumns.add(tblColRef);
            context.filterColumns.add(tblColRef);
        }
    }

    @Override
    public EnumerableRel implementEnumerable(List<EnumerableRel> inputs) {
        RexBuilder rexBuilder = this.getCluster().getRexBuilder();
        RelDataType inputRowType = this.getInput().getRowType();
        RexProgramBuilder programBuilder = new RexProgramBuilder(inputRowType, rexBuilder);
        programBuilder.addIdentity();
        programBuilder.addCondition(this.condition);
        RexProgram program = programBuilder.getProgram();
        return new EnumerableCalc(this.getCluster(), this.getCluster().traitSetOf((RelTrait)EnumerableConvention.INSTANCE), (RelNode)OLAPFilterRel.sole(inputs), program);
    }

    @Override
    public void implementRewrite(OLAPRel.RewriteImplementor implementor) {
        implementor.visitChild(this, this.getInput());
        this.rowType = this.deriveRowType();
        this.columnRowType = this.buildColumnRowType();
    }

    @Override
    public OLAPContext getContext() {
        return this.context;
    }

    @Override
    public ColumnRowType getColumnRowType() {
        return this.columnRowType;
    }

    @Override
    public boolean hasSubQuery() {
        OLAPRel olapChild = (OLAPRel)this.getInput();
        return olapChild.hasSubQuery();
    }

    @Override
    public RelTraitSet replaceTraitSet(RelTrait trait) {
        RelTraitSet oldTraitSet = this.traitSet;
        this.traitSet = this.traitSet.replace(trait);
        return oldTraitSet;
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("ctx", (Object)(this.context == null ? "" : String.valueOf(this.context.id) + "@" + this.context.realization));
    }

    static {
        REVERSE_OP_MAP.put(SqlKind.EQUALS, SqlKind.NOT_EQUALS);
        REVERSE_OP_MAP.put(SqlKind.NOT_EQUALS, SqlKind.EQUALS);
        REVERSE_OP_MAP.put(SqlKind.GREATER_THAN, SqlKind.LESS_THAN_OR_EQUAL);
        REVERSE_OP_MAP.put(SqlKind.LESS_THAN_OR_EQUAL, SqlKind.GREATER_THAN);
        REVERSE_OP_MAP.put(SqlKind.LESS_THAN, SqlKind.GREATER_THAN_OR_EQUAL);
        REVERSE_OP_MAP.put(SqlKind.GREATER_THAN_OR_EQUAL, SqlKind.LESS_THAN);
        REVERSE_OP_MAP.put(SqlKind.IS_NULL, SqlKind.IS_NOT_NULL);
        REVERSE_OP_MAP.put(SqlKind.IS_NOT_NULL, SqlKind.IS_NULL);
        REVERSE_OP_MAP.put(SqlKind.AND, SqlKind.OR);
        REVERSE_OP_MAP.put(SqlKind.OR, SqlKind.AND);
    }

    protected static class FilterVisitor
    extends RexVisitorImpl<Void> {
        final ColumnRowType inputRowType;
        final Set<TblColRef> filterColumns;
        final Stack<TblColRef.FilterColEnum> tmpLevels;
        final Stack<Boolean> reverses;

        public FilterVisitor(ColumnRowType inputRowType, Set<TblColRef> filterColumns) {
            super(true);
            this.inputRowType = inputRowType;
            this.filterColumns = filterColumns;
            this.tmpLevels = new Stack();
            this.tmpLevels.add(TblColRef.FilterColEnum.NONE);
            this.reverses = new Stack();
            this.reverses.add(false);
        }

        public Void visitCall(RexCall call) {
            SqlOperator op = call.getOperator();
            SqlKind kind = op.getKind();
            if (kind == SqlKind.CAST || kind == SqlKind.REINTERPRET) {
                for (RexNode operand : call.operands) {
                    operand.accept((RexVisitor)this);
                }
                return null;
            }
            if (op.getKind() == SqlKind.NOT) {
                this.reverses.add(this.reverses.peek() == false);
            } else if (this.reverses.peek().booleanValue()) {
                if ((kind = REVERSE_OP_MAP.get(kind)) == SqlKind.AND || kind == SqlKind.OR) {
                    this.reverses.add(true);
                } else {
                    this.reverses.add(false);
                }
            } else {
                this.reverses.add(false);
            }
            TblColRef.FilterColEnum tmpLevel = TblColRef.FilterColEnum.NONE;
            tmpLevel = kind == SqlKind.EQUALS ? TblColRef.FilterColEnum.EQUAL_FILTER : (kind == SqlKind.IS_NULL ? TblColRef.FilterColEnum.INFERIOR_EQUAL_FILTER : (this.isRangeFilter(kind) ? TblColRef.FilterColEnum.RANGE_FILTER : (kind == SqlKind.LIKE ? TblColRef.FilterColEnum.LIKE_FILTER : TblColRef.FilterColEnum.OTHER_FILTER)));
            this.tmpLevels.add(tmpLevel);
            for (RexNode operand : call.operands) {
                operand.accept((RexVisitor)this);
            }
            this.tmpLevels.pop();
            this.reverses.pop();
            return null;
        }

        boolean isRangeFilter(SqlKind sqlKind) {
            return sqlKind == SqlKind.NOT_EQUALS || sqlKind == SqlKind.GREATER_THAN || sqlKind == SqlKind.LESS_THAN || sqlKind == SqlKind.GREATER_THAN_OR_EQUAL || sqlKind == SqlKind.LESS_THAN_OR_EQUAL || sqlKind == SqlKind.IS_NOT_NULL;
        }

        public Void visitInputRef(RexInputRef inputRef) {
            TblColRef column = this.inputRowType.getColumnByIndex(inputRef.getIndex());
            TblColRef.FilterColEnum tmpLevel = this.tmpLevels.peek();
            this.collect(column, tmpLevel);
            return null;
        }

        private void collect(TblColRef column, TblColRef.FilterColEnum tmpLevel) {
            if (!column.isInnerColumn()) {
                this.filterColumns.add(column);
                if (tmpLevel.getPriority() > column.getFilterLevel().getPriority()) {
                    column.setFilterLevel(tmpLevel);
                }
                return;
            }
            if (column.isAggregationColumn()) {
                return;
            }
            List children = column.getOperands();
            if (children == null) {
                return;
            }
            for (TblColRef child : children) {
                this.collect(child, tmpLevel);
            }
        }
    }
}

