/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableLimit;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPRel;

public class OLAPLimitRel
extends SingleRel
implements OLAPRel {
    public final RexNode localOffset;
    public final RexNode localFetch;
    protected ColumnRowType columnRowType;
    protected OLAPContext context;

    public OLAPLimitRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode offset, RexNode fetch) {
        super(cluster, traitSet, child);
        Preconditions.checkArgument((this.getConvention() == CONVENTION ? 1 : 0) != 0);
        Preconditions.checkArgument((this.getConvention() == child.getConvention() ? 1 : 0) != 0);
        this.localOffset = offset;
        this.localFetch = fetch;
    }

    public OLAPLimitRel copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new OLAPLimitRel(this.getCluster(), traitSet, (RelNode)OLAPLimitRel.sole(inputs), this.localOffset, this.localFetch);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.05);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("ctx", (Object)(this.context == null ? "" : String.valueOf(this.context.id) + "@" + this.context.realization)).itemIf("offset", (Object)this.localOffset, this.localOffset != null).itemIf("fetch", (Object)this.localFetch, this.localFetch != null);
    }

    @Override
    public void implementOLAP(OLAPRel.OLAPImplementor implementor) {
        implementor.fixSharedOlapTableScan(this);
        implementor.visitChild(this.getInput(), this);
        this.columnRowType = this.buildColumnRowType();
        this.context = implementor.getContext();
        if (!this.context.afterHavingClauseFilter && !this.context.afterLimit) {
            this.context.afterLimit = true;
        }
    }

    protected Integer translateRexToValue(RexNode rexNode, int defaultValue) {
        if (rexNode instanceof RexLiteral) {
            RexLiteral rexLiteral = (RexLiteral)rexNode;
            Number number = (Number)((Object)rexLiteral.getValue());
            return number.intValue();
        }
        if (rexNode instanceof RexDynamicParam) {
            return defaultValue;
        }
        throw new IllegalStateException("Unsupported RexNode for limit Rel " + rexNode);
    }

    protected ColumnRowType buildColumnRowType() {
        OLAPRel olapChild = (OLAPRel)this.getInput();
        return olapChild.getColumnRowType();
    }

    @Override
    public void implementRewrite(OLAPRel.RewriteImplementor implementor) {
        implementor.visitChild(this, this.getInput());
        this.rowType = this.deriveRowType();
        this.columnRowType = this.buildColumnRowType();
    }

    @Override
    public EnumerableRel implementEnumerable(List<EnumerableRel> inputs) {
        EnumerableRel input = (EnumerableRel)OLAPLimitRel.sole(inputs);
        if (input instanceof OLAPRel) {
            ((OLAPRel)input).replaceTraitSet((RelTrait)EnumerableConvention.INSTANCE);
        }
        return EnumerableLimit.create((RelNode)input, (RexNode)this.localOffset, (RexNode)this.localFetch);
    }

    @Override
    public OLAPContext getContext() {
        return this.context;
    }

    @Override
    public ColumnRowType getColumnRowType() {
        return this.columnRowType;
    }

    @Override
    public boolean hasSubQuery() {
        OLAPRel olapChild = (OLAPRel)this.getInput();
        return olapChild.hasSubQuery();
    }

    @Override
    public RelTraitSet replaceTraitSet(RelTrait trait) {
        RelTraitSet oldTraitSet = this.traitSet;
        this.traitSet = this.traitSet.replace(trait);
        return oldTraitSet;
    }
}

