/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.adapter.enumerable.EnumerableCalc;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlCaseOperator;
import org.apache.calcite.tools.RelUtils;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPFilterRel;
import org.apache.kylin.query.relnode.OLAPRel;
import org.apache.kylin.query.relnode.OLAPToEnumerableConverter;
import org.apache.kylin.query.util.RexToTblColRefTranslator;

public class OLAPProjectRel
extends Project
implements OLAPRel {
    public List<RexNode> rewriteProjects;
    protected OLAPContext context;
    protected boolean rewriting;
    protected ColumnRowType columnRowType;
    protected boolean hasJoin;
    protected boolean afterTopJoin;
    protected boolean afterAggregate;
    protected boolean isMerelyPermutation = false;
    private int caseCount = 0;

    public OLAPProjectRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, List<RexNode> exps, RelDataType rowType) {
        super(cluster, traitSet, child, exps, rowType);
        Preconditions.checkArgument((this.getConvention() == CONVENTION ? 1 : 0) != 0);
        this.rewriteProjects = exps;
        this.hasJoin = false;
        this.afterTopJoin = false;
        this.rowType = this.getRowType();
        for (RexNode exp : exps) {
            this.caseCount += RelUtils.countOperatorCall((SqlOperator)SqlCaseOperator.INSTANCE, (RexNode)exp);
        }
    }

    public List<RexNode> getChildExps() {
        return this.rewriteProjects;
    }

    public List<RexNode> getProjects() {
        return this.rewriteProjects;
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        boolean hasRexOver = RexOver.containsOver(this.getProjects(), null);
        RelOptCost relOptCost = super.computeSelfCost(planner, mq).multiplyBy(0.05).multiplyBy((double)this.getProjects().size() * (hasRexOver ? 50.0 : 1.0)).plus(planner.getCostFactory().makeCost(0.1 * (double)this.caseCount, 0.0, 0.0));
        return planner.getCostFactory().makeCost(relOptCost.getRows(), 0.0, 0.0);
    }

    public Project copy(RelTraitSet traitSet, RelNode child, List<RexNode> exps, RelDataType rowType) {
        return new OLAPProjectRel(this.getCluster(), traitSet, child, exps, rowType);
    }

    @Override
    public void implementOLAP(OLAPRel.OLAPImplementor implementor) {
        if (this.getPermutation() != null && !(implementor.getParentNode() instanceof OLAPToEnumerableConverter)) {
            this.isMerelyPermutation = true;
        }
        implementor.fixSharedOlapTableScan((SingleRel)this);
        implementor.visitChild(this.getInput(), this);
        this.context = implementor.getContext();
        this.hasJoin = this.context.isHasJoin();
        this.afterTopJoin = this.context.afterTopJoin;
        this.afterAggregate = this.context.afterAggregate;
        this.columnRowType = this.buildColumnRowType();
        for (Set<TblColRef> colRefSet : this.columnRowType.getSourceColumns()) {
            for (TblColRef colRef : colRefSet) {
                if (this.isMerelyPermutation || !this.context.belongToContextTables(colRef)) continue;
                this.context.allColumns.add(colRef);
            }
        }
    }

    protected ColumnRowType buildColumnRowType() {
        ArrayList columns = Lists.newArrayList();
        ArrayList sourceColumns = Lists.newArrayList();
        OLAPRel olapChild = (OLAPRel)this.getInput();
        ColumnRowType inputColumnRowType = olapChild.getColumnRowType();
        HashMap<RexNode, TblColRef> nodeAndTblColMap = new HashMap<RexNode, TblColRef>();
        for (int i = 0; i < this.rewriteProjects.size(); ++i) {
            HashSet sourceCollector;
            RelDataTypeField columnField;
            String fieldName;
            RexNode rex = this.rewriteProjects.get(i);
            TblColRef column = this.translateRexNode(rex, inputColumnRowType, fieldName = (columnField = (RelDataTypeField)this.rowType.getFieldList().get(i)).getName(), sourceCollector = Sets.newHashSet(), nodeAndTblColMap);
            if (column == null) {
                throw new IllegalStateException("No TblColRef found in " + rex);
            }
            columns.add(column);
            sourceColumns.add(sourceCollector);
        }
        return new ColumnRowType(columns, sourceColumns);
    }

    TblColRef translateRexNode(RexNode rexNode, ColumnRowType inputColumnRowType, String fieldName, Set<TblColRef> sourceCollector, Map<RexNode, TblColRef> nodeAndTblColMap) {
        if (!this.rewriting && !this.afterAggregate) {
            return RexToTblColRefTranslator.translateRexNode(rexNode, inputColumnRowType, fieldName, sourceCollector, nodeAndTblColMap);
        }
        return RexToTblColRefTranslator.translateRexNode(rexNode, inputColumnRowType, fieldName, nodeAndTblColMap);
    }

    @Override
    public EnumerableRel implementEnumerable(List<EnumerableRel> inputs) {
        if (this.getInput() instanceof OLAPFilterRel) {
            OLAPFilterRel filter = (OLAPFilterRel)this.getInput();
            RelNode inputOfFilter = inputs.get(0).getInput(0);
            RexProgram program = RexProgram.create((RelDataType)inputOfFilter.getRowType(), this.rewriteProjects, (RexNode)filter.getCondition(), (RelDataType)this.rowType, (RexBuilder)this.getCluster().getRexBuilder());
            return new EnumerableCalc(this.getCluster(), this.getCluster().traitSetOf((RelTrait)EnumerableConvention.INSTANCE), inputOfFilter, program);
        }
        EnumerableRel input = (EnumerableRel)OLAPProjectRel.sole(inputs);
        RexProgram program = RexProgram.create((RelDataType)input.getRowType(), this.rewriteProjects, null, (RelDataType)this.rowType, (RexBuilder)this.getCluster().getRexBuilder());
        return new EnumerableCalc(this.getCluster(), this.getCluster().traitSetOf((RelTrait)EnumerableConvention.INSTANCE), (RelNode)input, program);
    }

    @Override
    public ColumnRowType getColumnRowType() {
        return this.columnRowType;
    }

    @Override
    public void implementRewrite(OLAPRel.RewriteImplementor implementor) {
        implementor.visitChild(this, this.getInput());
        this.rewriting = true;
        if (!OLAPRel.RewriteImplementor.needRewrite(this.context) || this.hasJoin && !this.afterTopJoin || this.afterAggregate || !this.context.hasPrecalculatedFields()) {
            this.columnRowType = this.buildColumnRowType();
            return;
        }
        int paramIndex = this.rowType.getFieldList().size();
        LinkedList newFieldList = Lists.newLinkedList();
        LinkedList newExpList = Lists.newLinkedList();
        ColumnRowType inputColumnRowType = ((OLAPRel)this.getInput()).getColumnRowType();
        for (Map.Entry<String, RelDataType> rewriteField : this.context.rewriteFields.entrySet()) {
            int inputIndex;
            String rewriteFieldName = rewriteField.getKey();
            int rowIndex = this.columnRowType.getIndexByName(rewriteFieldName);
            if (rowIndex >= 0 || (inputIndex = inputColumnRowType.getIndexByName(rewriteFieldName)) < 0) continue;
            RelDataType fieldType = rewriteField.getValue();
            RelDataTypeFieldImpl newField = new RelDataTypeFieldImpl(rewriteFieldName, paramIndex++, fieldType);
            newFieldList.add(newField);
            RelDataTypeField inputField = (RelDataTypeField)this.getInput().getRowType().getFieldList().get(inputIndex);
            RexInputRef newFieldRef = new RexInputRef(inputField.getIndex(), inputField.getType());
            newExpList.add(newFieldRef);
        }
        if (!newFieldList.isEmpty()) {
            ArrayList newProjects = Lists.newArrayList(this.rewriteProjects);
            newProjects.addAll(newExpList);
            this.rewriteProjects = newProjects;
            RelDataTypeFactory.FieldInfoBuilder fieldInfo = this.getCluster().getTypeFactory().builder();
            fieldInfo.addAll((Iterable)this.rowType.getFieldList());
            fieldInfo.addAll((Iterable)newFieldList);
            this.rowType = this.getCluster().getTypeFactory().createStructType((RelDataTypeFactory.FieldInfo)fieldInfo);
        }
        this.columnRowType = this.buildColumnRowType();
        this.rewriting = false;
    }

    @Override
    public OLAPContext getContext() {
        return this.context;
    }

    @Override
    public boolean hasSubQuery() {
        OLAPRel olapChild = (OLAPRel)this.getInput();
        return olapChild.hasSubQuery();
    }

    @Override
    public RelTraitSet replaceTraitSet(RelTrait trait) {
        RelTraitSet oldTraitSet = this.traitSet;
        this.traitSet = this.traitSet.replace(trait);
        return oldTraitSet;
    }

    public boolean isMerelyPermutation() {
        return this.isMerelyPermutation;
    }

    public RelWriter explainTerms(RelWriter pw) {
        pw.input("input", this.getInput());
        if (pw.nest()) {
            pw.item("fields", (Object)this.rowType.getFieldNames());
            pw.item("exprs", this.rewriteProjects);
        } else {
            for (Ord field : Ord.zip((List)this.rowType.getFieldList())) {
                String fieldName = ((RelDataTypeField)field.e).getName();
                if (fieldName == null) {
                    fieldName = "field#" + field.i;
                }
                pw.item(fieldName, (Object)this.rewriteProjects.get(field.i));
            }
        }
        return pw.item("ctx", (Object)(this.context == null ? "" : String.valueOf(this.context.id) + "@" + this.context.realization));
    }
}

