/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.tree.Blocks;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPJoinRel;
import org.apache.kylin.query.relnode.OLAPProjectRel;
import org.apache.kylin.query.relnode.OLAPRel;
import org.apache.kylin.query.relnode.OLAPToEnumerableConverter;
import org.apache.kylin.query.relnode.OLAPUnionRel;
import org.apache.kylin.query.schema.OLAPSchema;
import org.apache.kylin.query.schema.OLAPTable;

public class OLAPTableScan
extends TableScan
implements OLAPRel,
EnumerableRel {
    protected OLAPTable olapTable;
    protected String tableName;
    protected int[] fields;
    protected ColumnRowType columnRowType;
    protected OLAPContext context;
    protected KylinConfig kylinConfig;
    private String alias;
    private String backupAlias;

    public OLAPTableScan(RelOptCluster cluster, RelOptTable table, OLAPTable olapTable, int[] fields) {
        super(cluster, cluster.traitSetOf((RelTrait)CONVENTION), table);
        this.olapTable = olapTable;
        this.fields = fields;
        this.tableName = olapTable.getTableName();
        this.rowType = this.getRowType();
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
    }

    private static RelOptCluster emptyCluster() {
        VolcanoPlanner emptyPlanner = new VolcanoPlanner();
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        return RelOptCluster.create((RelOptPlanner)emptyPlanner, (RexBuilder)new RexBuilder((RelDataTypeFactory)typeFactory));
    }

    public OLAPTable getOlapTable() {
        return this.olapTable;
    }

    public String getTableName() {
        return this.tableName;
    }

    public int[] getFields() {
        return this.fields;
    }

    public String getBackupAlias() {
        return this.backupAlias;
    }

    @Override
    public OLAPContext getContext() {
        return this.context;
    }

    void overrideContext(OLAPContext context) {
        this.context = context;
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        Preconditions.checkArgument((boolean)inputs.isEmpty());
        return new OLAPTableScan(this.getCluster(), this.table, this.olapTable, this.fields);
    }

    public RelDataType deriveRowType() {
        List fieldList = this.table.getRowType().getFieldList();
        RelDataTypeFactory.FieldInfoBuilder builder = this.getCluster().getTypeFactory().builder();
        for (int field : this.fields) {
            builder.add((RelDataTypeField)fieldList.get(field));
        }
        return this.getCluster().getTypeFactory().createStructType((RelDataTypeFactory.FieldInfo)builder);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.05);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("ctx", (Object)(this.context == null ? "" : String.valueOf(this.context.id) + "@" + this.context.realization)).item("fields", (Object)Primitive.asList((int[])this.fields));
    }

    @Override
    public void implementOLAP(OLAPRel.OLAPImplementor implementor) {
        Preconditions.checkState((this.columnRowType == null ? 1 : 0) != 0, (Object)"OLAPTableScan MUST NOT be shared by more than one prent");
        if (implementor.getContext() == null || !(implementor.getParentNode() instanceof OLAPJoinRel) || implementor.isNewOLAPContextRequired()) {
            implementor.allocateContext();
        }
        this.context = implementor.getContext();
        this.context.allTableScans.add(this);
        this.columnRowType = this.buildColumnRowType();
        if (this.context.olapSchema == null) {
            OLAPSchema schema;
            this.context.olapSchema = schema = this.olapTable.getSchema();
        }
        if (this.context.firstTableScan == null) {
            this.context.firstTableScan = this;
        }
        if (this.needCollectionColumns(implementor.getParentNodeStack())) {
            for (TblColRef tblColRef : this.columnRowType.getAllColumns()) {
                if (tblColRef.getName().startsWith("_KY_")) continue;
                this.context.allColumns.add(tblColRef);
            }
        }
    }

    protected boolean needCollectionColumns(Stack<RelNode> allParents) {
        for (int index = allParents.size() - 1; index >= 0; --index) {
            RelNode parent = (RelNode)allParents.get(index);
            if (parent instanceof OLAPProjectRel) {
                return false;
            }
            if (parent instanceof OLAPToEnumerableConverter || parent instanceof OLAPUnionRel) {
                return true;
            }
            OLAPRel olapParent = (OLAPRel)allParents.get(index);
            if (olapParent.getContext() != null && olapParent.getContext() != this.context) break;
        }
        return true;
    }

    public String getAlias() {
        return this.alias;
    }

    protected ColumnRowType buildColumnRowType() {
        this.alias = ("T_" + this.context.allTableScans.size() + "_" + Integer.toHexString(System.identityHashCode(this))).toUpperCase(Locale.ROOT);
        TableRef tableRef = TblColRef.tableForUnknownModel((String)this.alias, (TableDesc)this.olapTable.getSourceTable());
        ArrayList<TblColRef> columns = new ArrayList<TblColRef>();
        for (ColumnDesc sourceColumn : this.olapTable.getSourceColumns()) {
            TblColRef colRef = TblColRef.columnForUnknownModel((TableRef)tableRef, (ColumnDesc)sourceColumn);
            columns.add(colRef);
        }
        if (columns.size() != this.rowType.getFieldCount()) {
            throw new IllegalStateException("RowType=" + this.rowType.getFieldCount() + ", ColumnRowType=" + columns.size());
        }
        return new ColumnRowType(columns);
    }

    public TableRef getTableRef() {
        return this.columnRowType.getColumnByIndex(0).getTableRef();
    }

    public TblColRef makeRewriteColumn(String name) {
        return this.getTableRef().makeFakeColumn(name);
    }

    public void fixColumnRowTypeWithModel(NDataModel model, Map<String, String> aliasMap) {
        String newAlias = aliasMap.get(this.alias);
        for (TblColRef col : this.columnRowType.getAllColumns()) {
            TblColRef.fixUnknownModel((NDataModel)model, (String)newAlias, (TblColRef)col);
        }
        this.backupAlias = this.alias;
        this.alias = newAlias;
    }

    public void unfixColumnRowTypeWithModel() {
        this.alias = this.backupAlias;
        this.backupAlias = null;
        for (TblColRef col : this.columnRowType.getAllColumns()) {
            TblColRef.unfixUnknownModel((TblColRef)col);
        }
    }

    @Override
    public EnumerableRel implementEnumerable(List<EnumerableRel> inputs) {
        return this;
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        this.context.setReturnTupleInfo(this.rowType, this.columnRowType);
        String execFunction = this.genExecFunc();
        PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)this.getRowType(), (JavaRowFormat)JavaRowFormat.ARRAY, (boolean)false);
        MethodCallExpression exprCall = Expressions.call((Expression)this.table.getExpression(OLAPTable.class), (String)execFunction, (Expression[])new Expression[]{implementor.getRootExpression(), Expressions.constant((Object)this.context.id)});
        return implementor.result(physType, Blocks.toBlock((Node)exprCall));
    }

    public String genExecFunc() {
        this.context.setReturnTupleInfo(this.rowType, this.columnRowType);
        if (this.context.isConstantQueryWithAggregations()) {
            return "executeSimpleAggregationQuery";
        }
        if (this.context.realization.getModel().isLookupTable(this.tableName)) {
            return "executeLookupTableQuery";
        }
        return "executeOLAPQuery";
    }

    @Override
    public ColumnRowType getColumnRowType() {
        return this.columnRowType;
    }

    public void setColumnRowType(ColumnRowType columnRowType) {
        this.columnRowType = columnRowType;
    }

    @Override
    public void implementRewrite(OLAPRel.RewriteImplementor implementor) {
        Map<String, RelDataType> rewriteFields = this.context.rewriteFields;
        for (Map.Entry<String, RelDataType> rewriteField : rewriteFields.entrySet()) {
            String fieldName = rewriteField.getKey();
            RelDataTypeField field = this.rowType.getField(fieldName, true, false);
            if (field == null) continue;
            RelDataType fieldType = field.getType();
            rewriteField.setValue(fieldType);
        }
    }

    @Override
    public boolean hasSubQuery() {
        return false;
    }

    @Override
    public RelTraitSet replaceTraitSet(RelTrait trait) {
        RelTraitSet oldTraitSet = this.traitSet;
        this.traitSet = this.traitSet.replace(trait);
        return oldTraitSet;
    }

    public OLAPTableScan cleanRelOptCluster() {
        OLAPTableScan tableScan = new OLAPTableScan(OLAPTableScan.emptyCluster(), this.table, this.olapTable, this.fields);
        tableScan.getCluster().getPlanner().clear();
        tableScan.columnRowType = this.columnRowType;
        tableScan.olapTable = this.olapTable;
        tableScan.fields = this.fields;
        tableScan.tableName = this.tableName;
        tableScan.context = this.context;
        tableScan.kylinConfig = this.kylinConfig;
        tableScan.digest = this.digest;
        tableScan.id = this.id;
        tableScan.alias = this.alias;
        return tableScan;
    }
}

