/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterImpl;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPRel;
import org.apache.kylin.query.routing.RealizationChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OLAPToEnumerableConverter
extends ConverterImpl
implements EnumerableRel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OLAPToEnumerableConverter.class);

    public OLAPToEnumerableConverter(RelOptCluster cluster, RelTraitSet traits, RelNode input) {
        super(cluster, (RelTraitDef)ConventionTraitDef.INSTANCE, traits, input);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new OLAPToEnumerableConverter(this.getCluster(), traitSet, (RelNode)OLAPToEnumerableConverter.sole(inputs));
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.05);
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor enumImplementor, EnumerableRel.Prefer pref) {
        if (System.getProperty("calcite.debug") != null) {
            String dumpPlan = RelOptUtil.dumpPlan((String)"", (RelNode)this, (boolean)false, (SqlExplainLevel)SqlExplainLevel.DIGEST_ATTRIBUTES);
            log.info("EXECUTION PLAN BEFORE REWRITE");
            log.info(dumpPlan);
        }
        OLAPRel.OLAPImplementor olapImplementor = new OLAPRel.OLAPImplementor();
        olapImplementor.visitChild(this.getInput(), (RelNode)this);
        List<OLAPContext> contexts = this.listContextsHavingScan();
        if (System.getProperty("calcite.debug") != null) {
            String dumpPlan = RelOptUtil.dumpPlan((String)"", (RelNode)this, (boolean)false, (SqlExplainLevel)SqlExplainLevel.DIGEST_ATTRIBUTES);
            log.info("EXECUTION PLAN AFTER OLAPCONTEXT IS SET");
            log.info(dumpPlan);
        }
        RealizationChooser.selectLayoutCandidate(contexts);
        this.doAccessControl(contexts, (OLAPRel)this.getInput());
        OLAPRel.RewriteImplementor rewriteImplementor = new OLAPRel.RewriteImplementor();
        rewriteImplementor.visitChild((RelNode)this, this.getInput());
        OLAPRel.JavaImplementor impl = new OLAPRel.JavaImplementor(enumImplementor);
        EnumerableRel inputAsEnum = impl.createEnumerable((OLAPRel)this.getInput());
        this.replaceInput(0, (RelNode)inputAsEnum);
        if (System.getProperty("calcite.debug") != null) {
            String dumpPlan = RelOptUtil.dumpPlan((String)"", (RelNode)this, (boolean)false, (SqlExplainLevel)SqlExplainLevel.DIGEST_ATTRIBUTES);
            log.info("EXECUTION PLAN AFTER REWRITE");
            log.info(dumpPlan);
            QueryContext.current().setCalcitePlan((Object)this.copy(this.getTraitSet(), this.getInputs()));
        }
        return impl.visitChild(this, 0, inputAsEnum, pref);
    }

    protected List<OLAPContext> listContextsHavingScan() {
        int size = OLAPContext.getThreadLocalContexts().size();
        ArrayList result = Lists.newArrayListWithCapacity((int)size);
        for (OLAPContext ctx : OLAPContext.getThreadLocalContexts()) {
            if (ctx.firstTableScan == null) continue;
            result.add(ctx);
        }
        return result;
    }

    protected void doAccessControl(List<OLAPContext> contexts, OLAPRel tree) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        String controllerCls = config.getQueryAccessController();
        if (null != controllerCls && !controllerCls.isEmpty()) {
            OLAPContext.IAccessController accessController = (OLAPContext.IAccessController)ClassUtil.newInstance((String)controllerCls);
            accessController.check(contexts, tree, config);
        }
    }
}

