/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPContextProp;

public class Candidate {
    public static final CandidateComparator COMPARATOR = new CandidateComparator();
    public static final CandidateTableIndexComparator COMPARATOR_TABLE_INDEX = new CandidateTableIndexComparator();
    IRealization realization;
    OLAPContext ctx;
    SQLDigest sqlDigest;
    CapabilityResult capability;
    OLAPContextProp rewrittenCtx;
    Map<String, String> aliasMap;
    private List<NDataSegment> prunedSegments;
    private List<NDataSegment> prunedStreamingSegments;
    private Map<String, Set<Long>> secondStorageSegmentLayoutMap;
    private Map<String, List<Long>> prunedPartitions;

    public void setPrunedSegments(List<NDataSegment> prunedSegments, boolean isStreaming) {
        if (isStreaming) {
            this.prunedStreamingSegments = prunedSegments;
        } else {
            this.prunedSegments = prunedSegments;
        }
    }

    public Candidate(IRealization realization, OLAPContext ctx, Map<String, String> aliasMap) {
        this.realization = realization;
        this.ctx = ctx;
        this.aliasMap = aliasMap;
    }

    Candidate() {
    }

    public IRealization getRealization() {
        return this.realization;
    }

    public CapabilityResult getCapability() {
        return this.capability;
    }

    public void setCapability(CapabilityResult capability) {
        this.capability = capability;
    }

    public String toString() {
        return this.realization.toString();
    }

    private static int compareCandidate(Candidate c1, Candidate c2) {
        int comp;
        IRealization real1 = c1.getRealization();
        IRealization real2 = c2.getRealization();
        if (QueryContext.current().getModelPriorities().length > 0) {
            HashMap<String, Integer> priorities = new HashMap<String, Integer>();
            for (int i = 0; i < QueryContext.current().getModelPriorities().length; ++i) {
                priorities.put(QueryContext.current().getModelPriorities()[i], i);
            }
            int comp2 = priorities.getOrDefault(real1.getModel().getAlias().toUpperCase(Locale.ROOT), Integer.MAX_VALUE) - priorities.getOrDefault(real2.getModel().getAlias().toUpperCase(Locale.ROOT), Integer.MAX_VALUE);
            if (comp2 != 0) {
                return comp2;
            }
        }
        if ((comp = real1.getCost() - real2.getCost()) != 0) {
            return comp;
        }
        comp = Double.compare(c1.capability.cost, c2.capability.cost);
        if (comp != 0) {
            return comp;
        }
        return real1.getModel().getId().compareTo(real2.getModel().getId());
    }

    @Generated
    public OLAPContext getCtx() {
        return this.ctx;
    }

    @Generated
    public OLAPContextProp getRewrittenCtx() {
        return this.rewrittenCtx;
    }

    @Generated
    public void setRewrittenCtx(OLAPContextProp rewrittenCtx) {
        this.rewrittenCtx = rewrittenCtx;
    }

    @Generated
    public Map<String, String> getAliasMap() {
        return this.aliasMap;
    }

    @Generated
    public void setAliasMap(Map<String, String> aliasMap) {
        this.aliasMap = aliasMap;
    }

    @Generated
    public List<NDataSegment> getPrunedSegments() {
        return this.prunedSegments;
    }

    @Generated
    public void setPrunedSegments(List<NDataSegment> prunedSegments) {
        this.prunedSegments = prunedSegments;
    }

    @Generated
    public List<NDataSegment> getPrunedStreamingSegments() {
        return this.prunedStreamingSegments;
    }

    @Generated
    public void setPrunedStreamingSegments(List<NDataSegment> prunedStreamingSegments) {
        this.prunedStreamingSegments = prunedStreamingSegments;
    }

    @Generated
    public Map<String, Set<Long>> getSecondStorageSegmentLayoutMap() {
        return this.secondStorageSegmentLayoutMap;
    }

    @Generated
    public void setSecondStorageSegmentLayoutMap(Map<String, Set<Long>> secondStorageSegmentLayoutMap) {
        this.secondStorageSegmentLayoutMap = secondStorageSegmentLayoutMap;
    }

    @Generated
    public Map<String, List<Long>> getPrunedPartitions() {
        return this.prunedPartitions;
    }

    @Generated
    public void setPrunedPartitions(Map<String, List<Long>> prunedPartitions) {
        this.prunedPartitions = prunedPartitions;
    }

    public static class CandidateTableIndexComparator
    implements Comparator<Candidate> {
        @Override
        public int compare(Candidate c1, Candidate c2) {
            CapabilityResult capabilityResult1 = c1.getCapability();
            CapabilityResult capabilityResult2 = c2.getCapability();
            if (capabilityResult1.getLayoutUnmatchedColsSize() != capabilityResult2.getLayoutUnmatchedColsSize()) {
                return capabilityResult1.getLayoutUnmatchedColsSize() - capabilityResult2.getLayoutUnmatchedColsSize();
            }
            return Candidate.compareCandidate(c1, c2);
        }
    }

    public static class CandidateComparator
    implements Comparator<Candidate> {
        @Override
        public int compare(Candidate c1, Candidate c2) {
            return Candidate.compareCandidate(c1, c2);
        }
    }
}

