/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPContextProp;
import org.apache.kylin.query.routing.Candidate;
import org.apache.kylin.query.routing.RealizationCheck;
import org.apache.kylin.query.routing.RoutingRule;
import org.apache.kylin.query.routing.rules.PartitionPruningRule;
import org.apache.kylin.query.routing.rules.RealizationSortRule;
import org.apache.kylin.query.routing.rules.RemoveBlackoutRealizationsRule;
import org.apache.kylin.query.routing.rules.RemoveUncapableRealizationsRule;
import org.apache.kylin.query.routing.rules.SegmentPruningRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryRouter {
    private static final Logger logger = LoggerFactory.getLogger(QueryRouter.class);
    private static final List<RoutingRule> LAYOUT_CHOOSING_RULES = Lists.newLinkedList();

    private QueryRouter() {
    }

    public static void applyRules(List<Candidate> candidates) {
        for (RoutingRule rule : LAYOUT_CHOOSING_RULES) {
            String before = QueryRouter.getPrintableText(candidates);
            rule.apply(candidates);
            String after = QueryRouter.getPrintableText(candidates);
            if (before.equals(after)) continue;
            logger.info("Applying rule: {}, realizations before:{}, realizations after: {}", new Object[]{rule, before, after});
        }
    }

    public static String getPrintableText(List<Candidate> candidates) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Candidate candidate : candidates) {
            IRealization r = candidate.realization;
            sb.append(r.getCanonicalName());
            sb.append(",");
        }
        if (sb.charAt(sb.length() - 1) != '[') {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("]");
        return sb.toString();
    }

    public static void removeRule(RoutingRule rule) {
        LAYOUT_CHOOSING_RULES.removeIf(r -> r.getClass() == rule.getClass());
    }

    public static Candidate selectRealization(OLAPContext olapContext, IRealization realization, Map<String, String> aliasMap) {
        if (!realization.isReady()) {
            logger.warn("Realization {} is not ready", (Object)realization);
            return null;
        }
        ArrayList candidates = Lists.newArrayListWithCapacity((int)1);
        candidates.add(new Candidate(realization, olapContext, aliasMap));
        logger.info("Find candidates by table {} and project={} : {}", new Object[]{olapContext.firstTableScan.getTableName(), olapContext.olapSchema.getProjectName(), StringUtils.join((Iterable)candidates, (String)",")});
        ArrayList originCandidates = Lists.newArrayList((Iterable)candidates);
        QueryRouter.applyRules(candidates);
        QueryRouter.collectIncapableReason(olapContext, originCandidates);
        if (candidates.isEmpty()) {
            return null;
        }
        Candidate chosen = (Candidate)candidates.get(0);
        chosen.setRewrittenCtx(QueryRouter.preserveRewriteProps(olapContext));
        logger.info("The realizations remaining: {}, and the final chosen one for current olap context {} is {}", new Object[]{QueryRouter.getPrintableText(candidates), olapContext.id, chosen.realization.getCanonicalName()});
        return chosen;
    }

    static OLAPContextProp preserveRewriteProps(OLAPContext rewrittenOLAContext) {
        return QueryRouter.preservePropsBeforeRewrite(rewrittenOLAContext);
    }

    static OLAPContextProp preservePropsBeforeRewrite(OLAPContext oriOLAPContext) {
        OLAPContextProp preserved = new OLAPContextProp(-1);
        preserved.allColumns = Sets.newHashSet(oriOLAPContext.allColumns);
        preserved.setSortColumns(Lists.newArrayList(oriOLAPContext.getSortColumns()));
        preserved.setInnerGroupByColumns(Sets.newHashSet(oriOLAPContext.getInnerGroupByColumns()));
        preserved.setGroupByColumns(Sets.newLinkedHashSet(oriOLAPContext.getGroupByColumns()));
        preserved.setInnerFilterColumns(Sets.newHashSet(oriOLAPContext.getInnerFilterColumns()));
        for (FunctionDesc agg : oriOLAPContext.aggregations) {
            preserved.getReservedMap().put(agg, FunctionDesc.newInstance((String)agg.getExpression(), (List)agg.getParameters(), (String)agg.getReturnType()));
        }
        return preserved;
    }

    static void restoreOLAPContextProps(OLAPContext oriOLAPContext, OLAPContextProp preservedOLAPContext) {
        oriOLAPContext.allColumns = preservedOLAPContext.allColumns;
        oriOLAPContext.setSortColumns(preservedOLAPContext.getSortColumns());
        oriOLAPContext.aggregations.forEach(agg -> {
            if (preservedOLAPContext.getReservedMap().containsKey(agg)) {
                FunctionDesc functionDesc = preservedOLAPContext.getReservedMap().get(agg);
                agg.setExpression(functionDesc.getExpression());
                agg.setParameters(functionDesc.getParameters());
                agg.setReturnType(functionDesc.getReturnType());
            }
        });
        oriOLAPContext.setGroupByColumns(preservedOLAPContext.getGroupByColumns());
        oriOLAPContext.setInnerGroupByColumns(preservedOLAPContext.getInnerGroupByColumns());
        oriOLAPContext.setInnerFilterColumns(preservedOLAPContext.getInnerFilterColumns());
        oriOLAPContext.resetSQLDigest();
    }

    private static void collectIncapableReason(OLAPContext olapContext, List<Candidate> candidates) {
        for (Candidate candidate : candidates) {
            if (!candidate.getCapability().capable) {
                RealizationCheck.IncapableReason reason = RealizationCheck.IncapableReason.create(candidate.getCapability().incapableCause);
                if (reason == null) continue;
                olapContext.realizationCheck.addIncapableCube(candidate.getRealization(), reason);
                continue;
            }
            olapContext.realizationCheck.addCapableCube(candidate.getRealization());
        }
    }

    static {
        LAYOUT_CHOOSING_RULES.add(new RemoveBlackoutRealizationsRule());
        LAYOUT_CHOOSING_RULES.add(new SegmentPruningRule());
        LAYOUT_CHOOSING_RULES.add(new PartitionPruningRule());
        LAYOUT_CHOOSING_RULES.add(new RemoveUncapableRealizationsRule());
        LAYOUT_CHOOSING_RULES.add(new RealizationSortRule());
    }
}

