/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing;

import com.alibaba.ttl.TtlRunnable;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinTimeoutException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.logging.SetLogCategory;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.NamedThreadFactory;
import org.apache.kylin.common.util.SetThreadName;
import org.apache.kylin.metadata.cube.cuboid.NLayoutCandidate;
import org.apache.kylin.metadata.cube.cuboid.NLookupCandidate;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.cube.realization.HybridRealization;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.FusionModelManager;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.JoinsGraph;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.project.NProjectLoader;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.NoRealizationFoundException;
import org.apache.kylin.metadata.realization.NoStreamingRealizationFoundException;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPContextProp;
import org.apache.kylin.query.relnode.OLAPTableScan;
import org.apache.kylin.query.routing.Candidate;
import org.apache.kylin.query.routing.QueryRouter;
import org.apache.kylin.query.routing.RealizationCheck;
import org.apache.kylin.query.util.RelAggPushDownUtil;
import org.apache.kylin.storage.StorageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealizationChooser {
    private static final Logger logger = LoggerFactory.getLogger(RealizationChooser.class);
    private static ExecutorService selectCandidateService = new ThreadPoolExecutor(KylinConfig.getInstanceFromEnv().getQueryRealizationChooserThreadCoreNum(), KylinConfig.getInstanceFromEnv().getQueryRealizationChooserThreadMaxNum(), 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("RealChooser"), new ThreadPoolExecutor.CallerRunsPolicy());

    private RealizationChooser() {
    }

    public static void selectLayoutCandidate(List<OLAPContext> contexts) {
        for (OLAPContext ctx : contexts) {
            if (ctx.isConstantQueryWithAggregations()) continue;
            ctx.realizationCheck = new RealizationCheck();
            RealizationChooser.attemptSelectCandidate(ctx);
            Preconditions.checkNotNull((Object)ctx.realization);
        }
    }

    public static void multiThreadSelectLayoutCandidate(List<OLAPContext> contexts) {
        ArrayList futureList = Lists.newArrayList();
        try {
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            String project = QueryContext.current().getProject();
            String queryId = QueryContext.current().getQueryId();
            CountDownLatch latch = new CountDownLatch(contexts.size());
            for (OLAPContext ctx : contexts) {
                Future<?> future = selectCandidateService.submit((Runnable)Objects.requireNonNull(TtlRunnable.get(() -> {
                    try (KylinConfig.SetAndUnsetThreadLocalConfig autoUnset = KylinConfig.setAndUnsetThreadLocalConfig((KylinConfig)kylinConfig);
                         SetThreadName ignored = new SetThreadName(Thread.currentThread().getName() + " QueryId %s", new Object[]{queryId});
                         SetLogCategory logCategory = new SetLogCategory("query");){
                        if (project != null) {
                            NTableMetadataManager.getInstance((KylinConfig)kylinConfig, (String)project);
                            NDataModelManager.getInstance((KylinConfig)kylinConfig, (String)project);
                            NDataflowManager.getInstance((KylinConfig)kylinConfig, (String)project);
                            NIndexPlanManager.getInstance((KylinConfig)kylinConfig, (String)project);
                            NProjectLoader.updateCache((String)project);
                        }
                        if (!ctx.isConstantQueryWithAggregations()) {
                            ctx.realizationCheck = new RealizationCheck();
                            RealizationChooser.attemptSelectCandidate(ctx);
                            Preconditions.checkNotNull((Object)ctx.realization);
                        }
                    }
                    catch (KylinTimeoutException e) {
                        logger.error("realization chooser thread task interrupted due to query [{}] timeout", (Object)queryId);
                    }
                    finally {
                        NProjectLoader.removeCache();
                        latch.countDown();
                    }
                })));
                futureList.add(future);
            }
            latch.await();
            for (Future future : futureList) {
                future.get();
            }
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof NoRealizationFoundException) {
                throw (NoRealizationFoundException)e.getCause();
            }
            if (e.getCause() instanceof NoStreamingRealizationFoundException) {
                throw (NoStreamingRealizationFoundException)e.getCause();
            }
        }
        catch (InterruptedException e) {
            for (Future future : futureList) {
                future.cancel(true);
            }
            QueryContext.current().getQueryTagInfo().setTimeout(true);
            Thread.currentThread().interrupt();
            throw new KylinTimeoutException("The query exceeds the set time limit of " + KylinConfig.getInstanceFromEnv().getQueryTimeoutSeconds() + "s. Current step: Realization chooser. ");
        }
    }

    @VisibleForTesting
    public static void attemptSelectCandidate(OLAPContext context) {
        List<Candidate> candidate;
        OLAPContextProp preservedOLAPContext;
        if (context.getModelAlias() != null) {
            logger.info("context is bound to model {}", (Object)context.getModelAlias());
        }
        context.setHasSelected(true);
        Multimap<NDataModel, IRealization> modelMap = RealizationChooser.makeOrderedModelMap(context);
        if (modelMap.size() == 0) {
            RealizationChooser.checkNoRealizationWithStreaming(context);
            RelAggPushDownUtil.registerUnmatchedJoinDigest(context.getTopNode());
            throw new NoRealizationFoundException("No model found for " + RealizationChooser.toErrorMsg(context));
        }
        logger.trace("Models matched fact table {}: {}", (Object)context.firstTableScan.getTableName(), (Object)modelMap.values());
        ArrayList candidates = Lists.newArrayList();
        HashMap model2AliasMap = Maps.newHashMap();
        logger.info("Context join graph: {}", (Object)context.getJoinsGraph());
        for (NDataModel model : modelMap.keySet()) {
            preservedOLAPContext = QueryRouter.preservePropsBeforeRewrite(context);
            candidate = RealizationChooser.selectRealizationFromModel(model, context, false, false, modelMap, model2AliasMap);
            if (candidate != null && !candidate.isEmpty()) {
                candidates.addAll(candidate);
                logger.info("context & model({}, {}) match info: {}", new Object[]{model.getUuid(), model.getAlias(), true});
            }
            QueryRouter.restoreOLAPContextProps(context, preservedOLAPContext);
        }
        if (CollectionUtils.isEmpty((Collection)candidates) && (RealizationChooser.partialMatchInnerJoin() || RealizationChooser.partialMatchNonEquiJoin())) {
            for (NDataModel model : modelMap.keySet()) {
                preservedOLAPContext = QueryRouter.preservePropsBeforeRewrite(context);
                candidate = RealizationChooser.selectRealizationFromModel(model, context, RealizationChooser.partialMatchInnerJoin(), RealizationChooser.partialMatchNonEquiJoin(), modelMap, model2AliasMap);
                if (candidate != null) {
                    candidates.addAll(candidate);
                }
                QueryRouter.restoreOLAPContextProps(context, preservedOLAPContext);
            }
            context.storageContext.setPartialMatchModel(CollectionUtils.isNotEmpty((Collection)candidates));
        }
        RealizationChooser.sortCandidate(context, candidates);
        logger.trace("Cost Sorted Realizations {}", (Object)candidates);
        if (!candidates.isEmpty()) {
            Candidate selectedCandidate = (Candidate)candidates.get(0);
            QueryRouter.restoreOLAPContextProps(context, selectedCandidate.getRewrittenCtx());
            context.fixModel(selectedCandidate.getRealization().getModel(), (Map)model2AliasMap.get(selectedCandidate.getRealization().getModel()));
            RealizationChooser.adjustForCapabilityInfluence(selectedCandidate, context);
            context.realization = selectedCandidate.realization;
            if (selectedCandidate.capability.getSelectedCandidate() instanceof NLookupCandidate) {
                context.storageContext.setUseSnapshot(context.isFirstTableLookupTableInModel(context.realization.getModel()));
            } else {
                HashSet dimensions = Sets.newHashSet();
                HashSet metrics = Sets.newHashSet();
                boolean isBatchQuery = !(context.realization instanceof HybridRealization) && !context.realization.isStreaming();
                RealizationChooser.buildDimensionsAndMetrics(context.getSQLDigest(), dimensions, metrics, context.realization);
                RealizationChooser.buildStorageContext(context.storageContext, dimensions, metrics, selectedCandidate, isBatchQuery);
                RealizationChooser.buildSecondStorageEnabled(context.getSQLDigest());
                RealizationChooser.fixContextForTableIndexAnswerNonRawQuery(context);
            }
            return;
        }
        RealizationChooser.checkNoRealizationWithStreaming(context);
        RelAggPushDownUtil.registerUnmatchedJoinDigest(context.getTopNode());
        throw new NoRealizationFoundException("No realization found for " + RealizationChooser.toErrorMsg(context));
    }

    private static void sortCandidate(OLAPContext context, List<Candidate> candidates) {
        ProjectInstance projectInstance = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(context.olapSchema.getProjectName());
        if (projectInstance.getConfig().useTableIndexAnswerSelectStarEnabled() && context.getSQLDigest().isRawQuery) {
            candidates.sort(Candidate.COMPARATOR_TABLE_INDEX);
        } else {
            candidates.sort(Candidate.COMPARATOR);
        }
    }

    private static void checkNoRealizationWithStreaming(OLAPContext context) {
        String projectName = context.olapSchema.getProjectName();
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        NTableMetadataManager tableManager = NTableMetadataManager.getInstance((KylinConfig)kylinConfig, (String)projectName);
        for (OLAPTableScan tableScan : context.allTableScans) {
            TableDesc tableDesc = tableManager.getTableDesc(tableScan.getTableName());
            if (tableDesc.getSourceType() != 1) continue;
            throw new NoStreamingRealizationFoundException((ErrorCodeSupplier)ServerErrorCode.STREAMING_MODEL_NOT_FOUND, MsgPicker.getMsg().getNoStreamingModelFound());
        }
    }

    private static List<Candidate> selectRealizationFromModel(NDataModel model, OLAPContext context, boolean isPartialMatch, boolean isPartialMatchNonEquiJoin, Multimap<NDataModel, IRealization> modelMap, Map<NDataModel, Map<String, String>> model2AliasMap) {
        Map<String, String> map = RealizationChooser.matchJoins(model, context, isPartialMatch, isPartialMatchNonEquiJoin);
        if (MapUtils.isEmpty(map)) {
            return new ArrayList<Candidate>();
        }
        context.fixModel(model, map);
        model2AliasMap.put(model, map);
        RealizationChooser.preprocessOlapCtx(context);
        if (!RealizationChooser.hasReadySegments(model)) {
            context.unfixModel();
            logger.info("Exclude this model {} because there are no ready segments", (Object)model.getAlias());
            return new ArrayList<Candidate>();
        }
        HashSet realizations = Sets.newHashSet((Iterable)modelMap.get((Object)model));
        ArrayList candidates = Lists.newArrayListWithCapacity((int)realizations.size());
        for (IRealization real : realizations) {
            Candidate candidate = QueryRouter.selectRealization(context, real, model2AliasMap.get(model));
            if (candidate != null) {
                candidates.add(candidate);
                logger.trace("Model {} QueryRouter matched", (Object)model);
                continue;
            }
            logger.trace("Model {} failed in QueryRouter matching", (Object)model);
        }
        context.setNeedToManyDerived(RealizationChooser.needToManyDerived(model));
        context.unfixModel();
        return candidates;
    }

    private static boolean needToManyDerived(NDataModel model) {
        return model.getJoinTables().stream().anyMatch(JoinTableDesc::isDerivedToManyJoinRelation);
    }

    private static boolean hasReadySegments(NDataModel model) {
        NDataflow dataflow = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)model.getProject()).getDataflow(model.getUuid());
        if (model.isFusionModel()) {
            FusionModelManager fusionModelManager = FusionModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)model.getProject());
            String batchId = fusionModelManager.getFusionModel(model.getFusionId()).getBatchModel().getUuid();
            NDataflow batchDataflow = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)model.getProject()).getDataflow(batchId);
            return dataflow.hasReadySegments() || batchDataflow.hasReadySegments();
        }
        return dataflow.hasReadySegments();
    }

    public static void fixContextForTableIndexAnswerNonRawQuery(OLAPContext context) {
        if (context.realization.getConfig().isUseTableIndexAnswerNonRawQuery() && !context.storageContext.isEmptyLayout() && context.isAnsweredByTableIndex()) {
            if (!context.aggregations.isEmpty()) {
                List<FunctionDesc> aggregations = context.aggregations;
                HashSet needDimensions = Sets.newHashSet();
                for (FunctionDesc aggregation : aggregations) {
                    List parameters = aggregation.getParameters();
                    for (ParameterDesc aggParameter : parameters) {
                        needDimensions.addAll(aggParameter.getColRef().getSourceColumns());
                    }
                }
                context.storageContext.getDimensions().addAll(needDimensions);
                context.aggregations.clear();
            }
            if (context.getSQLDigest().aggregations != null) {
                context.getSQLDigest().aggregations.clear();
            }
            if (context.storageContext.getMetrics() != null) {
                context.storageContext.getMetrics().clear();
            }
        }
    }

    private static void adjustForCapabilityInfluence(Candidate chosen, OLAPContext olapContext) {
        CapabilityResult capability = chosen.getCapability();
        for (CapabilityResult.CapabilityInfluence inf : capability.influences) {
            if (inf instanceof CapabilityResult.DimensionAsMeasure) {
                FunctionDesc functionDesc = ((CapabilityResult.DimensionAsMeasure)inf).getMeasureFunction();
                functionDesc.setDimensionAsMetric(true);
                RealizationChooser.addToContextGroupBy(functionDesc.getSourceColRefs(), olapContext);
                olapContext.resetSQLDigest();
                olapContext.getSQLDigest();
                logger.info("Adjust DimensionAsMeasure for {}", (Object)functionDesc);
                continue;
            }
            MeasureDesc involvedMeasure = inf.getInvolvedMeasure();
            if (involvedMeasure == null) continue;
            involvedMeasure.getFunction().getMeasureType().adjustSqlDigest(involvedMeasure, olapContext.getSQLDigest());
        }
    }

    private static void addToContextGroupBy(Collection<TblColRef> colRefs, OLAPContext context) {
        for (TblColRef col : colRefs) {
            if (col.isInnerColumn() || !context.belongToContextTables(col)) continue;
            context.getGroupByColumns().add(col);
        }
    }

    private static void preprocessOlapCtx(OLAPContext context) {
        if (CollectionUtils.isEmpty(context.aggregations)) {
            return;
        }
        Iterator<FunctionDesc> it = context.aggregations.iterator();
        while (it.hasNext()) {
            FunctionDesc func = it.next();
            if ("GROUPING".equalsIgnoreCase(func.getExpression())) {
                it.remove();
                continue;
            }
            if (!"INTERSECT_COUNT".equalsIgnoreCase(func.getExpression())) continue;
            TblColRef col = (TblColRef)func.getColRefs().get(1);
            context.getGroupByColumns().add(col);
        }
    }

    private static void buildSecondStorageEnabled(SQLDigest sqlDigest) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        if (kylinConfig.getSecondStorageQueryPushdownLimit() <= 0) {
            return;
        }
        if (sqlDigest.isRawQuery && sqlDigest.limit > kylinConfig.getSecondStorageQueryPushdownLimit()) {
            QueryContext.current().setRetrySecondStorage(false);
        }
    }

    private static void buildStorageContext(StorageContext context, Set<TblColRef> dimensions, Set<FunctionDesc> metrics, Candidate candidate, boolean isBatchQuery) {
        if (isBatchQuery) {
            RealizationChooser.buildBatchStorageContext(context, dimensions, metrics, candidate);
        } else {
            RealizationChooser.buildStreamingStorageContext(context, dimensions, metrics, candidate);
        }
    }

    private static void buildBatchStorageContext(StorageContext context, Set<TblColRef> dimensions, Set<FunctionDesc> metrics, Candidate candidate) {
        NLayoutCandidate layoutCandidate = (NLayoutCandidate)candidate.getCapability().getSelectedCandidate();
        List<NDataSegment> prunedSegments = candidate.getPrunedSegments();
        Map<String, List<Long>> prunedPartitions = candidate.getPrunedPartitions();
        if (layoutCandidate.isEmptyCandidate()) {
            context.setLayoutId(Long.valueOf(-1L));
            context.setEmptyLayout(true);
            logger.info("for context {}, chose empty layout", (Object)context.getCtxId());
            return;
        }
        LayoutEntity cuboidLayout = layoutCandidate.getLayoutEntity();
        context.setCandidate(layoutCandidate);
        context.setDimensions(dimensions);
        context.setMetrics(metrics);
        context.setLayoutId(Long.valueOf(cuboidLayout.getId()));
        context.setPrunedSegments(prunedSegments);
        context.setPrunedPartitions(prunedPartitions);
        List segmentIds = prunedSegments.stream().map(NDataSegment::getId).collect(Collectors.toList());
        logger.info("for context {}, chosen model: {}, its join: {}, layout: {}, dimensions: {}, measures: {}, segments: {}", new Object[]{context.getCtxId(), cuboidLayout.getModel().getAlias(), cuboidLayout.getModel().getJoinsGraph(), cuboidLayout.getId(), cuboidLayout.getOrderedDimensions(), cuboidLayout.getOrderedMeasures(), segmentIds});
    }

    private static void buildStreamingStorageContext(StorageContext context, Set<TblColRef> dimensions, Set<FunctionDesc> metrics, Candidate candidate) {
        List segmentIds;
        LayoutEntity cuboidLayout;
        context.setPrunedStreamingSegments(candidate.getPrunedStreamingSegments());
        NLayoutCandidate layoutStreamingCandidate = (NLayoutCandidate)candidate.getCapability().getSelectedStreamingCandidate();
        context.setStreamingCandidate(layoutStreamingCandidate);
        if (layoutStreamingCandidate == null || layoutStreamingCandidate.isEmptyCandidate()) {
            context.setStreamingLayoutId(Long.valueOf(-1L));
        } else {
            context.setStreamingLayoutId(Long.valueOf(layoutStreamingCandidate.getLayoutEntity().getId()));
        }
        List<NDataSegment> prunedSegments = candidate.getPrunedSegments();
        NLayoutCandidate layoutCandidate = (NLayoutCandidate)candidate.getCapability().getSelectedCandidate();
        Map<String, List<Long>> prunedPartitions = candidate.getPrunedPartitions();
        if (layoutCandidate == null && layoutStreamingCandidate == NLayoutCandidate.EMPTY || layoutStreamingCandidate == null && layoutCandidate == NLayoutCandidate.EMPTY) {
            throw new NoStreamingRealizationFoundException((ErrorCodeSupplier)ServerErrorCode.STREAMING_MODEL_NOT_FOUND, String.format(Locale.ROOT, MsgPicker.getMsg().getNoStreamingModelFound(), new Object[0]));
        }
        if (layoutCandidate == NLayoutCandidate.EMPTY && layoutStreamingCandidate == NLayoutCandidate.EMPTY) {
            context.setLayoutId(Long.valueOf(-1L));
            context.setStreamingLayoutId(Long.valueOf(-1L));
            context.setEmptyLayout(true);
            logger.info("for context {}, chose empty layout", (Object)context.getCtxId());
            return;
        }
        if (RealizationChooser.differentTypeofIndex(layoutCandidate, layoutStreamingCandidate)) {
            context.setLayoutId(null);
            context.setStreamingLayoutId(null);
            context.setEmptyLayout(true);
            logger.error("The case when the type of stream and batch index different is not supported yet.");
            throw new NoStreamingRealizationFoundException((ErrorCodeSupplier)ServerErrorCode.STREAMING_MODEL_NOT_FOUND, String.format(Locale.ROOT, MsgPicker.getMsg().getNoStreamingModelFound(), new Object[0]));
        }
        NDataModel model = candidate.getRealization().getModel();
        context.setCandidate(layoutCandidate);
        context.setDimensions(dimensions);
        context.setMetrics(metrics);
        context.setLayoutId(Long.valueOf(layoutCandidate == null ? -1L : layoutCandidate.getLayoutEntity().getId()));
        context.setPrunedSegments(prunedSegments);
        context.setPrunedPartitions(prunedPartitions);
        if (layoutCandidate != null && !layoutCandidate.isEmptyCandidate()) {
            cuboidLayout = layoutCandidate.getLayoutEntity();
            segmentIds = prunedSegments.stream().map(NDataSegment::getId).collect(Collectors.toList());
            logger.info("for context {}, chosen model: {}, its join: {}, batch layout: {}, batch layout dimensions: {}, batch layout measures: {}, batch segments: {}", new Object[]{context.getCtxId(), model.getAlias(), model.getJoinsGraph(), cuboidLayout.getId(), cuboidLayout.getOrderedDimensions(), cuboidLayout.getOrderedMeasures(), segmentIds});
        }
        if (layoutStreamingCandidate != null && !layoutStreamingCandidate.isEmptyCandidate()) {
            cuboidLayout = layoutStreamingCandidate.getLayoutEntity();
            segmentIds = candidate.getPrunedStreamingSegments().stream().map(NDataSegment::getId).collect(Collectors.toList());
            logger.info("for context {}, chosen model: {}, its join: {}, streaming layout: {}, streaming layout dimensions: {}, streaming layout measures: {}, streaming segments: {}", new Object[]{context.getCtxId(), model.getAlias(), model.getJoinsGraph(), cuboidLayout.getId(), cuboidLayout.getOrderedDimensions(), cuboidLayout.getOrderedMeasures(), segmentIds});
        }
    }

    private static boolean differentTypeofIndex(NLayoutCandidate batchLayout, NLayoutCandidate streamLayout) {
        if (batchLayout == null || batchLayout.isEmptyCandidate()) {
            return false;
        }
        if (streamLayout == null || streamLayout.isEmptyCandidate()) {
            return false;
        }
        return batchLayout.getLayoutEntity().getIndex().isTableIndex() != streamLayout.getLayoutEntity().getIndex().isTableIndex();
    }

    private static void buildDimensionsAndMetrics(SQLDigest sqlDigest, Collection<TblColRef> dimensions, Collection<FunctionDesc> metrics, IRealization realization) {
        for (FunctionDesc func : sqlDigest.aggregations) {
            if (!func.isDimensionAsMetric() && !func.isGrouping()) {
                if ("INTERSECT_COUNT".equalsIgnoreCase(func.getExpression())) {
                    realization.getMeasures().stream().filter(measureDesc -> measureDesc.getFunction().getReturnType().equals("bitmap") && ((ParameterDesc)func.getParameters().get(0)).equals(measureDesc.getFunction().getParameters().get(0))).forEach(measureDesc -> metrics.add(measureDesc.getFunction()));
                    dimensions.add(((ParameterDesc)func.getParameters().get(1)).getColRef());
                    continue;
                }
                if ("BITMAP_UUID".equalsIgnoreCase(func.getExpression()) || "BITMAP_BUILD".equalsIgnoreCase(func.getExpression())) {
                    realization.getMeasures().stream().filter(measureDesc -> measureDesc.getFunction().getReturnType().equals("bitmap") && ((ParameterDesc)func.getParameters().get(0)).equals(measureDesc.getFunction().getParameters().get(0))).forEach(measureDesc -> metrics.add(measureDesc.getFunction()));
                    continue;
                }
                FunctionDesc aggrFuncFromDataflowDesc = realization.findAggrFunc(func);
                metrics.add(aggrFuncFromDataflowDesc);
                continue;
            }
            if (!func.isDimensionAsMetric()) continue;
            FunctionDesc funcUsedDimenAsMetric = RealizationChooser.findAggrFuncFromRealization(func, realization);
            dimensions.addAll(funcUsedDimenAsMetric.getColRefs());
            LinkedHashSet groupbyCols = Sets.newLinkedHashSet((Iterable)sqlDigest.groupbyColumns);
            groupbyCols.addAll(funcUsedDimenAsMetric.getColRefs());
            sqlDigest.groupbyColumns = Lists.newArrayList((Iterable)groupbyCols);
        }
        if (sqlDigest.isRawQuery) {
            dimensions.addAll(sqlDigest.allColumns);
        } else {
            dimensions.addAll(sqlDigest.groupbyColumns);
            dimensions.addAll(sqlDigest.filterColumns);
        }
    }

    private static FunctionDesc findAggrFuncFromRealization(FunctionDesc aggrFunc, IRealization realization) {
        for (MeasureDesc measure : realization.getMeasures()) {
            if (!measure.getFunction().equals((Object)aggrFunc)) continue;
            return measure.getFunction();
        }
        return aggrFunc;
    }

    private static String toErrorMsg(OLAPContext ctx) {
        StringBuilder buf = new StringBuilder("OLAPContext");
        RealizationCheck checkResult = ctx.realizationCheck;
        for (List<RealizationCheck.IncapableReason> reasons : checkResult.getModelIncapableReasons().values()) {
            for (RealizationCheck.IncapableReason reason : reasons) {
                buf.append(", ").append(reason);
            }
        }
        buf.append(", ").append(ctx.firstTableScan);
        for (JoinDesc join : ctx.joins) {
            buf.append(", ").append(join);
        }
        return buf.toString();
    }

    public static Map<String, String> matchJoins(NDataModel model, OLAPContext ctx, boolean partialMatch, boolean partialMatchNonEquiJoin) {
        boolean matched;
        HashMap matchUp = Maps.newHashMap();
        TableRef firstTable = ctx.firstTableScan.getTableRef();
        if (ctx.isFirstTableLookupTableInModel(model)) {
            String modelAlias = model.findFirstTable(firstTable.getTableIdentity()).getAlias();
            matchUp = ImmutableMap.of((Object)firstTable.getAlias(), (Object)modelAlias);
            matched = true;
            logger.info("Context fact table {} matched lookup table in model {}", (Object)ctx.firstTableScan.getTableName(), (Object)model);
        } else {
            if (ctx.joins.size() != ctx.allTableScans.size() - 1) {
                ctx.realizationCheck.addModelIncapableReason(model, RealizationCheck.IncapableReason.create(RealizationCheck.IncapableType.MODEL_BAD_JOIN_SEQUENCE));
                return new HashMap<String, String>();
            }
            if (ctx.getJoinsGraph() == null) {
                ctx.setJoinsGraph(new JoinsGraph(firstTable, ctx.joins));
            }
            if (!(matched = ctx.getJoinsGraph().match(model.getJoinsGraph(), (Map)matchUp, partialMatch, partialMatchNonEquiJoin))) {
                KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
                if (kylinConfig.isJoinMatchOptimizationEnabled()) {
                    logger.info("Query match join with join match optimization mode, trying to match with newly rewrite join graph.");
                    ctx.matchJoinWithFilterTransformation();
                    ctx.matchJoinWithEnhancementTransformation();
                    matched = ctx.getJoinsGraph().match(model.getJoinsGraph(), (Map)matchUp, partialMatch, partialMatchNonEquiJoin);
                    logger.info("Match result for match join with join match optimization mode is: {}", (Object)matched);
                }
                logger.debug("Context join graph missed model {}, model join graph {}", (Object)model, (Object)model.getJoinsGraph());
                logger.debug("Missed match nodes - Context {}, Model {}", (Object)ctx.getJoinsGraph().unmatched(model.getJoinsGraph()), (Object)model.getJoinsGraph().unmatched(ctx.getJoinsGraph()));
            }
        }
        if (!matched) {
            ctx.realizationCheck.addModelIncapableReason(model, RealizationCheck.IncapableReason.create(RealizationCheck.IncapableType.MODEL_UNMATCHED_JOIN));
            return new HashMap<String, String>();
        }
        ctx.realizationCheck.addCapableModel(model, matchUp);
        return matchUp;
    }

    public static Map<String, String> matchJoins(NDataModel model, OLAPContext ctx) {
        return RealizationChooser.matchJoins(model, ctx, RealizationChooser.partialMatchInnerJoin(), RealizationChooser.partialMatchNonEquiJoin());
    }

    private static Multimap<NDataModel, IRealization> makeOrderedModelMap(OLAPContext context) {
        KylinConfig kylinConfig = context.olapSchema.getConfig();
        String projectName = context.olapSchema.getProjectName();
        String factTableName = context.firstTableScan.getOlapTable().getTableName();
        Set realizations = NProjectManager.getInstance((KylinConfig)kylinConfig).getRealizationsByTable(projectName, factTableName);
        HashMultimap mapModelToRealizations = HashMultimap.create();
        boolean streamingEnabled = kylinConfig.streamingEnabled();
        for (IRealization real : realizations) {
            if (!real.isReady() || RealizationChooser.isModelViewBounded(context, real) || RealizationChooser.omitFusionModel(streamingEnabled, real)) {
                if (real.isReady()) continue;
                context.realizationCheck.addIncapableCube(real, RealizationCheck.IncapableReason.create(RealizationCheck.IncapableType.CUBE_NOT_READY));
                logger.warn("Realization {} is not ready for project {} with fact table {}", new Object[]{real, projectName, factTableName});
                continue;
            }
            mapModelToRealizations.put((Object)real.getModel(), (Object)real);
        }
        if (mapModelToRealizations.isEmpty()) {
            logger.error("No realization found for project {} with fact table {}", (Object)projectName, (Object)factTableName);
        }
        return mapModelToRealizations;
    }

    private static boolean isModelViewBounded(OLAPContext context, IRealization realization) {
        return context.getModelAlias() != null && !StringUtils.equalsIgnoreCase((String)realization.getModel().getAlias(), (String)context.getModelAlias());
    }

    private static boolean omitFusionModel(boolean turnOnStreaming, IRealization real) {
        return !turnOnStreaming && real.getModel().isFusionModel();
    }

    private static boolean partialMatchInnerJoin() {
        return RealizationChooser.getProjectConfig().isQueryMatchPartialInnerJoinModel();
    }

    private static boolean partialMatchNonEquiJoin() {
        return RealizationChooser.getProjectConfig().partialMatchNonEquiJoins();
    }

    private static KylinConfig getProjectConfig() {
        String project = QueryContext.current().getProject();
        try {
            if (project != null) {
                return NProjectManager.getProjectConfig((String)project);
            }
        }
        catch (Exception e) {
            logger.error("Failed to get config of project<{}> when matching partial inner join model. {}", (Object)project, (Object)e.getMessage());
        }
        return KylinConfig.getInstanceFromEnv();
    }
}

