/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.TimestampString;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.MultiPartitionDesc;
import org.apache.kylin.metadata.model.MultiPartitionKeyMapping;
import org.apache.kylin.metadata.model.MultiPartitionKeyMappingProvider;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPTableScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealizationPruner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RealizationPruner.class);
    private static final String DATE = "date";
    private static final String TIMESTAMP = "timestamp";
    private static final String VARCHAR = "varchar";
    private static final String STRING = "string";
    private static final String INTEGER = "integer";
    private static final String BIGINT = "bigint";
    private static final TimeZone UTC_ZONE = TimeZone.getTimeZone("UTC");
    private static final Set<SqlKind> COMPARISON_OP_KIND_SET = ImmutableSet.of((Object)SqlKind.GREATER_THAN, (Object)SqlKind.GREATER_THAN_OR_EQUAL, (Object)SqlKind.LESS_THAN, (Object)SqlKind.LESS_THAN_OR_EQUAL, (Object)SqlKind.IN, (Object)SqlKind.NOT_IN, (Object[])new SqlKind[]{SqlKind.EQUALS, SqlKind.NOT_EQUALS});

    private RealizationPruner() {
    }

    public static List<NDataSegment> pruneSegments(NDataflow dataflow, OLAPContext olapContext) {
        RexNode simplifiedSqlFilter;
        PartitionDesc partitionDesc;
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        String projectName = dataflow.getProject();
        ProjectInstance projectInstance = NProjectManager.getInstance((KylinConfig)kylinConfig).getProject(projectName);
        Segments allReadySegments = dataflow.getQueryableSegments();
        if (!projectInstance.getConfig().isHeterogeneousSegmentEnabled()) {
            return allReadySegments;
        }
        boolean isStreamingFactTable = olapContext.firstTableScan.getOlapTable().getSourceTable().getSourceType() == 1;
        boolean isBatchFusionModel = isStreamingFactTable && dataflow.getModel().isFusionModel() && !dataflow.isStreaming();
        PartitionDesc partitionDesc2 = partitionDesc = isBatchFusionModel ? RealizationPruner.getStreamingPartitionDesc(dataflow.getModel(), kylinConfig, projectName) : dataflow.getModel().getPartitionDesc();
        if (PartitionDesc.isEmptyPartitionDesc((PartitionDesc)partitionDesc)) {
            log.info("No partition column");
            return allReadySegments;
        }
        TblColRef partitionColumn = partitionDesc.getPartitionDateColumnRef();
        String dateFormat = partitionDesc.getPartitionDateFormat();
        Set<TblColRef> filterColumns = olapContext.filterColumns;
        if (!filterColumns.contains(partitionColumn)) {
            log.info("Filter columns do not contain partition column");
            return allReadySegments;
        }
        ArrayList selectedSegments = Lists.newArrayList();
        List<Object> filterConditions = olapContext.getExpandedFilterConditions();
        RelOptCluster relOptCluster = olapContext.firstTableScan.getCluster();
        RexBuilder rexBuilder = relOptCluster.getRexBuilder();
        RexSimplify rexSimplify = new RexSimplify(relOptCluster.getRexBuilder(), RelOptPredicateList.EMPTY, true, relOptCluster.getPlanner().getExecutor());
        RexInputRef partitionColInputRef = RealizationPruner.transformColumn2RexInputRef(partitionColumn, olapContext.allTableScans);
        if (allReadySegments.size() > 0 && dateFormat != null) {
            Pair<RexNode, RexNode> firstSegmentRanges = RealizationPruner.transformSegment2RexCall((NDataSegment)allReadySegments.get(0), dateFormat, rexBuilder, partitionColInputRef, partitionColumn.getType(), dataflow.isStreaming());
            RelDataTypeFamily segmentLiteralTypeFamily = RealizationPruner.getSegmentLiteralTypeFamily((RexNode)firstSegmentRanges.getFirst());
            filterConditions = filterConditions.stream().map(filterCondition -> RealizationPruner.rewriteRexCall(filterCondition, rexBuilder, segmentLiteralTypeFamily, partitionColInputRef, dateFormat)).collect(Collectors.toList());
        }
        if ((simplifiedSqlFilter = rexSimplify.simplifyAnds(filterConditions)).isAlwaysFalse()) {
            log.info("SQL filter condition is always false, pruning all ready segments");
            olapContext.storageContext.setFilterCondAlwaysFalse(true);
            return selectedSegments;
        }
        if (simplifiedSqlFilter.isAlwaysTrue()) {
            log.info("SQL filter condition is always true, pruning no segment");
            return allReadySegments;
        }
        if (dateFormat == null) {
            return allReadySegments;
        }
        for (NDataSegment dataSegment : allReadySegments) {
            try {
                RelOptPredicateList segmentEndPredicate;
                Pair<RexNode, RexNode> segmentRanges = RealizationPruner.transformSegment2RexCall(dataSegment, dateFormat, rexBuilder, partitionColInputRef, partitionColumn.getType(), dataflow.isStreaming());
                RelOptPredicateList segmentStartPredicate = RelOptPredicateList.of((RexBuilder)rexBuilder, (Iterable)Lists.newArrayList((Object[])new RexNode[]{(RexNode)segmentRanges.getFirst()}));
                RexNode simplifiedWithPredicate = rexSimplify.withPredicates(segmentStartPredicate).simplify(simplifiedSqlFilter);
                if (simplifiedWithPredicate.isAlwaysFalse() || (simplifiedWithPredicate = rexSimplify.withPredicates(segmentEndPredicate = RelOptPredicateList.of((RexBuilder)rexBuilder, (Iterable)Lists.newArrayList((Object[])new RexNode[]{(RexNode)segmentRanges.getSecond()}))).simplify(simplifiedWithPredicate)).isAlwaysFalse()) continue;
                selectedSegments.add(dataSegment);
            }
            catch (Exception ex) {
                log.warn("Segment pruning error: ", (Throwable)ex);
                selectedSegments.add(dataSegment);
            }
        }
        log.info("Scan segment.size: {} after segment pruning", (Object)selectedSegments.size());
        return selectedSegments;
    }

    public static RexNode rewriteRexCall(RexNode rexNode, RexBuilder rexBuilder, RelDataTypeFamily relDataTypeFamily, RexInputRef partitionColInputRef, String dateFormat) {
        if (!(rexNode instanceof RexCall)) {
            return rexNode;
        }
        RexCall rewriteRexCall = (RexCall)rexNode;
        if (COMPARISON_OP_KIND_SET.contains(rewriteRexCall.getOperator().kind)) {
            return RealizationPruner.needRewrite(partitionColInputRef, rewriteRexCall) ? RealizationPruner.rewriteRexNodeLiteral(rexNode, rexBuilder, relDataTypeFamily, dateFormat) : rexNode;
        }
        List opList = rewriteRexCall.getOperands().stream().map(rex -> RealizationPruner.rewriteRexCall(rex, rexBuilder, relDataTypeFamily, partitionColInputRef, dateFormat)).collect(Collectors.toList());
        return rexBuilder.makeCall(rewriteRexCall.getOperator(), opList);
    }

    private static boolean needRewrite(RexInputRef partitionColInputRef, RexCall rewriteRexCall) {
        boolean isContainsPartitionColumn = false;
        boolean isContainsLiteral = false;
        for (RexNode sonRexNode : rewriteRexCall.getOperands()) {
            if (sonRexNode instanceof RexInputRef) {
                RexInputRef rexInputRef = (RexInputRef)sonRexNode;
                String columnName = rexInputRef.getName();
                if (!partitionColInputRef.getName().contains(columnName)) continue;
                isContainsPartitionColumn = true;
                continue;
            }
            if (!(sonRexNode instanceof RexLiteral)) continue;
            isContainsLiteral = true;
        }
        return isContainsPartitionColumn && isContainsLiteral;
    }

    public static RexNode rewriteRexNodeLiteral(RexNode rexNodeLiteral, RexBuilder rexBuilder, RelDataTypeFamily relDataTypeFamily, String dateFormat) {
        if (rexNodeLiteral instanceof RexCall) {
            try {
                RexCall rexCall = (RexCall)rexNodeLiteral;
                List oldRexNodes = rexCall.getOperands();
                ArrayList<RexNode> newRexNodes = new ArrayList<RexNode>();
                for (RexNode rexNode : oldRexNodes) {
                    newRexNodes.add(RealizationPruner.transform(rexNode, rexBuilder, relDataTypeFamily, dateFormat));
                }
                rexNodeLiteral = rexBuilder.makeCall(rexCall.getOperator(), newRexNodes);
            }
            catch (Exception e) {
                log.warn("RewriteRexNodeLiteral failed rexNodeLiteral:{} relDataTypeFamily:{} dateFormat:{}", new Object[]{rexNodeLiteral, relDataTypeFamily.toString(), dateFormat, e});
            }
        }
        return rexNodeLiteral;
    }

    private static RexNode transform(RexNode rexNode, RexBuilder rexBuilder, RelDataTypeFamily relDataTypeFamily, String dateFormat) {
        RexLiteral newLiteral;
        if (!(rexNode instanceof RexLiteral)) {
            return rexNode;
        }
        RexLiteral rexLiteral = (RexLiteral)rexNode;
        if (SqlTypeFamily.DATE == relDataTypeFamily) {
            String dateStr = RealizationPruner.normalization(dateFormat, rexLiteral);
            newLiteral = rexBuilder.makeLiteral((Object)new DateString(dateStr), (RelDataType)new BasicSqlType(RelDataTypeSystem.DEFAULT, SqlTypeName.DATE), true);
        } else if (SqlTypeFamily.CHARACTER == relDataTypeFamily) {
            String dateStr = RealizationPruner.normalization(dateFormat, rexLiteral);
            newLiteral = rexBuilder.makeLiteral((Object)new NlsString(dateStr, "UTF-16LE", SqlCollation.IMPLICIT), (RelDataType)new BasicSqlType(RelDataTypeSystem.DEFAULT, SqlTypeName.CHAR), true);
        } else {
            newLiteral = rexLiteral;
        }
        return newLiteral;
    }

    private static String normalization(String dateFormat, RexLiteral rexLiteral) {
        RelDataTypeFamily typeFamily = rexLiteral.getType().getFamily();
        if (SqlTypeFamily.DATE == typeFamily) {
            long timeInMillis = ((Calendar)rexLiteral.getValue()).getTimeInMillis();
            String dateStr = DateFormat.formatToDateStr((long)timeInMillis, (String)dateFormat, (TimeZone)UTC_ZONE);
            if (!rexLiteral.toString().equals(dateStr)) {
                log.warn("Normalize RexLiteral({}) to {}", (Object)rexLiteral, (Object)dateStr);
            }
            return dateStr;
        }
        return rexLiteral.getValue2().toString();
    }

    public static RelDataTypeFamily getSegmentLiteralTypeFamily(RexNode rangeRexNode) {
        if (rangeRexNode instanceof RexCall) {
            RexCall rexCall = (RexCall)rangeRexNode;
            List oldRexNodes = rexCall.getOperands();
            for (RexNode rexNode : oldRexNodes) {
                if (!(rexNode instanceof RexLiteral)) continue;
                return rexNode.getType().getFamily();
            }
        }
        return null;
    }

    private static PartitionDesc getStreamingPartitionDesc(NDataModel model, KylinConfig kylinConfig, String project) {
        NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)kylinConfig, (String)project);
        NDataModel streamingModel = modelManager.getDataModelDesc(model.getFusionId());
        return streamingModel.getPartitionDesc();
    }

    private static Pair<RexNode, RexNode> transformSegment2RexCall(NDataSegment dataSegment, String dateFormat, RexBuilder rexBuilder, RexInputRef partitionColInputRef, DataType partitionColType, boolean isStreaming) {
        String end;
        String start;
        if (dataSegment.isOffsetCube()) {
            start = DateFormat.formatToDateStr((long)dataSegment.getKSRange().getStart(), (String)dateFormat);
            end = DateFormat.formatToDateStr((long)dataSegment.getKSRange().getEnd(), (String)dateFormat);
        } else {
            start = DateFormat.formatToDateStr((long)dataSegment.getTSRange().getStart(), (String)dateFormat);
            end = DateFormat.formatToDateStr((long)dataSegment.getTSRange().getEnd(), (String)dateFormat);
        }
        RexNode startRexLiteral = RealizationPruner.transformValue2RexLiteral(rexBuilder, start, partitionColType);
        RexNode endRexLiteral = RealizationPruner.transformValue2RexLiteral(rexBuilder, end, partitionColType);
        RexNode greaterThanOrEqualCall = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (List)Lists.newArrayList((Object[])new RexNode[]{partitionColInputRef, startRexLiteral}));
        SqlBinaryOperator sqlOperator = isStreaming ? SqlStdOperatorTable.LESS_THAN_OR_EQUAL : SqlStdOperatorTable.LESS_THAN;
        RexNode lessCall = rexBuilder.makeCall((SqlOperator)sqlOperator, (List)Lists.newArrayList((Object[])new RexNode[]{partitionColInputRef, endRexLiteral}));
        return Pair.newPair((Object)greaterThanOrEqualCall, (Object)lessCall);
    }

    private static RexNode transformValue2RexLiteral(RexBuilder rexBuilder, String value, DataType colType) {
        switch (colType.getName()) {
            case "date": {
                return rexBuilder.makeDateLiteral(new DateString(value));
            }
            case "timestamp": {
                RelDataType relDataType = rexBuilder.getTypeFactory().createSqlType(SqlTypeName.TIMESTAMP);
                return rexBuilder.makeTimestampLiteral(new TimestampString(value), relDataType.getPrecision());
            }
            case "varchar": 
            case "string": {
                return rexBuilder.makeLiteral(value);
            }
            case "integer": {
                RelDataType relDataType = rexBuilder.getTypeFactory().createSqlType(SqlTypeName.INTEGER);
                return rexBuilder.makeLiteral((Object)Integer.parseInt(value), relDataType, false);
            }
            case "bigint": {
                RelDataType relDataType = rexBuilder.getTypeFactory().createSqlType(SqlTypeName.BIGINT);
                return rexBuilder.makeLiteral((Object)Long.parseLong(value), relDataType, false);
            }
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "%s data type is not supported for partition column", colType));
    }

    private static RexInputRef transformColumn2RexInputRef(TblColRef partitionCol, Set<OLAPTableScan> tableScans) {
        for (OLAPTableScan tableScan : tableScans) {
            String tableIdentity = tableScan.getTableName();
            if (!tableIdentity.equals(partitionCol.getTable())) continue;
            int index = tableScan.getColumnRowType().getAllColumns().indexOf(partitionCol);
            if (index >= 0) {
                return OLAPContext.createUniqueInputRefAmongTables(tableScan, index, tableScans);
            }
            throw new IllegalStateException(String.format(Locale.ROOT, "Cannot find column %s in all tableScans", partitionCol.getIdentity()));
        }
        throw new IllegalStateException(String.format(Locale.ROOT, "Cannot find column %s in all tableScans", partitionCol.getIdentity()));
    }

    public static Map<String, List<Long>> matchPartitions(List<NDataSegment> dataSegments, NDataModel model, OLAPContext olapContext) {
        MultiPartitionDesc multiPartitionDesc = model.getMultiPartitionDesc();
        List<RexNode> filterConditions = olapContext.getExpandedFilterConditions();
        Set<TblColRef> filterCols = olapContext.filterColumns;
        LinkedList partitionColRefs = multiPartitionDesc.getColumnRefs();
        MultiPartitionKeyMapping mapping = RealizationPruner.getMapping(model.getProject(), model.getId());
        Map<String, List<Long>> segPartitionMap = dataSegments.stream().collect(Collectors.toMap(NDataSegment::getId, NDataSegment::getMultiPartitionIds));
        if (!filterCols.containsAll(partitionColRefs) && !RealizationPruner.containsMappingColumns(mapping, filterCols)) {
            return segPartitionMap;
        }
        RelOptCluster relOptCluster = olapContext.firstTableScan.getCluster();
        RexBuilder rexBuilder = relOptCluster.getRexBuilder();
        RexSimplify rexSimplify = new RexSimplify(relOptCluster.getRexBuilder(), RelOptPredicateList.EMPTY, true, relOptCluster.getPlanner().getExecutor());
        RexNode simplifiedSqlFilter = rexSimplify.simplifyAnds(filterConditions);
        if (simplifiedSqlFilter.isAlwaysFalse()) {
            log.info("SQL filter condition is always false, pruning all partitions");
            return Maps.newHashMap();
        }
        if (simplifiedSqlFilter.isAlwaysTrue()) {
            log.info("SQL filter condition is always true, pruning no partition");
            return segPartitionMap;
        }
        for (MultiPartitionDesc.PartitionInfo partition : multiPartitionDesc.getPartitions()) {
            try {
                RexNode partitionCall = RealizationPruner.transformPartition2RexCall(partitionColRefs, partition.getValues(), rexBuilder, olapContext.allTableScans);
                RexLiteral mappingColumnRexCall = rexBuilder.makeLiteral(true);
                if (mapping != null && CollectionUtils.isNotEmpty((Collection)mapping.getMultiPartitionCols())) {
                    mappingColumnRexCall = RealizationPruner.transformPartitionMapping2RexCall(partition.getValues(), mapping, rexBuilder, olapContext.allTableScans);
                }
                if (RealizationPruner.isAlwaysFalse(simplifiedSqlFilter, partitionCall, (RexNode)mappingColumnRexCall, rexSimplify, rexBuilder)) {
                    segPartitionMap.forEach((dataSegment, partitionIds) -> partitionIds.remove(partition.getId()));
                    continue;
                }
            }
            catch (Exception ex) {
                log.warn("Multi-partition pruning error: ", (Throwable)ex);
            }
            for (Map.Entry<String, List<Long>> entry : segPartitionMap.entrySet()) {
                List<Long> partitionIds2 = entry.getValue();
                if (partitionIds2.contains(partition.getId())) continue;
                NDataflow dataflow = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)model.getProject()).getDataflow(model.getId());
                NDataSegment segment = dataflow.getSegment(entry.getKey());
                log.info("segment {} does not have partition {}", (Object)segment.displayIdName(), (Object)partition.getId());
                return null;
            }
        }
        return segPartitionMap;
    }

    private static boolean isAlwaysFalse(RexNode simplifiedSqlFilter, RexNode partitionNode, RexNode mappingNode, RexSimplify rexSimplify, RexBuilder rexBuilder) {
        RexNode simplifyAnds = rexSimplify.simplifyAnds((Iterable)Lists.newArrayList((Object[])new RexNode[]{simplifiedSqlFilter, partitionNode, mappingNode}));
        RelOptPredicateList predicate = RelOptPredicateList.of((RexBuilder)rexBuilder, (Iterable)Lists.newArrayList((Object[])new RexNode[]{partitionNode, mappingNode}));
        RexNode simplifiedWithPredicate = rexSimplify.withPredicates(predicate).simplify(simplifiedSqlFilter);
        return simplifyAnds.isAlwaysFalse() || simplifiedWithPredicate.isAlwaysFalse();
    }

    private static boolean containsMappingColumns(MultiPartitionKeyMapping mapping, Set<TblColRef> filterColumnRefs) {
        if (mapping == null || CollectionUtils.isEmpty((Collection)mapping.getMultiPartitionCols())) {
            return false;
        }
        Set filterColumnIdentities = filterColumnRefs.stream().map(TblColRef::getCanonicalName).collect(Collectors.toSet());
        Set aliasColumnIdentities = mapping.getAliasColumns().stream().map(TblColRef::getCanonicalName).collect(Collectors.toSet());
        return filterColumnIdentities.containsAll(aliasColumnIdentities);
    }

    private static MultiPartitionKeyMapping getMapping(String project, String model) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        try {
            MultiPartitionKeyMappingProvider provider = (MultiPartitionKeyMappingProvider)ClassUtil.newInstance((String)kylinConfig.getMultiPartitionKeyMappingProvider());
            return provider.getMapping(project, model);
        }
        catch (Exception | NoClassDefFoundError e) {
            log.error("Failed to create multi-partition key mapping provider", e);
            return null;
        }
    }

    private static RexNode transformPartition2RexCall(List<TblColRef> partitionCols, String[] partitionValues, RexBuilder rexBuilder, Set<OLAPTableScan> tableScans) {
        return RealizationPruner.transformColumns2RexCall(partitionCols, Collections.singletonList(Lists.newArrayList((Object[])partitionValues)), rexBuilder, tableScans);
    }

    private static RexNode transformPartitionMapping2RexCall(String[] partitionValues, MultiPartitionKeyMapping mapping, RexBuilder rexBuilder, Set<OLAPTableScan> tableScans) {
        List mappedColumns = mapping.getAliasColumns();
        Collection mappedValues = mapping.getAliasValue((List)Lists.newArrayList((Object[])partitionValues));
        if (CollectionUtils.isEmpty((Collection)mappedColumns) || CollectionUtils.isEmpty((Collection)mappedValues)) {
            return rexBuilder.makeLiteral(true);
        }
        return RealizationPruner.transformColumns2RexCall(mappedColumns, mappedValues, rexBuilder, tableScans);
    }

    private static RexNode transformColumns2RexCall(List<TblColRef> columns, Collection<List<String>> values, RexBuilder rexBuilder, Set<OLAPTableScan> tableScans) {
        ArrayList orRexCalls = Lists.newArrayList();
        for (List<String> columnValue : values) {
            int size = columns.size();
            ArrayList equalRexCalls = Lists.newArrayList();
            for (int i = 0; i < size; ++i) {
                String value = columnValue.get(i);
                TblColRef columnRef = columns.get(i);
                RexInputRef columnRexInputRef = RealizationPruner.transformColumn2RexInputRef(columnRef, tableScans);
                RexNode valueLiteral = RealizationPruner.transformValue2RexLiteral(rexBuilder, value, columnRef.getType());
                RexNode equalRexCall = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, (List)Lists.newArrayList((Object[])new RexNode[]{columnRexInputRef, valueLiteral}));
                equalRexCalls.add(equalRexCall);
            }
            RexNode andRexCall = equalRexCalls.size() == 1 ? (RexNode)equalRexCalls.get(0) : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, (List)equalRexCalls);
            orRexCalls.add(andRexCall);
        }
        return orRexCalls.size() == 1 ? (RexNode)orRexCalls.get(0) : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, (List)orRexCalls);
    }
}

