/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing.rules;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.cube.cuboid.NLayoutCandidate;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.MultiPartitionDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.IRealizationCandidate;
import org.apache.kylin.query.routing.Candidate;
import org.apache.kylin.query.routing.RealizationPruner;
import org.apache.kylin.query.routing.RoutingRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionPruningRule
extends RoutingRule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PartitionPruningRule.class);

    @Override
    public void apply(List<Candidate> candidates) {
        Iterator<Candidate> iterator = candidates.iterator();
        while (iterator.hasNext()) {
            MultiPartitionDesc multiPartitionDesc;
            Candidate candidate = iterator.next();
            NDataModel model = candidate.getRealization().getModel();
            List<NDataSegment> prunedSegments = candidate.getPrunedSegments();
            if (CollectionUtils.isEmpty(prunedSegments) || (multiPartitionDesc = model.getMultiPartitionDesc()) == null || CollectionUtils.isEmpty((Collection)multiPartitionDesc.getColumns())) continue;
            Map<String, List<Long>> matchedPartitions = RealizationPruner.matchPartitions(prunedSegments, model, candidate.getCtx());
            if (matchedPartitions == null) {
                CapabilityResult capability = new CapabilityResult();
                capability.capable = false;
                candidate.setCapability(capability);
                iterator.remove();
                continue;
            }
            NDataflow dataflow = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)model.getProject()).getDataflow(model.getId());
            boolean allPartitionsEmpty = matchedPartitions.entrySet().stream().allMatch(entry -> {
                NDataSegment segment = dataflow.getSegment((String)entry.getKey());
                List partitionIds = (List)entry.getValue();
                return CollectionUtils.isNotEmpty((Collection)segment.getMultiPartitionIds()) && CollectionUtils.isEmpty((Collection)partitionIds);
            });
            if (allPartitionsEmpty) {
                log.info("there is no partition to answer sql");
                CapabilityResult capability = new CapabilityResult();
                capability.capable = true;
                capability.setSelectedCandidate((IRealizationCandidate)NLayoutCandidate.EMPTY);
                candidate.setCapability(capability);
                continue;
            }
            candidate.setPrunedPartitions(matchedPartitions);
        }
    }
}

