/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing.rules;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.IRealizationFilter;
import org.apache.kylin.query.routing.Candidate;
import org.apache.kylin.query.routing.RoutingRule;

public class RemoveBlackoutRealizationsRule
extends RoutingRule {
    private static Set<String> blackList = Sets.newHashSet();
    private static Set<String> whiteList = Sets.newHashSet();
    private static ConcurrentHashMap<KylinConfig, IRealizationFilter> filters = new ConcurrentHashMap();

    public static boolean accept(IRealization real) {
        String canonicalName = real.getCanonicalName();
        if (blackList.contains(canonicalName)) {
            return false;
        }
        if (!whiteList.isEmpty() && !whiteList.contains(canonicalName)) {
            return false;
        }
        String filterClz = real.getConfig().getQueryRealizationFilter();
        return filterClz == null || RemoveBlackoutRealizationsRule.getFilterImpl(real.getConfig()).accept(real);
    }

    private static IRealizationFilter getFilterImpl(KylinConfig conf) {
        IRealizationFilter filter = filters.get(conf);
        if (filter == null) {
            try {
                Class clz = ClassUtil.forName((String)conf.getQueryRealizationFilter(), IRealizationFilter.class);
                filter = (IRealizationFilter)clz.getConstructor(KylinConfig.class).newInstance(conf);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            filters.put(conf, filter);
        }
        return filter;
    }

    @Override
    public void apply(List<Candidate> candidates) {
        candidates.removeIf(candidate -> !RemoveBlackoutRealizationsRule.accept(candidate.getRealization()));
    }
}

