/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing.rules;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.query.routing.Candidate;
import org.apache.kylin.query.routing.RoutingRule;
import org.apache.kylin.query.util.ComputedColumnRewriter;
import org.apache.kylin.query.util.QueryAliasMatchInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveUncapableRealizationsRule
extends RoutingRule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RemoveUncapableRealizationsRule.class);

    @Override
    public void apply(List<Candidate> candidates) {
        Iterator<Candidate> iterator = candidates.iterator();
        while (iterator.hasNext()) {
            Candidate candidate = iterator.next();
            if (candidate.getCapability() != null) continue;
            candidate.getCtx().resetSQLDigest();
            CapabilityResult capability = candidate.getRealization().isCapable(candidate.getCtx().getSQLDigest(), candidate.getPrunedSegments(), candidate.getPrunedStreamingSegments(), candidate.getSecondStorageSegmentLayoutMap());
            if (!capability.capable && !candidate.getRealization().getModel().getComputedColumnDescs().isEmpty()) {
                HashBiMap aliasMapping = HashBiMap.create();
                aliasMapping.putAll(candidate.getAliasMap());
                ComputedColumnRewriter.rewriteCcInnerCol(candidate.getCtx(), candidate.getRealization().getModel(), new QueryAliasMatchInfo((BiMap<String, String>)aliasMapping, null));
                candidate.getCtx().resetSQLDigest();
                capability = candidate.getRealization().isCapable(candidate.getCtx().getSQLDigest(), candidate.getPrunedSegments(), candidate.getPrunedStreamingSegments(), candidate.getSecondStorageSegmentLayoutMap());
            }
            candidate.setCapability(capability);
            if (capability.capable) continue;
            iterator.remove();
        }
    }
}

