/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing.rules;

import io.kyligence.kap.guava20.shaded.common.collect.Maps;
import io.kyligence.kap.secondstorage.SecondStorageUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.metadata.cube.cuboid.NLayoutCandidate;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.IRealizationCandidate;
import org.apache.kylin.query.routing.Candidate;
import org.apache.kylin.query.routing.RealizationPruner;
import org.apache.kylin.query.routing.RoutingRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentPruningRule
extends RoutingRule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SegmentPruningRule.class);

    @Override
    public void apply(List<Candidate> candidates) {
        for (Candidate candidate : candidates) {
            List realizations = candidate.getRealization().getRealizations();
            for (IRealization realization : realizations) {
                NDataflow df = (NDataflow)realization;
                List<NDataSegment> prunedSegments = RealizationPruner.pruneSegments(df, candidate.getCtx());
                HashMap secondStorageSegmentLayoutMap = Maps.newHashMap();
                if (SecondStorageUtil.isModelEnable((String)df.getProject(), (String)df.getId())) {
                    for (NDataSegment segment : prunedSegments) {
                        Set chEnableLayoutIds = SecondStorageUtil.listEnableLayoutBySegment((String)df.getProject(), (String)df.getId(), (String)segment.getId());
                        if (!CollectionUtils.isNotEmpty((Collection)chEnableLayoutIds)) continue;
                        secondStorageSegmentLayoutMap.put(segment.getId(), chEnableLayoutIds);
                    }
                }
                candidate.setSecondStorageSegmentLayoutMap(secondStorageSegmentLayoutMap);
                candidate.setPrunedSegments(prunedSegments, df.isStreaming());
            }
            if (!CollectionUtils.isEmpty(candidate.getPrunedSegments()) || !CollectionUtils.isEmpty(candidate.getPrunedStreamingSegments())) continue;
            log.info("there is no segment to answer sql");
            CapabilityResult capability = new CapabilityResult();
            capability.capable = true;
            capability.setSelectedCandidate((IRealizationCandidate)NLayoutCandidate.EMPTY);
            capability.setSelectedStreamingCandidate((IRealizationCandidate)NLayoutCandidate.EMPTY);
            candidate.setCapability(capability);
        }
    }
}

