/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.schema;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.schema.Table;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.query.schema.KapOLAPTable;
import org.apache.kylin.query.schema.OLAPSchema;

public class KapOLAPSchema
extends OLAPSchema {
    private String schemaName;
    private List<TableDesc> tables;
    private Map<String, List<NDataModel>> modelsMap;

    public KapOLAPSchema(String project, String schemaName, List<TableDesc> tables, Map<String, List<NDataModel>> modelsMap) {
        super(project, schemaName, tables);
        this.schemaName = schemaName;
        this.tables = tables;
        this.modelsMap = modelsMap;
    }

    @Override
    public Map<String, Table> getTableMap() {
        return this.createTableMap();
    }

    public boolean hasTables() {
        return this.tables != null && !this.tables.isEmpty();
    }

    private Map<String, Table> createTableMap() {
        HashMap<String, Table> olapTables = new HashMap<String, Table>();
        for (TableDesc tableDesc : this.tables) {
            String tableName = tableDesc.getName();
            KapOLAPTable table = new KapOLAPTable(this, tableDesc, this.modelsMap);
            olapTables.put(tableName, (Table)table);
        }
        return olapTables;
    }
}

