/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.schema;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.query.schema.OLAPTable;

@Deprecated
public class OLAPSchema
extends AbstractSchema {
    private KylinConfig config;
    private String projectName;
    private String schemaName;
    private List<TableDesc> tables;
    private Map<String, List<NDataModel>> modelsMap;
    private String starSchemaUrl;
    private String starSchemaUser;
    private String starSchemaPassword;

    public OLAPSchema(String project, String schemaName, List<TableDesc> tables) {
        this.projectName = project;
        this.schemaName = schemaName;
        this.tables = tables;
        this.init();
    }

    private void init() {
        this.config = KylinConfig.getInstanceFromEnv();
        this.starSchemaUrl = this.config.getHiveUrl();
        this.starSchemaUser = this.config.getHiveUser();
        this.starSchemaPassword = this.config.getHivePassword();
    }

    public Map<String, Table> getTableMap() {
        return this.buildTableMap();
    }

    private Map<String, Table> buildTableMap() {
        HashMap<String, Table> olapTables = new HashMap<String, Table>();
        for (TableDesc tableDesc : this.tables) {
            if (!tableDesc.getDatabase().equals(this.schemaName)) continue;
            String tableName = tableDesc.getName();
            OLAPTable table = new OLAPTable(this, tableDesc, this.modelsMap);
            olapTables.put(tableName, (Table)table);
        }
        return olapTables;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public boolean hasStarSchemaUrl() {
        return this.starSchemaUrl != null && !this.starSchemaUrl.isEmpty();
    }

    public String getStarSchemaUrl() {
        return this.starSchemaUrl;
    }

    public String getStarSchemaUser() {
        return this.starSchemaUser;
    }

    public String getStarSchemaPassword() {
        return this.starSchemaPassword;
    }

    public NDataModelManager getMetadataManager() {
        return NDataModelManager.getInstance((KylinConfig)this.config, (String)this.projectName);
    }

    public KylinConfig getConfig() {
        return this.config;
    }

    @VisibleForTesting
    public void setConfigOnlyInTest(KylinConfig config) {
        this.config = config;
    }

    public String getProjectName() {
        return this.projectName;
    }
}

