/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.security;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.acl.AclTCRManager;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.tool.CalciteParser;
import org.apache.kylin.query.IQueryTransformer;
import org.apache.kylin.query.exception.NoAuthorizedColsError;
import org.apache.kylin.query.security.RowFilter;
import org.apache.kylin.source.adhocquery.IPushDownConverter;

public class HackSelectStarWithColumnACL
implements IQueryTransformer,
IPushDownConverter {
    private static final String SELECT_STAR = "*";

    static String getNewSelectClause(SqlNode sqlNode, String project, String defaultSchema, QueryContext.AclInfo aclInfo) {
        StringBuilder newSelectClause = new StringBuilder();
        List<String> allCols = HackSelectStarWithColumnACL.getColsCanAccess(sqlNode, project, defaultSchema, aclInfo);
        if (CollectionUtils.isEmpty(allCols)) {
            throw new NoAuthorizedColsError();
        }
        for (String col : allCols) {
            if (!col.equals(allCols.get(allCols.size() - 1))) {
                newSelectClause.append(col).append(", ");
                continue;
            }
            newSelectClause.append(col);
        }
        return newSelectClause.toString();
    }

    static List<String> getColsCanAccess(SqlNode sqlNode, String project, String defaultSchema, QueryContext.AclInfo aclInfo) {
        ArrayList<String> cols = new ArrayList<String>();
        String user = Objects.nonNull(aclInfo) ? aclInfo.getUsername() : null;
        Set groups = Objects.nonNull(aclInfo) ? aclInfo.getGroups() : null;
        List aclTCRs = AclTCRManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).getAclTCRs(user, groups);
        List<RowFilter.Table> tblWithAlias = RowFilter.getTblWithAlias(defaultSchema, HackSelectStarWithColumnACL.getSingleSelect(sqlNode));
        for (RowFilter.Table table : tblWithAlias) {
            TableDesc tableDesc = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).getTableDesc(table.getName());
            if (Objects.isNull(tableDesc)) {
                throw new IllegalStateException("Table " + table.getAlias() + " not found. Please add table " + table.getAlias() + " to data source. If this table does exist, mention it as DATABASE.TABLE.");
            }
            ArrayList columns = Lists.newArrayList((Object[])tableDesc.getColumns());
            Collections.sort(columns, Comparator.comparing(ColumnDesc::getZeroBasedIndex));
            String quotingChar = Quoting.valueOf((String)KylinConfig.getInstanceFromEnv().getCalciteQuoting()).string;
            for (ColumnDesc column : columns) {
                if (!aclTCRs.stream().anyMatch(aclTCR -> aclTCR.isAuthorized(tableDesc.getIdentity(), column.getName()))) continue;
                StringBuilder sb = new StringBuilder();
                sb.append(quotingChar).append(table.getAlias()).append(quotingChar).append('.').append(quotingChar).append(column.getName()).append(quotingChar);
                cols.add(sb.toString());
            }
        }
        return cols;
    }

    private static boolean isSingleSelectStar(SqlNode sqlNode) {
        if (SelectNumVisitor.getSelectNum(sqlNode) != 1 || sqlNode instanceof SqlExplain) {
            return false;
        }
        SqlSelect singleSelect = HackSelectStarWithColumnACL.getSingleSelect(sqlNode);
        return singleSelect.getSelectList().toString().equals(SELECT_STAR);
    }

    private static int getSelectStarPos(String sql, SqlNode sqlNode) {
        SqlSelect singleSelect = HackSelectStarWithColumnACL.getSingleSelect(sqlNode);
        Pair replacePos = CalciteParser.getReplacePos((SqlNode)singleSelect.getSelectList(), (String)sql);
        Preconditions.checkState(((Integer)replacePos.getSecond() - (Integer)replacePos.getFirst() == 1 ? 1 : 0) != 0);
        return (Integer)replacePos.getFirst();
    }

    private static SqlSelect getSingleSelect(SqlNode sqlNode) {
        if (sqlNode instanceof SqlOrderBy) {
            SqlOrderBy orderBy = (SqlOrderBy)sqlNode;
            return (SqlSelect)orderBy.query;
        }
        return (SqlSelect)sqlNode;
    }

    private static boolean hasAdminPermission(QueryContext.AclInfo aclInfo) {
        if (Objects.isNull(aclInfo) || Objects.isNull(aclInfo.getGroups())) {
            return false;
        }
        return aclInfo.getGroups().stream().anyMatch("ROLE_ADMIN"::equals) || aclInfo.isHasAdminPermission();
    }

    public String convert(String originSql, String project, String defaultSchema) {
        return this.transform(originSql, project, defaultSchema);
    }

    @Override
    public String transform(String sql, String project, String defaultSchema) {
        SqlNode sqlNode;
        QueryContext.AclInfo aclLocal = QueryContext.current().getAclInfo();
        if (!KylinConfig.getInstanceFromEnv().isAclTCREnabled() || HackSelectStarWithColumnACL.hasAdminPermission(aclLocal)) {
            return sql;
        }
        try {
            sqlNode = CalciteParser.parse((String)sql, (String)project);
        }
        catch (SqlParseException e) {
            throw new KylinRuntimeException("Failed to parse SQL '" + sql + "', please make sure the SQL is valid");
        }
        if (!HackSelectStarWithColumnACL.isSingleSelectStar(sqlNode)) {
            return sql;
        }
        String newSelectClause = HackSelectStarWithColumnACL.getNewSelectClause(sqlNode, project, defaultSchema, aclLocal);
        int selectStarPos = HackSelectStarWithColumnACL.getSelectStarPos(sql, sqlNode);
        StringBuilder result = new StringBuilder(sql);
        result.replace(selectStarPos, selectStarPos + 1, newSelectClause);
        return result.toString();
    }

    static class SelectNumVisitor
    extends SqlBasicVisitor<SqlNode> {
        int selectNum = 0;

        SelectNumVisitor() {
        }

        static int getSelectNum(SqlNode sqlNode) {
            SelectNumVisitor snv = new SelectNumVisitor();
            sqlNode.accept((SqlVisitor)snv);
            return snv.getNum();
        }

        public SqlNode visit(SqlCall call) {
            if (call instanceof SqlSelect) {
                ++this.selectNum;
            }
            if (call instanceof SqlOrderBy) {
                SqlOrderBy sqlOrderBy = (SqlOrderBy)call;
                sqlOrderBy.query.accept((SqlVisitor)this);
            } else {
                for (SqlNode operand : call.getOperandList()) {
                    if (operand == null) continue;
                    operand.accept((SqlVisitor)this);
                }
            }
            return null;
        }

        private int getNum() {
            return this.selectNum;
        }
    }
}

