/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.Collection;
import java.util.List;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlWith;
import org.apache.calcite.sql.SqlWithItem;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.commons.collections.CollectionUtils;

public abstract class AbstractSqlVisitor
extends SqlBasicVisitor<SqlNode> {
    public String originSql;

    protected AbstractSqlVisitor(String originSql) {
        this.originSql = originSql;
    }

    public static boolean isUnion(SqlCall call) {
        return call instanceof SqlBasicCall && call.getOperator().getKind() == SqlKind.UNION;
    }

    public static boolean isAs(SqlNode call) {
        return call instanceof SqlBasicCall && ((SqlBasicCall)call).getOperator().isName("AS");
    }

    public static boolean isSqlBasicCall(SqlNode call) {
        return call instanceof SqlBasicCall && ((SqlBasicCall)call).getOperands().length != 0;
    }

    public SqlNode visit(SqlCall call) {
        if (AbstractSqlVisitor.isUnion(call)) {
            SqlNode[] operands;
            for (SqlNode operand : operands = ((SqlBasicCall)call).getOperands()) {
                operand.accept((SqlVisitor)this);
            }
        }
        if (call instanceof SqlOrderBy) {
            this.visitInSqlOrderBy((SqlOrderBy)call);
        }
        if (call instanceof SqlSelect) {
            SqlSelect sqlSelect = (SqlSelect)call;
            this.visitInSqlSelect(sqlSelect);
        }
        if (call instanceof SqlWith) {
            this.sqlWithFound((SqlWith)call);
        }
        if (call instanceof SqlJoin) {
            this.visitInSqlJoin((SqlJoin)call);
        }
        return null;
    }

    private void visitInSqlOrderBy(SqlOrderBy orderBy) {
        SqlNodeList orderList = orderBy.orderList;
        this.visitInSqlNodeList(orderList);
        SqlNode limit = orderBy.fetch;
        this.visitInSqlNode(limit);
        SqlNode offset = orderBy.offset;
        this.visitInSqlNode(offset);
        SqlNode query = orderBy.query;
        query.accept((SqlVisitor)this);
    }

    private void visitInSqlSelect(SqlSelect sqlSelect) {
        this.visitInSelectList(sqlSelect);
        SqlNode from = sqlSelect.getFrom();
        if (from != null) {
            this.visitInSqlFrom(from);
        }
        this.visitInSqlWhere(sqlSelect.getWhere());
        this.visitInSqlNodeList(sqlSelect.getGroup());
        this.visitInSqlNode(sqlSelect.getHaving());
        this.visitInSqlNodeList(sqlSelect.getWindowList());
        SqlNode limit = sqlSelect.getFetch();
        this.visitInSqlNode(limit);
        this.visitInSqlNode(sqlSelect.getOffset());
    }

    protected void visitInSqlWhere(SqlNode where) {
        this.visitInSqlNode(where);
    }

    private void visitInSelectList(SqlSelect sqlSelect) {
        SqlNodeList selectNodeList = sqlSelect.getSelectList();
        List selectList = selectNodeList.getList();
        for (SqlNode selectItem : selectList) {
            if (selectItem instanceof SqlWith) {
                this.sqlWithFound((SqlWith)selectItem);
                continue;
            }
            if (selectItem instanceof SqlOrderBy) {
                selectItem.accept((SqlVisitor)this);
                continue;
            }
            if (selectItem instanceof SqlSelect) {
                selectItem.accept((SqlVisitor)this);
                continue;
            }
            if (AbstractSqlVisitor.isAs(selectItem)) {
                this.visitInAsNode((SqlBasicCall)selectItem);
                continue;
            }
            if (AbstractSqlVisitor.isSqlBasicCall(selectItem)) {
                this.visitInSqlBasicCall((SqlBasicCall)selectItem);
                continue;
            }
            this.visitInSqlNode(selectItem);
        }
    }

    protected void visitInSqlFrom(SqlNode from) {
        if (from instanceof SqlWith) {
            this.sqlWithFound((SqlWith)from);
        } else if (AbstractSqlVisitor.isAs(from)) {
            this.visitInAsNode((SqlBasicCall)from);
        } else if (from instanceof SqlJoin) {
            SqlJoin join = (SqlJoin)from;
            this.visitInSqlJoin(join);
        } else {
            from.accept((SqlVisitor)this);
        }
    }

    protected void visitInSqlJoin(SqlJoin join) {
        this.visitInSqlNode(join.getLeft());
        this.visitInSqlNode(join.getRight());
        this.visitInSqlNode(join.getCondition());
    }

    protected void visitInAsNode(SqlBasicCall from) {
        SqlNode left = from.getOperands()[0];
        this.visitInSqlNode(left);
    }

    protected void visitInSqlNode(SqlNode node) {
        if (node == null) {
            return;
        }
        if (node instanceof SqlWith) {
            this.sqlWithFound((SqlWith)node);
        } else if (node instanceof SqlDynamicParam) {
            this.questionMarkFound((SqlDynamicParam)node);
        } else if (node instanceof SqlNodeList) {
            this.visitInSqlNodeList((SqlNodeList)node);
        } else if (node instanceof SqlCase) {
            this.visitInSqlCase((SqlCase)node);
        } else if (AbstractSqlVisitor.isSqlBasicCall(node)) {
            this.visitInSqlBasicCall((SqlBasicCall)node);
        } else {
            node.accept((SqlVisitor)this);
        }
    }

    protected void visitInSqlBasicCall(SqlBasicCall call) {
        SqlNode[] operands;
        for (SqlNode ope : operands = call.getOperands()) {
            this.visitInSqlNode(ope);
        }
    }

    protected void visitInSqlNodeList(SqlNodeList sqlNodeList) {
        if (sqlNodeList == null) {
            return;
        }
        List nodeList = sqlNodeList.getList();
        for (SqlNode node : nodeList) {
            this.visitInSqlNode(node);
        }
    }

    protected void visitInSqlCase(SqlCase sqlCase) {
        if (sqlCase == null) {
            return;
        }
        List sqlNodes = sqlCase.getOperandList();
        if (CollectionUtils.isEmpty((Collection)sqlNodes)) {
            return;
        }
        for (SqlNode sqlNode : sqlNodes) {
            this.visitInSqlNode(sqlNode);
        }
    }

    protected void questionMarkFound(SqlDynamicParam questionMark) {
    }

    protected void sqlWithFound(SqlWith sqlWith) {
        this.visitInSqlWithList(sqlWith.withList);
        SqlNode sqlWithQuery = sqlWith.body;
        sqlWithQuery.accept((SqlVisitor)this);
    }

    protected void visitInSqlWithList(SqlNodeList withList) {
        List list = withList.getList();
        for (SqlNode node : list) {
            SqlWithItem withItem = (SqlWithItem)node;
            SqlNode query = withItem.query;
            this.visitInSqlNode(query);
        }
    }
}

