/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.metadata.querymeta.SelectedColumnMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncQueryUtil {
    public static final String ASYNC_QUERY_JOB_ID_PRE = "ASYNC-QUERY-";
    private static final Logger logger = LoggerFactory.getLogger(AsyncQueryUtil.class);

    private AsyncQueryUtil() {
    }

    public static FileSystem getFileSystem() {
        return HadoopUtil.getWorkingFileSystem();
    }

    public static void saveMetaDataAndFileInfo(QueryContext queryContext, List<SelectedColumnMeta> columnMetas) {
        try {
            AsyncQueryUtil.saveMetaData(queryContext.getProject(), columnMetas, queryContext.getQueryId());
            AsyncQueryUtil.saveFileInfo(queryContext.getProject(), queryContext.getQueryTagInfo().getFileFormat(), queryContext.getQueryTagInfo().getFileEncode(), queryContext.getQueryTagInfo().getFileName(), queryContext.getQueryId(), queryContext.getQueryTagInfo().getSeparator());
        }
        catch (IOException e) {
            logger.error("save async query column metadata or file info failed.", (Throwable)e);
        }
    }

    public static void saveMetaData(String project, List<SelectedColumnMeta> columnMetas, String queryId) throws IOException {
        block26: {
            Path asyncQueryResultDir;
            ArrayList dataTypes = Lists.newArrayList();
            ArrayList columnNames = Lists.newArrayList();
            for (SelectedColumnMeta selectedColumnMeta : columnMetas) {
                dataTypes.add(selectedColumnMeta.getColumnTypeName());
                columnNames.add(selectedColumnMeta.getName());
            }
            FileSystem fileSystem = AsyncQueryUtil.getFileSystem();
            if (fileSystem.exists(asyncQueryResultDir = AsyncQueryUtil.getAsyncQueryResultDir(project, queryId))) {
                try (FSDataOutputStream os = AsyncQueryUtil.getFileSystem().create(new Path(asyncQueryResultDir, AsyncQueryUtil.getMetaDataFileName()));
                     OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, Charset.defaultCharset());){
                    String metaString = StringUtils.join((Collection)columnNames, (String)",") + "\n" + StringUtils.join((Collection)dataTypes, (String)",");
                    osw.write(metaString);
                    break block26;
                }
            }
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.ASYNC_QUERY_RESULT_NOT_FOUND, new Object[0]);
        }
    }

    public static void saveFileInfo(String project, String format, String encode, String fileName, String queryId, String separator) throws IOException {
        block25: {
            Path asyncQueryResultDir;
            FileSystem fileSystem = AsyncQueryUtil.getFileSystem();
            if (fileSystem.exists(asyncQueryResultDir = AsyncQueryUtil.getAsyncQueryResultDir(project, queryId))) {
                try (FSDataOutputStream os = AsyncQueryUtil.getFileSystem().create(new Path(asyncQueryResultDir, AsyncQueryUtil.getFileInfo()));
                     OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, Charset.defaultCharset());){
                    osw.write(format + "\n");
                    osw.write(encode + "\n");
                    osw.write(fileName + "\n");
                    osw.write(separator);
                    break block25;
                }
            }
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.ASYNC_QUERY_RESULT_NOT_FOUND, new Object[0]);
        }
    }

    public static void createErrorFlag(String project, String queryId, String errorMessage) throws IOException {
        Path asyncQueryResultDir;
        FileSystem fileSystem = AsyncQueryUtil.getFileSystem();
        if (!fileSystem.exists(asyncQueryResultDir = AsyncQueryUtil.getAsyncQueryResultDir(project, queryId))) {
            fileSystem.mkdirs(asyncQueryResultDir);
        }
        try (FSDataOutputStream os = fileSystem.create(new Path(asyncQueryResultDir, AsyncQueryUtil.getFailureFlagFileName()));
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, Charset.defaultCharset());){
            if (errorMessage != null) {
                osw.write(errorMessage);
                os.hflush();
            }
        }
    }

    public static void createSuccessFlag(String project, String queryId) throws IOException {
        FileSystem fileSystem = AsyncQueryUtil.getFileSystem();
        Path asyncQueryResultDir = AsyncQueryUtil.getAsyncQueryResultDir(project, queryId);
        try (FSDataOutputStream os = fileSystem.create(new Path(asyncQueryResultDir, AsyncQueryUtil.getSuccessFlagFileName()));){
            os.hflush();
        }
    }

    public static Path getAsyncQueryResultDir(String project, String queryId) {
        return new Path(KapConfig.getInstanceFromEnv().getAsyncResultBaseDir(project), queryId);
    }

    public static String getSuccessFlagFileName() {
        return "_SUCCESS";
    }

    public static String getFailureFlagFileName() {
        return "_FAILED";
    }

    public static String getMetaDataFileName() {
        return "_METADATA";
    }

    public static String getUserFileName() {
        return "_USER";
    }

    public static String getFileInfo() {
        return "_FILEINFO";
    }
}

