/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.sql.SqlNode;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.CollectionUtil;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.model.alias.AliasDeduce;
import org.apache.kylin.metadata.model.alias.AliasMapping;
import org.apache.kylin.metadata.model.alias.ExpressionComparator;
import org.apache.kylin.metadata.model.tool.CalciteParser;
import org.apache.kylin.metadata.model.util.ComputedColumnUtil;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.query.relnode.KapAggregateRel;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.TableColRefWithRel;
import org.apache.kylin.query.util.AliasDeduceImpl;
import org.apache.kylin.query.util.QueryAliasMatchInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputedColumnRewriter {
    private static final Logger logger = LoggerFactory.getLogger(ComputedColumnRewriter.class);

    private ComputedColumnRewriter() {
    }

    public static void rewriteCcInnerCol(OLAPContext context, NDataModel model, QueryAliasMatchInfo matchInfo) {
        KylinConfig projectConfig = NProjectManager.getProjectConfig((String)model.getProject());
        ComputedColumnRewriter.rewriteAggInnerCol(projectConfig, context, model, matchInfo);
        ComputedColumnRewriter.rewriteTopNInnerCol(projectConfig, context, model, matchInfo);
        ComputedColumnRewriter.rewriteGroupByInnerCol(projectConfig, context, model, matchInfo);
    }

    private static void rewriteAggInnerCol(KylinConfig kylinConfig, OLAPContext context, NDataModel model, QueryAliasMatchInfo matchInfo) {
        if (!KapConfig.getInstanceFromEnv().isAggComputedColumnRewriteEnabled() || CollectionUtils.isEmpty((Collection)model.getComputedColumnDescs())) {
            return;
        }
        context.aggregations.stream().filter(agg -> CollectionUtils.isNotEmpty((Collection)agg.getParameters())).forEach(agg -> {
            ArrayList parameters = Lists.newArrayList();
            for (ParameterDesc parameter : agg.getParameters()) {
                if (!parameter.getColRef().isInnerColumn()) {
                    parameters.add(parameter);
                    continue;
                }
                TblColRef translatedInnerCol = ComputedColumnRewriter.rewriteInnerColumnToTblColRef(kylinConfig, parameter.getColRef().getParserDescription(), model, matchInfo);
                if (translatedInnerCol == null) continue;
                parameters.add(ParameterDesc.newInstance((Object)translatedInnerCol));
                context.allColumns.add(translatedInnerCol);
            }
            if (!parameters.isEmpty()) {
                agg.setParameters((List)parameters);
            }
        });
    }

    private static TblColRef rewriteInnerColumnToTblColRef(KylinConfig kylinConfig, String innerExpression, NDataModel model, QueryAliasMatchInfo matchInfo) {
        SqlNode innerColExpr;
        try {
            innerColExpr = CalciteParser.getExpNode((String)innerExpression);
        }
        catch (IllegalStateException e) {
            logger.warn("Failed to resolve CC expr for {}", (Object)innerExpression, (Object)e);
            return null;
        }
        for (ComputedColumnDesc cc : model.getComputedColumnDescs()) {
            SqlNode ccExpressionNode;
            if (kylinConfig.isTableExclusionEnabled() && kylinConfig.onlyReuseUserDefinedCC() && cc.isAutoCC() || !ExpressionComparator.isNodeEqual((SqlNode)innerColExpr, (SqlNode)(ccExpressionNode = CalciteParser.getExpNode((String)cc.getExpression())), (AliasMapping)matchInfo, (AliasDeduce)new AliasDeduceImpl(matchInfo))) continue;
            ColumnDesc[] ccCols = ComputedColumnUtil.createComputedColumns((List)Lists.newArrayList((Object[])new ComputedColumnDesc[]{cc}), (TableDesc)model.getRootFactTable().getTableDesc());
            logger.info("Replacing CC expr [{},{}]", (Object)cc.getColumnName(), (Object)cc.getExpression());
            return new TblColRef(model.getRootFactTable(), ccCols[0]);
        }
        return null;
    }

    private static void rewriteTopNInnerCol(KylinConfig kylinConfig, OLAPContext context, NDataModel model, QueryAliasMatchInfo matchInfo) {
        if (CollectionUtils.isEmpty((Collection)model.getComputedColumnDescs())) {
            return;
        }
        context.getSortColumns().stream().filter(TblColRef::isInnerColumn).forEach(column -> {
            if (CollectionUtils.isEmpty((Collection)column.getOperands())) {
                return;
            }
            ArrayList translatedOperands = Lists.newArrayList();
            for (TblColRef tblColRef : column.getOperands()) {
                TblColRef translatedInnerCol;
                String innerExpression = tblColRef.getParserDescription();
                if (innerExpression == null || (translatedInnerCol = ComputedColumnRewriter.rewriteInnerColumnToTblColRef(kylinConfig, innerExpression, model, matchInfo)) == null) continue;
                translatedOperands.add(translatedInnerCol);
            }
            column.setOperands((List)translatedOperands);
        });
    }

    private static void rewriteGroupByInnerCol(KylinConfig kylinConfig, OLAPContext ctx, NDataModel model, QueryAliasMatchInfo matchInfo) {
        if (CollectionUtils.isEmpty((Collection)model.getComputedColumnDescs())) {
            return;
        }
        HashMap relColReplacementMapping = new HashMap();
        for (TableColRefWithRel tableColRefWithRel : ctx.getInnerGroupByColumns()) {
            SqlNode innerColExpr;
            try {
                innerColExpr = CalciteParser.getExpNode((String)tableColRefWithRel.getTblColRef().getParserDescription());
            }
            catch (IllegalStateException e) {
                logger.warn("Failed to resolve CC expr for {}", (Object)tableColRefWithRel.getTblColRef().getParserDescription(), (Object)e);
                continue;
            }
            for (ComputedColumnDesc cc : model.getComputedColumnDescs()) {
                SqlNode ccExpressionNode;
                if (kylinConfig.isTableExclusionEnabled() && kylinConfig.onlyReuseUserDefinedCC() && cc.isAutoCC() || !ExpressionComparator.isNodeEqual((SqlNode)innerColExpr, (SqlNode)(ccExpressionNode = CalciteParser.getExpNode((String)cc.getExpression())), (AliasMapping)matchInfo, (AliasDeduce)new AliasDeduceImpl(matchInfo))) continue;
                ColumnDesc[] ccCols = ComputedColumnUtil.createComputedColumns((List)Lists.newArrayList((Object[])new ComputedColumnDesc[]{cc}), (TableDesc)model.getRootFactTable().getTableDesc());
                CollectionUtil.find(ctx.firstTableScan.getColumnRowType().getAllColumns(), colRef -> colRef.getColumnDesc().equals((Object)ccCols[0])).ifPresent(ccColRef -> {
                    relColReplacementMapping.putIfAbsent(tableColRefWIthRel.getRelNodeAs(KapAggregateRel.class), new HashMap());
                    ((Map)relColReplacementMapping.get(tableColRefWIthRel.getRelNodeAs(KapAggregateRel.class))).put(tableColRefWIthRel.getTblColRef(), ccColRef);
                    logger.info("Replacing CC expr [{},{}] in group key {}", new Object[]{cc.getColumnName(), cc.getExpression(), tableColRefWIthRel.getTblColRef()});
                });
            }
        }
        for (Map.Entry entry : relColReplacementMapping.entrySet()) {
            KapAggregateRel aggRel = (KapAggregateRel)entry.getKey();
            Map colReplacementMapping = (Map)entry.getValue();
            aggRel.reBuildGroups(colReplacementMapping);
        }
    }
}

