/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import io.kyligence.kap.guava20.shaded.common.cache.CacheBuilder;
import io.kyligence.kap.guava20.shaded.common.cache.CacheLoader;
import io.kyligence.kap.guava20.shaded.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlAsOperator;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.util.Litmus;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.ThreadUtil;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.alias.AliasDeduce;
import org.apache.kylin.metadata.model.alias.AliasMapping;
import org.apache.kylin.metadata.model.alias.ExpressionComparator;
import org.apache.kylin.metadata.model.tool.CalciteParser;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.query.IQueryTransformer;
import org.apache.kylin.query.util.AliasDeduceImpl;
import org.apache.kylin.query.util.EscapeTransformer;
import org.apache.kylin.query.util.ModelViewSqlNodeComparator;
import org.apache.kylin.query.util.QueryAliasMatchInfo;
import org.apache.kylin.query.util.QueryAliasMatcher;
import org.apache.kylin.query.util.QueryUtil;
import org.apache.kylin.query.util.SqlSubqueryFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertToComputedColumn
implements IQueryTransformer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConvertToComputedColumn.class);
    private static final String CONVERT_TO_CC_ERROR_MSG = "Something unexpected while ConvertToComputedColumn transforming the query, return original query.";
    private static final String DOUBLE_QUOTE = Quoting.DOUBLE_QUOTE.string;
    private static final LoadingCache<String, String> transformExpressions = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, String>(){

        public String load(String cc) {
            return new EscapeTransformer().transform(cc, null, null);
        }
    });

    static Pair<String, Integer> replaceComputedColumn(String inputSql, SqlCall selectOrOrderby, List<ComputedColumnDesc> computedColumns, QueryAliasMatchInfo queryAliasMatchInfo) {
        return new ConvertToComputedColumn().replaceComputedColumn(inputSql, selectOrOrderby, computedColumns, queryAliasMatchInfo, false);
    }

    private static String transformExpr(String expression) {
        return (String)transformExpressions.get((Object)expression);
    }

    private static List<SqlNode> collectInputNodes(SqlSelect select) {
        LinkedList<SqlNode> inputNodes = new LinkedList<SqlNode>();
        inputNodes.addAll(ConvertToComputedColumn.collectCandidateInputNodes(select.getSelectList(), select.getGroup()));
        inputNodes.addAll(ConvertToComputedColumn.collectCandidateInputNodes(select.getOrderList(), select.getGroup()));
        inputNodes.addAll(ConvertToComputedColumn.collectCandidateInputNode(select.getHaving(), select.getGroup()));
        inputNodes.addAll(ConvertToComputedColumn.getInputTreeNodes(select.getWhere()));
        inputNodes.addAll(ConvertToComputedColumn.getInputTreeNodes((SqlNode)select.getGroup()));
        return inputNodes;
    }

    private static List<SqlNode> collectInputNodes(SqlOrderBy sqlOrderBy) {
        LinkedList<SqlNode> inputNodes = new LinkedList<SqlNode>();
        if (sqlOrderBy.orderList != null && sqlOrderBy.query instanceof SqlSelect && ((SqlSelect)sqlOrderBy.query).getGroup() != null) {
            inputNodes.addAll(ConvertToComputedColumn.collectCandidateInputNodes(sqlOrderBy.orderList, ((SqlSelect)sqlOrderBy.query).getGroup()));
        } else if (sqlOrderBy.orderList != null) {
            inputNodes.addAll(ConvertToComputedColumn.getInputTreeNodes((SqlNode)sqlOrderBy.orderList));
        }
        return inputNodes;
    }

    private static List<SqlNode> collectCandidateInputNodes(SqlNodeList sqlNodeList, SqlNodeList groupSet) {
        LinkedList<SqlNode> inputNodes = new LinkedList<SqlNode>();
        if (sqlNodeList == null) {
            return inputNodes;
        }
        for (SqlNode sqlNode : sqlNodeList) {
            inputNodes.addAll(ConvertToComputedColumn.collectCandidateInputNode(sqlNode, groupSet));
        }
        return inputNodes;
    }

    private static List<SqlNode> collectCandidateInputNode(SqlNode node, SqlNodeList groupSet) {
        LinkedList<SqlNode> inputNodes = new LinkedList<SqlNode>();
        if (node == null) {
            return inputNodes;
        }
        if (node instanceof SqlCall && ((SqlCall)node).getOperator().kind == SqlKind.AS) {
            node = (SqlNode)((SqlCall)node).getOperandList().get(0);
        }
        for (SqlNode sqlNode : ConvertToComputedColumn.getSelectNodesToReplace(node, groupSet)) {
            inputNodes.addAll(ConvertToComputedColumn.getInputTreeNodes(sqlNode));
        }
        return inputNodes;
    }

    private static List<SqlNode> getSelectNodesToReplace(SqlNode selectNode, SqlNodeList groupKeys) {
        for (SqlNode groupNode : groupKeys) {
            if (!selectNode.equalsDeep(groupNode, Litmus.IGNORE)) continue;
            return Collections.singletonList(selectNode);
        }
        if (selectNode instanceof SqlCall) {
            if (((SqlCall)selectNode).getOperator() instanceof SqlAggFunction) {
                return Collections.singletonList(selectNode);
            }
            return ((SqlCall)selectNode).getOperandList().stream().filter(Objects::nonNull).map(node -> ConvertToComputedColumn.getSelectNodesToReplace(node, groupKeys)).flatMap(Collection::stream).collect(Collectors.toList());
        }
        if (selectNode instanceof SqlNodeList) {
            return ((SqlNodeList)selectNode).getList().stream().filter(Objects::nonNull).map(node -> ConvertToComputedColumn.getSelectNodesToReplace(node, groupKeys)).flatMap(Collection::stream).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static List<SqlNode> getInputTreeNodes(SqlNode sqlNode) {
        if (sqlNode == null) {
            return Collections.emptyList();
        }
        SqlTreeVisitor stv = new SqlTreeVisitor();
        sqlNode.accept((SqlVisitor)stv);
        return stv.getSqlNodes();
    }

    private static String getTableAlias(SqlNode node) {
        if (node instanceof SqlCall) {
            SqlCall call = (SqlCall)node;
            return ConvertToComputedColumn.getTableAlias(call.getOperandList());
        }
        if (node instanceof SqlIdentifier) {
            StringBuilder alias = new StringBuilder();
            ImmutableList names = ((SqlIdentifier)node).names;
            if (names.size() >= 2) {
                for (int i = 0; i < names.size() - 1; ++i) {
                    alias.append((String)names.get(i)).append(".");
                }
            }
            return alias.toString();
        }
        return "";
    }

    private static String getTableAlias(List<SqlNode> operands) {
        if (operands.isEmpty()) {
            return "";
        }
        return ConvertToComputedColumn.getTableAlias(operands.get(0));
    }

    static List<ComputedColumnDesc> getCCListSortByLength(List<ComputedColumnDesc> computedColumns) {
        if (computedColumns == null || computedColumns.isEmpty()) {
            return Lists.newArrayList();
        }
        Ordering ordering = Ordering.from(Comparator.comparingInt(String::length)).reverse().nullsLast().onResultOf((Function)new Function<ComputedColumnDesc, String>(){

            @Nullable
            public String apply(@Nullable ComputedColumnDesc input) {
                return input == null ? null : input.getExpression();
            }
        });
        return ordering.immutableSortedCopy(computedColumns);
    }

    @Override
    public String transform(String originSql, String project, String defaultSchema) {
        try {
            return this.transformImpl(originSql, project, defaultSchema);
        }
        catch (Exception e) {
            log.warn("{}, critical stackTrace:\n{}", (Object)CONVERT_TO_CC_ERROR_MSG, (Object)ThreadUtil.getKylinStackTrace());
            return originSql;
        }
    }

    public String transformImpl(String originSql, String project, String defaultSchema) throws SqlParseException {
        NDataflowManager dataflowManager = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        List<NDataModel> dataModelDescs = dataflowManager.listOnlineDataModels().stream().filter(m -> !m.getComputedColumnDescs().isEmpty()).collect(Collectors.toList());
        if (dataModelDescs.isEmpty()) {
            return originSql;
        }
        return this.transformImpl(originSql, project, defaultSchema, dataModelDescs);
    }

    private String transformImpl(String originSql, String project, String defaultSchema, List<NDataModel> dataModelDescs) throws SqlParseException {
        if (project == null || originSql == null) {
            return originSql;
        }
        return this.transformImpl(originSql, new QueryAliasMatcher(project, defaultSchema), dataModelDescs);
    }

    private String transformImpl(String originSql, QueryAliasMatcher queryAliasMatcher, List<NDataModel> dataModelDescs) throws SqlParseException {
        if (!KapConfig.getInstanceFromEnv().isImplicitComputedColumnConvertEnabled()) {
            return originSql;
        }
        String sql = originSql;
        if (queryAliasMatcher == null || sql == null) {
            return sql;
        }
        int recursionTimes = 0;
        int maxRecursionTimes = KapConfig.getInstanceFromEnv().getComputedColumnMaxRecursionTimes();
        while (recursionTimes++ < maxRecursionTimes) {
            Pair<String, Boolean> result = this.transformImplRecursive(sql, queryAliasMatcher, dataModelDescs, false);
            sql = (String)result.getFirst();
            boolean recursionCompleted = (Boolean)result.getSecond();
            if (!recursionCompleted) continue;
            break;
        }
        return sql;
    }

    private Pair<String, Boolean> transformImplRecursive(String sql, QueryAliasMatcher queryAliasMatcher, List<NDataModel> dataModelDescs, boolean replaceCcName) throws SqlParseException {
        boolean recursionCompleted = true;
        List<SqlCall> selectOrOrderbys = SqlSubqueryFinder.getSubqueries(sql);
        Pair<String, Integer> choiceForCurrentSubquery = null;
        for (int i = 0; i < selectOrOrderbys.size(); ++i) {
            if (choiceForCurrentSubquery != null) {
                selectOrOrderbys = SqlSubqueryFinder.getSubqueries(sql);
                choiceForCurrentSubquery = null;
            }
            SqlCall selectOrOrderby = selectOrOrderbys.get(i);
            ComputedColumnReplacer rewriteChecker = new ComputedColumnReplacer(queryAliasMatcher, dataModelDescs, recursionCompleted, choiceForCurrentSubquery, selectOrOrderby);
            rewriteChecker.replace(sql, replaceCcName);
            recursionCompleted = rewriteChecker.isRecursionCompleted();
            choiceForCurrentSubquery = rewriteChecker.getChoiceForCurrentSubquery();
            if (choiceForCurrentSubquery == null) continue;
            sql = (String)choiceForCurrentSubquery.getFirst();
        }
        return Pair.newPair((Object)sql, (Object)recursionCompleted);
    }

    private Pair<String, Integer> replaceComputedColumn(String inputSql, SqlCall selectOrOrderby, List<ComputedColumnDesc> computedColumns, QueryAliasMatchInfo queryAliasMatchInfo, boolean replaceCcName) {
        List<Pair<ComputedColumnDesc, Pair<Integer, Integer>>> toBeReplacedExp;
        if (CollectionUtils.isEmpty(computedColumns)) {
            return Pair.newPair((Object)inputSql, (Object)0);
        }
        String result = inputSql;
        try {
            toBeReplacedExp = this.matchComputedColumn(inputSql, selectOrOrderby, computedColumns, queryAliasMatchInfo, replaceCcName);
        }
        catch (Exception e) {
            log.debug("Convert to computedColumn Fail,parse sql fail ", (Throwable)e);
            return Pair.newPair((Object)inputSql, (Object)0);
        }
        toBeReplacedExp.sort((o1, o2) -> ((Integer)((Pair)o2.getSecond()).getFirst()).compareTo((Integer)((Pair)o1.getSecond()).getFirst()));
        for (Pair<ComputedColumnDesc, Pair<Integer, Integer>> toBeReplaced : toBeReplacedExp) {
            Pair startEndPos = (Pair)toBeReplaced.getSecond();
            int start = (Integer)startEndPos.getFirst();
            int end = (Integer)startEndPos.getSecond();
            ComputedColumnDesc cc = (ComputedColumnDesc)toBeReplaced.getFirst();
            String alias = null;
            alias = queryAliasMatchInfo.isModelView() ? (String)queryAliasMatchInfo.getAliasMap().inverse().get((Object)queryAliasMatchInfo.getModel().getAlias()) : (String)queryAliasMatchInfo.getAliasMap().inverse().get((Object)cc.getTableAlias());
            if (alias == null) {
                throw new IllegalStateException(cc.getExpression() + " expression of cc " + cc.getFullName() + " is found in query but its table ref " + cc.getTableAlias() + " is missing in query");
            }
            String expr = inputSql.substring(start, end);
            String ccColumnName = replaceCcName ? cc.getInternalCcName() : cc.getColumnName();
            log.debug("Computed column: {} matching {} at [{},{}] using alias in query: {}", new Object[]{cc.getColumnName(), expr, start, end, alias});
            alias = Character.isAlphabetic(alias.charAt(0)) ? alias : DOUBLE_QUOTE + alias + DOUBLE_QUOTE;
            ccColumnName = Character.isAlphabetic(ccColumnName.charAt(0)) ? ccColumnName : DOUBLE_QUOTE + ccColumnName + DOUBLE_QUOTE;
            result = result.substring(0, start) + alias + "." + ccColumnName + result.substring(end);
        }
        try {
            SqlNode inputNodes = CalciteParser.parse((String)inputSql);
            int cntNodesBefore = ConvertToComputedColumn.getInputTreeNodes(inputNodes).size();
            SqlNode resultNodes = CalciteParser.parse((String)result);
            int cntNodesAfter = ConvertToComputedColumn.getInputTreeNodes(resultNodes).size();
            return Pair.newPair((Object)result, (Object)(cntNodesBefore - cntNodesAfter));
        }
        catch (SqlParseException e) {
            log.debug("Convert to computedColumn Fail, parse result sql fail: {}", (Object)result, (Object)e);
            return Pair.newPair((Object)inputSql, (Object)0);
        }
    }

    private List<Pair<ComputedColumnDesc, Pair<Integer, Integer>>> matchComputedColumn(String inputSql, SqlCall selectOrOrderby, List<ComputedColumnDesc> computedColumns, QueryAliasMatchInfo queryAliasMatchInfo, boolean replaceCcName) {
        ArrayList<Pair<ComputedColumnDesc, Pair<Integer, Integer>>> toBeReplacedExp = new ArrayList<Pair<ComputedColumnDesc, Pair<Integer, Integer>>>();
        for (ComputedColumnDesc cc : computedColumns) {
            ArrayList matchedNodes = Lists.newArrayList();
            matchedNodes.addAll(this.getMatchedNodes(selectOrOrderby, replaceCcName ? cc.getFullName() : cc.getExpression(), queryAliasMatchInfo));
            String transformedExpression = ConvertToComputedColumn.transformExpr(cc.getExpression());
            if (!transformedExpression.equals(cc.getExpression())) {
                matchedNodes.addAll(this.getMatchedNodes(selectOrOrderby, transformedExpression, queryAliasMatchInfo));
            }
            for (SqlNode node : matchedNodes) {
                Pair startEndPos = CalciteParser.getReplacePos((SqlNode)node, (String)inputSql);
                int start = (Integer)startEndPos.getFirst();
                int end = (Integer)startEndPos.getSecond();
                boolean conflict = false;
                for (Pair pair : toBeReplacedExp) {
                    Pair replaced = (Pair)pair.getSecond();
                    if ((Integer)replaced.getFirst() >= end || (Integer)replaced.getSecond() <= start) continue;
                    conflict = true;
                    break;
                }
                if (conflict) continue;
                toBeReplacedExp.add((Pair<ComputedColumnDesc, Pair<Integer, Integer>>)Pair.newPair((Object)cc, (Object)Pair.newPair((Object)start, (Object)end)));
            }
        }
        return toBeReplacedExp;
    }

    private List<SqlNode> getMatchedNodes(SqlCall selectOrOrderby, String ccExp, QueryAliasMatchInfo matchInfo) {
        if (ccExp == null || ccExp.equals("")) {
            return Collections.emptyList();
        }
        ArrayList<SqlNode> matchedNodes = new ArrayList<SqlNode>();
        SqlNode ccExpressionNode = CalciteParser.getReadonlyExpNode((String)ccExp);
        List<Object> inputNodes = new LinkedList();
        if ("LENIENT".equals(KylinConfig.getInstanceFromEnv().getCalciteConformance())) {
            inputNodes = ConvertToComputedColumn.getInputTreeNodes((SqlNode)selectOrOrderby);
        } else if (selectOrOrderby instanceof SqlSelect && ((SqlSelect)selectOrOrderby).getGroup() != null) {
            inputNodes.addAll(ConvertToComputedColumn.collectInputNodes((SqlSelect)selectOrOrderby));
        } else if (selectOrOrderby instanceof SqlOrderBy) {
            SqlOrderBy sqlOrderBy = (SqlOrderBy)selectOrOrderby;
            inputNodes.addAll(ConvertToComputedColumn.collectInputNodes(sqlOrderBy));
            if (sqlOrderBy.query instanceof SqlCall) {
                matchedNodes.addAll(this.getMatchedNodes((SqlCall)sqlOrderBy.query, ccExp, matchInfo));
            } else {
                inputNodes.addAll(ConvertToComputedColumn.getInputTreeNodes(sqlOrderBy.query));
            }
        } else {
            inputNodes = ConvertToComputedColumn.getInputTreeNodes((SqlNode)selectOrOrderby);
        }
        inputNodes.stream().filter(inputNode -> this.isNodesEqual(matchInfo, ccExpressionNode, (SqlNode)inputNode)).forEach(matchedNodes::add);
        return matchedNodes;
    }

    private boolean isNodesEqual(QueryAliasMatchInfo matchInfo, SqlNode ccExpressionNode, SqlNode inputNode) {
        if (matchInfo.isModelView()) {
            return ExpressionComparator.isNodeEqual((SqlNode)inputNode, (SqlNode)ccExpressionNode, (ExpressionComparator.SqlNodeComparator)new ModelViewSqlNodeComparator(matchInfo.getModel()));
        }
        return ExpressionComparator.isNodeEqual((SqlNode)inputNode, (SqlNode)ccExpressionNode, (AliasMapping)matchInfo, (AliasDeduce)new AliasDeduceImpl(matchInfo));
    }

    private class ComputedColumnReplacer {
        private QueryAliasMatcher queryAliasMatcher;
        private List<NDataModel> dataModels;
        private boolean recursionCompleted;
        private Pair<String, Integer> choiceForCurrentSubquery;
        private SqlCall selectOrOrderby;

        ComputedColumnReplacer(QueryAliasMatcher queryAliasMatcher, List<NDataModel> dataModels, boolean recursionCompleted, Pair<String, Integer> choiceForCurrentSubquery, SqlCall selectOrOrderby) {
            this.queryAliasMatcher = queryAliasMatcher;
            this.dataModels = dataModels;
            this.recursionCompleted = recursionCompleted;
            this.choiceForCurrentSubquery = choiceForCurrentSubquery;
            this.selectOrOrderby = selectOrOrderby;
        }

        boolean isRecursionCompleted() {
            return this.recursionCompleted;
        }

        Pair<String, Integer> getChoiceForCurrentSubquery() {
            return this.choiceForCurrentSubquery;
        }

        public void replace(String sql, boolean replaceCcName) {
            SqlSelect sqlSelect = QueryUtil.extractSqlSelect(this.selectOrOrderby);
            if (sqlSelect == null) {
                return;
            }
            for (NDataModel model : this.dataModels) {
                QueryAliasMatchInfo info = this.queryAliasMatcher.match(model, sqlSelect);
                if (info == null) continue;
                Set cols = this.queryAliasMatcher.getChecker().filterRelatedExcludedColumn(model);
                info.getExcludedColumns().addAll(cols);
                List<ComputedColumnDesc> computedColumns = this.getSortedComputedColumnWithModel(model);
                if (!CollectionUtils.isNotEmpty(computedColumns)) continue;
                Pair ret = ConvertToComputedColumn.this.replaceComputedColumn(sql, this.selectOrOrderby, computedColumns, info, replaceCcName);
                if (replaceCcName && !sql.equals(ret.getFirst())) {
                    this.choiceForCurrentSubquery = ret;
                    continue;
                }
                if ((Integer)ret.getSecond() == 0 || this.choiceForCurrentSubquery != null && (Integer)ret.getSecond() <= (Integer)this.choiceForCurrentSubquery.getSecond()) continue;
                this.choiceForCurrentSubquery = ret;
                this.recursionCompleted = false;
            }
        }

        private List<ComputedColumnDesc> getSortedComputedColumnWithModel(NDataModel model) {
            List ccList = model.getComputedColumnDescs();
            KylinConfig projectConfig = NProjectManager.getProjectConfig((String)model.getProject());
            if (projectConfig.isTableExclusionEnabled() && projectConfig.onlyReuseUserDefinedCC()) {
                ccList = ccList.stream().filter(cc -> !cc.isAutoCC()).collect(Collectors.toList());
            }
            return ConvertToComputedColumn.getCCListSortByLength(ccList);
        }
    }

    static class SqlTreeVisitor
    implements SqlVisitor<SqlNode> {
        private List<SqlNode> sqlNodes = new ArrayList<SqlNode>();

        SqlTreeVisitor() {
        }

        List<SqlNode> getSqlNodes() {
            return this.sqlNodes;
        }

        public SqlNode visit(SqlNodeList nodeList) {
            this.sqlNodes.add((SqlNode)nodeList);
            for (int i = 0; i < nodeList.size(); ++i) {
                SqlNode node = nodeList.get(i);
                node.accept((SqlVisitor)this);
            }
            return null;
        }

        public SqlNode visit(SqlLiteral literal) {
            this.sqlNodes.add((SqlNode)literal);
            return null;
        }

        public SqlNode visit(SqlCall call) {
            this.sqlNodes.add((SqlNode)call);
            if (call.getOperator() instanceof SqlAsOperator) {
                call.getOperator().acceptCall((SqlVisitor)this, call, true, SqlBasicVisitor.ArgHandlerImpl.instance());
            } else {
                for (SqlNode operand : call.getOperandList()) {
                    if (operand == null) continue;
                    operand.accept((SqlVisitor)this);
                }
            }
            return null;
        }

        public SqlNode visit(SqlIdentifier id) {
            this.sqlNodes.add((SqlNode)id);
            return null;
        }

        public SqlNode visit(SqlDataTypeSpec type) {
            return null;
        }

        public SqlNode visit(SqlDynamicParam param) {
            return null;
        }

        public SqlNode visit(SqlIntervalQualifier intervalQualifier) {
            return null;
        }
    }
}

