/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.query.IQueryTransformer;

public class DefaultQueryTransformer
implements IQueryTransformer {
    private static final String S0 = "\\s*";
    private static final String SM = "\\s+";
    private static final String ONE = "1";
    private static final Pattern PTN_SUM = Pattern.compile("\\s*\\bSUM\\s*[(]\\s*(-?\\d+(\\.\\d+)?)\\s*[)]\\s*", 2);
    private static final Pattern PTN_INTERVAL = Pattern.compile("\\binterval\\s+(floor\\()([\\d.]+)(\\))\\s+(second|minute|hour|day|month|year)", 2);
    private static final Pattern PTN_HAVING_ESCAPE_FUNCTION = Pattern.compile("[{]\\s*fn\\s+(EXTRACT\\(.*?\\))\\s*[}]", 2);
    private static final Pattern PIN_SUM_OF_CAST = Pattern.compile("\\s*\\bSUM\\s*\\(\\s*CAST\\s*\\(\\s*([^\\s,]+)\\s*AS\\s+DOUBLE\\s*\\)\\s*\\)", 2);

    private static String transformSumOfCast(String sql) {
        if (!KylinConfig.getInstanceFromEnv().isOptimizedSumCastDoubleRuleEnabled()) {
            Matcher m;
            while ((m = PIN_SUM_OF_CAST.matcher(sql)).find()) {
                sql = sql.substring(0, m.start()) + " SUM(" + m.group(1).trim() + ")" + sql.substring(m.end(), sql.length());
            }
        }
        return sql;
    }

    private static String transformEscapeFunction(String sql) {
        Matcher m;
        while ((m = PTN_HAVING_ESCAPE_FUNCTION.matcher(sql)).find()) {
            sql = sql.substring(0, m.start()) + m.group(1) + sql.substring(m.end());
        }
        return sql;
    }

    private static String transformSumOfNumericLiteral(String sql) {
        Matcher m;
        while ((m = PTN_SUM.matcher(sql)).find()) {
            String literal = m.group(1);
            String replacedLiteral = ONE.equals(literal) ? " COUNT(1) " : " " + literal + " * COUNT(1) ";
            sql = sql.substring(0, m.start()) + replacedLiteral + sql.substring(m.end());
        }
        return sql;
    }

    private static String transformIntervalFunc(String sql) {
        Matcher m;
        while ((m = PTN_INTERVAL.matcher(sql)).find()) {
            int value = (int)Math.floor(Double.parseDouble(m.group(2)));
            sql = sql.substring(0, m.start(1)) + "'" + value + "'" + sql.substring(m.end(3));
        }
        return sql;
    }

    @Override
    public String transform(String sql, String project, String defaultSchema) {
        sql = DefaultQueryTransformer.transformSumOfCast(sql);
        sql = DefaultQueryTransformer.transformEscapeFunction(sql);
        sql = DefaultQueryTransformer.transformSumOfNumericLiteral(sql);
        sql = DefaultQueryTransformer.transformIntervalFunc(sql);
        return sql;
    }
}

