/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.kylin.query.util.EscapeFunction;

public abstract class EscapeDialect {
    private static final String FN_LENGTH_ALIAS = "CHAR_LENGTH";
    private static final String FN_WEEK = "WEEK";
    private static final String FN_CEIL = "CEIL";
    private static final String FN_FLOOR = "FLOOR";
    private static final String FN_SUBSTR = "SUBSTR";
    private static final String FN_SUBSTRING = "SUBSTRING";
    private static final String FN_ASCII = "ASCII";
    private static final String FN_CHR = "CHR";
    private static final String FN_SPACE = "SPACE";
    public static final EscapeDialect CALCITE = new EscapeDialect(){

        @Override
        public void init() {
            this.registerAll(EscapeFunction.FnConversion.LEFT, EscapeFunction.FnConversion.RIGHT, EscapeFunction.FnConversion.CURRENT_DATE, EscapeFunction.FnConversion.CURRENT_TIME, EscapeFunction.FnConversion.CURRENT_TIMESTAMP, EscapeFunction.FnConversion.CONVERT, EscapeFunction.FnConversion.OVERLAY, EscapeFunction.FnConversion.SETS, EscapeFunction.FnConversion.GROUPING, EscapeFunction.FnConversion.TRIM, EscapeFunction.FnConversion.TIMESTAMPADD, EscapeFunction.FnConversion.TIMESTAMPDIFF, EscapeFunction.FnConversion.YEAR, EscapeFunction.FnConversion.QUARTER, EscapeFunction.FnConversion.MONTH, EscapeFunction.FnConversion.DAYOFMONTH, EscapeFunction.FnConversion.DAYOFYEAR, EscapeFunction.FnConversion.DAYOFWEEK, EscapeFunction.FnConversion.HOUR, EscapeFunction.FnConversion.MINUTE, EscapeFunction.FnConversion.SECOND);
            this.register(EscapeDialect.FN_LENGTH_ALIAS, EscapeFunction.FnConversion.FN_LENGTH);
            this.register(EscapeDialect.FN_WEEK, EscapeFunction.FnConversion.WEEK_CALCITE);
            this.register(EscapeDialect.FN_CEIL, EscapeFunction.FnConversion.CEIL);
            this.register(EscapeDialect.FN_FLOOR, EscapeFunction.FnConversion.FLOOR);
            this.register(EscapeDialect.FN_SUBSTR, EscapeFunction.FnConversion.SUSTR);
            this.register(EscapeDialect.FN_SUBSTRING, EscapeFunction.FnConversion.SUSTRING);
            this.register(EscapeDialect.FN_ASCII, EscapeFunction.FnConversion.ASCII);
            this.register(EscapeDialect.FN_CHR, EscapeFunction.FnConversion.CHR);
            this.register(EscapeDialect.FN_SPACE, EscapeFunction.FnConversion.SPACE);
        }

        @Override
        public String defaultConversion(String functionName, String[] args) {
            return EscapeFunction.scalarFN(functionName, args);
        }

        @Override
        public String transformDataType(String type) {
            return type.equalsIgnoreCase("STRING") ? "VARCHAR" : type;
        }
    };
    public static final EscapeDialect SPARK_SQL = new EscapeDialect(){

        @Override
        public void init() {
            this.registerAll(EscapeFunction.FnConversion.LEFT, EscapeFunction.FnConversion.RIGHT, EscapeFunction.FnConversion.CONVERT, EscapeFunction.FnConversion.GROUPING, EscapeFunction.FnConversion.LOG, EscapeFunction.FnConversion.CURRENT_DATE, EscapeFunction.FnConversion.CURRENT_TIME, EscapeFunction.FnConversion.CURRENT_TIMESTAMP, EscapeFunction.FnConversion.TIMESTAMPADD, EscapeFunction.FnConversion.TIMESTAMPDIFF, EscapeFunction.FnConversion.YEAR, EscapeFunction.FnConversion.QUARTER, EscapeFunction.FnConversion.MONTH, EscapeFunction.FnConversion.DAYOFMONTH, EscapeFunction.FnConversion.DAYOFYEAR, EscapeFunction.FnConversion.DAYOFWEEK, EscapeFunction.FnConversion.HOUR, EscapeFunction.FnConversion.MINUTE, EscapeFunction.FnConversion.SECOND, EscapeFunction.FnConversion.TRIM);
            this.register(EscapeDialect.FN_WEEK, EscapeFunction.FnConversion.WEEK_SPARK);
            this.register(EscapeDialect.FN_LENGTH_ALIAS, EscapeFunction.FnConversion.LENGTH);
            this.register(EscapeDialect.FN_CEIL, EscapeFunction.FnConversion.CEIL2);
            this.register(EscapeDialect.FN_FLOOR, EscapeFunction.FnConversion.FLOOR2);
            this.register(EscapeDialect.FN_SUBSTR, EscapeFunction.FnConversion.SUSTR);
            this.register(EscapeDialect.FN_SUBSTRING, EscapeFunction.FnConversion.SUSTRING);
            this.register("OVERLAY", EscapeFunction.FnConversion.OVERLAY_SPARK);
            this.register("SETS", EscapeFunction.FnConversion.SETS_SPARK);
            this.register(EscapeDialect.FN_ASCII, EscapeFunction.FnConversion.ASCII);
            this.register(EscapeDialect.FN_CHR, EscapeFunction.FnConversion.CHR);
            this.register(EscapeDialect.FN_SPACE, EscapeFunction.FnConversion.SPACE);
        }

        @Override
        public String defaultConversion(String functionName, String[] args) {
            return EscapeFunction.normalFN(functionName, args);
        }

        @Override
        public String transformDoubleQuoteString(String input) {
            if (!input.startsWith("\"")) {
                return input;
            }
            return Quoting.BACK_TICK.string + input.substring(1, input.length() - 1) + Quoting.BACK_TICK.string;
        }

        @Override
        public String transformTimeunitOfTimestampDiffOrAdd(String timeunit) {
            return "'" + timeunit + "'";
        }

        @Override
        public String transformDataType(String type) {
            if (type.equalsIgnoreCase("INTEGER")) {
                return type.substring(0, 3);
            }
            if (type.equalsIgnoreCase("WVARCHAR")) {
                return type.substring(1);
            }
            if (type.equalsIgnoreCase("SQL_WVARCHAR")) {
                return type.substring(5);
            }
            return type;
        }

        @Override
        public String transformNiladicFunction(String funcName) {
            return String.format(Locale.ROOT, "%s()", funcName);
        }
    };
    public static final EscapeDialect HIVE = new EscapeDialect(){

        @Override
        public void init() {
            this.registerAll(EscapeFunction.FnConversion.LEFT, EscapeFunction.FnConversion.RIGHT, EscapeFunction.FnConversion.CONVERT, EscapeFunction.FnConversion.GROUPING, EscapeFunction.FnConversion.LOG, EscapeFunction.FnConversion.CURRENT_DATE, EscapeFunction.FnConversion.CURRENT_TIME, EscapeFunction.FnConversion.CURRENT_TIMESTAMP, EscapeFunction.FnConversion.TIMESTAMPADD, EscapeFunction.FnConversion.TIMESTAMPDIFF, EscapeFunction.FnConversion.YEAR, EscapeFunction.FnConversion.QUARTER, EscapeFunction.FnConversion.MONTH, EscapeFunction.FnConversion.DAYOFMONTH, EscapeFunction.FnConversion.DAYOFYEAR, EscapeFunction.FnConversion.DAYOFWEEK, EscapeFunction.FnConversion.HOUR, EscapeFunction.FnConversion.MINUTE, EscapeFunction.FnConversion.SECOND);
            this.register(EscapeDialect.FN_LENGTH_ALIAS, EscapeFunction.FnConversion.LENGTH);
            this.register(EscapeDialect.FN_WEEK, EscapeFunction.FnConversion.WEEK_SPARK);
            this.register("TRUNCATE", EscapeFunction.FnConversion.TRUNCATE_NUM);
            this.register(EscapeDialect.FN_CEIL, EscapeFunction.FnConversion.CEIL2);
            this.register(EscapeDialect.FN_FLOOR, EscapeFunction.FnConversion.FLOOR2);
            this.register(EscapeDialect.FN_SUBSTR, EscapeFunction.FnConversion.SUSTR);
            this.register(EscapeDialect.FN_SUBSTRING, EscapeFunction.FnConversion.SUSTRING);
            this.register("OVERLAY", EscapeFunction.FnConversion.OVERLAY_SPARK);
            this.register("SETS", EscapeFunction.FnConversion.SETS_SPARK);
        }

        @Override
        public String defaultConversion(String functionName, String[] args) {
            return EscapeFunction.normalFN(functionName, args);
        }

        @Override
        public String transformDoubleQuoteString(String input) {
            if (!input.startsWith("\"")) {
                return input;
            }
            return Quoting.BACK_TICK.string + input.substring(1, input.length() - 1) + Quoting.BACK_TICK.string;
        }

        @Override
        public String transformTimeunitOfTimestampDiffOrAdd(String timeunit) {
            return "'" + timeunit + "'";
        }
    };
    public static final EscapeDialect DEFAULT = CALCITE;
    private final Map<String, EscapeFunction.FnConversion> registeredFunction = new HashMap<String, EscapeFunction.FnConversion>();

    public EscapeDialect() {
        this.init();
    }

    public abstract void init();

    public abstract String defaultConversion(String var1, String[] var2);

    public String transformDoubleQuoteString(String input) {
        return input;
    }

    public String transformTimeunitOfTimestampDiffOrAdd(String timeunit) {
        return timeunit;
    }

    public String transformDataType(String type) {
        return type;
    }

    public String transformFN(String functionName, String[] args) {
        EscapeFunction.FnConversion fnType = this.registeredFunction.get(functionName.toUpperCase(Locale.ROOT));
        if (fnType != null) {
            return fnType.convert(args);
        }
        return this.defaultConversion(functionName, args);
    }

    public void registerAll(EscapeFunction.FnConversion ... fnTypes) {
        Arrays.stream(fnTypes).forEach(this::register);
    }

    public void register(EscapeFunction.FnConversion fnType) {
        this.register(fnType.name(), fnType);
    }

    public void register(String fnAlias, EscapeFunction.FnConversion fnType) {
        if (fnType == null) {
            return;
        }
        this.registeredFunction.put(fnAlias, fnType);
    }

    public String transformNiladicFunction(String funcName) {
        return funcName;
    }
}

