/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Locale;

public class EscapeFunction {
    private static final String SUBSTRING_FUNCTION = "SUBSTRING";
    private static final String CEIL_EXCEPTION_MSG = "ceil function only support ceil(numeric) or ceil(datetime to timeunit)";
    private static final String FLOOR_EXCEPTION_MSG = "ceil function only support ceil(numeric) or ceil(datetime to timeunit)";
    private static final String SUBSTRING_EXCEPTION_MSG = "substring/substr only support substring(col from start for len) or substring(col from start)";
    private static final String SUBSTR_EXCEPTION_MSG = "substring/substr only support substr(col from start for len) or substr(col from start)";
    private static final String OVERLAY_EXCEPTION_MSG = "overlay only support overlay(exp1 placing exp2 from start for len) or overlay(exp1 placing exp2 from start)";

    public static String normalFN(String functionName, String[] args) {
        return String.format(Locale.ROOT, "%s(%s)", functionName, String.join((CharSequence)", ", args));
    }

    public static String scalarFN(String functionName, String[] args) {
        return String.format(Locale.ROOT, "{fn %s(%s)}", functionName, String.join((CharSequence)", ", args));
    }

    private static void checkArgs(String[] args, int expectedCount) {
        int actualCount = 0;
        if (args != null) {
            actualCount = args.length;
        }
        if (actualCount != expectedCount) {
            throw new IllegalArgumentException("Bad arguments count, expected count " + expectedCount + " but actual " + actualCount);
        }
    }

    public static enum FnConversion {
        LEFT(args -> {
            EscapeFunction.checkArgs(args, 2);
            String[] newArgs = new String[]{args[0], "1", args[1]};
            return EscapeFunction.normalFN(EscapeFunction.SUBSTRING_FUNCTION, newArgs);
        }),
        RIGHT(args -> {
            EscapeFunction.checkArgs(args, 2);
            String origStrRef = args[0];
            String rightOffset = args[1];
            String[] newArgs = new String[]{origStrRef, "CHAR_LENGTH(" + origStrRef + ") + 1 - " + rightOffset, "" + rightOffset};
            return EscapeFunction.normalFN(EscapeFunction.SUBSTRING_FUNCTION, newArgs);
        }),
        TRIM(args -> {
            EscapeFunction.checkArgs(args, 1);
            String[] newArgs = new String[]{"both " + args[0]};
            return EscapeFunction.normalFN("TRIM", newArgs);
        }),
        LTRIM(args -> {
            EscapeFunction.checkArgs(args, 1);
            String[] newArgs = new String[]{"leading " + args[0]};
            return EscapeFunction.normalFN("TRIM", newArgs);
        }),
        RTRIM(args -> {
            EscapeFunction.checkArgs(args, 1);
            String[] newArgs = new String[]{"trailing " + args[0]};
            return EscapeFunction.normalFN("TRIM", newArgs);
        }),
        FN_LENGTH(args -> {
            EscapeFunction.checkArgs(args, 1);
            return EscapeFunction.scalarFN("LENGTH", args);
        }),
        LENGTH(args -> {
            EscapeFunction.checkArgs(args, 1);
            return EscapeFunction.normalFN("LENGTH", args);
        }),
        CONVERT(args -> {
            EscapeFunction.checkArgs(args, 2);
            String value = args[0];
            String sqlType = args[1].toUpperCase(Locale.ROOT);
            String sqlPrefix = "SQL_";
            if (sqlType.startsWith(sqlPrefix)) {
                sqlType = sqlType.substring(sqlPrefix.length());
            }
            switch (sqlType) {
                case "WVARCHAR": 
                case "CHAR": 
                case "WCHAR": {
                    sqlType = "VARCHAR";
                    break;
                }
            }
            String[] newArgs = new String[]{value + " AS " + sqlType};
            return EscapeFunction.normalFN("CAST", newArgs);
        }),
        LCASE(args -> {
            EscapeFunction.checkArgs(args, 1);
            return EscapeFunction.normalFN("LOWER", args);
        }),
        UCASE(args -> {
            EscapeFunction.checkArgs(args, 1);
            return EscapeFunction.normalFN("UPPER", args);
        }),
        LOG(args -> {
            EscapeFunction.checkArgs(args, 1);
            return EscapeFunction.normalFN("LN", args);
        }),
        EXTRACT(args -> {
            EscapeFunction.checkArgs(args, 3);
            String function = args[0];
            if (function.equalsIgnoreCase("DAY")) {
                function = "DAYOFMONTH";
            } else if (function.equalsIgnoreCase("DOW")) {
                function = "DAYOFWEEK";
            } else if (function.equalsIgnoreCase("DOY")) {
                function = "DAYOFYEAR";
            }
            return EscapeFunction.normalFN(function, new String[]{args[2]});
        }),
        CURRENT_DATE(args -> {
            EscapeFunction.checkArgs(args, 0);
            return "CURRENT_DATE";
        }),
        CURRENT_TIME(args -> {
            EscapeFunction.checkArgs(args, 0);
            return "CURRENT_TIME";
        }),
        CURRENT_TIMESTAMP(args -> {
            if (args == null || args.length > 1) {
                throw new IllegalArgumentException("Bad arguments");
            }
            return "CURRENT_TIMESTAMP";
        }),
        WEEK_CALCITE(args -> {
            EscapeFunction.checkArgs(args, 1);
            return EscapeFunction.normalFN("WEEK", args);
        }),
        WEEK_SPARK(args -> {
            EscapeFunction.checkArgs(args, 1);
            return EscapeFunction.normalFN("WEEKOFYEAR", args);
        }),
        YEAR(args -> {
            EscapeFunction.checkArgs(args, 1);
            return EscapeFunction.normalFN("YEAR", args);
        }),
        QUARTER(args -> {
            EscapeFunction.checkArgs(args, 1);
            return EscapeFunction.normalFN("QUARTER", args);
        }),
        MONTH(args -> {
            EscapeFunction.checkArgs(args, 1);
            return EscapeFunction.normalFN("MONTH", args);
        }),
        DAYOFMONTH(args -> {
            EscapeFunction.checkArgs(args, 1);
            return EscapeFunction.normalFN("DAYOFMONTH", args);
        }),
        DAYOFWEEK(args -> {
            EscapeFunction.checkArgs(args, 1);
            return EscapeFunction.normalFN("DAYOFWEEK", args);
        }),
        DAYOFYEAR(args -> {
            EscapeFunction.checkArgs(args, 1);
            return EscapeFunction.normalFN("DAYOFYEAR", args);
        }),
        HOUR(args -> {
            EscapeFunction.checkArgs(args, 1);
            return EscapeFunction.normalFN("HOUR", args);
        }),
        MINUTE(args -> {
            EscapeFunction.checkArgs(args, 1);
            return EscapeFunction.normalFN("MINUTE", args);
        }),
        SECOND(args -> {
            EscapeFunction.checkArgs(args, 1);
            return EscapeFunction.normalFN("SECOND", args);
        }),
        TRUNCATE_NUM(args -> {
            EscapeFunction.checkArgs(args, 2);
            return EscapeFunction.normalFN("TRUNCATE_NUM", args);
        }),
        TIMESTAMPADD(args -> {
            EscapeFunction.checkArgs(args, 3);
            return EscapeFunction.normalFN("TIMESTAMPADD", args);
        }),
        TIMESTAMPDIFF(args -> {
            EscapeFunction.checkArgs(args, 3);
            return EscapeFunction.normalFN("TIMESTAMPDIFF", args);
        }),
        SUSTRING(args -> {
            Preconditions.checkArgument((args.length == 2 || args.length == 3 ? 1 : 0) != 0, (Object)EscapeFunction.SUBSTRING_EXCEPTION_MSG);
            return EscapeFunction.normalFN(EscapeFunction.SUBSTRING_FUNCTION, args);
        }),
        SUSTR(args -> {
            Preconditions.checkArgument((args.length == 2 || args.length == 3 ? 1 : 0) != 0, (Object)EscapeFunction.SUBSTR_EXCEPTION_MSG);
            return EscapeFunction.normalFN(EscapeFunction.SUBSTRING_FUNCTION, args);
        }),
        OVERLAY_SPARK(args -> {
            Preconditions.checkArgument((args.length == 3 || args.length == 4 ? 1 : 0) != 0, (Object)EscapeFunction.OVERLAY_EXCEPTION_MSG);
            ArrayList newArgs = Lists.newArrayList();
            newArgs.add(String.format(Locale.ROOT, "SUBSTRING(%s, %s, %s - 1)", args[0], 0, args[2]));
            newArgs.add(args[1]);
            if (args.length == 3) {
                newArgs.add(String.format(Locale.ROOT, "SUBSTRING(%s, %s + CHAR_LENGTH(%s))", args[0], args[2], args[1]));
            } else {
                newArgs.add(String.format(Locale.ROOT, "SUBSTRING(%s, %s + %s)", args[0], args[2], args[3]));
            }
            return EscapeFunction.normalFN("CONCAT", newArgs.toArray(new String[0]));
        }),
        OVERLAY(args -> {
            Preconditions.checkArgument((args.length == 3 || args.length == 4 ? 1 : 0) != 0, (Object)EscapeFunction.OVERLAY_EXCEPTION_MSG);
            String newArg = args.length == 3 ? String.format(Locale.ROOT, "%s PLACING %s FROM %s", args[0], args[1], args[2]) : String.format(Locale.ROOT, "%s PLACING %s FROM %s for %s", args[0], args[1], args[2], args[3]);
            return EscapeFunction.normalFN("OVERLAY", new String[]{newArg});
        }),
        GROUPING(args -> {
            Preconditions.checkArgument((args.length > 0 ? 1 : 0) != 0);
            return EscapeFunction.normalFN("GROUPING", args);
        }),
        SETS_SPARK(args -> {
            Preconditions.checkArgument((args.length > 0 ? 1 : 0) != 0);
            String groupByColumns = args[0].trim();
            if (groupByColumns.startsWith("(") && groupByColumns.endsWith(")")) {
                groupByColumns = groupByColumns.substring(1, groupByColumns.length() - 1);
            }
            return String.format(Locale.ROOT, "%s grouping sets(%s)", groupByColumns, String.join((CharSequence)",", args));
        }),
        SETS(args -> {
            Preconditions.checkArgument((args.length > 0 ? 1 : 0) != 0);
            return String.format(Locale.ROOT, "grouping sets(%s)", String.join((CharSequence)",", args));
        }),
        CEIL2(args -> {
            Preconditions.checkArgument((args.length == 1 || args.length == 2 ? 1 : 0) != 0, (Object)"ceil function only support ceil(numeric) or ceil(datetime to timeunit)");
            if (args.length == 1) {
                return EscapeFunction.normalFN("CEIL", args);
            }
            String[] newArgs = new String[]{args[0], "'" + args[1].toUpperCase(Locale.ROOT) + "'"};
            return EscapeFunction.normalFN("CEIL_DATETIME", newArgs);
        }),
        CEIL(args -> {
            String[] stringArray;
            Preconditions.checkArgument((args.length == 1 || args.length == 2 ? 1 : 0) != 0, (Object)"ceil function only support ceil(numeric) or ceil(datetime to timeunit)");
            if (args.length == 1) {
                stringArray = args;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = args[0] + " to " + args[1];
            }
            String[] newArgs = stringArray;
            return EscapeFunction.normalFN("CEIL", newArgs);
        }),
        FLOOR2(args -> {
            Preconditions.checkArgument((args.length == 1 || args.length == 2 ? 1 : 0) != 0, (Object)"ceil function only support ceil(numeric) or ceil(datetime to timeunit)");
            if (args.length == 1) {
                return EscapeFunction.normalFN("FLOOR", args);
            }
            String[] newArgs = new String[]{args[0].trim(), "'" + args[1].toUpperCase(Locale.ROOT) + "'"};
            return EscapeFunction.normalFN("FLOOR_DATETIME", newArgs);
        }),
        FLOOR(args -> {
            String[] stringArray;
            Preconditions.checkArgument((args.length == 1 || args.length == 2 ? 1 : 0) != 0, (Object)"ceil function only support ceil(numeric) or ceil(datetime to timeunit)");
            if (args.length == 1) {
                stringArray = args;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = args[0] + " to " + args[1];
            }
            String[] newArgs = stringArray;
            return EscapeFunction.normalFN("FLOOR", newArgs);
        }),
        SPACE(args -> {
            EscapeFunction.checkArgs(args, 1);
            return EscapeFunction.normalFN("SPACE", args);
        }),
        CHR(args -> {
            EscapeFunction.checkArgs(args, 1);
            return EscapeFunction.normalFN("CHR", args);
        }),
        ASCII(args -> {
            EscapeFunction.checkArgs(args, 1);
            return EscapeFunction.normalFN("ASCII", args);
        });

        private final IConvert innerCvt;

        private FnConversion(IConvert convert) {
            this.innerCvt = convert;
        }

        public String convert(String[] args) {
            return this.innerCvt.convert(args);
        }

        private static interface IConvert {
            public String convert(String[] var1);
        }
    }
}

