/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import org.apache.kylin.common.KapConfig;
import org.apache.kylin.query.IQueryTransformer;
import org.apache.kylin.query.util.EscapeDialect;
import org.apache.kylin.query.util.EscapeParser;
import org.apache.kylin.query.util.RawSqlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EscapeTransformer
implements IQueryTransformer {
    private static final Logger logger = LoggerFactory.getLogger(EscapeTransformer.class);
    private EscapeDialect dialect = EscapeDialect.DEFAULT;

    @Override
    public String transform(String sql, String project, String defaultSchema) {
        if (!KapConfig.getInstanceFromEnv().isJdbcEscapeEnabled()) {
            return sql;
        }
        return this.transform(sql);
    }

    public String transform(String sql) {
        try {
            sql = new RawSqlParser(sql).parse().getStatementString();
        }
        catch (Throwable ex) {
            logger.error("Something unexpected while CommentParser transforming the query, return original query", ex);
            logger.error(sql);
        }
        try {
            EscapeParser parser = new EscapeParser(this.dialect, sql);
            String result = parser.Input();
            logger.debug("EscapeParser done parsing");
            return result;
        }
        catch (Throwable ex) {
            logger.error("Something unexpected while EscapeTransformer transforming the query, return original query", ex);
            logger.error(sql);
            return sql;
        }
    }

    public void setFunctionDialect(EscapeDialect newDialect) {
        this.dialect = newDialect;
    }
}

