/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexNode;
import org.apache.kylin.common.util.Pair;

public class KapRelUtil {
    private static final String CTX = "ctx=";

    private KapRelUtil() {
    }

    public static String getDigestWithoutRelNodeId(String digest, long layoutId, String modelId) {
        StringBuilder digestWithoutId = new StringBuilder();
        boolean isPointToId = false;
        for (char c : digest.toCharArray()) {
            if (isPointToId && !KapRelUtil.isCharNum(c)) {
                isPointToId = false;
            }
            if (isPointToId) continue;
            if (c == '#') {
                isPointToId = true;
            }
            digestWithoutId.append(c);
        }
        return KapRelUtil.replaceDigestCtxValueByLayoutIdAndModelId(digestWithoutId.toString(), layoutId, modelId);
    }

    public static String replaceDigestCtxValueByLayoutIdAndModelId(String digestId, long layoutId, String modelId) {
        if (layoutId <= 0L || "".equals(modelId)) {
            return digestId;
        }
        StringBuilder digestBuilder = new StringBuilder();
        char[] digestArray = digestId.toCharArray();
        char[] compareArray = CTX.toCharArray();
        int len = digestArray.length;
        for (int i = 0; i < len; ++i) {
            char c1 = digestArray[i];
            if (c1 == compareArray[0] && i + 3 < len && digestArray[i + 1] == compareArray[1] && digestArray[i + 2] == compareArray[2] && digestArray[i + 3] == compareArray[3]) {
                digestBuilder.append(CTX);
                i += 2;
                while (digestArray[i + 1] != ',' && digestArray[i + 1] != ')') {
                    ++i;
                }
                digestBuilder.append(modelId + "_" + layoutId);
                continue;
            }
            digestBuilder.append(c1);
        }
        return digestBuilder.toString();
    }

    private static boolean isCharNum(char c) {
        return c >= '0' && c <= '9';
    }

    public static RexNode isNotDistinctFrom(RelNode left, RelNode right, RexNode condition, List<Pair<Integer, Integer>> pairs, List<Boolean> filterNulls) {
        ArrayList leftKeys = new ArrayList();
        ArrayList rightKeys = new ArrayList();
        RexNode rexNode = RelOptUtil.splitJoinCondition((RelNode)left, (RelNode)right, (RexNode)condition, leftKeys, rightKeys, filterNulls);
        for (int i = 0; i < leftKeys.size(); ++i) {
            pairs.add((Pair<Integer, Integer>)new Pair(leftKeys.get(i), (Object)((Integer)rightKeys.get(i) + left.getRowType().getFieldCount())));
        }
        return rexNode;
    }
}

