/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.exception.CalciteNotSupportException;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.KylinTimeoutException;
import org.apache.kylin.common.exception.QueryErrorCode;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.querymeta.SelectedColumnMeta;
import org.apache.kylin.metadata.realization.RoutingIndicatorException;
import org.apache.kylin.query.exception.NoAuthorizedColsError;
import org.apache.kylin.query.security.AccessDeniedException;
import org.apache.kylin.query.util.AsyncQueryUtil;
import org.apache.kylin.query.util.QueryParams;
import org.apache.kylin.query.util.QueryUtil;
import org.apache.kylin.source.adhocquery.IPushDownRunner;
import org.apache.kylin.source.adhocquery.PushdownResult;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushDownUtil {
    private static final Logger logger = LoggerFactory.getLogger(PushDownUtil.class);
    private static final ExecutorService asyncExecutor = Executors.newCachedThreadPool();

    private PushDownUtil() {
    }

    public static PushdownResult tryPushDownQueryToIterator(QueryParams queryParams) throws Exception {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        NProjectManager prjManager = NProjectManager.getInstance((KylinConfig)kylinConfig);
        ProjectInstance prj = prjManager.getProject(queryParams.getProject());
        String sql = queryParams.getSql();
        String project = queryParams.getProject();
        kylinConfig = prj.getConfig();
        if (!kylinConfig.isPushDownEnabled()) {
            SQLException sqlException = queryParams.getSqlException();
            if (queryParams.isForcedToPushDown() || sqlException != null && sqlException.getMessage().contains("should route use forcedToTieredStorage")) {
                throw new KylinException((ErrorCodeSupplier)QueryErrorCode.INVALID_PARAMETER_PUSH_DOWN, MsgPicker.getMsg().getDisablePushDownPrompt());
            }
            return null;
        }
        if (queryParams.isSelect()) {
            logger.info("Query:[{}] failed to utilize pre-calculation, routing to other engines", (Object)QueryContext.current().getMetrics().getCorrectedSql(), (Object)queryParams.getSqlException());
            if (!queryParams.isForcedToPushDown() && !PushDownUtil.isExpectedCause(queryParams.getSqlException())) {
                logger.info("quit doPushDownQuery because prior exception thrown is unexpected");
                return null;
            }
        } else {
            Preconditions.checkState((queryParams.getSqlException() == null ? 1 : 0) != 0);
            logger.info("Kylin cannot support non-select queries, routing to other engines");
        }
        IPushDownRunner runner = (IPushDownRunner)ClassUtil.newInstance((String)kylinConfig.getPushDownRunnerClassName());
        runner.init(kylinConfig, project);
        logger.debug("Query Pushdown runner {}", (Object)runner);
        int sourceType = ((NProjectManager)kylinConfig.getManager(NProjectManager.class)).getProject(queryParams.getProject()).getSourceType();
        String pushdownEngine = sourceType == 9 && KapConfig.getInstanceFromEnv().isCloud() ? "OBJECT STORAGE" : runner.getName();
        QueryContext.current().setPushdownEngine(pushdownEngine);
        queryParams.setKylinConfig(kylinConfig);
        queryParams.setSql(sql);
        try {
            sql = QueryUtil.massagePushDownSql(queryParams);
        }
        catch (NoAuthorizedColsError e) {
            return PushdownResult.emptyResult();
        }
        QueryContext.currentTrace().startSpan("PREPARE_AND_SUBMIT_JOB");
        if (queryParams.isSelect()) {
            PushdownResult result = runner.executeQueryToIterator(sql, project);
            if (QueryContext.current().getQueryTagInfo().isAsyncQuery()) {
                AsyncQueryUtil.saveMetaDataAndFileInfo(QueryContext.current(), result.getColumnMetas());
            }
            return result;
        }
        return PushdownResult.emptyResult();
    }

    public static Pair<String, String> getMaxAndMinTimeWithTimeOut(String partitionColumn, String table, String project) throws Exception {
        Pair pushdownResult;
        Future<Pair> pushDownTask = asyncExecutor.submit(() -> {
            try {
                return PushDownUtil.getMaxAndMinTime(partitionColumn, table, project);
            }
            catch (Exception e) {
                logger.error("Failed to get partition column latest data range by push down!", (Throwable)e);
                if (e instanceof KylinException) {
                    throw e;
                }
                return null;
            }
        });
        try {
            pushdownResult = pushDownTask.get(30L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            pushDownTask.cancel(true);
            throw new KylinTimeoutException("The query exceeds the set time limit of " + KylinConfig.getInstanceFromEnv().getQueryTimeoutSeconds() + "s. Current step: Getting latest data range by push down. ");
        }
        return pushdownResult;
    }

    public static Pair<String, String> getMaxAndMinTime(String partitionColumn, String table, String project) throws Exception {
        Pair<String, String> pair = PushDownUtil.addBackTickForIdentity(table, partitionColumn);
        String sql = String.format(Locale.ROOT, "select min(%s), max(%s) from %s", pair.getSecond(), pair.getSecond(), pair.getFirst());
        Pair result = new Pair();
        List returnRows = (List)PushDownUtil.selectPartitionColumn(sql, table, project).getFirst();
        if (returnRows.isEmpty() || ((List)returnRows.get(0)).get(0) == null || ((List)returnRows.get(0)).get(1) == null) {
            throw new BadRequestException(String.format(Locale.ROOT, MsgPicker.getMsg().getNoDataInTable(), table));
        }
        result.setFirst(((List)returnRows.get(0)).get(0));
        result.setSecond(((List)returnRows.get(0)).get(1));
        return result;
    }

    public static boolean needPushdown(String start, String end) {
        return StringUtils.isEmpty((String)start) && StringUtils.isEmpty((String)end);
    }

    public static Pair<List<List<String>>, List<SelectedColumnMeta>> selectPartitionColumn(String sql, String table, String project) throws Exception {
        NTableMetadataManager tableMgr = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        TableDesc tableDesc = tableMgr.getTableDesc(table);
        if (tableDesc.isView()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.VIEW_PARTITION_DATE_FORMAT_DETECTION_FORBIDDEN, MsgPicker.getMsg().getViewDateFormatDetectionError());
        }
        NProjectManager prjManager = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        ProjectInstance prj = prjManager.getProject(project);
        KylinConfigExt kylinConfig = prj.getConfig();
        ArrayList returnRows = Lists.newArrayList();
        ArrayList returnColumnMeta = Lists.newArrayList();
        IPushDownRunner runner = (IPushDownRunner)ClassUtil.newInstance((String)kylinConfig.getPartitionCheckRunnerClassNameWithDefaultValue());
        runner.init((KylinConfig)kylinConfig, project);
        runner.executeQuery(sql, (List)returnRows, (List)returnColumnMeta, project);
        return Pair.newPair((Object)returnRows, (Object)returnColumnMeta);
    }

    public static void trySimplePushDownExecute(String sql, String project) throws Exception {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        IPushDownRunner runner = (IPushDownRunner)ClassUtil.newInstance((String)kylinConfig.getPushDownRunnerClassName());
        runner.init(kylinConfig, project);
        runner.executeUpdate(sql, project);
    }

    public static String getFormatIfNotExist(String table, String partitionColumn, String project) throws Exception {
        Pair<String, String> pair = PushDownUtil.addBackTickForIdentity(table, partitionColumn);
        String sql = String.format(Locale.ROOT, "select %s from %s where %s is not null limit 1", pair.getSecond(), pair.getFirst(), pair.getSecond());
        List returnRows = (List)PushDownUtil.selectPartitionColumn(sql, table, project).getFirst();
        if (CollectionUtils.isEmpty((Collection)returnRows) || CollectionUtils.isEmpty((Collection)((Collection)returnRows.get(0)))) {
            throw new KylinException((ErrorCodeSupplier)QueryErrorCode.EMPTY_TABLE, String.format(Locale.ROOT, MsgPicker.getMsg().getNoDataInTable(), table));
        }
        return (String)((List)returnRows.get(0)).get(0);
    }

    private static boolean isExpectedCause(SQLException sqlException) {
        Preconditions.checkArgument((sqlException != null ? 1 : 0) != 0);
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)sqlException);
        if (rootCause instanceof KylinTimeoutException) {
            return false;
        }
        if (rootCause instanceof AccessDeniedException) {
            return false;
        }
        if (rootCause instanceof RoutingIndicatorException) {
            return true;
        }
        if (rootCause instanceof CalciteNotSupportException) {
            return true;
        }
        if (rootCause instanceof CompileException) {
            return true;
        }
        if (QueryContext.current().getQueryTagInfo().isWithoutSyntaxError()) {
            logger.warn("route to push down for met error when running the query: {}", (Object)QueryContext.current().getMetrics().getCorrectedSql(), (Object)sqlException);
            return true;
        }
        return false;
    }

    public static String calcStart(String start, SegmentRange<?> coveredRange) {
        if (coveredRange != null) {
            start = coveredRange.getEnd().toString();
        }
        return start;
    }

    public static Pair<List<List<String>>, List<SelectedColumnMeta>> tryPushDownQuery(QueryParams queryParams) throws Exception {
        PushdownResult results = PushDownUtil.tryPushDownQueryToIterator(queryParams);
        if (results == null) {
            return null;
        }
        return new Pair((Object)ImmutableList.copyOf((Iterable)results.getRows()), (Object)results.getColumnMetas());
    }

    protected static Pair<String, String> addBackTickForIdentity(String table, String partitionColumn) {
        String tableName = Arrays.stream(table.split("\\.")).map(s -> "`" + s + "`").collect(Collectors.joining("."));
        String partitionColumnName = Arrays.stream(partitionColumn.split("\\.")).map(s -> "`" + s + "`").collect(Collectors.joining("."));
        return Pair.newPair((Object)tableName, (Object)partitionColumnName);
    }
}

