/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlAsOperator;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.ColExcludedChecker;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.JoinsGraph;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.model.alias.AliasDeduce;
import org.apache.kylin.metadata.model.alias.AliasMapping;
import org.apache.kylin.metadata.model.alias.ExpressionComparator;
import org.apache.kylin.metadata.model.tool.CalciteParser;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.schema.KapOLAPSchema;
import org.apache.kylin.query.schema.OLAPTable;
import org.apache.kylin.query.util.AliasDeduceImpl;
import org.apache.kylin.query.util.QueryAliasMatchInfo;

public class QueryAliasMatcher {
    static final ColumnRowType MODEL_VIEW_COLUMN_ROW_TYPE = new ColumnRowType(new ArrayList<TblColRef>());
    private static final ColumnRowType SUBQUERY_TAG = new ColumnRowType(null);
    private static final String[] COLUMN_ARRAY_MARKER = new String[0];
    private final String project;
    private final String defaultSchema;
    private final Map<String, KapOLAPSchema> schemaMap = Maps.newHashMap();
    private final Map<String, Map<String, OLAPTable>> schemaTables = Maps.newHashMap();
    private final ColExcludedChecker checker;

    public QueryAliasMatcher(String project, String defaultSchema) {
        this.project = project;
        this.defaultSchema = defaultSchema;
        this.checker = new ColExcludedChecker(KylinConfig.getInstanceFromEnv(), project, null);
    }

    static TblColRef resolveTblColRef(SqlIdentifier sqlIdentifier, LinkedHashMap<String, ColumnRowType> alias2CRT) {
        TblColRef ret = null;
        ImmutableList namesOfIdentifier = sqlIdentifier.names;
        if (namesOfIdentifier.size() == 3) {
            String tableAlias = (String)namesOfIdentifier.get(1);
            String colName = (String)namesOfIdentifier.get(2);
            ColumnRowType columnRowType = alias2CRT.get(tableAlias);
            Preconditions.checkState((columnRowType != null ? 1 : 0) != 0, (String)"Alias {} is not defined", (Object[])new Object[]{tableAlias});
            return columnRowType == SUBQUERY_TAG ? null : columnRowType.getColumnByName(colName);
        }
        if (namesOfIdentifier.size() == 2) {
            String tableAlias = (String)namesOfIdentifier.get(0);
            String colName = (String)namesOfIdentifier.get(1);
            ColumnRowType columnRowType = alias2CRT.get(tableAlias);
            Preconditions.checkState((columnRowType != null ? 1 : 0) != 0, (String)"Alias {} is not defined", (Object[])new Object[]{tableAlias});
            return columnRowType == SUBQUERY_TAG ? null : columnRowType.getColumnByName(colName);
        }
        if (namesOfIdentifier.size() == 1) {
            String col = (String)namesOfIdentifier.get(0);
            ret = QueryAliasMatcher.resolveTblColRef(alias2CRT, col);
        }
        return ret;
    }

    static TblColRef resolveTblColRef(LinkedHashMap<String, ColumnRowType> alias2CRT, String col) {
        ArrayList potentialAlias = Lists.newArrayList();
        for (Map.Entry<String, ColumnRowType> entry : alias2CRT.entrySet()) {
            if (entry.getValue() == SUBQUERY_TAG || entry.getValue().getColumnByName(col) == null) continue;
            potentialAlias.add(entry.getKey());
        }
        if (potentialAlias.size() == 1) {
            ColumnRowType columnRowType = alias2CRT.get(potentialAlias.get(0));
            return columnRowType.getColumnByName(col);
        }
        if (potentialAlias.size() > 1) {
            throw new IllegalStateException("The column " + col + " is found on multiple alias: " + StringUtils.join((Collection)potentialAlias, (String)","));
        }
        throw new IllegalStateException("The column " + col + " can't be found");
    }

    public QueryAliasMatchInfo match(NDataModel model, SqlSelect sqlSelect) {
        HashBiMap aliasMapping;
        Map matches;
        Map.Entry<String, ColumnRowType> entry;
        if (sqlSelect.getFrom() == null || SqlKind.VALUES == sqlSelect.getFrom().getKind()) {
            return null;
        }
        SqlSelect subQuery = this.getSubQuery(sqlSelect.getFrom());
        boolean reUseSubqeury = false;
        if (subQuery != null) {
            if (subQuery.getSelectList().size() == 1 && subQuery.getSelectList().get(0).toString().equals("*") && subQuery.getFrom() instanceof SqlIdentifier) {
                reUseSubqeury = true;
            } else {
                return null;
            }
        }
        SqlJoinCapturer sqlJoinCapturer = new SqlJoinCapturer(model.getAlias());
        if (reUseSubqeury) {
            subQuery.getFrom().accept((SqlVisitor)sqlJoinCapturer);
        } else {
            sqlSelect.getFrom().accept((SqlVisitor)sqlJoinCapturer);
        }
        LinkedHashMap<String, ColumnRowType> queryAlias = sqlJoinCapturer.getAlias2CRT();
        if (queryAlias.size() == 1 && (entry = queryAlias.entrySet().iterator().next()).getValue() == MODEL_VIEW_COLUMN_ROW_TYPE) {
            return QueryAliasMatchInfo.fromModelView(entry.getKey(), model);
        }
        List<JoinDesc> joinDescs = sqlJoinCapturer.getJoinDescs();
        TableRef firstTable = sqlJoinCapturer.getFirstTable();
        if (firstTable == null) {
            return null;
        }
        JoinsGraph joinsGraph = new JoinsGraph(firstTable, joinDescs);
        KylinConfigExt projectConfig = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(this.project).getConfig();
        if (sqlJoinCapturer.foundJoinOnCC) {
            joinsGraph.setJoinEdgeMatcher((JoinsGraph.IJoinEdgeMatcher)new CCJoinEdgeMatcher(null, false));
            matches = joinsGraph.matchAlias(model.getJoinsGraph(), (KylinConfig)projectConfig);
            if (matches == null || matches.isEmpty()) {
                return null;
            }
            aliasMapping = HashBiMap.create();
            aliasMapping.putAll(matches);
            QueryAliasMatchInfo ccAliasMatch = new QueryAliasMatchInfo((BiMap<String, String>)aliasMapping, queryAlias);
            joinsGraph.setJoinEdgeMatcher((JoinsGraph.IJoinEdgeMatcher)new CCJoinEdgeMatcher(ccAliasMatch, true));
        }
        if (MapUtils.isEmpty((Map)(matches = joinsGraph.matchAlias(model.getJoinsGraph(), (KylinConfig)projectConfig)))) {
            return null;
        }
        aliasMapping = HashBiMap.create();
        aliasMapping.putAll(matches);
        return new QueryAliasMatchInfo((BiMap<String, String>)aliasMapping, queryAlias);
    }

    private SqlSelect getSubQuery(SqlNode sqlNode) {
        if (sqlNode instanceof SqlSelect) {
            return (SqlSelect)sqlNode;
        }
        if (SqlKind.UNION == sqlNode.getKind()) {
            return (SqlSelect)((SqlBasicCall)sqlNode).getOperandList().get(0);
        }
        if (SqlKind.AS == sqlNode.getKind()) {
            return this.getSubQuery((SqlNode)((SqlBasicCall)sqlNode).getOperandList().get(0));
        }
        return null;
    }

    @Generated
    public ColExcludedChecker getChecker() {
        return this.checker;
    }

    private static class JoinConditionCapturer
    extends SqlBasicVisitor<SqlNode> {
        private final LinkedHashMap<String, ColumnRowType> alias2CRT;
        private final String joinType;
        private final List<TblColRef> pks = Lists.newArrayList();
        private final List<TblColRef> fks = Lists.newArrayList();
        private boolean foundCC = false;
        private boolean foundNonEqualJoin = false;

        JoinConditionCapturer(LinkedHashMap<String, ColumnRowType> alias2CRT, String joinType) {
            this.alias2CRT = alias2CRT;
            this.joinType = joinType;
        }

        public JoinDesc getJoinDescs() {
            List<String> pkNames = this.pks.stream().map(input -> input == null ? null : input.getName()).collect(Collectors.toList());
            List<String> fkNames = this.fks.stream().map(input -> input == null ? null : input.getName()).collect(Collectors.toList());
            JoinDesc join = new JoinDesc();
            join.setType(this.joinType);
            join.setForeignKey(fkNames.toArray(COLUMN_ARRAY_MARKER));
            join.setForeignKeyColumns(this.fks.toArray(new TblColRef[0]));
            join.setPrimaryKey(pkNames.toArray(COLUMN_ARRAY_MARKER));
            join.setPrimaryKeyColumns(this.pks.toArray(new TblColRef[0]));
            join.sortByFK();
            return join;
        }

        public SqlNode visit(SqlNodeList nodeList) {
            return null;
        }

        private TblColRef resolveComputedColumnRef(SqlCall call, String ... tableCandidates) {
            this.foundCC = true;
            String table = this.findComputedColumnTable(call, tableCandidates);
            ColumnDesc columnDesc = new ColumnDesc("-1", RandomUtil.randomUUIDStr(), "string", "", null, null, call.toSqlString(CalciteSqlDialect.DEFAULT).getSql());
            TableRef tableRef = this.alias2CRT.get(table).getColumnByIndex(0).getTableRef();
            columnDesc.setTable(tableRef.getTableDesc());
            return TblColRef.columnForUnknownModel((TableRef)tableRef, (ColumnDesc)columnDesc);
        }

        private String findComputedColumnTable(SqlCall call, final String ... tableCandidates) {
            final String[] result = new String[1];
            SqlBasicVisitor<SqlNode> visitor = new SqlBasicVisitor<SqlNode>(){

                public SqlNode visit(SqlIdentifier sqlIdentifier) {
                    TblColRef colRef = QueryAliasMatcher.resolveTblColRef(sqlIdentifier, alias2CRT);
                    for (String table : tableCandidates) {
                        if (!((ColumnRowType)alias2CRT.get(table)).getAllColumns().contains(colRef)) continue;
                        result[0] = table;
                        return sqlIdentifier;
                    }
                    return null;
                }
            };
            visitor.visit(call);
            Preconditions.checkNotNull((Object)result[0], (Object)("Table not found for SqlCall: " + call.toString()));
            return result[0];
        }

        public SqlNode visit(SqlCall call) {
            if (call instanceof SqlBasicCall && call.getOperator() instanceof SqlBinaryOperator) {
                if (call.getOperator().getKind() == SqlKind.AND) {
                    for (SqlNode operand : call.getOperandList()) {
                        if (operand == null) continue;
                        operand.accept((SqlVisitor)this);
                    }
                    return null;
                }
                if (call.getOperator().getKind() == SqlKind.EQUALS && call.getOperandList().size() == 2) {
                    SqlNode operand0 = (SqlNode)call.getOperandList().get(0);
                    SqlNode operand1 = (SqlNode)call.getOperandList().get(1);
                    if ((operand0 instanceof SqlIdentifier || operand0 instanceof SqlCall) && (operand1 instanceof SqlIdentifier || operand1 instanceof SqlCall)) {
                        TblColRef tblColRef1;
                        int numOfAlias = this.alias2CRT.size();
                        String pkAlias = (String)Iterables.getLast(this.alias2CRT.keySet());
                        String fkAlias = (String)Iterables.get(this.alias2CRT.keySet(), (int)(numOfAlias - 2));
                        TblColRef tblColRef0 = operand0 instanceof SqlIdentifier ? QueryAliasMatcher.resolveTblColRef((SqlIdentifier)operand0, this.alias2CRT) : this.resolveComputedColumnRef((SqlCall)operand0, pkAlias, fkAlias);
                        TblColRef tblColRef = tblColRef1 = operand1 instanceof SqlIdentifier ? QueryAliasMatcher.resolveTblColRef((SqlIdentifier)operand1, this.alias2CRT) : this.resolveComputedColumnRef((SqlCall)operand1, pkAlias, fkAlias);
                        if (tblColRef0 == null || tblColRef1 == null) {
                            return null;
                        }
                        if (tblColRef1.getTableRef().getAlias().equals(pkAlias)) {
                            this.pks.add(tblColRef1);
                            this.fks.add(tblColRef0);
                        } else if (tblColRef0.getTableRef().getAlias().equals(pkAlias)) {
                            this.pks.add(tblColRef0);
                            this.fks.add(tblColRef1);
                        }
                        return null;
                    }
                }
            }
            this.foundNonEqualJoin = true;
            return null;
        }
    }

    private class SqlJoinCapturer
    extends SqlBasicVisitor<SqlNode> {
        private final List<JoinDesc> joinDescs;
        private final LinkedHashMap<String, ColumnRowType> alias2CRT = Maps.newLinkedHashMap();
        private final String modelName;
        private boolean foundJoinOnCC = false;

        SqlJoinCapturer(String modelName) {
            this.joinDescs = new ArrayList<JoinDesc>();
            this.modelName = modelName;
        }

        List<JoinDesc> getJoinDescs() {
            return this.joinDescs;
        }

        LinkedHashMap<String, ColumnRowType> getAlias2CRT() {
            return this.alias2CRT;
        }

        TableRef getFirstTable() {
            if (this.alias2CRT.size() == 0) {
                throw new IllegalStateException("alias2CRT is empty");
            }
            ColumnRowType first = (ColumnRowType)Iterables.getFirst(this.alias2CRT.values(), null);
            Preconditions.checkNotNull((Object)first);
            if (first.getAllColumns() == null || first.getAllColumns().isEmpty()) {
                return null;
            }
            return first.getAllColumns().get(0).getTableRef();
        }

        public SqlNode visit(SqlNodeList nodeList) {
            return null;
        }

        public SqlNode visit(SqlCall call) {
            if (call instanceof SqlSelect) {
                return null;
            }
            if (call instanceof SqlBasicCall && call.getOperator() instanceof SqlAsOperator) {
                SqlNode[] operands = ((SqlBasicCall)call).getOperands();
                if (operands != null && operands.length == 2) {
                    String alias;
                    if (operands[0] instanceof SqlIdentifier && operands[1] instanceof SqlIdentifier) {
                        alias = operands[1].toString();
                        SqlIdentifier tableIdentifier = (SqlIdentifier)operands[0];
                        Pair<String, String> schemaAndTable = this.getSchemaAndTable(tableIdentifier);
                        ColumnRowType columnRowType = this.buildColumnRowType(alias, (String)schemaAndTable.getFirst(), (String)schemaAndTable.getSecond());
                        this.alias2CRT.put(alias, columnRowType);
                    }
                    if (operands[0] instanceof SqlSelect || operands[0] instanceof SqlOrderBy && operands[1] instanceof SqlIdentifier) {
                        alias = operands[1].toString();
                        this.alias2CRT.put(alias, SUBQUERY_TAG);
                    }
                    if (operands[0] instanceof SqlBasicCall && operands[0].getKind() == SqlKind.UNION && operands[1] instanceof SqlIdentifier) {
                        alias = operands[1].toString();
                        this.alias2CRT.put(alias, SUBQUERY_TAG);
                    }
                }
                return null;
            }
            List operandList = call.getOperandList();
            List operands = call instanceof SqlJoin ? operandList.subList(0, operandList.size() - 1) : operandList;
            for (SqlNode operand : operands) {
                if (operand == null) continue;
                operand.accept((SqlVisitor)this);
            }
            if (call instanceof SqlJoin) {
                SqlJoin join = (SqlJoin)call;
                if (join.getConditionType() != JoinConditionType.ON) {
                    throw new IllegalArgumentException("JoinConditionType is not ON: " + join.toSqlString(CalciteSqlDialect.DEFAULT));
                }
                if (join.getJoinType() != JoinType.INNER && join.getJoinType() != JoinType.LEFT) {
                    throw new IllegalArgumentException("JoinType must be INNER or LEFT");
                }
                if (join.getCondition() instanceof SqlBasicCall) {
                    JoinConditionCapturer joinConditionCapturer = new JoinConditionCapturer(this.alias2CRT, join.getJoinType().toString());
                    join.getCondition().accept((SqlVisitor)joinConditionCapturer);
                    JoinDesc joinDesc = joinConditionCapturer.getJoinDescs();
                    boolean bl = this.foundJoinOnCC = this.foundJoinOnCC || joinConditionCapturer.foundCC;
                    if (joinDesc.getForeignKey().length != 0 && !joinConditionCapturer.foundNonEqualJoin) {
                        this.joinDescs.add(joinDesc);
                    }
                } else {
                    throw new IllegalArgumentException("join condition should be SqlBasicCall");
                }
            }
            return null;
        }

        public SqlNode visit(SqlIdentifier id) {
            Pair<String, String> schemaAndTable = this.getSchemaAndTable(id);
            ColumnRowType columnRowType = this.buildColumnRowType((String)schemaAndTable.getSecond(), (String)schemaAndTable.getFirst(), (String)schemaAndTable.getSecond());
            this.alias2CRT.put((String)schemaAndTable.getSecond(), columnRowType);
            return null;
        }

        private ColumnRowType buildColumnRowType(String alias, String schemaName, String tableName) {
            OLAPTable olapTable = this.getTable(schemaName.toUpperCase(Locale.ROOT), tableName);
            if (olapTable == null && schemaName.equalsIgnoreCase(QueryAliasMatcher.this.project) && tableName.equalsIgnoreCase(this.modelName)) {
                return MODEL_VIEW_COLUMN_ROW_TYPE;
            }
            ArrayList<TblColRef> columns = new ArrayList<TblColRef>();
            if (olapTable != null) {
                TableRef tableRef = TblColRef.tableForUnknownModel((String)alias, (TableDesc)olapTable.getSourceTable());
                for (ColumnDesc sourceColumn : olapTable.getSourceColumns()) {
                    TblColRef colRef = TblColRef.columnForUnknownModel((TableRef)tableRef, (ColumnDesc)sourceColumn);
                    columns.add(colRef);
                }
            }
            return new ColumnRowType(columns);
        }

        private OLAPTable getTable(String schemaName, String tableName) {
            Map localTables = (Map)QueryAliasMatcher.this.schemaTables.get(schemaName);
            if (localTables == null) {
                KapOLAPSchema olapSchema = this.getSchema(schemaName);
                if (!olapSchema.hasTables()) {
                    return null;
                }
                localTables = Maps.newHashMap();
                for (Map.Entry<String, Table> entry : olapSchema.getTableMap().entrySet()) {
                    localTables.put(entry.getKey(), (OLAPTable)entry.getValue());
                }
                QueryAliasMatcher.this.schemaTables.put(schemaName, localTables);
            }
            return (OLAPTable)((Object)localTables.get(tableName));
        }

        private KapOLAPSchema getSchema(String name) {
            return QueryAliasMatcher.this.schemaMap.computeIfAbsent(name, schemaName -> new KapOLAPSchema(QueryAliasMatcher.this.project, (String)schemaName, (List)NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)QueryAliasMatcher.this.project).listTablesGroupBySchema().get(schemaName), NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)QueryAliasMatcher.this.project).getModelsGroupbyTable()));
        }

        private Pair<String, String> getSchemaAndTable(SqlIdentifier tableIdentifier) {
            String tableName;
            String schemaName;
            if (tableIdentifier.names.size() == 2) {
                schemaName = (String)tableIdentifier.names.get(0);
                tableName = (String)tableIdentifier.names.get(1);
            } else if (tableIdentifier.names.size() == 1) {
                schemaName = QueryAliasMatcher.this.defaultSchema;
                tableName = (String)tableIdentifier.names.get(0);
            } else {
                throw new IllegalStateException("table.names size being " + tableIdentifier.names.size());
            }
            return Pair.newPair((Object)schemaName, (Object)tableName);
        }
    }

    private static class CCJoinEdgeMatcher
    extends JoinsGraph.DefaultJoinEdgeMatcher {
        transient QueryAliasMatchInfo matchInfo;
        boolean compareCCExpr;

        public CCJoinEdgeMatcher(QueryAliasMatchInfo matchInfo, boolean compareCCExpr) {
            this.matchInfo = matchInfo;
            this.compareCCExpr = compareCCExpr;
        }

        protected boolean columnDescEquals(ColumnDesc a, ColumnDesc b) {
            if (a == null) {
                return b == null;
            }
            if (b == null) {
                return false;
            }
            if (!a.isComputedColumn() && !b.isComputedColumn()) {
                return super.columnDescEquals(a, b);
            }
            if (a.isComputedColumn() && !b.isComputedColumn() || !a.isComputedColumn() && b.isComputedColumn()) {
                return false;
            }
            if (!this.compareCCExpr) {
                return true;
            }
            SqlNode node1 = CalciteParser.getExpNode((String)a.getComputedColumnExpr());
            SqlNode node2 = CalciteParser.getExpNode((String)b.getComputedColumnExpr());
            return ExpressionComparator.isNodeEqual((SqlNode)node1, (SqlNode)node2, (AliasMapping)this.matchInfo, (AliasDeduce)new AliasDeduceImpl(this.matchInfo));
        }
    }
}

