/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.util.Util;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.exception.KylinTimeoutException;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.query.BigQueryThresholdUpdater;
import org.apache.kylin.query.IQueryTransformer;
import org.apache.kylin.query.SlowQueryDetector;
import org.apache.kylin.query.exception.UserStopQueryException;
import org.apache.kylin.query.relnode.KapJoinRel;
import org.apache.kylin.query.security.AccessDeniedException;
import org.apache.kylin.query.util.KeywordDefaultDirtyHack;
import org.apache.kylin.query.util.QueryParams;
import org.apache.kylin.query.util.RawSqlParser;
import org.apache.kylin.query.util.RelAggPushDownUtil;
import org.apache.kylin.query.util.RestoreFromComputedColumn;
import org.apache.kylin.source.adhocquery.IPushDownConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryUtil {
    private static final Logger log = LoggerFactory.getLogger((String)"query");
    public static final String DEFAULT_SCHEMA = "DEFAULT";
    public static final ImmutableSet<String> REMOVED_TRANSFORMERS = ImmutableSet.of((Object)"ReplaceStringWithVarchar");
    private static final Pattern SELECT_PATTERN = Pattern.compile("^select", 2);
    private static final Pattern SELECT_STAR_PTN = Pattern.compile("^select\\s+\\*\\p{all}*", 2);
    private static final Pattern LIMIT_PATTERN = Pattern.compile("(limit\\s+\\d+)$", 2);
    private static final String SELECT = "select";
    private static final String COLON = ":";
    private static final String SEMI_COLON = ";";
    public static final String JDBC = "jdbc";
    public static List<IQueryTransformer> queryTransformers = Collections.emptyList();
    public static List<IPushDownConverter> pushDownConverters = Collections.emptyList();
    private static final Pattern SQL_HINT_ERASER = Pattern.compile("/\\*\\s*\\+\\s*(?i)MODEL_PRIORITY\\s*\\([\\s\\S]*\\)\\s*\\*/");

    private QueryUtil() {
    }

    public static boolean isSelectStatement(String sql) {
        String sql1 = sql.toLowerCase(Locale.ROOT);
        sql1 = QueryUtil.removeCommentInSql(sql1);
        sql1 = sql1.trim();
        while (sql1.startsWith("(")) {
            sql1 = sql1.substring(1).trim();
        }
        return sql1.startsWith(SELECT) || sql1.startsWith("with") && sql1.contains(SELECT) || sql1.startsWith("explain") && sql1.contains(SELECT);
    }

    public static boolean isSelectStarStatement(String sql) {
        return SELECT_STAR_PTN.matcher(sql).find();
    }

    public static String removeCommentInSql(String sql) {
        try {
            return new RawSqlParser(sql).parse().getStatementString();
        }
        catch (Exception ex) {
            log.error("Something unexpected while removing comments in the query, return original query", (Throwable)ex);
            return sql;
        }
    }

    public static String makeErrorMsgUserFriendly(Throwable e) {
        String msg = e.getMessage();
        boolean needBreak = false;
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            String className = cause.getClass().getName();
            if (className.contains("ParseException") || className.contains("NoSuchTableException") || className.contains("NoSuchDatabaseException") || cause instanceof AccessDeniedException) {
                msg = cause.getMessage();
                needBreak = true;
            } else if (className.contains("ArithmeticException")) {
                msg = "ArithmeticException: " + cause.getMessage();
                needBreak = true;
            } else if (className.contains("NoStreamingRealizationFoundException")) {
                msg = "NoStreamingRealizationFoundException: " + cause.getMessage();
                needBreak = true;
            }
            if (needBreak) break;
        }
        return QueryUtil.makeErrorMsgUserFriendly(msg);
    }

    public static String makeErrorMsgUserFriendly(String errorMsg) {
        if (StringUtils.isBlank((CharSequence)errorMsg)) {
            return errorMsg;
        }
        String[] split = (errorMsg = errorMsg.trim()).split(COLON);
        if (split.length == 3) {
            String prefix = "Error";
            if (StringUtils.startsWithIgnoreCase((CharSequence)split[0], (CharSequence)prefix)) {
                split[0] = split[0].substring(prefix.length()).trim();
            }
            if (StringUtils.startsWith((CharSequence)split[0], (CharSequence)(prefix = "while executing SQL"))) {
                split[0] = split[0].substring(0, prefix.length()) + COLON + split[0].substring(prefix.length());
            }
            return split[1].trim() + COLON + " " + split[2].trim() + "\n" + split[0];
        }
        return errorMsg;
    }

    public static String addLimit(String originString) {
        if (StringUtils.isBlank((CharSequence)originString)) {
            return originString;
        }
        String replacedString = originString.trim();
        Matcher selectMatcher = SELECT_PATTERN.matcher(replacedString);
        if (!selectMatcher.find()) {
            return originString;
        }
        while (replacedString.endsWith(SEMI_COLON)) {
            replacedString = replacedString.substring(0, replacedString.length() - 1).trim();
        }
        Matcher limitMatcher = LIMIT_PATTERN.matcher(replacedString);
        return limitMatcher.find() ? originString : replacedString.concat(" limit 1");
    }

    public static String massageExpression(NDataModel model, String project, String expression, QueryContext.AclInfo aclInfo, boolean isForPushDown) {
        String tempConst = "'" + RandomUtil.randomUUIDStr() + "'";
        StringBuilder forCC = new StringBuilder();
        forCC.append("select ").append(expression).append(" ,").append(tempConst).append(" FROM ").append(model.getRootFactTable().getTableDesc().getDoubleQuoteIdentity());
        QueryUtil.appendJoinStatement(model, forCC, false);
        String ccSql = KeywordDefaultDirtyHack.transform(forCC.toString());
        try {
            HashMap modelMap = Maps.newHashMap();
            modelMap.put(model.getUuid(), model);
            ccSql = RestoreFromComputedColumn.convertWithGivenModels(ccSql, project, DEFAULT_SCHEMA, modelMap);
            QueryParams queryParams = new QueryParams(project, ccSql, DEFAULT_SCHEMA, false);
            queryParams.setKylinConfig(NProjectManager.getProjectConfig((String)project));
            queryParams.setAclInfo(aclInfo);
            if (isForPushDown) {
                ccSql = QueryUtil.massagePushDownSql(queryParams);
            }
        }
        catch (Exception e) {
            log.warn("Failed to massage SQL expression [{}] with input model {}", new Object[]{ccSql, model.getUuid(), e});
        }
        return ccSql.substring("select ".length(), ccSql.indexOf(tempConst) - 2).trim();
    }

    public static String massageExpression(NDataModel model, String project, String expression, QueryContext.AclInfo aclInfo) {
        return QueryUtil.massageExpression(model, project, expression, aclInfo, true);
    }

    public static String massageComputedColumn(NDataModel model, String project, ComputedColumnDesc cc, QueryContext.AclInfo aclInfo) {
        return QueryUtil.massageExpression(model, project, cc.getExpression(), aclInfo);
    }

    public static void appendJoinStatement(NDataModel model, StringBuilder sql, boolean singleLine) {
        String sep = singleLine ? " " : "\n";
        HashSet dimTableCache = Sets.newHashSet();
        sql.append(sep);
        for (JoinTableDesc lookupDesc : model.getJoinTables()) {
            TblColRef[] fk;
            JoinDesc join = lookupDesc.getJoin();
            TableRef dimTable = lookupDesc.getTableRef();
            if (join == null || StringUtils.isEmpty((CharSequence)join.getType()) || dimTableCache.contains(dimTable)) continue;
            TblColRef[] pk = join.getPrimaryKeyColumns();
            if (pk.length != (fk = join.getForeignKeyColumns()).length) {
                throw new IllegalArgumentException("Invalid join condition of lookup table:" + lookupDesc);
            }
            String joinType = join.getType().toUpperCase(Locale.ROOT);
            sql.append(String.format(Locale.ROOT, "%s JOIN \"%s\".\"%s\" as \"%s\"", joinType, dimTable.getTableDesc().getDatabase(), dimTable.getTableDesc().getName(), dimTable.getAlias()));
            sql.append(sep);
            sql.append("ON ");
            if (pk.length == 0 && join.getNonEquiJoinCondition() != null) {
                sql.append(join.getNonEquiJoinCondition().getExpr());
                dimTableCache.add(dimTable);
                continue;
            }
            String collect = IntStream.range(0, pk.length).mapToObj(i -> fk[i].getDoubleQuoteExpressionInSourceDB() + " = " + pk[i].getDoubleQuoteExpressionInSourceDB()).collect(Collectors.joining(" AND ", "", sep));
            sql.append(collect);
            dimTableCache.add(dimTable);
        }
    }

    public static SqlSelect extractSqlSelect(SqlCall selectOrOrderby) {
        SqlSelect sqlSelect = null;
        if (selectOrOrderby instanceof SqlSelect) {
            sqlSelect = (SqlSelect)selectOrOrderby;
        } else if (selectOrOrderby instanceof SqlOrderBy) {
            SqlOrderBy sqlOrderBy = (SqlOrderBy)selectOrOrderby;
            if (sqlOrderBy.query instanceof SqlSelect) {
                sqlSelect = (SqlSelect)sqlOrderBy.query;
            }
        }
        return sqlSelect;
    }

    public static boolean isJoinOnlyOneAggChild(KapJoinRel joinRel) {
        RelNode joinRightChild;
        RelNode joinLeftChild;
        RelNode joinLeft = joinRel.getLeft();
        RelNode joinRight = joinRel.getRight();
        if (joinLeft instanceof RelSubset && joinRight instanceof RelSubset) {
            RelSubset joinLeftChildSub = (RelSubset)joinLeft;
            RelSubset joinRightChildSub = (RelSubset)joinRight;
            joinLeftChild = (RelNode)Util.first((Object)joinLeftChildSub.getBest(), (Object)joinLeftChildSub.getOriginal());
            joinRightChild = (RelNode)Util.first((Object)joinRightChildSub.getBest(), (Object)joinRightChildSub.getOriginal());
        } else if (joinLeft instanceof HepRelVertex && joinRight instanceof HepRelVertex) {
            joinLeftChild = ((HepRelVertex)joinLeft).getCurrentRel();
            joinRightChild = ((HepRelVertex)joinRight).getCurrentRel();
        } else {
            return false;
        }
        String project = QueryContext.current().getProject();
        if (project != null && NProjectManager.getProjectConfig((String)project).isEnhancedAggPushDownEnabled() && RelAggPushDownUtil.canRelAnsweredBySnapshot(project, joinRight) && RelAggPushDownUtil.isUnmatchedJoinRel(joinRel)) {
            QueryContext.current().setEnhancedAggPushDown(true);
            return true;
        }
        return QueryUtil.isContainAggregate(joinLeftChild) ^ QueryUtil.isContainAggregate(joinRightChild);
    }

    private static boolean isContainAggregate(RelNode node) {
        final boolean[] isContainAggregate = new boolean[]{false};
        new RelVisitor(){

            public void visit(RelNode node, int ordinal, RelNode parent) {
                if (isContainAggregate[0]) {
                    return;
                }
                RelNode relNode = node;
                if (node instanceof RelSubset) {
                    relNode = (RelNode)Util.first((Object)((RelSubset)node).getBest(), (Object)((RelSubset)node).getOriginal());
                } else if (node instanceof HepRelVertex) {
                    relNode = ((HepRelVertex)node).getCurrentRel();
                }
                if (relNode instanceof Aggregate) {
                    isContainAggregate[0] = true;
                }
                super.visit(relNode, ordinal, parent);
            }
        }.go(node);
        return isContainAggregate[0];
    }

    public static boolean isCast(RexNode rexNode) {
        if (!(rexNode instanceof RexCall)) {
            return false;
        }
        return SqlKind.CAST == rexNode.getKind();
    }

    public static boolean isPlainTableColumn(int colIdx, RelNode relNode) {
        if (relNode instanceof HepRelVertex) {
            relNode = ((HepRelVertex)relNode).getCurrentRel();
        }
        if (relNode instanceof TableScan) {
            return true;
        }
        if (relNode instanceof Join) {
            Join join = (Join)relNode;
            int offset = 0;
            for (RelNode input : join.getInputs()) {
                if (colIdx >= offset && colIdx < offset + input.getRowType().getFieldCount()) {
                    return QueryUtil.isPlainTableColumn(colIdx - offset, input);
                }
                offset += input.getRowType().getFieldCount();
            }
        } else if (relNode instanceof Project) {
            RexNode inputRex = (RexNode)((Project)relNode).getProjects().get(colIdx);
            if (inputRex instanceof RexInputRef) {
                return QueryUtil.isPlainTableColumn(((RexInputRef)inputRex).getIndex(), ((Project)relNode).getInput());
            }
        } else if (relNode instanceof Filter) {
            return QueryUtil.isPlainTableColumn(colIdx, relNode.getInput(0));
        }
        return false;
    }

    public static boolean containCast(RexNode rexNode) {
        if (!(rexNode instanceof RexCall)) {
            return false;
        }
        if (SqlKind.CAST == rexNode.getKind()) {
            RexNode operand = (RexNode)((RexCall)rexNode).getOperands().get(0);
            return !(operand instanceof RexCall) || operand.getKind() == SqlKind.CASE;
        }
        return false;
    }

    public static boolean isNotNullLiteral(RexNode node) {
        return !QueryUtil.isNullLiteral(node);
    }

    public static boolean isNullLiteral(RexNode node) {
        return node instanceof RexLiteral && ((RexLiteral)node).isNull();
    }

    public static String massageSql(QueryParams queryParams) {
        String massagedSql = QueryUtil.normalMassageSql(queryParams.getKylinConfig(), queryParams.getSql(), queryParams.getLimit(), queryParams.getOffset());
        queryParams.setSql(massagedSql);
        massagedSql = QueryUtil.transformSql(queryParams);
        QueryContext.current().record("massage");
        return massagedSql;
    }

    public static String massageSqlAndExpandCC(QueryParams queryParams) {
        String massaged = QueryUtil.massageSql(queryParams);
        return new RestoreFromComputedColumn().convert(massaged, queryParams.getProject(), queryParams.getDefaultSchema());
    }

    private static String transformSql(QueryParams queryParams) {
        QueryUtil.initQueryTransformersIfNeeded(queryParams.getKylinConfig(), queryParams.isCCNeeded());
        String sql = queryParams.getSql();
        for (IQueryTransformer t : queryTransformers) {
            QueryUtil.checkThreadInterrupted("Interrupted sql transformation at the stage of " + t.getClass(), "Current step: SQL transformation.");
            sql = t.transform(sql, queryParams.getProject(), queryParams.getDefaultSchema());
        }
        return sql;
    }

    private static String trimRightSemiColon(String sql) {
        while (sql.endsWith(SEMI_COLON)) {
            sql = sql.substring(0, sql.length() - 1).trim();
        }
        return sql;
    }

    public static String normalMassageSql(KylinConfig kylinConfig, String sql, int limit, int offset) {
        sql = sql.trim();
        sql = sql.replace("\r", " ").replace("\n", System.getProperty("line.separator"));
        sql = QueryUtil.trimRightSemiColon(sql);
        ArrayList sqlElements = Lists.newArrayList((Object[])sql.toLowerCase(Locale.ROOT).split("(?![._'\"`])\\p{P}|\\s+"));
        Integer maxRows = kylinConfig.getMaxResultRows();
        if (maxRows != null && maxRows > 0 && (maxRows < limit || limit <= 0)) {
            limit = maxRows;
        }
        if (kylinConfig.getForceLimit() > 0 && limit <= 0 && !sql.toLowerCase(Locale.ROOT).contains("limit") && QueryUtil.isSelectStarStatement(sql)) {
            limit = kylinConfig.getForceLimit();
        }
        if (QueryUtil.checkBigQueryPushDown(kylinConfig)) {
            long bigQueryThreshold = BigQueryThresholdUpdater.getBigQueryThreshold();
            if (limit <= 0 && bigQueryThreshold > 0L) {
                log.info("Big query route to pushdown, Add limit {} to sql.", (Object)bigQueryThreshold);
                limit = (int)bigQueryThreshold;
            }
        }
        if (limit > 0 && !sqlElements.contains("limit")) {
            sql = sql + "\nLIMIT " + limit;
        }
        if (offset > 0 && !sqlElements.contains("offset")) {
            sql = sql + "\nOFFSET " + offset;
        }
        return sql;
    }

    public static boolean checkBigQueryPushDown(KylinConfig kylinConfig) {
        return kylinConfig.isBigQueryPushDown() && JDBC.equals(KapConfig.getInstanceFromEnv().getShareStateSwitchImplement());
    }

    public static void initQueryTransformersIfNeeded(KylinConfig kylinConfig, boolean isCCNeeded) {
        String[] currentTransformers = (String[])queryTransformers.stream().map(Object::getClass).map(Class::getCanonicalName).toArray(String[]::new);
        String[] configTransformers = kylinConfig.getQueryTransformers();
        boolean containsCCTransformer = Arrays.asList(configTransformers).contains("org.apache.kylin.query.util.ConvertToComputedColumn");
        boolean transformersEqual = Objects.deepEquals(currentTransformers, configTransformers);
        if (transformersEqual && (isCCNeeded || !containsCCTransformer)) {
            return;
        }
        List<IQueryTransformer> transformers = QueryUtil.initTransformers(isCCNeeded, configTransformers);
        queryTransformers = Collections.unmodifiableList(transformers);
        log.debug("SQL transformer: {}", queryTransformers);
    }

    public static List<IQueryTransformer> initTransformers(boolean isCCNeeded, String[] configTransformers) {
        ArrayList transformers = Lists.newArrayList();
        ArrayList classList = Lists.newArrayList((Object[])configTransformers);
        classList.removeIf(clazz -> {
            String name = clazz.substring(clazz.lastIndexOf(".") + 1);
            return REMOVED_TRANSFORMERS.contains((Object)name);
        });
        for (String clz : classList) {
            if (!isCCNeeded && clz.equals("org.apache.kylin.query.util.ConvertToComputedColumn")) continue;
            try {
                IQueryTransformer t = (IQueryTransformer)ClassUtil.newInstance((String)clz);
                transformers.add(t);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to init query transformer", e);
            }
        }
        return transformers;
    }

    public static String massagePushDownSql(QueryParams queryParams) {
        String sql = queryParams.getSql();
        sql = QueryUtil.trimRightSemiColon(sql);
        sql = SQL_HINT_ERASER.matcher(sql).replaceAll("");
        QueryUtil.initPushDownConvertersIfNeeded(queryParams.getKylinConfig());
        for (IPushDownConverter converter : pushDownConverters) {
            QueryUtil.checkThreadInterrupted("Interrupted sql transformation at the stage of " + converter.getClass(), "Current step: Massage push-down sql. ");
            sql = converter.convert(sql, queryParams.getProject(), queryParams.getDefaultSchema());
        }
        sql = QueryUtil.replaceDoubleQuoteToSingle(sql);
        return sql;
    }

    public static String replaceDoubleQuoteToSingle(String originSql) {
        boolean inStrVal = false;
        boolean needTransfer = false;
        char[] res = originSql.toCharArray();
        for (int i = 0; i < res.length; ++i) {
            if (res[i] == '\'') {
                if (inStrVal) {
                    if (needTransfer) {
                        res[i - 1] = 92;
                        needTransfer = false;
                        continue;
                    }
                    needTransfer = true;
                    continue;
                }
                inStrVal = true;
                continue;
            }
            if (!needTransfer) continue;
            inStrVal = false;
            needTransfer = false;
        }
        return new String(res);
    }

    static void initPushDownConvertersIfNeeded(KylinConfig kylinConfig) {
        String[] configConverters;
        String[] currentConverters = (String[])pushDownConverters.stream().map(Object::getClass).map(Class::getCanonicalName).toArray(String[]::new);
        boolean skipInit = Objects.deepEquals(currentConverters, configConverters = kylinConfig.getPushDownConverterClassNames());
        if (skipInit) {
            return;
        }
        ArrayList converters = Lists.newArrayList();
        for (String clz : configConverters) {
            try {
                IPushDownConverter converter = (IPushDownConverter)ClassUtil.newInstance((String)clz);
                converters.add(converter);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to init pushdown converter", e);
            }
        }
        pushDownConverters = Collections.unmodifiableList(converters);
    }

    public static void checkThreadInterrupted(String errorMsgLog, String stepInfo) {
        if (Thread.currentThread().isInterrupted()) {
            log.error("{} {}", (Object)QueryContext.current().getQueryId(), (Object)errorMsgLog);
            if (SlowQueryDetector.getRunningQueries().get(Thread.currentThread()).isStopByUser()) {
                throw new UserStopQueryException("");
            }
            QueryContext.current().getQueryTagInfo().setTimeout(true);
            throw new KylinTimeoutException("The query exceeds the set time limit of " + KylinConfig.getInstanceFromEnv().getQueryTimeoutSeconds() + "s. " + stepInfo);
        }
    }
}

